/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.metadata.cube.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.metadata.model.IStorageAware;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class LayoutEntity
implements IStorageAware {
    @JsonProperty(value="id")
    private long id;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="col_order")
    private List<Integer> colOrder = Lists.newArrayList();
    @JsonProperty(value="update_time")
    private long updateTime;
    @JsonProperty(value="storage_type")
    private int storageType = 4;
    @JsonProperty(value="shard_by_columns")
    private List<Integer> shardByColumns = Lists.newArrayList();
    private Map<Integer, ColumnDesc> orderedDimensions;
    private Map<Integer, FunctionDesc> orderedMeasures;
    long rows;
    long sourceRows;
    long byteSize;
    long fileCount;
    int shardNum;

    public static LayoutEntity newLayoutEntity(long layoutId) {
        LayoutEntity layoutEntity = new LayoutEntity();
        layoutEntity.setId(layoutId);
        return layoutEntity;
    }

    public int getStorageType() {
        return this.storageType;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getOwner() {
        return this.owner;
    }

    public Map<Integer, ColumnDesc> getOrderedDimensions() {
        return this.orderedDimensions;
    }

    public Map<Integer, FunctionDesc> getOrderedMeasures() {
        return this.orderedMeasures;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<Integer> getShardByColumns() {
        return this.shardByColumns;
    }

    public void setShardByColumns(List<Integer> shardByColumns) {
        this.shardByColumns = shardByColumns;
    }

    public boolean fullyDerive(LayoutEntity child) {
        return this.orderedDimensions.keySet().containsAll(child.orderedDimensions.keySet()) && this.orderedMeasures.keySet().containsAll(child.orderedMeasures.keySet());
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(long byteSize) {
        this.byteSize = byteSize;
    }

    public long getRows() {
        return this.rows;
    }

    public void setRows(long rows) {
        this.rows = rows;
    }

    public long getFileCount() {
        return this.fileCount;
    }

    public void setFileCount(long fileCount) {
        this.fileCount = fileCount;
    }

    public long getSourceRows() {
        return this.sourceRows;
    }

    public void setSourceRows(long sourceRows) {
        this.sourceRows = sourceRows;
    }

    public int getShardNum() {
        return this.shardNum;
    }

    public void setShardNum(int shardNum) {
        this.shardNum = shardNum;
    }

    public void setOrderedDimensions(Map<Integer, ColumnDesc> orderedDimensions) {
        this.orderedDimensions = orderedDimensions;
    }

    public void setOrderedMeasures(Map<Integer, FunctionDesc> orderedMeasures) {
        this.orderedMeasures = orderedMeasures;
    }

    public boolean isTableIndex() {
        return this.orderedMeasures.isEmpty();
    }
}

