/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.metadata.cube.source;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ImplementationSwitch;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.source.ISource;

public class SourceFactory {
    private static ThreadLocal<ImplementationSwitch<ISource>> sources = new ThreadLocal();

    public static ISource getSource(int sourceType) {
        ImplementationSwitch current = sources.get();
        if (current == null) {
            current = new ImplementationSwitch(KylinConfig.getInstanceFromEnv().getSourceEngines(), ISource.class);
            sources.set((ImplementationSwitch<ISource>)current);
        }
        return (ISource)current.get(sourceType);
    }

    public static ISource getDefaultSource() {
        return SourceFactory.getSource(KylinConfig.getInstanceFromEnv().getDefaultSource());
    }

    public static ISource getCSVSource() {
        return SourceFactory.getSource(9);
    }

    public static ISource getSource(ISourceAware aware) {
        return SourceFactory.getSource(aware.getSourceType());
    }

    public static <T> T createEngineAdapter(ISourceAware table, Class<T> engineInterface) {
        return (T)SourceFactory.getSource(table).adaptToBuildEngine(engineInterface);
    }
}

