/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.cube.v2;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.BytesSerializer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class RawScan {
    public byte[] startKey;
    public byte[] endKey;
    public List<Pair<byte[], byte[]>> hbaseColumns;
    public List<Pair<byte[], byte[]>> fuzzyKeys;
    public int hbaseCaching;
    public int hbaseMaxResultSize;
    public static final BytesSerializer<RawScan> serializer = new BytesSerializer<RawScan>(){

        public void serialize(RawScan value, ByteBuffer out) {
            BytesUtil.writeByteArray((byte[])value.startKey, (ByteBuffer)out);
            BytesUtil.writeByteArray((byte[])value.endKey, (ByteBuffer)out);
            BytesUtil.writeVInt((int)value.hbaseColumns.size(), (ByteBuffer)out);
            for (Pair<byte[], byte[]> hbaseColumn : value.hbaseColumns) {
                BytesUtil.writeByteArray((byte[])((byte[])hbaseColumn.getFirst()), (ByteBuffer)out);
                BytesUtil.writeByteArray((byte[])((byte[])hbaseColumn.getSecond()), (ByteBuffer)out);
            }
            BytesUtil.writeVInt((int)value.fuzzyKeys.size(), (ByteBuffer)out);
            for (Pair<byte[], byte[]> fuzzyKey : value.fuzzyKeys) {
                BytesUtil.writeByteArray((byte[])((byte[])fuzzyKey.getFirst()), (ByteBuffer)out);
                BytesUtil.writeByteArray((byte[])((byte[])fuzzyKey.getSecond()), (ByteBuffer)out);
            }
            BytesUtil.writeVInt((int)value.hbaseCaching, (ByteBuffer)out);
            BytesUtil.writeVInt((int)value.hbaseMaxResultSize, (ByteBuffer)out);
        }

        public RawScan deserialize(ByteBuffer in) {
            byte[] sStartKey = BytesUtil.readByteArray((ByteBuffer)in);
            byte[] sEndKey = BytesUtil.readByteArray((ByteBuffer)in);
            int hbaseColumnsSize = BytesUtil.readVInt((ByteBuffer)in);
            ArrayList sHbaseCoumns = Lists.newArrayListWithCapacity((int)hbaseColumnsSize);
            for (int i = 0; i < hbaseColumnsSize; ++i) {
                byte[] a = BytesUtil.readByteArray((ByteBuffer)in);
                byte[] b = BytesUtil.readByteArray((ByteBuffer)in);
                sHbaseCoumns.add(Pair.newPair((Object)a, (Object)b));
            }
            int fuzzyKeysSize = BytesUtil.readVInt((ByteBuffer)in);
            ArrayList sFuzzyKeys = Lists.newArrayListWithCapacity((int)fuzzyKeysSize);
            for (int i = 0; i < fuzzyKeysSize; ++i) {
                byte[] a = BytesUtil.readByteArray((ByteBuffer)in);
                byte[] b = BytesUtil.readByteArray((ByteBuffer)in);
                sFuzzyKeys.add(Pair.newPair((Object)a, (Object)b));
            }
            int sHBaseCaching = BytesUtil.readVInt((ByteBuffer)in);
            int sHBaseMaxResultSize = BytesUtil.readVInt((ByteBuffer)in);
            return new RawScan(sStartKey, sEndKey, sHbaseCoumns, sFuzzyKeys, sHBaseCaching, sHBaseMaxResultSize);
        }
    };

    public RawScan(byte[] startKey, byte[] endKey, List<Pair<byte[], byte[]>> hbaseColumns, List<Pair<byte[], byte[]>> fuzzyKeys, int hbaseCaching, int hbaseMaxResultSize) {
        this.startKey = startKey;
        this.endKey = endKey;
        this.hbaseColumns = hbaseColumns;
        this.fuzzyKeys = fuzzyKeys;
        this.hbaseCaching = hbaseCaching;
        this.hbaseMaxResultSize = hbaseMaxResultSize;
    }

    public RawScan(RawScan other) {
        this.startKey = other.startKey;
        this.endKey = other.endKey;
        this.hbaseColumns = other.hbaseColumns;
        this.fuzzyKeys = other.fuzzyKeys;
        this.hbaseCaching = other.hbaseCaching;
        this.hbaseMaxResultSize = other.hbaseMaxResultSize;
    }

    public String getStartKeyAsString() {
        return BytesUtil.toHex((byte[])this.startKey);
    }

    public String getEndKeyAsString() {
        return BytesUtil.toHex((byte[])this.endKey);
    }

    public String getFuzzyKeyAsString() {
        StringBuilder buf = new StringBuilder();
        for (Pair<byte[], byte[]> fuzzyKey : this.fuzzyKeys) {
            buf.append(BytesUtil.toHex((byte[])((byte[])fuzzyKey.getFirst())));
            buf.append(" ");
            buf.append(BytesUtil.toHex((byte[])((byte[])fuzzyKey.getSecond())));
            buf.append(";");
        }
        return buf.toString();
    }
}

