/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.steps;

import java.io.IOException;
import org.apache.commons.cli.Options;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FsShell;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.mapreduce.LoadIncrementalHFiles;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.mr.MRUtil;
import org.apache.kylin.engine.mr.common.AbstractHadoopJob;
import org.apache.kylin.storage.hbase.HBaseConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkLoadJob
extends AbstractHadoopJob {
    protected static final Logger logger = LoggerFactory.getLogger(BulkLoadJob.class);

    public int run(String[] args) throws Exception {
        FileStatus[] fileStatuses;
        Options options = new Options();
        options.addOption(OPTION_INPUT_PATH);
        options.addOption(OPTION_HTABLE_NAME);
        options.addOption(OPTION_CUBE_NAME);
        this.parseOptions(options, args);
        String tableName = this.getOptionValue(OPTION_HTABLE_NAME);
        String input = this.getOptionValue(OPTION_INPUT_PATH);
        Configuration conf = HBaseConnection.getCurrentHBaseConfiguration();
        FsShell shell = new FsShell(conf);
        int exitCode = -1;
        for (int retryCount = 10; exitCode != 0 && retryCount >= 1; --retryCount) {
            exitCode = shell.run(new String[]{"-chmod", "-R", "777", input});
            Thread.sleep(5000L);
        }
        if (exitCode != 0) {
            logger.error("Failed to change the file permissions: " + input);
            throw new IOException("Failed to change the file permissions: " + input);
        }
        String[] newArgs = new String[]{input, tableName};
        int count = 0;
        Path inputPath = new Path(input);
        FileSystem fs = HadoopUtil.getFileSystem((Path)inputPath);
        for (FileStatus fileStatus : fileStatuses = fs.listStatus(inputPath)) {
            if (!fileStatus.isDirectory()) continue;
            Path path = fileStatus.getPath();
            if (path.getName().equals("_temporary")) {
                logger.info("Delete temporary path: " + path);
                fs.delete(path, true);
                continue;
            }
            ++count;
        }
        int ret = 0;
        if (count > 0) {
            logger.debug("Start to run LoadIncrementalHFiles, File count is: " + count);
            ret = MRUtil.runMRJob((Tool)new LoadIncrementalHFiles(conf), (String[])newArgs);
            logger.debug("End to run LoadIncrementalHFiles");
            return ret;
        }
        logger.debug("Nothing to load, cube is empty");
        return ret;
    }

    public static void main(String[] args) throws Exception {
        int exitCode = ToolRunner.run((Tool)new BulkLoadJob(), (String[])args);
        System.exit(exitCode);
    }
}

