/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.hbase.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateHTableHostCLI {
    private static final Logger logger = LoggerFactory.getLogger(UpdateHTableHostCLI.class);
    private List<String> updatedResources = Lists.newArrayList();
    private List<String> errorMsgs = Lists.newArrayList();
    private List<String> htables;
    private Admin hbaseAdmin;
    private KylinConfig kylinConfig;
    private String oldHostValue;

    public UpdateHTableHostCLI(List<String> htables, String oldHostValue) throws IOException {
        this.htables = htables;
        this.oldHostValue = oldHostValue;
        try (Connection conn = ConnectionFactory.createConnection((Configuration)HBaseConfiguration.create());){
            this.hbaseAdmin = conn.getAdmin();
            this.kylinConfig = KylinConfig.getInstanceFromEnv();
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            UpdateHTableHostCLI.printUsageAndExit();
        }
        List<String> tableNames = UpdateHTableHostCLI.getHTableNames(KylinConfig.getInstanceFromEnv());
        if (!args[0].toLowerCase(Locale.ROOT).equals("-from")) {
            UpdateHTableHostCLI.printUsageAndExit();
        }
        String oldHostValue = args[1].toLowerCase(Locale.ROOT);
        String filterType = args[2].toLowerCase(Locale.ROOT);
        if (filterType.equals("-table")) {
            tableNames = UpdateHTableHostCLI.filterByTables(tableNames, Arrays.asList(args).subList(3, args.length));
        } else if (filterType.equals("-cube")) {
            tableNames = UpdateHTableHostCLI.filterByCubes(tableNames, Arrays.asList(args).subList(3, args.length));
        } else if (!filterType.equals("-all")) {
            UpdateHTableHostCLI.printUsageAndExit();
        }
        logger.info("These htables are needed to be updated: {}", (Object)StringUtils.join(tableNames, (String)","));
        UpdateHTableHostCLI updateHTableHostCLI = new UpdateHTableHostCLI(tableNames, oldHostValue);
        updateHTableHostCLI.execute();
        logger.info("=================================================================");
        logger.info("Run UpdateHTableHostCLI completed;");
        if (!updateHTableHostCLI.updatedResources.isEmpty()) {
            logger.info("Following resources are updated successfully:");
            for (String s : updateHTableHostCLI.updatedResources) {
                logger.info(s);
            }
        } else {
            logger.warn("No resource updated.");
        }
        if (!updateHTableHostCLI.errorMsgs.isEmpty()) {
            logger.info("Here are the error/warning messages, you may need to check:");
            for (String s : updateHTableHostCLI.errorMsgs) {
                logger.warn(s);
            }
        } else {
            logger.info("No error or warning messages; The update succeeds.");
        }
        logger.info("=================================================================");
    }

    private static void printUsageAndExit() {
        logger.info("Usage: exec -from oldHostValue -all|-cube cubeA,cubeB|-table tableA,tableB");
        System.exit(0);
    }

    private static List<String> getHTableNames(KylinConfig config) {
        CubeManager cubeMgr = CubeManager.getInstance((KylinConfig)config);
        ArrayList<String> result = new ArrayList<String>();
        for (CubeInstance cube : cubeMgr.listAllCubes()) {
            for (CubeSegment seg : cube.getSegments(SegmentStatusEnum.READY)) {
                String tableName = seg.getStorageLocationIdentifier();
                if (StringUtils.isBlank((String)tableName)) continue;
                result.add(tableName);
                logger.info("added new table: {}", (Object)tableName);
            }
        }
        return result;
    }

    private static List<String> filterByCubes(List<String> allTableNames, List<String> cubeNames) {
        CubeManager cubeManager = CubeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ArrayList result = Lists.newArrayList();
        for (String c : cubeNames) {
            if ((c = c.trim()).endsWith(",")) {
                c = c.substring(0, c.length() - 1);
            }
            CubeInstance cubeInstance = cubeManager.getCube(c);
            for (CubeSegment segment : cubeInstance.getSegments()) {
                String tableName = segment.getStorageLocationIdentifier();
                if (!allTableNames.contains(tableName)) continue;
                result.add(tableName);
            }
        }
        return result;
    }

    private static List<String> filterByTables(List<String> allTableNames, List<String> tableNames) {
        ArrayList result = Lists.newArrayList();
        for (String t : tableNames) {
            if ((t = t.trim()).endsWith(",")) {
                t = t.substring(0, t.length() - 1);
            }
            if (!allTableNames.contains(t)) continue;
            result.add(t);
        }
        return result;
    }

    private void updateHtable(String tableName) throws IOException {
        HTableDescriptor desc = this.hbaseAdmin.getTableDescriptor(TableName.valueOf((String)tableName));
        if (this.oldHostValue.equals(desc.getValue("KYLIN_HOST"))) {
            desc.setValue("KYLIN_HOST", this.kylinConfig.getMetadataUrlPrefix());
            this.hbaseAdmin.disableTable(TableName.valueOf((String)tableName));
            this.hbaseAdmin.modifyTable(TableName.valueOf((String)tableName), desc);
            this.hbaseAdmin.enableTable(TableName.valueOf((String)tableName));
            this.updatedResources.add(tableName);
        }
    }

    public void execute() {
        for (String htable : this.htables) {
            try {
                this.updateHtable(htable);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.errorMsgs.add("Update HTable[" + htable + "] failed: " + ex.getMessage());
            }
        }
    }
}

