/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.server;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.stream.core.model.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicaSetLeaderSelector
extends LeaderSelectorListenerAdapter
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(ReplicaSetLeaderSelector.class);
    private LeaderSelector leaderSelector;
    private int replicaSetID;
    private Node node;
    private List<LeaderChangeListener> leaderChangeListeners;

    public ReplicaSetLeaderSelector(CuratorFramework client, Node currNode, int replicaSetID) {
        this.node = currNode;
        this.replicaSetID = replicaSetID;
        String path = "/stream/replica_sets_lead/" + replicaSetID;
        this.leaderSelector = new LeaderSelector(client, path, (LeaderSelectorListener)this);
        this.leaderSelector.autoRequeue();
        this.leaderChangeListeners = Lists.newArrayList();
    }

    @Override
    public void close() throws IOException {
        this.leaderSelector.close();
    }

    public void start() {
        this.leaderSelector.start();
    }

    public void addLeaderChangeListener(LeaderChangeListener listener) {
        this.leaderChangeListeners.add(listener);
    }

    public void takeLeadership(CuratorFramework client) throws Exception {
        logger.info("become the leader of the replicaSet:{}", (Object)this.replicaSetID);
        for (LeaderChangeListener leaderChangeListener : this.leaderChangeListeners) {
            try {
                leaderChangeListener.becomeLeader();
            }
            catch (Exception e) {
                logger.error("error when call listener", (Throwable)e);
            }
        }
        do {
            try {
                Thread.sleep(300000L);
            }
            catch (InterruptedException exception) {
                Thread.interrupted();
                break;
            }
        } while (this.leaderSelector.hasLeadership());
        logger.info("become the follower of the replicaSet:{}", (Object)this.replicaSetID);
        for (LeaderChangeListener leaderChangeListener : this.leaderChangeListeners) {
            try {
                leaderChangeListener.becomeFollower();
            }
            catch (Exception e) {
                logger.error("error when call listener", (Throwable)e);
            }
        }
    }

    public static interface LeaderChangeListener {
        public void becomeLeader();

        public void becomeFollower();
    }
}

