/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import javax.servlet.Servlet;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.stream.core.model.Node;
import org.apache.kylin.stream.core.util.NodeUtil;
import org.apache.kylin.stream.server.StreamingServer;
import org.apache.log4j.PropertyConfigurator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.XmlWebApplicationContext;
import org.springframework.web.servlet.DispatcherServlet;

public class StreamingReceiver {
    private static final Logger logger = LoggerFactory.getLogger(StreamingReceiver.class);
    private Server httpServer;

    public static void main(String[] args) {
        try {
            StreamingReceiver receiver = new StreamingReceiver();
            receiver.start();
        }
        catch (Exception e) {
            logger.error("streaming receiver start fail", (Throwable)e);
        }
    }

    private void start() throws Exception {
        if (System.getProperty("debug") != null) {
            this.setupDebugEnv();
        }
        this.startStreamingServer();
        this.startRpcServer();
        this.startHttpServer();
    }

    private void startStreamingServer() throws Exception {
        StreamingServer.getInstance().start();
    }

    private void startHttpServer() throws Exception {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        this.createAndConfigHttpServer(kylinConfig);
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/kylin");
        XmlWebApplicationContext ctx = new XmlWebApplicationContext();
        ctx.setConfigLocation("classpath:applicationContext.xml");
        ctx.refresh();
        DispatcherServlet dispatcher = new DispatcherServlet((WebApplicationContext)ctx);
        context.addServlet(new ServletHolder((Servlet)dispatcher), "/api/*");
        ContextHandler logContext = new ContextHandler("/kylin/logs");
        String logDir = this.getLogDir(kylinConfig);
        ResourceHandler logHandler = new ResourceHandler();
        logHandler.setResourceBase(logDir);
        logHandler.setDirectoriesListed(true);
        logContext.setHandler((Handler)logHandler);
        contexts.setHandlers(new Handler[]{context, logContext});
        this.httpServer.setHandler((Handler)contexts);
        this.httpServer.start();
        this.httpServer.join();
    }

    private void startRpcServer() throws Exception {
    }

    private String getLogDir(KylinConfig kylinConfig) {
        String kylinHome = kylinConfig.getKylinHome();
        if (kylinHome == null) {
            kylinHome = System.getProperty("KYLIN_HOME");
        }
        return kylinHome + File.separator + "logs";
    }

    private void createAndConfigHttpServer(KylinConfig kylinConfig) {
        this.httpServer = new Server(this.createThreadPool(kylinConfig));
        ServerConnector httpConnector = this.getHttpConnector();
        httpConnector.setPort(this.getHttpPort());
        httpConnector.setIdleTimeout(30000L);
        this.httpServer.addConnector((Connector)httpConnector);
    }

    private ServerConnector getHttpConnector() {
        return new ServerConnector(this.httpServer);
    }

    private ThreadPool createThreadPool(KylinConfig kylinConfig) {
        QueuedThreadPool threadPool = new QueuedThreadPool();
        threadPool.setMinThreads(kylinConfig.getStreamingReceiverHttpMinThreads());
        threadPool.setMaxThreads(kylinConfig.getStreamingReceiverHttpMaxThreads());
        return threadPool;
    }

    private void setupDebugEnv() {
        try {
            Properties props = new Properties();
            props.load(new FileInputStream("../build/conf/kylin-tools-log4j.properties"));
            PropertyConfigurator.configure((Properties)props);
            KylinConfig.setSandboxEnvIfPossible();
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.setProperty("kylin.stream.settled.storage", "org.apache.kylin.stream.server.storage.LocalStreamStorage");
        }
        catch (Exception e) {
            logger.error("debug env setup fail", (Throwable)e);
        }
    }

    private int getHttpPort() {
        Node currentNode = NodeUtil.getCurrentNode((int)9090);
        return currentNode.getPort();
    }
}

