/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.stream.server.rest.controller;

import java.util.Locale;
import org.apache.kylin.common.debug.BackdoorToggles;
import org.apache.kylin.stream.server.rest.controller.BasicController;
import org.apache.kylin.stream.server.rest.exception.InternalErrorException;
import org.apache.kylin.stream.server.rest.model.SQLRequest;
import org.apache.kylin.stream.server.rest.model.SQLResponse;
import org.apache.kylin.stream.server.rest.service.QueryService;
import org.apache.kylin.stream.server.rest.util.QueryUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class QueryController
extends BasicController {
    public static final String SUCCESS_QUERY_CACHE = "StorageCache";
    public static final String EXCEPTION_QUERY_CACHE = "ExceptionQueryCache";
    private static final Logger logger = LoggerFactory.getLogger(QueryController.class);
    @Autowired
    private QueryService queryService;

    @RequestMapping(value={"/query"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public SQLResponse query(@RequestBody SQLRequest sqlRequest) {
        return this.doQueryWithCache(sqlRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLResponse doQueryWithCache(SQLRequest sqlRequest) {
        try {
            SQLResponse sqlResponse;
            BackdoorToggles.setToggles(sqlRequest.getBackdoorToggles());
            String sql = sqlRequest.getSql();
            String project = sqlRequest.getProject();
            logger.info("Using project: " + project);
            logger.info("The original query:  " + sql);
            if (!sql.toLowerCase(Locale.ROOT).contains("select")) {
                logger.debug("Directly return exception as not supported");
                throw new InternalErrorException("Not Supported SQL.");
            }
            long startTime = System.currentTimeMillis();
            try {
                sqlResponse = this.queryService.query(sqlRequest);
                sqlResponse.setDuration(System.currentTimeMillis() - startTime);
                logger.info("Stats of SQL response: isException: {}, duration: {}, total scan count {}", (Object[])new String[]{String.valueOf(sqlResponse.getIsException()), String.valueOf(sqlResponse.getDuration()), String.valueOf(sqlResponse.getTotalScanCount())});
            }
            catch (Throwable e) {
                logger.error("Exception when execute sql", e);
                String errMsg = QueryUtil.makeErrorMsgUserFriendly(e);
                sqlResponse = new SQLResponse(null, null, 0, true, errMsg);
            }
            if (sqlResponse.getIsException()) {
                throw new InternalErrorException(sqlResponse.getExceptionMessage());
            }
            SQLResponse sQLResponse = sqlResponse;
            return sQLResponse;
        }
        finally {
            BackdoorToggles.cleanToggles();
        }
    }

    public void setQueryService(QueryService queryService) {
        this.queryService = queryService;
    }
}

