/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.parser;

import java.time.ZoneId;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.parser.AbstractTimeParser;

public class DefaultTimeParser
extends AbstractTimeParser {
    private String tsTimezone = null;

    public DefaultTimeParser(Map<String, String> properties) {
        super(properties);
        this.tsTimezone = properties.get("tsTimezone");
    }

    @Override
    public long parseTime(String time) throws IllegalArgumentException {
        long t;
        if (StringUtils.isEmpty((CharSequence)time)) {
            t = 0L;
        } else {
            try {
                ZoneId zoneId = ZoneId.of(this.tsTimezone);
                TimeZone timeZone = TimeZone.getTimeZone(zoneId);
                Calendar calendar = Calendar.getInstance(timeZone, Locale.ROOT);
                int offsetMilli = calendar.get(15);
                t = Long.parseLong(time) + (long)offsetMilli;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return t;
    }
}

