/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.jobs;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.login.AppConfigurationEntry;
import lombok.Generated;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.common.config.types.Password;
import org.apache.kafka.common.security.JaasContext;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StreamingJobUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamingJobUtils.class);

    public static KylinConfig getStreamingKylinConfig(KylinConfig originalConfig, Map<String, String> jobParams, String modelId, String project) {
        KylinConfigExt kylinConfigExt;
        if (StringUtils.isNotBlank((CharSequence)modelId)) {
            NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)originalConfig, (String)project);
            kylinConfigExt = dataflowManager.getDataflow(modelId).getConfig();
        } else {
            ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)originalConfig).getProject(project);
            kylinConfigExt = projectInstance.getConfig();
        }
        HashMap streamingJobOverrides = Maps.newHashMap();
        if (MapUtils.isNotEmpty((Map)kylinConfigExt.getExtendedOverrides())) {
            streamingJobOverrides.putAll(kylinConfigExt.getExtendedOverrides());
        }
        jobParams.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("kylin.streaming.spark-conf.")).forEach(entry -> {
            String cfr_ignored_0 = (String)streamingJobOverrides.put(entry.getKey(), entry.getValue());
        });
        jobParams.entrySet().stream().filter(entry -> ((String)entry.getKey()).startsWith("kylin.streaming.kafka-conf.")).forEach(entry -> {
            String cfr_ignored_0 = (String)streamingJobOverrides.put(entry.getKey(), entry.getValue());
        });
        jobParams.entrySet().stream().filter(entry -> ((String)entry.getKey()).equals("kylin.streaming.table-refresh-interval")).forEach(entry -> {
            String cfr_ignored_0 = (String)streamingJobOverrides.put(entry.getKey(), entry.getValue());
        });
        jobParams.entrySet().stream().filter(entry -> !((String)entry.getKey()).startsWith("kylin.streaming.spark-conf.")).forEach(entry -> {
            String cfr_ignored_0 = (String)streamingJobOverrides.put("kylin.streaming.spark-conf." + (String)entry.getKey(), entry.getValue());
        });
        return KylinConfigExt.createInstance((KylinConfig)kylinConfigExt, (Map)streamingJobOverrides);
    }

    public static String extractKafkaJaasConf(boolean useAbsKeyTabPath) {
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        if (!kapConfig.isKafkaJaasEnabled()) {
            return null;
        }
        String jaasOriginText = StreamingJobUtils.extractJaasText();
        if (StringUtils.isEmpty((CharSequence)jaasOriginText)) {
            return null;
        }
        String jaasTextRewrite = StreamingJobUtils.rewriteJaasConf(jaasOriginText);
        return StreamingJobUtils.rewriteKeyTab(jaasTextRewrite, useAbsKeyTabPath);
    }

    public static String getJaasKeyTabAbsPath() {
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        if (!kapConfig.isKafkaJaasEnabled()) {
            return null;
        }
        String jaasOriginText = StreamingJobUtils.extractJaasText();
        if (StringUtils.isEmpty((CharSequence)jaasOriginText)) {
            return null;
        }
        String jaasRewriteText = StreamingJobUtils.rewriteJaasConf(jaasOriginText);
        String keyTabPath = StreamingJobUtils.getKeyTabPathFromJaas(jaasRewriteText);
        if (StringUtils.isEmpty((CharSequence)keyTabPath)) {
            return null;
        }
        return FileUtils.getFile((String[])new String[]{keyTabPath}).getAbsolutePath();
    }

    public static void createExecutorJaas() {
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        if (!kapConfig.isKafkaJaasEnabled()) {
            return;
        }
        String jaasConf = StreamingJobUtils.extractKafkaJaasConf(false);
        if (StringUtils.isEmpty((CharSequence)jaasConf)) {
            return;
        }
        String jaasResultText = "KafkaClient { " + jaasConf + " };";
        String jaasPath = StreamingJobUtils.getExecutorJaasPath();
        File executorJaasConfFile = FileUtils.getFile((String[])new String[]{jaasPath});
        FileUtils.write((File)executorJaasConfFile, (CharSequence)jaasResultText, (Charset)StandardCharsets.UTF_8, (boolean)false);
        log.info("extract kafka jaas file to {}", (Object)jaasPath);
    }

    public static String getExecutorJaasPath() {
        return HadoopUtil.getHadoopConfDir() + File.separator + StreamingJobUtils.getExecutorJaasName();
    }

    public static String getExecutorJaasName() {
        return KapConfig.getInstanceFromEnv().getKafkaJaasConf();
    }

    private static String extractJaasText() {
        String jaasOriginText;
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        File jaasFile = new File(kapConfig.getKafkaJaasConfPath());
        try {
            jaasOriginText = FileUtils.readFileToString((File)jaasFile, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.READ_KAFKA_JAAS_FILE_ERROR, (Throwable)e, new Object[0]);
        }
        if (StringUtils.indexOf((CharSequence)jaasOriginText, (CharSequence)"KafkaClient") == -1) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.KAFKA_JAAS_FILE_KAFKACLIENT_NOT_EXISTS, new Object[0]);
        }
        return jaasOriginText;
    }

    private static String rewriteJaasConf(String jaasText) {
        int start = StringUtils.indexOf((CharSequence)jaasText, (int)123) + 1;
        int end = StringUtils.indexOf((CharSequence)jaasText, (int)125);
        return StringUtils.substring((String)jaasText, (int)start, (int)end).trim();
    }

    private static String rewriteKeyTab(String jaasText, boolean useAbsKeyTabPath) {
        String keyTabPath = StreamingJobUtils.getKeyTabPathFromJaas(jaasText);
        if (StringUtils.isEmpty((CharSequence)keyTabPath)) {
            return jaasText;
        }
        File keyTabFile = FileUtils.getFile((String[])new String[]{keyTabPath});
        String replacement = keyTabFile.getName();
        if (useAbsKeyTabPath) {
            replacement = keyTabFile.getAbsolutePath();
        }
        log.info("kafka jaas replace {} -> {}", (Object)keyTabPath, (Object)replacement);
        return StringUtils.replace((String)jaasText, (String)keyTabPath, (String)replacement);
    }

    public static String getKeyTabPathFromJaas(String jaasStr) {
        HashMap map = Maps.newHashMap();
        map.put("sasl.jaas.config", new Password(jaasStr));
        AppConfigurationEntry configEntry = (AppConfigurationEntry)JaasContext.loadClientContext((Map)map).configurationEntries().get(0);
        String keyTabPath = configEntry.getOptions().getOrDefault("keyTab", null);
        if (StringUtils.isEmpty((CharSequence)keyTabPath)) {
            return null;
        }
        if (!FileUtils.getFile((String[])new String[]{keyTabPath}).exists()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.KAFKA_JAAS_FILE_KEYTAB_NOT_EXISTS, new Object[0]);
        }
        return keyTabPath;
    }

    @Generated
    private StreamingJobUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

