/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.metadata;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import lombok.Generated;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.streaming.constants.StreamingConstants;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class StreamingJobMeta
extends RootPersistentEntity {
    @JsonProperty(value="model_alias")
    private String modelName;
    @JsonProperty(value="owner")
    private String owner;
    @JsonProperty(value="model_id")
    private String modelId;
    @JsonProperty(value="last_start_time")
    private String lastStartTime;
    @JsonProperty(value="last_end_time")
    private String lastEndTime;
    @JsonProperty(value="last_update_time")
    private String lastUpdateTime;
    @JsonProperty(value="last_batch_count")
    private Integer lastBatchCount;
    @JsonProperty(value="subscribe")
    private String topicName;
    @JsonProperty(value="fact_table")
    private String factTableName;
    @JsonProperty(value="job_status")
    private JobStatusEnum currentStatus;
    @JsonProperty(value="job_type")
    private JobTypeEnum jobType;
    @JsonProperty(value="process_id")
    private String processId;
    @JsonProperty(value="node_info")
    private String nodeInfo;
    @JsonProperty(value="job_execution_id")
    private Integer jobExecutionId;
    @JsonProperty(value="yarn_app_id")
    private String yarnAppId;
    @JsonProperty(value="yarn_app_url")
    private String yarnAppUrl;
    @JsonProperty(value="params")
    private Map<String, String> params = Maps.newHashMap();
    @JsonProperty(value="project")
    private String project;
    @JsonProperty(value="skip_listener")
    private boolean skipListener;
    @JsonProperty(value="action")
    private String action;

    public static StreamingJobMeta create(NDataModel model, JobStatusEnum status, JobTypeEnum jobType) {
        StreamingJobMeta meta = new StreamingJobMeta();
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
        meta.setCreateTime(calendar.getTimeInMillis());
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
        meta.setLastUpdateTime(format.format(calendar.getTime()));
        meta.setCurrentStatus(status);
        meta.setJobType(jobType);
        meta.setModelId(model.getUuid());
        meta.setModelName(model.getAlias());
        meta.setFactTableName(model.getRootFactTableName());
        meta.setTopicName(model.getRootFactTable().getTableDesc().getKafkaConfig().getSubscribe());
        meta.setOwner(model.getOwner());
        meta.setUuid(StreamingUtils.getJobId((String)model.getUuid(), (String)jobType.name()));
        StreamingJobMeta.initJobParams(meta, jobType);
        return meta;
    }

    private static void initJobParams(StreamingJobMeta jobMeta, JobTypeEnum jobType) {
        jobMeta.params.put("spark.master", "yarn");
        jobMeta.params.put("spark.driver.memory", "512m");
        jobMeta.params.put("spark.executor.instances", "2");
        jobMeta.params.put("spark.executor.cores", "2");
        jobMeta.params.put("spark.executor.memory", "1g");
        jobMeta.params.put("spark.sql.shuffle.partitions", "8");
        if (JobTypeEnum.STREAMING_BUILD == jobType) {
            jobMeta.params.put("kylin.streaming.duration", "30");
            jobMeta.params.put("kylin.streaming.kafka-conf.maxOffsetsPerTrigger", StreamingConstants.STREAMING_MAX_OFFSETS_PER_TRIGGER_DEFAULT);
        } else if (JobTypeEnum.STREAMING_MERGE == jobType) {
            jobMeta.params.put("kylin.streaming.segment-max-size", "32m");
            jobMeta.params.put("kylin.streaming.segment-merge-threshold", "3");
        }
        jobMeta.params.put("kylin.streaming.job-retry-enabled", "false");
    }

    public static String concatResourcePath(String name, String project, String jobType) {
        return "/" + project + "/streaming" + "/" + name + ("_" + jobType.toLowerCase(Locale.ROOT));
    }

    public String getResourcePath() {
        return StreamingJobMeta.concatResourcePath(this.getUuid(), this.project, this.jobType.name());
    }

    @Generated
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setModelId(String modelId) {
        this.modelId = modelId;
    }

    @Generated
    public void setLastStartTime(String lastStartTime) {
        this.lastStartTime = lastStartTime;
    }

    @Generated
    public void setLastEndTime(String lastEndTime) {
        this.lastEndTime = lastEndTime;
    }

    @Generated
    public void setLastUpdateTime(String lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    @Generated
    public void setLastBatchCount(Integer lastBatchCount) {
        this.lastBatchCount = lastBatchCount;
    }

    @Generated
    public void setTopicName(String topicName) {
        this.topicName = topicName;
    }

    @Generated
    public void setFactTableName(String factTableName) {
        this.factTableName = factTableName;
    }

    @Generated
    public void setCurrentStatus(JobStatusEnum currentStatus) {
        this.currentStatus = currentStatus;
    }

    @Generated
    public void setJobType(JobTypeEnum jobType) {
        this.jobType = jobType;
    }

    @Generated
    public void setProcessId(String processId) {
        this.processId = processId;
    }

    @Generated
    public void setNodeInfo(String nodeInfo) {
        this.nodeInfo = nodeInfo;
    }

    @Generated
    public void setJobExecutionId(Integer jobExecutionId) {
        this.jobExecutionId = jobExecutionId;
    }

    @Generated
    public void setYarnAppId(String yarnAppId) {
        this.yarnAppId = yarnAppId;
    }

    @Generated
    public void setYarnAppUrl(String yarnAppUrl) {
        this.yarnAppUrl = yarnAppUrl;
    }

    @Generated
    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setSkipListener(boolean skipListener) {
        this.skipListener = skipListener;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public String getModelName() {
        return this.modelName;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public String getModelId() {
        return this.modelId;
    }

    @Generated
    public String getLastStartTime() {
        return this.lastStartTime;
    }

    @Generated
    public String getLastEndTime() {
        return this.lastEndTime;
    }

    @Generated
    public String getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    @Generated
    public Integer getLastBatchCount() {
        return this.lastBatchCount;
    }

    @Generated
    public String getTopicName() {
        return this.topicName;
    }

    @Generated
    public String getFactTableName() {
        return this.factTableName;
    }

    @Generated
    public JobStatusEnum getCurrentStatus() {
        return this.currentStatus;
    }

    @Generated
    public JobTypeEnum getJobType() {
        return this.jobType;
    }

    @Generated
    public String getProcessId() {
        return this.processId;
    }

    @Generated
    public String getNodeInfo() {
        return this.nodeInfo;
    }

    @Generated
    public Integer getJobExecutionId() {
        return this.jobExecutionId;
    }

    @Generated
    public String getYarnAppId() {
        return this.yarnAppId;
    }

    @Generated
    public String getYarnAppUrl() {
        return this.yarnAppUrl;
    }

    @Generated
    public Map<String, String> getParams() {
        return this.params;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public boolean isSkipListener() {
        return this.skipListener;
    }

    @Generated
    public String getAction() {
        return this.action;
    }
}

