/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.rest;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Closeable;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.response.RestResponse;
import org.apache.kylin.common.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestSupport
implements Closeable {
    protected static final Logger logger = LoggerFactory.getLogger(RestSupport.class);
    private static int MAX_RETRY = 3;
    private static long RETRY_INTERVAL = 10000L;
    protected String baseUrl;
    HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
    CloseableHttpClient httpClient;

    public RestSupport(String baseUrl) {
        this.baseUrl = baseUrl;
        this.httpClient = this.httpClientBuilder.build();
    }

    public RestSupport(KylinConfig config) {
        String restServer = System.getProperty("kylin.spark.rest.server.ip");
        if (StringUtils.isEmpty((String)restServer)) {
            restServer = "127.0.0.1";
        }
        String restPort = config.getServerPort();
        this.baseUrl = "http://" + restServer + ":" + restPort + "/kylin/api";
        this.httpClientBuilder.setMaxConnPerRoute(config.getRestClientDefaultMaxPerRoute());
        this.httpClientBuilder.setMaxConnTotal(config.getRestClientMaxTotal());
        this.httpClient = this.httpClientBuilder.build();
    }

    public RestResponse<String> execute(HttpRequestBase httpReqBase, Object param) {
        int retry = 0;
        Exception err = null;
        while (retry++ < MAX_RETRY) {
            try {
                if (param != null && httpReqBase instanceof HttpEntityEnclosingRequestBase) {
                    ObjectMapper mapper = new ObjectMapper();
                    ((HttpEntityEnclosingRequestBase)httpReqBase).setEntity((HttpEntity)new StringEntity(mapper.writeValueAsString(param), "UTF-8"));
                }
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpReqBase);
                int code = response.getStatusLine().getStatusCode();
                logger.info("code={},url={}", (Object)code, (Object)httpReqBase.getURI());
                if (code == 200) {
                    return (RestResponse)JsonUtil.readValue((InputStream)response.getEntity().getContent(), (TypeReference)new TypeReference<RestResponse<String>>(){});
                }
                InputStream inputStream = response.getEntity().getContent();
                String responseContent = IOUtils.toString((InputStream)inputStream);
                logger.error(responseContent);
                this.checkMaintenceMode();
                Thread.sleep(RETRY_INTERVAL * (long)retry);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                err = e;
                logger.error(e.getMessage(), (Throwable)e);
                this.checkMaintenceMode();
            }
        }
        throw new RuntimeException(err);
    }

    public Boolean checkMaintenceMode() {
        Boolean maintenanceMode = this.isMaintenanceMode();
        while (maintenanceMode.booleanValue()) {
            try {
                if (!KylinConfig.getInstanceFromEnv().isUTEnv()) {
                    Thread.sleep(60000L);
                }
                maintenanceMode = this.isMaintenanceMode();
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return maintenanceMode;
    }

    public Boolean isMaintenanceMode() {
        int retry = 0;
        Exception err = null;
        String url = "/epoch/maintenance_mode";
        HttpGet httpReqBase = this.createHttpGet(url);
        while (retry++ < MAX_RETRY) {
            try {
                CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpReqBase);
                int code = response.getStatusLine().getStatusCode();
                logger.info("code=" + code + ",url=" + httpReqBase.getURI());
                if (code == 200) {
                    RestResponse resp = (RestResponse)JsonUtil.readValue((InputStream)response.getEntity().getContent(), (TypeReference)new TypeReference<RestResponse<String>>(){});
                    return Boolean.parseBoolean((String)resp.getData());
                }
                InputStream inputStream = response.getEntity().getContent();
                String responseContent = IOUtils.toString((InputStream)inputStream);
                logger.error(responseContent);
                Thread.sleep(RETRY_INTERVAL * (long)retry);
            }
            catch (InterruptedException e) {
                logger.error(e.getMessage(), (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                err = e;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        throw new RuntimeException(err);
    }

    @Override
    public void close() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public HttpPut createHttpPut(String url) {
        HttpPut httpPut = new HttpPut(this.baseUrl + url);
        this.addHeader((HttpEntityEnclosingRequestBase)httpPut);
        return httpPut;
    }

    public HttpPost createHttpPost(String url) {
        HttpPost httpPost = new HttpPost(this.baseUrl + url);
        this.addHeader((HttpEntityEnclosingRequestBase)httpPost);
        return httpPost;
    }

    public HttpGet createHttpGet(String url) {
        HttpGet httpGet = new HttpGet(this.baseUrl + url);
        return httpGet;
    }

    private void addHeader(HttpEntityEnclosingRequestBase httpReqBase) {
        httpReqBase.addHeader("Accept", "application/vnd.apache.kylin-v4+json");
        httpReqBase.addHeader("Content-Type", "application/vnd.apache.kylin-v4+json");
    }
}

