/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.util;

import io.kyligence.kap.guava20.shaded.common.util.concurrent.UncheckedTimeoutException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.cluster.ClusterManagerFactory;
import org.apache.kylin.cluster.IClusterManager;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.utils.StreamingUtils;
import org.apache.kylin.streaming.app.StreamingEntry;
import org.apache.kylin.streaming.app.StreamingMergeEntry;
import org.apache.kylin.streaming.metadata.StreamingJobMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobKiller {
    private static final Logger logger = LoggerFactory.getLogger(JobKiller.class);
    private static final String GREP_CMD = "ps -ef|grep '%s' | grep -v grep|awk '{print $2}'";
    private static boolean isYarnEnv = StreamingUtils.isJobOnCluster((KylinConfig)KylinConfig.getInstanceFromEnv());
    private static IClusterManager mock = null;

    public static IClusterManager createClusterManager() {
        if (mock != null) {
            return mock;
        }
        return ClusterManagerFactory.create((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    public static boolean applicationExisted(String jobId) {
        boolean existed = false;
        if (isYarnEnv) {
            int errCnt = 0;
            while (errCnt++ < 3) {
                try {
                    IClusterManager cm = JobKiller.createClusterManager();
                    return cm.applicationExisted(jobId);
                }
                catch (UncheckedTimeoutException e) {
                    logger.warn(e.getMessage());
                    existed = false;
                }
            }
        }
        return existed;
    }

    public static synchronized void killApplication(String jobId) {
        if (isYarnEnv) {
            int errCnt = 0;
            while (errCnt++ < 3) {
                try {
                    IClusterManager cm = JobKiller.createClusterManager();
                    if (cm.applicationExisted(jobId)) {
                        cm.killApplication("", jobId);
                        logger.info("kill jobId:{}", (Object)jobId);
                    }
                    return;
                }
                catch (UncheckedTimeoutException e) {
                    logger.warn(e.getMessage());
                }
            }
        }
    }

    public static synchronized int killProcess(StreamingJobMeta jobMeta) {
        if (!isYarnEnv) {
            if (jobMeta.getJobType() == JobTypeEnum.STREAMING_BUILD) {
                StreamingEntry.stop();
            } else if (jobMeta.getJobType() == JobTypeEnum.STREAMING_MERGE) {
                StreamingMergeEntry.stop();
            }
            return 1;
        }
        StringLogger strLogger = new StringLogger();
        CliCommandExecutor exec = KylinConfig.getInstanceFromEnv().getCliCommandExecutor();
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (!StringUtils.isEmpty((CharSequence)jobMeta.getNodeInfo())) {
            String host = jobMeta.getNodeInfo().split(":")[0];
            if (!AddressUtil.isSameHost((String)host)) {
                exec.setRunAtRemote(host, config.getRemoteSSHPort(), config.getRemoteSSHUsername(), config.getRemoteSSHPassword());
            } else {
                exec.setRunAtRemote(null, config.getRemoteSSHPort(), config.getRemoteSSHUsername(), config.getRemoteSSHPassword());
            }
        }
        return JobKiller.killYarnEnvProcess(exec, jobMeta, strLogger);
    }

    public static int killYarnEnvProcess(CliCommandExecutor exec, StreamingJobMeta jobMeta, StringLogger strLogger) {
        String nodeInfo = jobMeta.getNodeInfo();
        int statusCode = -1;
        String jobId = StreamingUtils.getJobId((String)jobMeta.getModelId(), (String)jobMeta.getJobType().name());
        int retryCnt = 0;
        boolean forced = false;
        while (retryCnt++ < 6) {
            try {
                int errCode = JobKiller.grepProcess(exec, strLogger, jobId);
                if (errCode == 0) {
                    if (!strLogger.getContents().isEmpty()) {
                        if (retryCnt >= 3) {
                            forced = true;
                        }
                        statusCode = JobKiller.doKillProcess(exec, jobId, forced);
                    } else {
                        statusCode = 1;
                        break;
                    }
                }
                StreamingUtils.sleep((long)(1000L * (long)retryCnt));
            }
            catch (ShellException e) {
                logger.warn("failed to kill driver {} on {}", (Object)nodeInfo, (Object)jobMeta.getProcessId());
            }
        }
        return statusCode;
    }

    public static int grepProcess(CliCommandExecutor exec, StringLogger strLogger, String jobId) throws ShellException {
        String cmd = String.format(Locale.getDefault(), GREP_CMD, jobId);
        int result = exec.execute(cmd, (org.apache.kylin.common.util.Logger)strLogger).getCode();
        logger.info("grep process cmd={}, result ={} ", (Object)cmd, (Object)result);
        return result;
    }

    public static int doKillProcess(CliCommandExecutor exec, String jobId, boolean forced) throws ShellException {
        String cmd = String.format(Locale.getDefault(), GREP_CMD, jobId);
        String force = forced ? " -9" : "";
        int result = exec.execute(cmd + "|xargs kill" + force, null).getCode();
        logger.info("kill process cmd={}, result ={} ", (Object)cmd, (Object)result);
        return result;
    }

    static class StringLogger
    implements org.apache.kylin.common.util.Logger {
        private List<String> contents = new ArrayList<String>(2);

        StringLogger() {
        }

        public void log(String message) {
            if (!StringUtils.isEmpty((CharSequence)message)) {
                this.contents.add(message);
            }
        }

        public List<String> getContents() {
            return this.contents;
        }
    }
}

