/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.streaming.util;

import io.kyligence.kap.guava20.shaded.common.collect.Sets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.job.constant.JobStatusEnum;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.streaming.StreamingJobRecord;
import org.apache.kylin.metadata.streaming.StreamingJobRecordManager;
import org.apache.kylin.streaming.manager.StreamingJobManager;

public class MetaInfoUpdater {
    public static void update(String project, NDataSegment seg, NDataLayout layout) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NDataflowUpdate update = new NDataflowUpdate(seg.getDataflow().getUuid());
            update.setToAddOrUpdateLayouts(new NDataLayout[]{layout});
            NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).updateDataflow(update);
            return 0;
        }, (String)project);
    }

    public static void updateJobState(String project, String jobId, JobStatusEnum state) {
        MetaInfoUpdater.updateJobState(project, jobId, Sets.newHashSet((Object[])new JobStatusEnum[]{state}), state);
    }

    public static void updateJobState(String project, String jobId, Set<JobStatusEnum> excludeStates, JobStatusEnum state) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            StreamingJobManager mgr = StreamingJobManager.getInstance(KylinConfig.getInstanceFromEnv(), project);
            mgr.updateStreamingJob(jobId, copyForWrite -> {
                if (!excludeStates.contains(copyForWrite.getCurrentStatus())) {
                    copyForWrite.setCurrentStatus(state);
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
                    Date date = new Date(System.currentTimeMillis());
                    copyForWrite.setLastUpdateTime(format.format(date));
                    StreamingJobRecordManager recordMgr = StreamingJobRecordManager.getInstance();
                    StreamingJobRecord record = new StreamingJobRecord();
                    record.setJobId(jobId);
                    record.setProject(project);
                    record.setCreateTime(Long.valueOf(System.currentTimeMillis()));
                    switch (state) {
                        case STARTING: {
                            if (StringUtils.isEmpty((CharSequence)copyForWrite.getYarnAppUrl())) break;
                            copyForWrite.setYarnAppId("");
                            copyForWrite.setYarnAppUrl("");
                            break;
                        }
                        case RUNNING: {
                            copyForWrite.setLastStartTime(format.format(date));
                            copyForWrite.setSkipListener(false);
                            copyForWrite.setAction("START");
                            record.setAction("START");
                            recordMgr.insert(record);
                            break;
                        }
                        case STOPPED: {
                            record.setAction("STOP");
                            copyForWrite.setLastEndTime(format.format(date));
                            recordMgr.insert(record);
                            break;
                        }
                        case ERROR: {
                            copyForWrite.setLastEndTime(format.format(date));
                            record.setAction("ERROR");
                            recordMgr.insert(record);
                            break;
                        }
                    }
                }
            });
            return null;
        }, (String)project);
    }

    public static void markGracefulShutdown(String project, String uuid) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            StreamingJobManager mgr = StreamingJobManager.getInstance(config, project);
            mgr.updateStreamingJob(uuid, copyForWrite -> {
                if (copyForWrite != null) {
                    copyForWrite.setAction("GRACEFUL_SHUTDOWN");
                }
            });
            return null;
        }, (String)project);
    }
}

