/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.DatatypeConverter;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.TimeZoneUtils;
import org.apache.kylin.common.util.ZipFileUtils;
import org.apache.kylin.query.util.ExtractFactory;
import org.apache.kylin.query.util.ILogExtractor;
import org.apache.kylin.tool.AuditLogTool;
import org.apache.kylin.tool.ClickhouseDiagTool;
import org.apache.kylin.tool.CommonInfoTool;
import org.apache.kylin.tool.ConfTool;
import org.apache.kylin.tool.DiagClientTool;
import org.apache.kylin.tool.DiagSubTaskInfo;
import org.apache.kylin.tool.InfluxDBTool;
import org.apache.kylin.tool.JStackTool;
import org.apache.kylin.tool.JobDiagInfoTool;
import org.apache.kylin.tool.KylinLogTool;
import org.apache.kylin.tool.MetadataTool;
import org.apache.kylin.tool.QueryDiagInfoTool;
import org.apache.kylin.tool.RecCandidateTool;
import org.apache.kylin.tool.StreamingJobDiagInfoTool;
import org.apache.kylin.tool.StreamingSparkLogTool;
import org.apache.kylin.tool.SystemUsageTool;
import org.apache.kylin.tool.constant.DiagSubTaskEnum;
import org.apache.kylin.tool.constant.StageEnum;
import org.apache.kylin.tool.obf.KylinConfObfuscator;
import org.apache.kylin.tool.obf.MappingRecorder;
import org.apache.kylin.tool.obf.ObfLevel;
import org.apache.kylin.tool.obf.ResultRecorder;
import org.apache.kylin.tool.restclient.RestClient;
import org.apache.kylin.tool.util.DiagnosticFilesChecker;
import org.apache.kylin.tool.util.HashFunction;
import org.apache.kylin.tool.util.ServerInfoUtil;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInfoExtractorTool
extends ExecutableApplication {
    public static final String SLASH = "/";
    public static final String TRUE = "true";
    public static final String FALSE = "false";
    public static final String OPT_COMPRESS = "-compress";
    public static final String OPT_PROJECT = "-project";
    public static final String OPT_DIR = "-dir";
    static final Option OPTION_DEST = OptionBuilder.getInstance().withArgName("destDir").hasArg().isRequired(true).withDescription("specify the dest dir to save the related information").create("destDir");
    static final Option OPTION_START_TIME = OptionBuilder.getInstance().withArgName("startTime").hasArg().isRequired(false).withDescription("specify the start of time range to extract logs. ").create("startTime");
    static final Option OPTION_END_TIME = OptionBuilder.getInstance().withArgName("endTime").hasArg().isRequired(false).withDescription("specify the end of time range to extract logs. ").create("endTime");
    static final Option OPTION_CURRENT_TIME = OptionBuilder.getInstance().withArgName("currentTime").hasArg().isRequired(false).withDescription("specify the current of time from client to fix diff between client and server and timezone problem. ").create("currentTime");
    static final Option OPTION_COMPRESS = OptionBuilder.getInstance().withArgName("compress").hasArg().isRequired(false).withDescription("specify whether to compress the output with zip. Default true.").create("compress");
    static final Option OPTION_SUBMODULE = OptionBuilder.getInstance().withArgName("submodule").hasArg().isRequired(false).withDescription("specify whether this is a submodule of other CLI tool").create("submodule");
    static final Option OPTION_SYSTEM_ENV = OptionBuilder.getInstance().withArgName("systemProp").hasArg().isRequired(false).withDescription("specify whether to include system env and properties to extract. Default false.").create("systemProp");
    static final Option OPTION_DIAGID = OptionBuilder.getInstance().withArgName("diagId").hasArg().isRequired(false).withDescription("Specify whether diag from web").create("diagId");
    static final Option OPTION_OBF_LEVEL = OptionBuilder.getInstance().withArgName("obfLevel").hasArg().isRequired(false).withDescription("specify obfuscate level of the diagnostic package: \nRAW means no obfuscate,\nOBF means obfuscate,\nDefault obfuscate level is OBF.").create("obfLevel");
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final Option OPTION_THREADS = OptionBuilder.getInstance().withArgName("threads").hasArg().isRequired(false).withDescription("Specify number of threads for parallel extraction.").create("threads");
    private static final String DEFAULT_PACKAGE_TYPE = "base";
    private static final String[] COMMIT_SHA1_FILES = new String[]{"commit_SHA1", "commit.sha1"};
    private static final int DEFAULT_PARALLEL_SIZE = 4;
    protected final Options options;
    protected ConcurrentHashMap<DiagSubTaskEnum, Long> taskStartTime;
    protected LinkedBlockingQueue<DiagSubTaskInfo> taskQueue;
    protected StageEnum stage = StageEnum.PREPARE;
    protected ScheduledExecutorService executorService;
    protected ScheduledExecutorService timerExecutorService;
    protected boolean mainTaskComplete;
    private String packageType;
    private File exportDir;
    private KylinConfig kylinConfig;
    private KapConfig kapConfig;
    private String kylinHome;
    private CliCommandExecutor cmdExecutor;
    private boolean includeSystemEnv;

    public AbstractInfoExtractorTool() {
        this.options = new Options();
        this.options.addOption(OPTION_DEST);
        this.options.addOption(OPTION_COMPRESS);
        this.options.addOption(OPTION_SUBMODULE);
        this.options.addOption(OPTION_SYSTEM_ENV);
        this.options.addOption(OPTION_START_TIME);
        this.options.addOption(OPTION_END_TIME);
        this.options.addOption(OPTION_DIAGID);
        this.options.addOption(OPTION_OBF_LEVEL);
        this.packageType = DEFAULT_PACKAGE_TYPE;
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.kapConfig = KapConfig.wrap((KylinConfig)this.kylinConfig);
        this.kylinHome = KapConfig.getKylinHomeAtBestEffort().getAbsolutePath();
        this.cmdExecutor = this.kylinConfig.getCliCommandExecutor();
    }

    protected Options getOptions() {
        return this.options;
    }

    protected abstract void executeExtract(OptionsHelper var1, File var2) throws Exception;

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        this.stage = StageEnum.PREPARE;
        TimeZoneUtils.setDefaultTimeZone((KylinConfig)this.kylinConfig);
        String exportDest = optionsHelper.getOptionValue(OPTION_DEST);
        boolean shouldCompress = this.getBooleanOption(optionsHelper, OPTION_COMPRESS, true);
        boolean submodule = this.getBooleanOption(optionsHelper, OPTION_SUBMODULE, false);
        this.includeSystemEnv = this.getBooleanOption(optionsHelper, OPTION_SYSTEM_ENV, false);
        if (this.isDiag()) {
            int threadsNum = this.getIntOption(optionsHelper, OPTION_THREADS, 4);
            this.executorService = Executors.newScheduledThreadPool(threadsNum);
            this.timerExecutorService = Executors.newScheduledThreadPool(2);
            this.taskQueue = new LinkedBlockingQueue();
            this.taskStartTime = new ConcurrentHashMap();
            if (this.isDiagFromWeb(optionsHelper)) {
                this.scheduleDiagProgress(optionsHelper.getOptionValue(OPTION_DIAGID));
            }
            logger.info("Start diagnosis info extraction in {} threads.", (Object)threadsNum);
        }
        Preconditions.checkArgument((!StringUtils.isEmpty((String)exportDest) ? 1 : 0) != 0, (Object)"destDir is not set, exit directly without extracting");
        if (!exportDest.endsWith(SLASH)) {
            exportDest = exportDest + SLASH;
        }
        String packageName = this.packageType.toLowerCase(Locale.ROOT) + "_" + new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss", Locale.getDefault(Locale.Category.FORMAT)).format(new Date());
        if (!submodule) {
            exportDest = exportDest + packageName + SLASH;
        }
        this.exportDir = new File(exportDest);
        FileUtils.forceMkdir((File)this.exportDir);
        if (!submodule) {
            this.dumpBasicDiagInfo();
        }
        this.stage = StageEnum.EXTRACT;
        this.mainTaskComplete = false;
        this.executeExtract(optionsHelper, this.exportDir);
        this.mainTaskComplete = true;
        this.obfDiag(optionsHelper, this.exportDir);
        if (shouldCompress) {
            this.stage = StageEnum.COMPRESS;
            File tempZipFile = new File(RandomUtil.randomUUIDStr() + ".zip");
            ZipFileUtils.compressZipFile((String)this.exportDir.getAbsolutePath(), (String)tempZipFile.getAbsolutePath());
            FileUtils.cleanDirectory((File)this.exportDir);
            String sha256Sum = DatatypeConverter.printHexBinary((byte[])HashFunction.SHA256.checksum(tempZipFile));
            String packageFilename = StringUtils.join((Object[])new String[]{ToolUtil.getHostName(), this.getKylinConfig().getServerPort(), packageName, sha256Sum.substring(0, 6)}, (char)'_');
            File zipFile = new File(this.exportDir, packageFilename + ".zip");
            FileUtils.moveFile((File)tempZipFile, (File)zipFile);
            exportDest = zipFile.getAbsolutePath();
            this.exportDir = new File(exportDest);
        }
        this.stage = StageEnum.DONE;
        if (this.isDiagFromWeb(optionsHelper)) {
            this.reportDiagProgressImmediately(optionsHelper.getOptionValue(OPTION_DIAGID));
            ExecutorServiceUtil.forceShutdown((ExecutorService)this.timerExecutorService);
        }
    }

    String getObfMappingPath() {
        return KylinConfig.getKylinHome() + "/logs/obfuscation-mapping.json";
    }

    protected void obfDiag(OptionsHelper optionsHelper, File rootDir) throws IOException {
        logger.info("Start obf diag file.");
        ObfLevel obfLevel = ObfLevel.valueOf(this.kylinConfig.getDiagObfLevel());
        if (optionsHelper.hasOption(OPTION_OBF_LEVEL)) {
            obfLevel = ObfLevel.valueOf(optionsHelper.getOptionValue(OPTION_OBF_LEVEL));
        }
        logger.info("Obf level is {}.", (Object)obfLevel);
        try (MappingRecorder recorder = new MappingRecorder(null);){
            ResultRecorder resultRecorder = new ResultRecorder();
            KylinConfObfuscator kylinConfObfuscator = new KylinConfObfuscator(obfLevel, recorder, resultRecorder);
            kylinConfObfuscator.obfuscate(new File(rootDir, "conf"), file -> file.isFile() && file.getName().startsWith("kylin.properties"));
        }
    }

    private boolean isDiag() {
        return this instanceof DiagClientTool || this instanceof JobDiagInfoTool || this instanceof StreamingJobDiagInfoTool || this instanceof QueryDiagInfoTool;
    }

    private boolean isDiagFromWeb(OptionsHelper optionsHelper) {
        return this.isDiag() && optionsHelper.hasOption(OPTION_DIAGID);
    }

    private void scheduleDiagProgress(String diagId) {
        long interval = 3L;
        int serverPort = Integer.parseInt(this.getKylinConfig().getServerPort());
        RestClient restClient = new RestClient("127.0.0.1", serverPort, null, null);
        this.timerExecutorService.scheduleWithFixedDelay(() -> restClient.updateDiagProgress(diagId, this.getStage(), this.getProgress(), System.currentTimeMillis()), 0L, interval, TimeUnit.SECONDS);
    }

    private void reportDiagProgressImmediately(String diagId) {
        int retry = 3;
        int serverPort = Integer.parseInt(this.getKylinConfig().getServerPort());
        RestClient restClient = new RestClient("127.0.0.1", serverPort, null, null);
        boolean updateSuccess = false;
        while (retry-- > 0 && !updateSuccess) {
            updateSuccess = restClient.updateDiagProgress(diagId, this.getStage(), this.getProgress(), System.currentTimeMillis());
        }
    }

    protected void exportSparkLog(File exportDir, long startTime, long endTime, File recordTime, String queryId) {
        Future<?> sparkLogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SPARK_LOGS);
            if (StringUtils.isEmpty((String)queryId)) {
                KylinLogTool.extractFullDiagSparderLog(exportDir, startTime, endTime);
            } else {
                KylinLogTool.extractQueryDiagSparderLog(exportDir, startTime, endTime);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SPARK_LOGS, recordTime);
        });
        this.scheduleTimeoutTask(sparkLogTask, DiagSubTaskEnum.SPARK_LOGS);
        Future<?> sparderHistoryTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SPARDER_HISTORY);
            ILogExtractor extractTool = ExtractFactory.create();
            this.tryRollUpEventLog();
            KylinLogTool.extractSparderEventLog(exportDir, startTime, endTime, this.getKapConfig().getSparkConf(), extractTool);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SPARDER_HISTORY, recordTime);
        });
        this.scheduleTimeoutTask(sparderHistoryTask, DiagSubTaskEnum.SPARDER_HISTORY);
    }

    public void tryRollUpEventLog() {
        int retry = 3;
        int serverPort = Integer.parseInt(this.getKylinConfig().getServerPort());
        RestClient restClient = new RestClient("127.0.0.1", serverPort, null, null);
        boolean eventLogSuccess = false;
        while (retry-- > 0 && !eventLogSuccess) {
            eventLogSuccess = restClient.rollUpEventLog();
        }
    }

    public void extractCommitFile(File exportDir) {
        try {
            for (String commitSHA1File : COMMIT_SHA1_FILES) {
                File commitFile = new File(this.kylinHome, commitSHA1File);
                if (!commitFile.exists()) continue;
                Files.copy(commitFile.toPath(), new File(exportDir, commitFile.getName()).toPath(), new CopyOption[0]);
            }
        }
        catch (IOException e) {
            logger.warn("Failed to copy commit_SHA1 file.", (Throwable)e);
        }
    }

    public void dumpSystemEnv() throws IOException {
        StringBuilder sb = new StringBuilder("System env:").append("\n");
        Map<String, String> systemEnv = System.getenv();
        for (Map.Entry<String, String> entry : systemEnv.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append("\n");
        }
        sb.append("System properties:").append("\n");
        Properties systemProperties = System.getProperties();
        for (String key : systemProperties.stringPropertyNames()) {
            sb.append(key).append("=").append(systemProperties.getProperty(key)).append("\n");
        }
        FileUtils.writeStringToFile((File)new File(this.exportDir, "system_env"), (String)sb.toString());
    }

    public void dumpLicenseInfo(File exportDir) throws IOException {
        StringBuilder basicSb = new StringBuilder();
        File[] licenseFiles = new File(this.kylinHome).listFiles((dir, name) -> name.endsWith(".license") || name.equals("LICENSE"));
        File licFile = null;
        if (licenseFiles != null && licenseFiles.length > 0) {
            File[] fileArray = licenseFiles;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File licenseFile;
                licFile = licenseFile = fileArray[i];
            }
        }
        StringBuilder licSb = new StringBuilder();
        if (null != licFile) {
            int splitPos = 0;
            List lines = FileUtils.readLines(licFile);
            licSb.append("Statement: ").append((String)lines.get(0)).append("\n");
            for (int i = 0; i < lines.size(); ++i) {
                String line = (String)lines.get(i);
                if (line.startsWith("Parallel Scale:")) {
                    licSb.append(line).append("\n");
                    continue;
                }
                if (line.startsWith("Service End:")) {
                    licSb.append(line).append("\n");
                    continue;
                }
                if (!line.equals("====")) continue;
                splitPos = i;
            }
            if (splitPos > 0 && splitPos + 2 < lines.size()) {
                licSb.append((String)lines.get(splitPos + 1)).append("\n");
                licSb.append((String)lines.get(splitPos + 2)).append("\n");
            }
        }
        basicSb.append("MetaStoreID: ").append(ToolUtil.getMetaStoreId()).append("\n");
        basicSb.append(licSb.toString());
        basicSb.append("PackageType: ").append(this.packageType.toUpperCase(Locale.ROOT)).append("\n");
        String hostname = ToolUtil.getHostName();
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z", Locale.getDefault(Locale.Category.FORMAT));
        basicSb.append("PackageTimestamp: ").append(format.format(new Date())).append("\n");
        basicSb.append("Host: ").append(hostname).append("\n");
        FileUtils.writeStringToFile((File)new File(exportDir, "info"), (String)basicSb.toString());
    }

    private void dumpBasicDiagInfo() throws IOException {
        this.extractCommitFile(this.exportDir);
        File kylinEnv = new File(this.exportDir, "kylin_env");
        FileUtils.writeStringToFile((File)kylinEnv, (String)ServerInfoUtil.getKylinClientInformation());
        this.dumpLicenseInfo(this.exportDir);
        if (this.includeSystemEnv) {
            this.dumpSystemEnv();
        }
    }

    protected void addFile(File srcFile, File destDir) {
        logger.info("copy file: {}", (Object)srcFile.getName());
        try {
            FileUtils.forceMkdir((File)destDir);
        }
        catch (IOException e) {
            logger.error("Can not create" + destDir, (Throwable)e);
        }
        File destFile = new File(destDir, srcFile.getName());
        String copyCmd = String.format(Locale.ROOT, "cp -r %s %s", srcFile.getAbsolutePath(), destFile.getAbsolutePath());
        logger.info("The command is: {}", (Object)copyCmd);
        try {
            this.cmdExecutor.execute(copyCmd, null);
        }
        catch (Exception e) {
            logger.debug("Failed to execute copyCmd", (Throwable)e);
        }
    }

    protected void addShellOutput(String cmd, File destDir, String filename) {
        this.addShellOutput(cmd, destDir, filename, false);
    }

    protected void addShellOutput(String cmd, File destDir, String filename, boolean append) {
        this.addShellOutput(cmd, destDir, filename, append, false);
    }

    protected void addShellOutput(String cmd, File destDir, String filename, boolean append, boolean errorDebug) {
        if (null == this.cmdExecutor) {
            logger.error("Failed to run cmd because cmdExecutor is null: {}", (Object)cmd);
            return;
        }
        try {
            if (null == destDir) {
                destDir = this.exportDir;
            }
            FileUtils.forceMkdir((File)destDir);
            String output = this.cmdExecutor.execute(cmd, null).getCmd();
            FileUtils.writeStringToFile((File)new File(destDir, filename), (String)output, (boolean)append);
        }
        catch (Exception e) {
            if (errorDebug) {
                logger.debug("Failed to run command: {}", (Object)cmd, (Object)e);
            }
            logger.error("Failed to run command: {}", (Object)cmd, (Object)e);
        }
    }

    public String getStringOption(OptionsHelper optionsHelper, Option option, String defaultVal) {
        return optionsHelper.hasOption(option) ? optionsHelper.getOptionValue(option) : defaultVal;
    }

    public boolean getBooleanOption(OptionsHelper optionsHelper, Option option, boolean defaultVal) {
        return optionsHelper.hasOption(option) ? Boolean.parseBoolean(optionsHelper.getOptionValue(option)) : defaultVal;
    }

    public int getIntOption(OptionsHelper optionsHelper, Option option, int defaultVal) {
        return optionsHelper.hasOption(option) ? Integer.parseInt(optionsHelper.getOptionValue(option)) : defaultVal;
    }

    public long getLongOption(OptionsHelper optionsHelper, Option option, long defaultVal) {
        return optionsHelper.hasOption(option) ? Long.parseLong(optionsHelper.getOptionValue(option)) : defaultVal;
    }

    public String getStage() {
        return this.stage.toString();
    }

    public float getProgress() {
        if (this.executorService == null || this.getStage().equals("PREPARE")) {
            return 0.0f;
        }
        if (this.getStage().equals("DONE")) {
            return 1.0f;
        }
        long totalTaskCount = ((ThreadPoolExecutor)((Object)this.executorService)).getTaskCount() + 1L;
        long completedTaskCount = ((ThreadPoolExecutor)((Object)this.executorService)).getCompletedTaskCount() + (long)(this.mainTaskComplete ? 1 : 0);
        return (float)completedTaskCount / (float)totalTaskCount * 0.9f;
    }

    protected void awaitDiagPackageTermination(long timeout) throws InterruptedException {
        try {
            if (this.executorService != null && !this.executorService.awaitTermination(timeout, TimeUnit.SECONDS)) {
                ExecutorServiceUtil.forceShutdown((ExecutorService)this.executorService);
                throw new KylinTimeoutException("The query exceeds the set time limit of " + KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds() + "s. Current step: Diagnosis packaging. ");
            }
        }
        catch (InterruptedException e) {
            ExecutorServiceUtil.forceShutdown((ExecutorService)this.executorService);
            logger.debug("diagnosis main wait for all sub task exit...");
            long start = System.currentTimeMillis();
            boolean allSubTaskExit = this.executorService.awaitTermination(600L, TimeUnit.SECONDS);
            logger.warn("diagnosis main task quit by interrupt , all sub task exit ? {} , waiting for {} ms ", (Object)allSubTaskExit, (Object)(System.currentTimeMillis() - start));
            throw e;
        }
    }

    protected void dumpMetadata(String[] metaToolArgs, File recordTime) {
        Future<?> metadataTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.METADATA);
            try {
                File metaDir = new File(this.exportDir, "metadata");
                FileUtils.forceMkdir((File)metaDir);
                new MetadataTool().execute(metaToolArgs);
            }
            catch (Exception e) {
                logger.error("Failed to extract metadata.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.METADATA, recordTime);
        });
        this.scheduleTimeoutTask(metadataTask, DiagSubTaskEnum.METADATA);
    }

    protected void dumpStreamingSparkLog(String[] sparkToolArgs, File recordTime) {
        Future<?> metadataTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SPARK_STREAMING_LOGS);
            try {
                new StreamingSparkLogTool().execute(sparkToolArgs);
            }
            catch (Exception e) {
                logger.error("Failed to extract streaming spark log.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SPARK_STREAMING_LOGS, recordTime);
        });
        this.scheduleTimeoutTask(metadataTask, DiagSubTaskEnum.SPARK_STREAMING_LOGS);
    }

    protected void exportRecCandidate(String project, String modelId, File exportDir, boolean full, File recordTime) {
        Future<?> recTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.REC_CANDIDATE);
            try {
                File recDir = new File(exportDir, "rec_candidate");
                FileUtils.forceMkdir((File)recDir);
                if (full) {
                    new RecCandidateTool().extractFull(recDir);
                } else {
                    new RecCandidateTool().extractModel(project, modelId, recDir);
                }
            }
            catch (Exception e) {
                logger.error("Failed to extract rec candidate.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.REC_CANDIDATE, recordTime);
        });
        this.scheduleTimeoutTask(recTask, DiagSubTaskEnum.REC_CANDIDATE);
    }

    protected void exportTieredStorage(String project, File exportDir, long startTime, long endTime, File recordTime) {
        Future<?> kgLogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.TIERED_STORAGE_LOGS);
            new ClickhouseDiagTool(project).dumpClickHouseServerLog(exportDir, startTime, endTime);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.TIERED_STORAGE_LOGS, recordTime);
        });
        this.scheduleTimeoutTask(kgLogTask, DiagSubTaskEnum.TIERED_STORAGE_LOGS);
    }

    protected void exportKgLogs(File exportDir, long startTime, long endTime, File recordTime) {
        Future<?> kgLogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.KG_LOGS);
            KylinLogTool.extractKGLogs(exportDir, startTime, endTime);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.KG_LOGS, recordTime);
        });
        this.scheduleTimeoutTask(kgLogTask, DiagSubTaskEnum.KG_LOGS);
    }

    protected void exportAuditLog(String[] auditLogToolArgs, File recordTime) {
        Future<?> auditTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.AUDIT_LOG);
            try {
                new AuditLogTool(KylinConfig.getInstanceFromEnv()).execute(auditLogToolArgs);
            }
            catch (Exception e) {
                logger.error("Failed to extract audit log.", (Throwable)e);
            }
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.AUDIT_LOG, recordTime);
        });
        this.scheduleTimeoutTask(auditTask, DiagSubTaskEnum.AUDIT_LOG);
    }

    protected void exportInfluxDBMetrics(File exportDir, File recordTime) {
        Future<?> metricsTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SYSTEM_METRICS);
            InfluxDBTool.dumpInfluxDBMetrics(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SYSTEM_METRICS, recordTime);
        });
        this.scheduleTimeoutTask(metricsTask, DiagSubTaskEnum.SYSTEM_METRICS);
        Future<?> monitorTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.MONITOR_METRICS);
            InfluxDBTool.dumpInfluxDBMonitorMetrics(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.MONITOR_METRICS, recordTime);
        });
        this.scheduleTimeoutTask(monitorTask, DiagSubTaskEnum.MONITOR_METRICS);
    }

    protected void exportClient(File recordTime) {
        Future<?> clientTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.CLIENT);
            CommonInfoTool.exportClientInfo(this.exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.CLIENT, recordTime);
        });
        this.scheduleTimeoutTask(clientTask, DiagSubTaskEnum.CLIENT);
    }

    protected void exportJstack(File recordTime) {
        Future<?> jstackTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.JSTACK);
            JStackTool.extractJstack(this.exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.JSTACK, recordTime);
        });
        this.scheduleTimeoutTask(jstackTask, DiagSubTaskEnum.JSTACK);
    }

    protected void exportSystemUsageInfo(File recordTime, long startTime, long endTime) {
        Future<?> confTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SYSTEM_USAGE);
            SystemUsageTool.extractUseInfo(this.exportDir, startTime, endTime);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SYSTEM_USAGE, recordTime);
        });
        this.scheduleTimeoutTask(confTask, DiagSubTaskEnum.SYSTEM_USAGE);
    }

    protected void exportConf(File exportDir, File recordTime, boolean includeConf, boolean includeBin) {
        if (includeConf) {
            Future<?> confTask = this.executorService.submit(() -> {
                this.recordTaskStartTime(DiagSubTaskEnum.CONF);
                ConfTool.extractConf(exportDir);
                this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.CONF, recordTime);
            });
            this.scheduleTimeoutTask(confTask, DiagSubTaskEnum.CONF);
        }
        Future<?> hadoopConfTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.HADOOP_CONF);
            ConfTool.extractHadoopConf(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.HADOOP_CONF, recordTime);
        });
        this.scheduleTimeoutTask(hadoopConfTask, DiagSubTaskEnum.HADOOP_CONF);
        if (includeBin) {
            Future<?> binTask = this.executorService.submit(() -> {
                this.recordTaskStartTime(DiagSubTaskEnum.BIN);
                ConfTool.extractBin(exportDir);
                this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.BIN, recordTime);
            });
            this.scheduleTimeoutTask(binTask, DiagSubTaskEnum.BIN);
        }
        Future<?> hadoopEnvTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.HADOOP_ENV);
            CommonInfoTool.exportHadoopEnv(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.HADOOP_ENV, recordTime);
        });
        this.scheduleTimeoutTask(hadoopEnvTask, DiagSubTaskEnum.HADOOP_ENV);
        Future<?> catcalogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.CATALOG_INFO);
            CommonInfoTool.exportKylinHomeDir(exportDir);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.CATALOG_INFO, recordTime);
        });
        this.scheduleTimeoutTask(catcalogTask, DiagSubTaskEnum.CATALOG_INFO);
    }

    protected void scheduleTimeoutTask(Future task, DiagSubTaskEnum taskEnum) {
        if (!KylinConfig.getInstanceFromEnv().getDiagTaskTimeoutBlackList().contains((Object)taskEnum.name())) {
            this.taskQueue.add(new DiagSubTaskInfo(task, taskEnum));
            logger.info("Add {} to task queue.", (Object)taskEnum);
        }
    }

    protected void executeTimeoutTask(LinkedBlockingQueue<DiagSubTaskInfo> tasks) {
        this.timerExecutorService.submit(() -> {
            while (!tasks.isEmpty()) {
                DiagSubTaskInfo info = (DiagSubTaskInfo)tasks.poll();
                Future task = info.getTask();
                DiagSubTaskEnum taskEnum = info.getTaskEnum();
                logger.info("Timeout task {} start at {}.", (Object)taskEnum, (Object)System.currentTimeMillis());
                Long startTime = this.taskStartTime.get((Object)taskEnum);
                if (startTime == null) {
                    startTime = System.currentTimeMillis();
                    logger.info("Task {} start time is not set now, choose current time {} as task start time.", (Object)taskEnum, (Object)startTime);
                }
                long endTime = startTime + KylinConfig.getInstanceFromEnv().getDiagTaskTimeout() * 1000L;
                long waitTime = endTime - System.currentTimeMillis();
                logger.info("Timeout task {} wait time is {}ms.", (Object)taskEnum, (Object)waitTime);
                if (waitTime > 0L) {
                    try {
                        task.get(waitTime, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        logger.warn(String.format(Locale.ROOT, "Task %s call get function.", task), (Throwable)e);
                    }
                }
                if (task.cancel(true)) {
                    logger.error("Cancel '{}' task.", (Object)taskEnum);
                }
                logger.info("Timeout task {} exit at {}.", (Object)taskEnum, (Object)System.currentTimeMillis());
            }
        });
    }

    protected void recordTaskStartTime(DiagSubTaskEnum subTask) {
        logger.info("Start to dump {}.", (Object)subTask);
        this.taskStartTime.put(subTask, System.currentTimeMillis());
    }

    protected void recordTaskExecutorTimeToFile(DiagSubTaskEnum subTask, File file) {
        long startTime = this.taskStartTime.get((Object)subTask);
        DiagnosticFilesChecker.writeMsgToFile(subTask.name(), System.currentTimeMillis() - startTime, file);
    }

    @Generated
    public String getPackageType() {
        return this.packageType;
    }

    @Generated
    public void setPackageType(String packageType) {
        this.packageType = packageType;
    }

    @Generated
    public File getExportDir() {
        return this.exportDir;
    }

    @Generated
    public KylinConfig getKylinConfig() {
        return this.kylinConfig;
    }

    @Generated
    public KapConfig getKapConfig() {
        return this.kapConfig;
    }

    @Generated
    public String getKylinHome() {
        return this.kylinHome;
    }

    @Generated
    public CliCommandExecutor getCmdExecutor() {
        return this.cmdExecutor;
    }
}

