/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.dbcp2.BasicDataSourceFactory;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeTool;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.metadata.JdbcAuditLogStore;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.NExecutableManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class AuditLogTool
extends ExecutableApplication {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String CHARSET = Charset.defaultCharset().name();
    private static final Option OPTION_START_TIME = OptionBuilder.getInstance().hasArg().withArgName("START_TIMESTAMP").withDescription("Specify the start timestamp (sec) (optional)").isRequired(false).create("startTime");
    private static final Option OPTION_END_TIME = OptionBuilder.getInstance().hasArg().withArgName("END_TIMESTAMP").withDescription("Specify the end timestamp (sec) (optional)").isRequired(false).create("endTime");
    private static final Option OPTION_JOB = OptionBuilder.getInstance().hasArg().withArgName("JOB_ID").withDescription("Specify the job (optional)").isRequired(false).create("job");
    private static final Option OPTION_PROJECT = OptionBuilder.getInstance().hasArg().withArgName("OPTION_PROJECT").withDescription("Specify project (optional)").isRequired(false).create("project");
    private static final Option OPTION_RESTORE = OptionBuilder.getInstance().withDescription("Restore audit log from local path").isRequired(false).create("restore");
    private static final Option OPTION_TABLE = OptionBuilder.getInstance().hasArg().withArgName("TABLE_NAME").withDescription("Specify the table (optional)").isRequired(false).create("table");
    private static final Option OPTION_DIR = OptionBuilder.getInstance().hasArg().withArgName("DESTINATION_DIR").withDescription("Specify the directory for audit log backup or restore").isRequired(true).create("dir");
    private static final String AUDIT_LOG_SUFFIX = ".jsonl";
    private static final int MAX_BATCH_SIZE = 50000;
    private final Options options;
    private final KylinConfig kylinConfig;

    AuditLogTool() {
        this(KylinConfig.newKylinConfig());
    }

    public AuditLogTool(KylinConfig kylinConfig) {
        this.kylinConfig = kylinConfig;
        this.options = new Options();
        this.initOptions();
    }

    public static void main(String[] args) {
        try {
            AuditLogTool tool = new AuditLogTool();
            tool.execute(args);
        }
        catch (Exception e) {
            System.out.println("\u001b[31mAudit log task failed.\u001b[0m");
            logger.error("fail execute audit log tool: ", (Throwable)e);
            Unsafe.systemExit((int)1);
        }
        System.out.println("Audit log task finished.");
        Unsafe.systemExit((int)0);
    }

    private void initOptions() {
        this.options.addOption(OPTION_JOB);
        this.options.addOption(OPTION_DIR);
        this.options.addOption(OPTION_START_TIME);
        this.options.addOption(OPTION_END_TIME);
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_RESTORE);
        this.options.addOption(OPTION_TABLE);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String dir = optionsHelper.getOptionValue(OPTION_DIR);
        if (optionsHelper.hasOption(OPTION_RESTORE)) {
            this.restore(optionsHelper, dir);
        } else if (optionsHelper.hasOption(OPTION_JOB)) {
            this.extractJob(optionsHelper, dir);
        } else {
            this.extractFull(optionsHelper, dir);
        }
    }

    private void extractJob(OptionsHelper optionsHelper, String dir) throws Exception {
        if (!optionsHelper.hasOption(OPTION_PROJECT)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_NOT_SPECIFY, new Object[]{"-project"});
        }
        String project = optionsHelper.getOptionValue(OPTION_PROJECT);
        if (StringUtils.isEmpty((String)project)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_EMPTY, new Object[]{"project"});
        }
        String jobId = optionsHelper.getOptionValue(OPTION_JOB);
        if (StringUtils.isEmpty((String)jobId)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_EMPTY, new Object[]{"job"});
        }
        AbstractExecutable job = NExecutableManager.getInstance((KylinConfig)this.kylinConfig, (String)project).getJob(jobId);
        long startTs = job.getStartTime();
        long endTs = job.getEndTime();
        this.extract(startTs, endTs, Paths.get(dir, String.format(Locale.ROOT, "%d-%d%s", startTs, endTs, AUDIT_LOG_SUFFIX)).toFile());
    }

    private void extractFull(OptionsHelper optionsHelper, String dir) throws Exception {
        if (!optionsHelper.hasOption(OPTION_START_TIME)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_TIMESTAMP_NOT_SPECIFY, new Object[]{"-startTime"});
        }
        if (!optionsHelper.hasOption(OPTION_END_TIME)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_TIMESTAMP_NOT_SPECIFY, new Object[]{"-endTime"});
        }
        long startTs = Long.parseLong(optionsHelper.getOptionValue(OPTION_START_TIME));
        long endTs = Long.parseLong(optionsHelper.getOptionValue(OPTION_END_TIME));
        this.extract(startTs, endTs, Paths.get(dir, String.format(Locale.ROOT, "%d-%d%s", startTs, endTs, AUDIT_LOG_SUFFIX)).toFile());
    }

    private void restore(OptionsHelper optionsHelper, String dir) throws Exception {
        if (!optionsHelper.hasOption(OPTION_TABLE)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_NOT_SPECIFY, new Object[]{"-table"});
        }
        String table = optionsHelper.getOptionValue(OPTION_TABLE);
        if (StringUtils.isEmpty((String)table)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PARAMETER_EMPTY, new Object[]{"table"});
        }
        File dirFile = Paths.get(dir, new String[0]).toFile();
        if (!dirFile.exists()) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeTool.PATH_NOT_EXISTS, new Object[]{dir});
        }
        StorageURL url = this.kylinConfig.getMetadataUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        BasicDataSource dataSource = BasicDataSourceFactory.createDataSource((Properties)props);
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager((DataSource)dataSource);
        JdbcTemplate jdbcTemplate = new JdbcTemplate((DataSource)dataSource);
        try (JdbcAuditLogStore auditLogStore = new JdbcAuditLogStore(this.kylinConfig, jdbcTemplate, transactionManager, table);){
            for (File logFile : Objects.requireNonNull(dirFile.listFiles())) {
                if (!logFile.getName().endsWith(AUDIT_LOG_SUFFIX)) continue;
                try (FileInputStream fin = new FileInputStream(logFile);
                     BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fin, CHARSET));){
                    String line;
                    ArrayList auditLogs = Lists.newArrayList();
                    while ((line = br.readLine()) != null) {
                        try {
                            auditLogs.add(JsonUtil.readValue((String)line, AuditLog.class));
                        }
                        catch (Exception e) {
                            logger.error("audit log deserialize error >>> {}", (Object)line, (Object)e);
                        }
                    }
                    auditLogStore.batchInsert((List)auditLogs);
                }
            }
        }
    }

    private void extract(long startTs, long endTs, File auditLogFile) throws Exception {
        auditLogFile.getParentFile().mkdirs();
        long fromId = Long.MAX_VALUE;
        int batchSize = KylinConfig.getInstanceFromEnv().getAuditLogBatchSize();
        batchSize = Math.min(50000, batchSize);
        logger.info("Audit log batch size is {}.", (Object)batchSize);
        try (JdbcAuditLogStore auditLogStore = new JdbcAuditLogStore(this.kylinConfig, this.kylinConfig.getAuditLogBatchTimeout());
             FileOutputStream fos = new FileOutputStream(auditLogFile);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)fos, CHARSET), 0xA00000);){
            while (true) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("audit log task is interrupt");
                }
                List auditLogs = auditLogStore.fetchRange(fromId, startTs, endTs, batchSize);
                if (CollectionUtils.isEmpty((Collection)auditLogs)) {
                    break;
                }
                auditLogs.forEach(x -> {
                    try {
                        bw.write(JsonUtil.writeValueAsString((Object)x));
                        bw.newLine();
                    }
                    catch (Exception e) {
                        logger.error("Write audit log error, id is {}", (Object)x.getId(), (Object)e);
                    }
                });
                if (auditLogs.size() < batchSize) {
                    break;
                }
                fromId = ((AuditLog)auditLogs.get(auditLogs.size() - 1)).getId();
                logger.info("Audit log size is {}, id range is [{},{}].", new Object[]{auditLogs.size(), ((AuditLog)auditLogs.get(0)).getId(), fromId});
            }
        }
    }
}

