/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.base.Preconditions;
import io.kyligence.kap.secondstorage.SecondStorage;
import io.kyligence.kap.secondstorage.SecondStorageNodeHelper;
import io.kyligence.kap.secondstorage.config.ClusterInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.zip.GZIPInputStream;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.tool.KylinLogTool;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClickhouseDiagTool {
    public static final String SUB_DIR = "tieredStorage";
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String CK_NODE_PATH_FORMAT = "%s_%s_%s";
    private static final String SECOND_DATE_FORMAT = "yyyy.MM.dd HH:mm:ss.SSSSSS";
    private static final KylinLogTool.ExtractLogByRangeTool LOG_EXTRACT = new KylinLogTool.ExtractLogByRangeTool("^([0-9]{4}\\.[0-9]{2}\\.[0-9]{2} [0-9]{2}:[0-9]{2}:[0-9]{2}\\.[0-9]{6})", "yyyy.MM.dd HH:mm:ss.SSSSSS");
    private String project;

    public ClickhouseDiagTool(String project) {
        this.project = project;
    }

    private static String getCompressedFileMatcher(String filePrefix, int maxCompressedFile) {
        Preconditions.checkState((maxCompressedFile > 0 ? 1 : 0) != 0, (Object)("max file count should > 0," + maxCompressedFile));
        return IntStream.range(0, maxCompressedFile).mapToObj(index -> filePrefix + "." + index + ".gz").collect(Collectors.joining(",", "{", "}"));
    }

    private boolean isFullDiag() {
        return this.project == null;
    }

    public void dumpClickHouseServerLog(File exportDir, long startTime, long endTime) {
        try {
            SecondStorage.init((boolean)false);
            if (!SecondStorage.enabled()) {
                logger.error("TieredStorage is not enabled. Skip to fetch diag log.");
                return;
            }
            File ckLogsDir = new File(exportDir, SUB_DIR);
            FileUtils.forceMkdir((File)ckLogsDir);
            this.extractCkLogFile(ckLogsDir, startTime, endTime);
        }
        catch (Exception e) {
            logger.error("TieredStorage is enabled. But extract error,", (Throwable)e);
        }
    }

    private void extractCkLogFile(File exportDir, long startTime, long endTime) {
        List allNodes;
        ClusterInfo cluster = SecondStorage.configLoader().getCluster();
        if (cluster.emptyCluster()) {
            logger.error("TieredStorage cluster is empty. Skip to fetch diag log.");
            return;
        }
        if (StringUtils.isEmpty((String)cluster.getLogPath())) {
            logger.error("TieredStorage log path is empty. Skip to fetch diag log.");
            return;
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String diagLogMatcher = kylinConfig.getSecondStorageDiagLogMatcher();
        File remoteFilePath = new File(cluster.getLogPath(), diagLogMatcher);
        int maxCompressedFile = kylinConfig.getSecondStorageDiagMaxCompressedFile();
        File remoteHistoryGZPath = maxCompressedFile > 0 ? new File(cluster.getLogPath(), ClickhouseDiagTool.getCompressedFileMatcher(diagLogMatcher, maxCompressedFile)) : null;
        Pair timeRange = new Pair((Object)new DateTime(startTime).toString(SECOND_DATE_FORMAT), (Object)new DateTime(endTime).toString(SECOND_DATE_FORMAT));
        List list = allNodes = this.isFullDiag() ? cluster.getNodes() : SecondStorageNodeHelper.getALlNodesInProject((String)this.project);
        if (CollectionUtils.isEmpty((Collection)allNodes)) {
            logger.warn("There is no active node in TieredStorage");
        }
        allNodes.forEach(node -> {
            CliCommandExecutor cliCommandExecutor = new CliCommandExecutor(node.getIp(), cluster.getUserName(), cluster.getPassword(), kylinConfig.getSecondStorageSshIdentityPath(), node.getSSHPort());
            File nodeTargetPath = new File(exportDir, String.format(Locale.ROOT, CK_NODE_PATH_FORMAT, node.getName(), node.getIp(), node.getPort()));
            File nodeTargetTmpPath = new File(exportDir, nodeTargetPath.getName() + "_tmp");
            try {
                FileUtils.forceMkdir((File)nodeTargetPath);
                FileUtils.forceMkdir((File)nodeTargetTmpPath);
                cliCommandExecutor.copyRemoteToLocal(remoteFilePath.getAbsolutePath(), nodeTargetTmpPath.getAbsolutePath());
                this.copyAndUnzipCompressedLogFile(remoteHistoryGZPath, cliCommandExecutor, nodeTargetTmpPath);
                if (!this.extractCkLogByRange((Pair<String, String>)timeRange, nodeTargetPath, nodeTargetTmpPath)) {
                    return;
                }
                this.cleanEmptyFile(nodeTargetPath);
            }
            catch (IOException e) {
                logger.error("gather clickhouse log failed,{},", (Object)nodeTargetTmpPath.getAbsolutePath(), (Object)e);
            }
            finally {
                FileUtils.deleteQuietly((File)nodeTargetTmpPath);
            }
        });
    }

    private void copyAndUnzipCompressedLogFile(File remoteHistoryGZPath, CliCommandExecutor cliCommandExecutor, File nodeTargetTmpPath) {
        if (remoteHistoryGZPath == null) {
            return;
        }
        try {
            cliCommandExecutor.copyRemoteToLocal(remoteHistoryGZPath.getAbsolutePath(), nodeTargetTmpPath.getAbsolutePath());
            this.unzipLogFile(nodeTargetTmpPath);
        }
        catch (IOException e) {
            logger.error("copy remote compressed file failed,{},", (Object)nodeTargetTmpPath.getAbsolutePath(), (Object)e);
        }
    }

    private boolean extractCkLogByRange(Pair<String, String> timeRange, File nodeTargetPath, File nodeTargetTmpPath) {
        Object[] serverLogFiles = nodeTargetTmpPath.listFiles((dir, name) -> name.endsWith(".log"));
        if (ArrayUtils.isEmpty((Object[])serverLogFiles)) {
            logger.error("{} dir is empty", (Object)nodeTargetTmpPath.getAbsolutePath());
            return false;
        }
        Arrays.stream(serverLogFiles).forEach(file -> {
            try {
                LOG_EXTRACT.extractLogByRange((File)file, timeRange, nodeTargetPath);
            }
            catch (IOException e) {
                logger.error("extract file:{} log error", file, (Object)e);
            }
        });
        return true;
    }

    private void cleanEmptyFile(File filePath) {
        Object[] fileList = filePath.listFiles();
        if (ArrayUtils.isEmpty((Object[])fileList)) {
            return;
        }
        Arrays.stream(fileList).filter(file -> FileUtils.sizeOf((File)file) == 0L).forEach(file -> {
            if (FileUtils.deleteQuietly((File)file)) {
                logger.debug("{} size is 0, clean it success", (Object)file.getName());
                return;
            }
            logger.debug("{} size is 0, clean it failed", (Object)file.getName());
        });
    }

    private void unzipLogFile(File nodeTargetPath) {
        Object[] gzFileList = nodeTargetPath.listFiles((dir, name) -> name.endsWith(".gz"));
        if (ArrayUtils.isEmpty((Object[])gzFileList)) {
            logger.warn("{} dont have gz file, skit unzip it", (Object)nodeTargetPath.getName());
            return;
        }
        Arrays.stream(gzFileList).filter(file -> FileUtils.sizeOf((File)file) > 0L).forEach(file -> {
            try {
                int len;
                GZIPInputStream gzipInputStream = new GZIPInputStream(new FileInputStream((File)file));
                String fileName = file.getName().substring(0, file.getName().lastIndexOf("."));
                FileOutputStream fileOutputStream = new FileOutputStream(new File(nodeTargetPath, fileName + ".log"));
                byte[] buffer = new byte[1024];
                while ((len = gzipInputStream.read(buffer)) > 0) {
                    fileOutputStream.write(buffer, 0, len);
                }
                gzipInputStream.close();
                fileOutputStream.close();
                logger.info("Extracted " + fileName);
            }
            catch (IOException e) {
                logger.error("extract gz file:{} log error", file, (Object)e);
            }
        });
    }

    @Generated
    public ClickhouseDiagTool() {
    }
}

