/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.tool.util.ToolUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final Set<String> KYLIN_BIN_INCLUSION = Sets.newHashSet((Object[])new String[]{"kylin.sh"});

    private ConfTool() {
    }

    public static void extractConf(File exportDir) {
        try {
            File confDir = new File(ToolUtil.getConfFolder());
            if (confDir.exists()) {
                FileUtils.copyDirectoryToDirectory((File)confDir, (File)exportDir);
            } else {
                logger.error("Can not find the /conf dir: {}!", (Object)confDir.getAbsolutePath());
            }
        }
        catch (Exception e) {
            logger.warn("Failed to copy /conf, ", (Throwable)e);
        }
    }

    public static void extractHadoopConf(File exportDir) {
        try {
            File hadoopConfDir = new File(ToolUtil.getHadoopConfFolder());
            if (hadoopConfDir.exists()) {
                FileUtils.copyDirectoryToDirectory((File)hadoopConfDir, (File)exportDir);
            } else {
                logger.error("Can not find the hadoop_conf: {}!", (Object)hadoopConfDir.getAbsolutePath());
            }
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            String buildHadoopConf = kylinConfig.getBuildConf();
            if (StringUtils.isNotEmpty((String)buildHadoopConf)) {
                File buildHadoopConfDir = new File(buildHadoopConf);
                if (buildHadoopConfDir.exists()) {
                    FileUtils.copyDirectoryToDirectory((File)buildHadoopConfDir, (File)exportDir);
                } else {
                    logger.error("Can not find the write hadoop_conf: {}!", (Object)buildHadoopConfDir.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to copy /hadoop_conf, ", (Throwable)e);
        }
    }

    public static void extractBin(File exportDir) {
        File destBinDir = new File(exportDir, "bin");
        try {
            File[] binFiles;
            FileUtils.forceMkdir((File)destBinDir);
            File srcBinDir = new File(ToolUtil.getBinFolder());
            if (srcBinDir.exists() && null != (binFiles = srcBinDir.listFiles())) {
                for (File binFile : binFiles) {
                    String binFileName = binFile.getName();
                    if (!KYLIN_BIN_INCLUSION.contains(binFileName)) continue;
                    Files.copy(binFile.toPath(), new File(destBinDir, binFile.getName()).toPath(), new CopyOption[0]);
                    logger.info("copy file: {} {}", (Object)binFiles, (Object)destBinDir);
                }
            }
        }
        catch (Exception e) {
            logger.error("Failed to export bin.", (Throwable)e);
        }
    }
}

