/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.Unsafe;

public class DumpHadoopSystemProps {
    private static final String NO_PARAMETER = RandomUtil.randomUUIDStr();
    private static final String UTF8 = "UTF-8";

    public static void main(String[] args) throws Exception {
        File tmp = File.createTempFile("kylin-env-diff-", ".sh");
        String filters = NO_PARAMETER;
        switch (args.length) {
            case 0: {
                break;
            }
            case 1: {
                filters = args[0];
                break;
            }
            default: {
                System.out.println("Usages: DumpHadoopSystemProps 'filter1 filter2 filter3'");
                Unsafe.systemExit((int)1);
            }
        }
        String[] cmd = new String[]{"hadoop", Inner.class.getName(), tmp.getAbsolutePath(), filters};
        Process proc = Runtime.getRuntime().exec(cmd);
        int code = proc.waitFor();
        if (code != 0) {
            throw new IllegalStateException("Failed to execute: " + StringUtils.join(Arrays.asList(cmd), (String)" "));
        }
        TreeMap<String, String> propsDiff = DumpHadoopSystemProps.diffSystemProps(tmp.getAbsolutePath() + ".props");
        TreeMap<String, String> envsDiff = DumpHadoopSystemProps.diffSystemEnvs(tmp.getAbsolutePath() + ".envs");
        DumpHadoopSystemProps.output(propsDiff, envsDiff, tmp);
        System.out.println(tmp.getAbsolutePath());
        Unsafe.systemExit((int)0);
    }

    private static void output(TreeMap<String, String> propsDiff, TreeMap<String, String> envsDiff, File tmp) throws IOException {
        try (PrintWriter out = new PrintWriter(tmp, UTF8);){
            for (Map.Entry<String, String> e : envsDiff.entrySet()) {
                out.println("export " + e.getKey() + "=" + DumpHadoopSystemProps.doubleQuote(e.getValue()));
            }
            out.print("export kylin_hadoop_opts=\"");
            for (Map.Entry<String, String> e : propsDiff.entrySet()) {
                out.print(" -D" + e.getKey() + "=" + DumpHadoopSystemProps.singleQuote(e.getValue()) + " ");
            }
            out.println("\"");
            out.println("rm -f " + tmp.getAbsolutePath());
        }
    }

    private static String doubleQuote(String s) {
        return s.contains(" ") ? "\"" + s + "\"" : s;
    }

    private static String singleQuote(String s) {
        return s.contains(" ") ? "'" + s + "'" : s;
    }

    private static TreeMap<String, String> diffSystemProps(String inPath) throws IOException {
        return DumpHadoopSystemProps.diff(DumpHadoopSystemProps.readAndDelete(inPath), DumpHadoopSystemProps.getSystemProps());
    }

    private static TreeMap<String, String> diffSystemEnvs(String inPath) throws IOException {
        return DumpHadoopSystemProps.diff(DumpHadoopSystemProps.readAndDelete(inPath), DumpHadoopSystemProps.getSystemEnvs());
    }

    private static TreeMap<String, String> diff(TreeMap<String, String> enhanced, TreeMap<String, String> orig) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (Map.Entry<String, String> e : enhanced.entrySet()) {
            String origV = orig.get(e.getKey());
            if (e.getValue().equals(origV)) continue;
            map.put(e.getKey(), e.getValue());
        }
        return map;
    }

    private static TreeMap<String, String> readAndDelete(String inPath) throws IOException {
        TreeMap<String, String> map = new TreeMap<String, String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inPath), UTF8));){
            String line;
            while ((line = in.readLine()) != null) {
                int cut = line.indexOf(61);
                map.put(line.substring(0, cut), line.substring(cut + 1));
            }
        }
        Files.delete(Paths.get(inPath, new String[0]));
        return map;
    }

    private static TreeMap<String, String> getSystemProps() {
        TreeMap<String, String> r = new TreeMap<String, String>();
        for (Object key : System.getProperties().keySet()) {
            String k = key.toString();
            if (k.contains("java.command") || k.contains("class.path")) continue;
            r.put(k, System.getProperty(k));
        }
        return r;
    }

    private static TreeMap<String, String> getSystemEnvs() {
        return new TreeMap<String, String>(System.getenv());
    }

    public static class Inner {
        public static void main(String[] args) throws IOException {
            Inner.dump(DumpHadoopSystemProps.getSystemProps(), args[1], args[0] + ".props");
            Inner.dump(DumpHadoopSystemProps.getSystemEnvs(), args[1], args[0] + ".envs");
        }

        private static void dump(TreeMap<String, String> map, String filters, String outPath) throws IOException {
            try (PrintWriter out = new PrintWriter(outPath, DumpHadoopSystemProps.UTF8);){
                for (Map.Entry<String, String> e : map.entrySet()) {
                    String k = e.getKey();
                    String v = e.getValue();
                    if (k.contains("=") || Inner.containsReturn(k) || Inner.containsReturn(v) || Inner.filter(k, filters)) continue;
                    out.println(k + "=" + v);
                }
            }
        }

        private static boolean filter(String key, String filters) {
            if (filters == null || filters.equals(NO_PARAMETER)) {
                return false;
            }
            for (String s : filters.split(" ")) {
                if (!key.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        private static boolean containsReturn(String s) {
            return (s = s.trim()).isEmpty() || s.contains("\r") || s.contains("\n");
        }
    }
}

