/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.exception.KylinRuntimeException;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.AbstractInfoExtractorTool;
import org.apache.kylin.tool.KylinLogTool;
import org.apache.kylin.tool.YarnApplicationTool;
import org.apache.kylin.tool.constant.DiagSubTaskEnum;
import org.apache.kylin.tool.snapshot.SnapshotSourceTableStatsTool;
import org.apache.kylin.tool.util.DiagnosticFilesChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobDiagInfoTool
extends AbstractInfoExtractorTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final Option OPTION_JOB_ID = OptionBuilder.getInstance().withArgName("job").hasArg().isRequired(true).withDescription("specify the Job ID to extract information. ").create("job");
    private static final Option OPTION_INCLUDE_YARN_LOGS = OptionBuilder.getInstance().withArgName("includeYarnLogs").hasArg().isRequired(false).withDescription("set this to true if want to extract related yarn logs too. Default true").create("includeYarnLogs");
    private static final Option OPTION_INCLUDE_CLIENT = OptionBuilder.getInstance().withArgName("includeClient").hasArg().isRequired(false).withDescription("Specify whether to include client info to extract. Default true.").create("includeClient");
    private static final Option OPTION_INCLUDE_CONF = OptionBuilder.getInstance().withArgName("includeConf").hasArg().isRequired(false).withDescription("Specify whether to include conf files to extract. Default true.").create("includeConf");
    private static final Option OPTION_META = OptionBuilder.getInstance().withArgName("includeMeta").hasArg().isRequired(false).withDescription("Specify whether to include metadata to extract. Default true.").create("includeMeta");
    private static final Option OPTION_AUDIT_LOG = OptionBuilder.getInstance().withArgName("includeAuditLog").hasArg().isRequired(false).withDescription("Specify whether to include auditLog to extract. Default true.").create("includeAuditLog");
    private static final String OPT_JOB = "-job";

    public JobDiagInfoTool() {
        this.setPackageType("job");
        this.options.addOption(OPTION_JOB_ID);
        this.options.addOption(OPTION_INCLUDE_CLIENT);
        this.options.addOption(OPTION_INCLUDE_YARN_LOGS);
        this.options.addOption(OPTION_INCLUDE_CONF);
        this.options.addOption(OPTION_START_TIME);
        this.options.addOption(OPTION_END_TIME);
        this.options.addOption(OPTION_META);
        this.options.addOption(OPTION_AUDIT_LOG);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        String modelId;
        String jobId = optionsHelper.getOptionValue(OPTION_JOB_ID);
        boolean includeYarnLogs = this.getBooleanOption(optionsHelper, OPTION_INCLUDE_YARN_LOGS, true);
        boolean includeClient = this.getBooleanOption(optionsHelper, OPTION_INCLUDE_CLIENT, true);
        boolean includeConf = this.getBooleanOption(optionsHelper, OPTION_INCLUDE_CONF, true);
        boolean includeMeta = this.getBooleanOption(optionsHelper, OPTION_META, true);
        boolean isCloud = this.getKapConfig().isCloud();
        boolean includeAuditLog = this.getBooleanOption(optionsHelper, OPTION_AUDIT_LOG, true);
        boolean includeBin = true;
        long start = System.currentTimeMillis();
        File recordTime = new File(exportDir, "time_used_info");
        AbstractExecutable job = this.getJobByJobId(jobId);
        if (null == job) {
            logger.error("Can not find the jobId: {}", (Object)jobId);
            throw new KylinRuntimeException(String.format(Locale.ROOT, "Can not find the jobId: %s", jobId));
        }
        String project = job.getProject();
        long startTime = job.getCreateTime();
        long endTime = job.getEndTime() != 0L ? job.getEndTime() : System.currentTimeMillis();
        logger.info("job project : {} , startTime : {} , endTime : {}", new Object[]{project, startTime, endTime});
        if (includeMeta) {
            File metaDir = new File(exportDir, "metadata");
            FileUtils.forceMkdir((File)metaDir);
            String[] metaToolArgs = new String[]{"-backup", "-dir", metaDir.getAbsolutePath(), "-project", project, "-excludeTableExd"};
            this.dumpMetadata(metaToolArgs, recordTime);
        }
        if (includeAuditLog) {
            File auditLogDir = new File(exportDir, "audit_log");
            FileUtils.forceMkdir((File)auditLogDir);
            String[] auditLogToolArgs = new String[]{OPT_JOB, jobId, "-project", project, "-dir", auditLogDir.getAbsolutePath()};
            this.exportAuditLog(auditLogToolArgs, recordTime);
        }
        if (StringUtils.isNotEmpty((String)(modelId = job.getTargetModelId()))) {
            this.exportRecCandidate(project, modelId, exportDir, false, recordTime);
        }
        if (includeYarnLogs && !isCloud) {
            Future<?> future = this.executorService.submit(() -> {
                this.recordTaskStartTime(DiagSubTaskEnum.YARN);
                new YarnApplicationTool().extractYarnLogs(exportDir, project, jobId);
                this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.YARN, recordTime);
            });
            this.scheduleTimeoutTask(future, DiagSubTaskEnum.YARN);
        }
        if (includeClient) {
            this.exportClient(recordTime);
        }
        this.exportJstack(recordTime);
        this.exportConf(exportDir, recordTime, includeConf, true);
        this.exportSparkLog(exportDir, recordTime, project, jobId, job);
        this.exportCandidateLog(exportDir, recordTime, project, startTime, endTime);
        this.exportKgLogs(exportDir, startTime, endTime, recordTime);
        this.exportTieredStorage(project, exportDir, startTime, endTime, recordTime);
        this.exportInfluxDBMetrics(exportDir, recordTime);
        this.executeTimeoutTask(this.taskQueue);
        this.exportSourceTableStats(exportDir, recordTime, project, job);
        this.executorService.shutdown();
        this.awaitDiagPackageTermination(this.getKapConfig().getDiagPackageTimeout());
        this.recordTaskStartTime(DiagSubTaskEnum.LOG);
        KylinLogTool.extractKylinLog(exportDir, jobId);
        KylinLogTool.extractOtherLogs(exportDir, startTime, endTime);
        this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.LOG, recordTime);
        DiagnosticFilesChecker.writeMsgToFile("Total files", System.currentTimeMillis() - start, recordTime);
    }

    public Boolean exportSourceTableStats(File exportDir, File recordTime, String project, AbstractExecutable job) {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.readSystemKylinConfig());
        KylinConfigExt projectConfig = projectManager.getProject(project).getConfig();
        if (!projectConfig.isSnapshotManualManagementEnabled() || !projectConfig.isSnapshotAutoRefreshEnabled()) {
            return false;
        }
        HashSet needExtractSourceTableStatsJobTypes = Sets.newHashSet((Object[])new JobTypeEnum[]{JobTypeEnum.INDEX_REFRESH, JobTypeEnum.INDEX_BUILD, JobTypeEnum.INC_BUILD, JobTypeEnum.SUB_PARTITION_BUILD, JobTypeEnum.SUB_PARTITION_REFRESH, JobTypeEnum.SNAPSHOT_BUILD, JobTypeEnum.SNAPSHOT_REFRESH});
        if (needExtractSourceTableStatsJobTypes.contains(job.getJobType())) {
            Future<?> sourceTableStatsTask = this.executorService.submit(() -> {
                this.recordTaskStartTime(DiagSubTaskEnum.SOURCE_TABLE_STATS);
                SnapshotSourceTableStatsTool.extractSourceTableStats((KylinConfig)projectConfig, exportDir, project, job);
                this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SOURCE_TABLE_STATS, recordTime);
            });
            this.scheduleTimeoutTask(sourceTableStatsTask, DiagSubTaskEnum.SOURCE_TABLE_STATS);
            return true;
        }
        return false;
    }

    private void exportCandidateLog(File exportDir, File recordTime, String project, long startTime, long endTime) {
        Future<?> candidateLogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.CANDIDATE_LOG);
            KylinLogTool.extractJobTmpCandidateLog(exportDir, project, startTime, endTime);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.CANDIDATE_LOG, recordTime);
        });
        this.scheduleTimeoutTask(candidateLogTask, DiagSubTaskEnum.CANDIDATE_LOG);
    }

    private void exportSparkLog(File exportDir, File recordTime, String project, String jobId, AbstractExecutable job) {
        Future<?> sparkLogTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.SPARK_LOGS);
            KylinLogTool.extractSparkLog(exportDir, project, jobId);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.SPARK_LOGS, recordTime);
        });
        this.scheduleTimeoutTask(sparkLogTask, DiagSubTaskEnum.SPARK_LOGS);
        Future<?> eventLogTask = this.executorService.submit(() -> {
            if (job instanceof DefaultExecutable) {
                this.recordTaskStartTime(DiagSubTaskEnum.JOB_EVENTLOGS);
                Set appIds = NExecutableManager.getInstance((KylinConfig)this.getKylinConfig(), (String)project).getYarnApplicationJobs(jobId);
                Map sparkConf = this.getKylinConfig().getSparkConfigOverride();
                KylinLogTool.extractJobEventLogs(exportDir, appIds, sparkConf);
                this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.JOB_EVENTLOGS, recordTime);
            }
        });
        this.scheduleTimeoutTask(eventLogTask, DiagSubTaskEnum.JOB_EVENTLOGS);
        Future<?> jobTmpTask = this.executorService.submit(() -> {
            this.recordTaskStartTime(DiagSubTaskEnum.JOB_TMP);
            KylinLogTool.extractJobTmp(exportDir, project, jobId);
            this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.JOB_TMP, recordTime);
        });
        this.scheduleTimeoutTask(jobTmpTask, DiagSubTaskEnum.JOB_TMP);
    }

    @VisibleForTesting
    public AbstractExecutable getJobByJobId(String jobId) {
        List projects = NProjectManager.getInstance((KylinConfig)this.getKylinConfig()).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        for (String project : projects) {
            AbstractExecutable job = NExecutableManager.getInstance((KylinConfig)this.getKylinConfig(), (String)project).getJob(jobId);
            if (job == null) continue;
            return job;
        }
        return null;
    }
}

