/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.query.util.ILogExtractor;
import org.apache.kylin.tool.SparkLogExtractorFactory;
import org.apache.kylin.tool.util.ToolUtil;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterable;
import scala.collection.JavaConversions;
import scala.collection.immutable.List;

public class KylinLogTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final String CHARSET_NAME = Charset.defaultCharset().name();
    public static final long DAY = 86400000L;
    public static final String SECOND_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String LOG_TIME_PATTERN = "^([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2})";
    private static final String LOG_PATTERN = "([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}) ([^ ]*)[ ]+\\[(.*)\\] ([^: ]*) :([\\n\\r. ]*)";
    private static final String QUERY_LOG_PATTERN = "Query ([0-9a-z]{8}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{4}-[0-9a-z]{12})";
    private static final int EXTRA_LINES = 100;
    private static final String ROLL_LOG_FILE_NAME_PREFIX = "events";
    private static final String SYSTEM_PROPERTIES = "System Properties";
    private static final Set<String> kylinLogPrefix = Sets.newHashSet((Object[])new String[]{"kylin.log", "kylin.schedule.log", "kylin.query.log", "kylin.smart.log", "kylin.build.log", "kylin.security.log", "kylin.metadata.log"});
    private static final Set<String> queryDiagExcludedLogs = Sets.newHashSet((Object[])new String[]{"kylin.log", "kylin.schedule.log", "kylin.smart.log", "kylin.build.log", "kylin.security.log"});
    private static ExtractLogByRangeTool DEFAULT_EXTRACT_LOG_BY_RANGE = new ExtractLogByRangeTool("([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2},[0-9]{3}) ([^ ]*)[ ]+\\[(.*)\\] ([^: ]*) :([\\n\\r. ]*)", "^([0-9]{4}-[0-9]{2}-[0-9]{2}T[0-9]{2}:[0-9]{2}:[0-9]{2})", "yyyy-MM-dd'T'HH:mm:ss");

    @VisibleForTesting
    public static String getJobLogPattern(String jobId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)jobId));
        return String.format(Locale.ROOT, "%s(.*JobWorker.*jobid:%s.*)|%s.*%s", LOG_TIME_PATTERN, jobId.substring(0, 8), LOG_TIME_PATTERN, jobId);
    }

    @VisibleForTesting
    public static String getJobTimeString(Matcher matcher) {
        String result = matcher.group(1);
        if (StringUtils.isEmpty((String)result)) {
            result = matcher.group(3);
        }
        return result;
    }

    private static String getQueryLogPattern(String queryId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((String)queryId));
        return String.format(Locale.ROOT, "%s(.*Query %s.*)", LOG_TIME_PATTERN, queryId);
    }

    private KylinLogTool() {
    }

    private static boolean checkTimeoutTask(long timeout, String task) {
        return !KylinConfig.getInstanceFromEnv().getDiagTaskTimeoutBlackList().contains((Object)task) && System.currentTimeMillis() > timeout;
    }

    private static void extractAllIncludeLogs(File[] logFiles, File destDir, long timeout) throws IOException {
        String[] allIncludeLogs = new String[]{"kylin.gc.", "shell.", "kylin.out", "diag.log"};
        for (File logFile : logFiles) {
            for (String includeLog : allIncludeLogs) {
                if (KylinLogTool.checkTimeoutTask(timeout, "LOG")) {
                    logger.error("Cancel 'LOG:all' task.");
                    return;
                }
                if (!logFile.getName().startsWith(includeLog)) continue;
                Files.copy(logFile.toPath(), new File(destDir, logFile.getName()).toPath(), new CopyOption[0]);
            }
        }
    }

    private static void extractPartIncludeLogByDay(File[] logFiles, String startDate, String endDate, File destDir, long timeout) throws IOException {
        String[] partIncludeLogByDay = new String[]{"access_log."};
        for (File logFile : logFiles) {
            for (String includeLog : partIncludeLogByDay) {
                String date;
                if (KylinLogTool.checkTimeoutTask(timeout, "LOG")) {
                    logger.error("Cancel 'LOG:partByDay' task.");
                    return;
                }
                if (!logFile.getName().startsWith(includeLog) || (date = logFile.getName().split("\\.")[1]).compareTo(startDate) < 0 || date.compareTo(endDate) > 0) continue;
                Files.copy(logFile.toPath(), new File(destDir, logFile.getName()).toPath(), new CopyOption[0]);
            }
        }
    }

    private static void extractPartIncludeLogByMs(File[] logFiles, long start, long end, File destDir, long timeout) throws IOException {
        String[] partIncludeLogByMs = new String[]{"jstack.timed.log"};
        for (File logFile : logFiles) {
            for (String includeLog : partIncludeLogByMs) {
                long time;
                if (KylinLogTool.checkTimeoutTask(timeout, "LOG")) {
                    logger.error("Cancel 'LOG:partByMs' task.");
                    return;
                }
                if (!logFile.getName().startsWith(includeLog) || (time = Long.parseLong(logFile.getName().split("\\.")[3])) < start || time > end) continue;
                Files.copy(logFile.toPath(), new File(destDir, logFile.getName()).toPath(), new CopyOption[0]);
            }
        }
    }

    public static void extractOtherLogs(File exportDir, long start, long end) {
        File destDir = new File(exportDir, "logs");
        SimpleDateFormat logFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
        String startDate = logFormat.format(new Date(start));
        String endDate = logFormat.format(new Date(end));
        logger.debug("logs startDate : {}, endDate : {}", (Object)startDate, (Object)endDate);
        long duration = KylinConfig.getInstanceFromEnv().getDiagTaskTimeout() * 1000L;
        long timeout = System.currentTimeMillis() + duration;
        try {
            FileUtils.forceMkdir((File)destDir);
            File kylinLogDir = new File(ToolUtil.getLogFolder());
            if (kylinLogDir.exists()) {
                File[] logFiles = kylinLogDir.listFiles();
                if (null == logFiles) {
                    logger.error("Failed to list kylin logs dir: {}", (Object)kylinLogDir);
                    return;
                }
                KylinLogTool.extractAllIncludeLogs(logFiles, destDir, timeout);
                KylinLogTool.extractPartIncludeLogByDay(logFiles, startDate, endDate, destDir, timeout);
                KylinLogTool.extractPartIncludeLogByMs(logFiles, start, end, destDir, timeout);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract the logs from kylin logs dir, ", (Throwable)e);
        }
    }

    public static void extractKylinLog(File exportDir, String jobId) {
        KylinLogTool.extractKylinLog(exportDir, jobId, null, null, null);
    }

    public static void extractKylinLog(File exportDir, long startTime, long endTime) {
        KylinLogTool.extractKylinLog(exportDir, null, startTime, endTime, null);
    }

    public static void extractKylinLog(File exportDir, long startTime, long endTime, String queryId) {
        KylinLogTool.extractKylinLog(exportDir, null, startTime, endTime, queryId);
    }

    private static Pair<String, String> getTimeRangeFromLogFileByJobId(String jobId, File logFile) {
        return KylinLogTool.getTimeRangeFromLogFileByJobId(jobId, logFile, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<String, String> getTimeRangeFromLogFileByJobId(String jobId, File logFile, boolean onlyStartTime) {
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull((Object)logFile);
        String dateStart = null;
        String dateEnd = null;
        try (FileInputStream in = new FileInputStream(logFile);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, CHARSET_NAME));){
            String log;
            Pattern pattern = Pattern.compile(KylinLogTool.getJobLogPattern(jobId));
            while ((log = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(log);
                if (!matcher.find()) continue;
                if (Objects.isNull(dateStart)) {
                    dateStart = KylinLogTool.getJobTimeString(matcher);
                    if (onlyStartTime) {
                        Pair pair = new Pair((Object)dateStart, (Object)dateStart);
                        return pair;
                    }
                }
                dateEnd = KylinLogTool.getJobTimeString(matcher);
            }
            return new Pair(dateStart, dateEnd);
        }
        catch (Exception e) {
            logger.error("Failed to get time range from logFile:{}, jobId:{}, onlyStartTime: {}", new Object[]{logFile.getAbsolutePath(), jobId, onlyStartTime, e});
        }
        return new Pair(dateStart, dateEnd);
    }

    private static Pair<String, String> getTimeRangeFromLogFileByJobId(String jobId, File[] kylinLogs) {
        String dateStart;
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull((Object)kylinLogs);
        Pair timeRangeResult = new Pair();
        if (0 == kylinLogs.length) {
            return timeRangeResult;
        }
        java.util.List logFiles = Stream.of(kylinLogs).sorted(Comparator.comparing(File::getName)).collect(Collectors.toList());
        int i = 0;
        while (i < logFiles.size()) {
            Pair<String, String> timeRange;
            if (null == (timeRange = KylinLogTool.getTimeRangeFromLogFileByJobId(jobId, (File)logFiles.get(i++))).getFirst() || null == timeRange.getSecond()) continue;
            timeRangeResult.setFirst(timeRange.getFirst());
            timeRangeResult.setSecond(timeRange.getSecond());
            break;
        }
        while (i < logFiles.size() && null != (dateStart = (String)KylinLogTool.getTimeRangeFromLogFileByJobId(jobId, (File)logFiles.get(i++), true).getFirst())) {
            if (dateStart.compareTo((String)timeRangeResult.getFirst()) >= 0) continue;
            timeRangeResult.setFirst((Object)dateStart);
        }
        return timeRangeResult;
    }

    private static boolean isKylinLogFile(String fileName) {
        for (String name : kylinLogPrefix) {
            if (!StringUtils.startsWith((String)fileName, (String)name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isQueryDiagExcludedLogs(String fileName) {
        for (String name : queryDiagExcludedLogs) {
            if (!StringUtils.startsWith((String)fileName, (String)name)) continue;
            return true;
        }
        return false;
    }

    private static void extractQueryLogByQueryId(File queryLogFile, String queryId, File distFile) {
        Preconditions.checkNotNull((Object)queryLogFile);
        Preconditions.checkNotNull((Object)queryId);
        Preconditions.checkNotNull((Object)distFile);
        String charsetName = Charset.defaultCharset().name();
        try (FileInputStream in = new FileInputStream(queryLogFile);
             FileOutputStream out = new FileOutputStream(distFile);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, charsetName));
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, charsetName));){
            String queryLog;
            boolean extract = false;
            boolean stdLogNotFound = true;
            Pattern pattern = Pattern.compile(QUERY_LOG_PATTERN);
            while ((queryLog = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(queryLog);
                if (matcher.find()) {
                    stdLogNotFound = false;
                    if (queryId.equals(matcher.group(1))) {
                        extract = true;
                        bw.write(queryLog);
                        bw.write(10);
                        continue;
                    }
                    extract = false;
                    continue;
                }
                if (!extract && !stdLogNotFound) continue;
                bw.write(queryLog);
                bw.write(10);
            }
        }
        catch (IOException e) {
            logger.error("Failed to extract query log from {} to {}", new Object[]{queryLogFile.getAbsolutePath(), distFile.getAbsolutePath(), e});
        }
    }

    public static void extractQueryDiagSparderLog(File exportDir, long startTime, long endTime) {
        File sparkLogsDir = new File(exportDir, "spark_logs");
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        try {
            FileUtils.forceMkdir((File)sparkLogsDir);
            if (!KylinLogTool.checkTimeRange(startTime, endTime)) {
                return;
            }
            DateTime date = new DateTime(startTime);
            while (date.getMillis() <= endTime) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Sparder log task is interrupt");
                }
                String sourceLogsPath = KylinLogTool.getSourceLogPath(kylinConfig, date);
                FileSystem sourceFileSystem = HadoopUtil.getFileSystem((String)sourceLogsPath);
                if (sourceFileSystem.exists(new Path(sourceLogsPath))) {
                    FileStatus[] sourceAppFiles;
                    File sparkLogsDateDir = new File(sparkLogsDir, date.toString("yyyy-MM-dd"));
                    FileUtils.forceMkdir((File)sparkLogsDateDir);
                    for (FileStatus sourceAppFile : sourceAppFiles = sourceFileSystem.listStatus(new Path(sourceLogsPath))) {
                        KylinLogTool.extractAppDirSparderLog(sourceAppFile, sparkLogsDateDir, startTime, endTime);
                    }
                }
                if (kylinConfig.cleanDiagTmpFile()) {
                    sourceFileSystem.delete(new Path(sourceLogsPath), true);
                    logger.info("Clean tmp spark logs {}", (Object)sourceLogsPath);
                }
                date = date.plusDays(1);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract query sparder log, ", (Throwable)e);
        }
    }

    private static void extractAppDirSparderLog(FileStatus fileStatus, File sparkLogsDateDir, long startTime, long endTime) {
        File exportAppDir = new File(sparkLogsDateDir, fileStatus.getPath().getName());
        try {
            FileUtils.forceMkdir((File)exportAppDir);
            FileSystem sourceExecutorFiles = HadoopUtil.getFileSystem((Path)fileStatus.getPath());
            if (sourceExecutorFiles.exists(fileStatus.getPath())) {
                FileStatus[] executors;
                for (FileStatus sourceExecutorFile : executors = sourceExecutorFiles.listStatus(fileStatus.getPath())) {
                    FileSystem executorFileSystem = HadoopUtil.getFileSystem((Path)sourceExecutorFile.getPath());
                    Pair timeRange = new Pair((Object)new DateTime(startTime).toString(SECOND_DATE_FORMAT), (Object)new DateTime(endTime).toString(SECOND_DATE_FORMAT));
                    File exportExecutorsDir = new File(exportAppDir, sourceExecutorFile.getPath().getName());
                    KylinLogTool.extractExecutorByTimeRange(executorFileSystem, (Pair<String, String>)timeRange, exportExecutorsDir, sourceExecutorFile.getPath());
                    if (FileUtils.sizeOf((File)exportExecutorsDir) != 0L) continue;
                    FileUtils.deleteQuietly((File)exportExecutorsDir);
                }
            }
            if (FileUtils.sizeOf((File)exportAppDir) == 0L) {
                FileUtils.deleteQuietly((File)exportAppDir);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract sparder log in application directory, ", (Throwable)e);
        }
    }

    private static void extractExecutorByTimeRange(FileSystem logFile, Pair<String, String> timeRange, File distFile, Path path) {
        Preconditions.checkNotNull((Object)logFile);
        Preconditions.checkNotNull((Object)path);
        String charsetName = Charset.defaultCharset().name();
        try (FSDataInputStream in = logFile.open(path);
             BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, charsetName));
             FileOutputStream out = new FileOutputStream(distFile);
             BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, charsetName));){
            String log;
            boolean extract = false;
            boolean stdLogNotFound = true;
            Pattern pattern = Pattern.compile(LOG_PATTERN);
            while ((log = br.readLine()) != null) {
                Matcher matcher = pattern.matcher(log);
                if (matcher.find()) {
                    stdLogNotFound = false;
                    String logDate = matcher.group(1);
                    if (logDate.compareTo((String)timeRange.getSecond()) > 0) {
                        break;
                    }
                    if (!extract && logDate.compareTo((String)timeRange.getFirst()) < 0) continue;
                    extract = true;
                    bw.write(log);
                    bw.write(10);
                    continue;
                }
                if (!extract && !stdLogNotFound) continue;
                bw.write(log);
                bw.write(10);
            }
        }
        catch (IOException e) {
            logger.error("Failed to extract executor from {} to {}", new Object[]{path, distFile.getAbsolutePath(), e});
        }
    }

    private static void extractKylinLog(File exportDir, String jobId, Long startTime, Long endTime, String queryId) {
        File destLogDir = new File(exportDir, "logs");
        try {
            Pair timeRange;
            FileUtils.forceMkdir((File)destLogDir);
            File logsDir = new File(ToolUtil.getKylinHome(), "logs");
            if (!logsDir.exists()) {
                logger.error("Can not find the logs dir: {}", (Object)logsDir);
                return;
            }
            File[] kylinLogs = null != queryId ? logsDir.listFiles(pathname -> KylinLogTool.isQueryDiagExcludedLogs(pathname.getName())) : logsDir.listFiles(pathname -> KylinLogTool.isKylinLogFile(pathname.getName()));
            if (null == kylinLogs || 0 == kylinLogs.length) {
                logger.error("Can not find the kylin.log file!");
                return;
            }
            if (null != jobId) {
                timeRange = KylinLogTool.getTimeRangeFromLogFileByJobId(jobId, kylinLogs);
                Preconditions.checkArgument((null != timeRange.getFirst() && null != timeRange.getSecond() && ((String)timeRange.getFirst()).compareTo((String)timeRange.getSecond()) <= 0 ? 1 : 0) != 0, (String)"Can not get time range from log files by jobId: {}", (Object[])new Object[]{jobId});
            } else {
                timeRange = new Pair((Object)new DateTime((Object)startTime).toString(SECOND_DATE_FORMAT), (Object)new DateTime((Object)endTime).toString(SECOND_DATE_FORMAT));
            }
            logger.info("Extract kylin log from {} to {} .", timeRange.getFirst(), timeRange.getSecond());
            long start = System.currentTimeMillis();
            long duration = KylinConfig.getInstanceFromEnv().getDiagTaskTimeout() * 1000L;
            long timeout = start + duration;
            for (File logFile : kylinLogs) {
                if (KylinLogTool.checkTimeoutTask(timeout, "LOG")) {
                    logger.error("Cancel 'LOG:kylin.log' task.");
                    break;
                }
                DEFAULT_EXTRACT_LOG_BY_RANGE.extractLogByRange(logFile, (Pair<String, String>)timeRange, destLogDir);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract kylin.log, ", (Throwable)e);
        }
    }

    public static void extractKylinQueryLog(File exportDir, String queryId) {
        File destLogDir = new File(exportDir, "logs");
        try {
            FileUtils.forceMkdir((File)destLogDir);
            File logsDir = new File(ToolUtil.getKylinHome(), "logs");
            File[] kylinQueryLogs = logsDir.listFiles(pathname -> StringUtils.startsWith((String)pathname.getName(), (String)"kylin.query.log"));
            if (kylinQueryLogs == null || kylinQueryLogs.length == 0) {
                logger.error("Can not fond the kylin.query.log file!");
            }
            for (File kylinQueryLog : kylinQueryLogs) {
                KylinLogTool.extractQueryLogByQueryId(kylinQueryLog, queryId, new File(destLogDir, kylinQueryLog.getName()));
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract kylin.query.log, ", (Throwable)e);
        }
    }

    public static void extractSparkLog(File exportDir, String project, String jobId) {
        File sparkLogsDir = new File(exportDir, "spark_logs");
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        try {
            FileUtils.forceMkdir((File)sparkLogsDir);
            String sourceLogsPath = SparkLogExtractorFactory.create(kylinConfig).getSparkLogsDir(project, kylinConfig);
            FileSystem fs = HadoopUtil.getFileSystem((String)sourceLogsPath);
            String jobPath = sourceLogsPath + "/*/" + jobId;
            FileStatus[] fileStatuses = fs.globStatus(new Path(jobPath));
            if (null == fileStatuses || fileStatuses.length == 0) {
                logger.error("Can not find the spark logs: {}", (Object)jobPath);
                return;
            }
            for (FileStatus fileStatus : fileStatuses) {
                if (Thread.interrupted()) {
                    throw new InterruptedException("spark log task is interrupt");
                }
                fs.copyToLocalFile(false, fileStatus.getPath(), new Path(sparkLogsDir.getAbsolutePath()), true);
            }
            if (kylinConfig.cleanDiagTmpFile()) {
                logger.info("Clean tmp spark logs {}", (Object)sourceLogsPath);
                fs.delete(new Path(sourceLogsPath), true);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract spark log, ", (Throwable)e);
        }
    }

    public static void extractSparderEventLog(File exportDir, long startTime, long endTime, Map<String, String> sparderConf, ILogExtractor extractTool) {
        File sparkLogsDir = new File(exportDir, "sparder_history");
        FileSystem fs = HadoopUtil.getFileSystem((String)extractTool.getSparderEvenLogDir());
        List validApps = extractTool.getValidSparderApps(startTime, endTime);
        JavaConversions.asJavaCollection((Iterable)validApps).forEach(app -> {
            try {
                if (!sparkLogsDir.exists()) {
                    FileUtils.forceMkdir((File)sparkLogsDir);
                }
                String fileAppId = app.getPath().getName().split("#")[0].replace(extractTool.ROLL_LOG_DIR_NAME_PREFIX(), "");
                File localFile = new File(sparkLogsDir, fileAppId);
                KylinLogTool.copyValidLog(fileAppId, startTime, endTime, app, fs, localFile);
            }
            catch (Exception e) {
                logger.error("Failed to extract sparder eventLog.", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void hideLicenseString(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            logger.error("file {} is not exist", (Object)file.getAbsolutePath());
            return;
        }
        logger.info("hide license file {}", (Object)file.getAbsolutePath());
        File tempFile = new File(file.getParent(), RandomUtil.randomUUIDStr());
        try {
            FileUtils.moveFile((File)file, (File)tempFile);
            try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(tempFile), Charset.defaultCharset().name()));
                 BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), Charset.defaultCharset().name()));){
                String line;
                while ((line = br.readLine()) != null) {
                    HashMap map = (HashMap)JsonUtil.readValue((String)line, HashMap.class);
                    if (map.containsKey(SYSTEM_PROPERTIES)) {
                        Map systemProperties = (Map)map.get(SYSTEM_PROPERTIES);
                        systemProperties.put("ke.license", "***");
                        line = JsonUtil.writeValueAsString((Object)map);
                    }
                    bw.write(line);
                    bw.newLine();
                }
            }
        }
        finally {
            FileUtils.deleteQuietly((File)tempFile);
        }
    }

    private static void copyValidLog(String appId, long startTime, long endTime, FileStatus fileStatus, FileSystem fs, File localFile) throws IOException, InterruptedException {
        FileStatus[] eventStatuses;
        for (FileStatus status : eventStatuses = fs.listStatus(new Path(fileStatus.getPath().toUri()))) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("Event log task is interrupt");
            }
            boolean valid = false;
            boolean isFirstLogFile = false;
            String[] att = status.getPath().getName().replace("_" + appId, "").split("_");
            if (att.length >= 3 && ROLL_LOG_FILE_NAME_PREFIX.equals(att[0])) {
                long begin = Long.parseLong(att[2]);
                long end = System.currentTimeMillis();
                if (att.length == 4) {
                    end = Long.parseLong(att[3]);
                }
                boolean isTimeValid = begin <= endTime && end >= startTime;
                isFirstLogFile = "1".equals(att[1]);
                if (isTimeValid || isFirstLogFile) {
                    valid = true;
                }
            }
            KylinLogTool.copyToLocalFile(valid, localFile, status, fs, isFirstLogFile);
        }
    }

    private static void copyToLocalFile(boolean valid, File localFile, FileStatus status, FileSystem fs, boolean isFirstLogFile) throws IOException {
        if (valid) {
            if (!localFile.exists()) {
                FileUtils.forceMkdir((File)localFile);
            }
            fs.copyToLocalFile(false, status.getPath(), new Path(localFile.getAbsolutePath()), true);
            if (isFirstLogFile) {
                KylinLogTool.hideLicenseString(new File(localFile, status.getPath().getName()));
            }
        }
    }

    public static void extractJobEventLogs(File exportDir, Set<String> appIds, Map<String, String> sparkConf) {
        try {
            String logDir = sparkConf.get("spark.eventLog.dir").trim();
            boolean eventEnabled = Boolean.parseBoolean(sparkConf.get("spark.eventLog.enabled").trim());
            if (!eventEnabled || StringUtils.isBlank((String)logDir)) {
                return;
            }
            File jobLogsDir = new File(exportDir, "job_history");
            FileUtils.forceMkdir((File)jobLogsDir);
            FileSystem fs = HadoopUtil.getFileSystem((String)logDir);
            for (String appId : appIds) {
                if (!StringUtils.isNotEmpty((String)appId)) continue;
                KylinLogTool.copyJobEventLog(fs, appId, logDir, jobLogsDir);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract job eventLog.", (Throwable)e);
        }
    }

    private static void copyJobEventLog(FileSystem fs, String appId, String logDir, File exportDir) throws Exception {
        if (StringUtils.isBlank((String)appId)) {
            logger.warn("Failed to extract step eventLog due to the appId is empty.");
            return;
        }
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Job eventLog task is interrupt");
        }
        String eventPath = logDir + "/" + appId + "*";
        FileStatus[] eventLogsStatus = fs.globStatus(new Path(eventPath));
        Path[] listedPaths = FileUtil.stat2Paths((FileStatus[])eventLogsStatus);
        logger.info("Copy appId {}.", (Object)appId);
        for (Path path : listedPaths) {
            FileStatus fileStatus = fs.getFileStatus(path);
            if (fileStatus == null) continue;
            fs.copyToLocalFile(false, fileStatus.getPath(), new Path(exportDir.getAbsolutePath()), true);
        }
    }

    private static File getJobTmpDir(File exportDir) throws IOException {
        File jobTmpDir = new File(exportDir, "job_tmp");
        FileUtils.forceMkdir((File)jobTmpDir);
        return jobTmpDir;
    }

    private static boolean notExistHdfsPath(FileSystem fs, String hdfsPath) throws IOException {
        if (!fs.exists(new Path(hdfsPath))) {
            logger.error("Can not find the hdfs path: {}", (Object)hdfsPath);
            return true;
        }
        return false;
    }

    public static void extractJobTmp(File exportDir, String project, String jobId) {
        try {
            File jobTmpDir = KylinLogTool.getJobTmpDir(exportDir);
            String hdfsPath = ToolUtil.getJobTmpDir((String)project, (String)jobId);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            if (KylinLogTool.notExistHdfsPath(fs, hdfsPath)) {
                return;
            }
            fs.copyToLocalFile(false, new Path(hdfsPath), new Path(jobTmpDir.getAbsolutePath()), true);
        }
        catch (Exception e) {
            logger.error("Failed to extract job_tmp, ", (Throwable)e);
        }
    }

    public static void extractJobTmpCandidateLog(File exportDir, String project, long startTime, long endTime) {
        logger.info("extract job tmp candidate log for {}", (Object)project);
        try {
            FileStatus[] fileStatuses;
            File jobTmpDir = KylinLogTool.getJobTmpDir(exportDir);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            String hdfsPath = ToolUtil.getHdfsJobTmpDir((String)project);
            if (KylinLogTool.notExistHdfsPath(fs, hdfsPath)) {
                return;
            }
            for (FileStatus fileStatus : fileStatuses = fs.listStatus(new Path(hdfsPath))) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Candidate log task is interrupt");
                }
                String fileName = fileStatus.getPath().getName();
                if (!fileName.startsWith(project) || !fileName.endsWith(".zip")) continue;
                String dateString = fileName.substring(project.length() + 1, fileName.length() - 4);
                long date = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS", Locale.getDefault(Locale.Category.FORMAT)).parse(dateString).getTime();
                if (startTime > date || date > endTime) continue;
                fs.copyToLocalFile(false, fileStatus.getPath(), new Path(jobTmpDir.getAbsolutePath()), true);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract job_tmp candidate log", (Throwable)e);
        }
    }

    public static void extractFullDiagSparderLog(File exportDir, long startTime, long endTime) {
        File sparkLogsDir = new File(exportDir, "spark_logs");
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        try {
            FileUtils.forceMkdir((File)sparkLogsDir);
            if (!KylinLogTool.checkTimeRange(startTime, endTime)) {
                return;
            }
            long days = (endTime - startTime) / 86400000L;
            if (days > 31L) {
                logger.error("time range is too large, startTime: {}, endTime: {}, days: {}", new Object[]{startTime, endTime, days});
                return;
            }
            DateTime date = new DateTime(startTime).withTimeAtStartOfDay();
            while (date.getMillis() <= endTime + 86400000L - 1L) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("sparder log task is interrupt");
                }
                String sourceLogsPath = KylinLogTool.getSourceLogPath(kylinConfig, date);
                FileSystem fs = HadoopUtil.getFileSystem((String)sourceLogsPath);
                if (fs.exists(new Path(sourceLogsPath))) {
                    fs.copyToLocalFile(false, new Path(sourceLogsPath), new Path(sparkLogsDir.getAbsolutePath()), true);
                }
                if (kylinConfig.cleanDiagTmpFile()) {
                    fs.delete(new Path(sourceLogsPath), true);
                    logger.info("Clean tmp spark logs {}", (Object)sourceLogsPath);
                }
                date = date.plusDays(1);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract sparder log, ", (Throwable)e);
        }
    }

    private static String getSourceLogPath(KylinConfig kylinConfig, DateTime date) {
        return SparkLogExtractorFactory.create(kylinConfig).getSparderLogsDir(kylinConfig) + File.separator + date.toString("yyyy-MM-dd");
    }

    private static boolean checkTimeRange(long startTime, long endTime) {
        if (endTime < startTime) {
            logger.error("Time range is error, endTime: {} < startTime: {}", (Object)endTime, (Object)startTime);
            return false;
        }
        return true;
    }

    public static void extractKGLogs(File exportDir, long startTime, long endTime) {
        File kgLogsDir = new File(exportDir, "logs");
        try {
            FileUtils.forceMkdir((File)kgLogsDir);
            if (endTime < startTime) {
                logger.error("endTime: {} < startTime: {}", (Object)endTime, (Object)startTime);
                return;
            }
            File logsDir = new File(ToolUtil.getKylinHome(), "logs");
            if (!logsDir.exists()) {
                logger.error("Can not find the logs dir: {}", (Object)logsDir);
                return;
            }
            File[] kgLogs = logsDir.listFiles(pathname -> pathname.getName().startsWith("guardian.log"));
            if (null == kgLogs || 0 == kgLogs.length) {
                logger.error("Can not find the guardian.log file!");
                return;
            }
            Pair timeRange = new Pair((Object)new DateTime(startTime).toString(SECOND_DATE_FORMAT), (Object)new DateTime(endTime).toString(SECOND_DATE_FORMAT));
            logger.info("Extract guardian log from {} to {} .", timeRange.getFirst(), timeRange.getSecond());
            for (File logFile : kgLogs) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException("Kg log task is interrupt");
                }
                DEFAULT_EXTRACT_LOG_BY_RANGE.extractLogByRange(logFile, (Pair<String, String>)timeRange, kgLogsDir);
            }
        }
        catch (Exception e) {
            logger.error("Failed to extract kg log!", (Throwable)e);
        }
    }

    public static class ExtractLogByRangeTool {
        private String logPattern;
        private String logTimePattern;
        private String secondDateFormat;

        public ExtractLogByRangeTool(String logPattern, String logTimePattern, String secondDateFormat) {
            this.logPattern = logPattern;
            this.logTimePattern = logTimePattern;
            this.secondDateFormat = secondDateFormat;
        }

        public ExtractLogByRangeTool(String logPattern, String secondDateFormat) {
            this.logPattern = logPattern;
            this.logTimePattern = logPattern;
            this.secondDateFormat = secondDateFormat;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getFirstTimeByLogFile(File logFile) {
            try (FileInputStream in = new FileInputStream(logFile);
                 BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, CHARSET_NAME));){
                String log;
                Matcher matcher;
                Pattern pattern = Pattern.compile(this.logTimePattern);
                do {
                    if ((log = br.readLine()) == null) return null;
                } while (!(matcher = pattern.matcher(log)).find());
                String string = matcher.group(1);
                return string;
            }
            catch (Exception e) {
                logger.error("Failed to get first time by log file: {}", (Object)logFile.getAbsolutePath(), (Object)e);
            }
            return null;
        }

        public void extractLogByRange(File logFile, Pair<String, String> timeRange, File destLogDir) throws IOException {
            String lastDate = new DateTime(logFile.lastModified()).toString(this.secondDateFormat);
            if (lastDate.compareTo((String)timeRange.getFirst()) < 0) {
                return;
            }
            String logFirstTime = this.getFirstTimeByLogFile(logFile);
            if (Objects.isNull(logFirstTime) || logFirstTime.compareTo((String)timeRange.getSecond()) > 0) {
                return;
            }
            if (logFirstTime.compareTo((String)timeRange.getFirst()) >= 0 && lastDate.compareTo((String)timeRange.getSecond()) <= 0) {
                Files.copy(logFile.toPath(), new File(destLogDir, logFile.getName()).toPath(), new CopyOption[0]);
            } else {
                this.extractLogByTimeRange(logFile, timeRange, new File(destLogDir, logFile.getName()));
            }
        }

        public void extractLogByTimeRange(File logFile, Pair<String, String> timeRange, File distFile) {
            Preconditions.checkNotNull((Object)logFile);
            Preconditions.checkNotNull(timeRange);
            Preconditions.checkNotNull((Object)distFile);
            Preconditions.checkArgument((((String)timeRange.getFirst()).compareTo((String)timeRange.getSecond()) <= 0 ? 1 : 0) != 0);
            String charsetName = Charset.defaultCharset().name();
            try (FileInputStream in = new FileInputStream(logFile);
                 FileOutputStream out = new FileOutputStream(distFile);
                 BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, charsetName));
                 BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, charsetName));){
                String log;
                boolean extract = false;
                boolean stdLogNotFound = true;
                Pattern pattern = Pattern.compile(this.logPattern);
                int extraLines = 100;
                while ((log = br.readLine()) != null) {
                    Matcher matcher = pattern.matcher(log);
                    if (matcher.find()) {
                        stdLogNotFound = false;
                        String logDate = matcher.group(1);
                        if (logDate.compareTo((String)timeRange.getSecond()) > 0 && --extraLines < 1) {
                            break;
                        }
                        if (!extract && logDate.compareTo((String)timeRange.getFirst()) < 0) continue;
                        extract = true;
                        bw.write(log);
                        bw.write(10);
                        continue;
                    }
                    if (!extract && !stdLogNotFound) continue;
                    bw.write(log);
                    bw.write(10);
                }
            }
            catch (IOException e) {
                logger.error("Failed to extract log from {} to {}", new Object[]{logFile.getAbsolutePath(), distFile.getAbsolutePath(), e});
            }
        }
    }
}

