/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import java.io.File;
import java.util.Locale;
import org.apache.commons.cli.Option;
import org.apache.commons.io.FileUtils;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.apache.kylin.tool.AbstractInfoExtractorTool;
import org.apache.kylin.tool.KylinLogTool;
import org.apache.kylin.tool.constant.DiagSubTaskEnum;
import org.apache.kylin.tool.util.DiagnosticFilesChecker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDiagInfoTool
extends AbstractInfoExtractorTool {
    private static final Logger logger = LoggerFactory.getLogger((String)"diag");
    private static final Option OPTION_QUERY_ID = OptionBuilder.getInstance().withArgName("query").hasArg().isRequired(true).withDescription("specify the Query ID to extract information. ").create("query");
    private static final Option OPTION_PROJECT = OptionBuilder.getInstance().withArgName("project").hasArg().isRequired(true).withDescription("Specify realizations in which project to extract").create("project");
    private static final Option OPTION_QUERY_CONF = OptionBuilder.getInstance().withArgName("includeConf").hasArg().isRequired(false).withDescription("Specify whether to include conf files to extract. Default true.").create("includeConf");
    private static final Option OPTION_QUERY_CLIENT = OptionBuilder.getInstance().withArgName("includeClient").hasArg().isRequired(false).withDescription("Specify whether to include client info to extract. Default true.").create("includeClient");
    private static final Option OPTION_QUERY_META = OptionBuilder.getInstance().withArgName("includeMeta").hasArg().isRequired(false).withDescription("Specify whether to include metadata to extract. Default true.").create("includeMeta");

    public QueryDiagInfoTool() {
        this.setPackageType("query");
        this.options.addOption(OPTION_QUERY_ID);
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_QUERY_CLIENT);
        this.options.addOption(OPTION_QUERY_CONF);
        this.options.addOption(OPTION_QUERY_META);
    }

    @Override
    protected void executeExtract(OptionsHelper optionsHelper, File exportDir) throws Exception {
        String queryId = optionsHelper.getOptionValue(OPTION_QUERY_ID);
        String project = optionsHelper.getOptionValue(OPTION_PROJECT);
        boolean includeConf = this.getBooleanOption(optionsHelper, OPTION_QUERY_CONF, true);
        boolean includeClient = this.getBooleanOption(optionsHelper, OPTION_QUERY_CLIENT, true);
        boolean includeMeta = this.getBooleanOption(optionsHelper, OPTION_QUERY_META, true);
        boolean includeBin = false;
        long start = System.currentTimeMillis();
        File recordTime = new File(exportDir, "time_used_info");
        QueryHistory query = this.getQueryByQueryId(queryId);
        if (null == query) {
            logger.error("Can not find the queryId: {}", (Object)queryId);
            throw new RuntimeException(String.format(Locale.ROOT, "Can not find the queryId: %s", queryId));
        }
        if (project == null || !project.equals(query.getProjectName())) {
            logger.error("Can not find the project: {}", (Object)project);
            throw new RuntimeException(String.format(Locale.ROOT, "Can not find the project: %s", project));
        }
        long startTime = query.getQueryTime();
        long endTime = query.getDuration() + startTime;
        logger.info("query project : {} , startTime : {} , endTime : {}", new Object[]{project, startTime, endTime});
        if (includeMeta) {
            File metaDir = new File(exportDir, "metadata");
            FileUtils.forceMkdir((File)metaDir);
            String[] metaToolArgs = new String[]{"-backup", "-dir", metaDir.getAbsolutePath(), "-project", project, "-excludeTableExd"};
            this.dumpMetadata(metaToolArgs, recordTime);
        }
        if (includeClient) {
            this.exportClient(recordTime);
        }
        this.exportConf(exportDir, recordTime, includeConf, false);
        this.exportSparkLog(exportDir, startTime, endTime, recordTime, queryId);
        this.exportKgLogs(exportDir, startTime, endTime, recordTime);
        this.executeTimeoutTask(this.taskQueue);
        this.executorService.shutdown();
        this.awaitDiagPackageTermination(this.getKapConfig().getDiagPackageTimeout());
        this.recordTaskStartTime(DiagSubTaskEnum.LOG);
        KylinLogTool.extractKylinLog(exportDir, startTime, endTime, queryId);
        KylinLogTool.extractKylinQueryLog(exportDir, queryId);
        KylinLogTool.extractOtherLogs(exportDir, startTime, endTime);
        this.recordTaskExecutorTimeToFile(DiagSubTaskEnum.LOG, recordTime);
        DiagnosticFilesChecker.writeMsgToFile("Total files", System.currentTimeMillis() - start, recordTime);
    }

    public QueryHistory getQueryByQueryId(String queryId) {
        RDBMSQueryHistoryDAO rdbmsQueryHistoryDAO = RDBMSQueryHistoryDAO.getInstance();
        return rdbmsQueryHistoryDAO.getByQueryId(queryId);
    }
}

