/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.apache.kylin.metadata.query.QueryMetrics;
import org.apache.kylin.metadata.query.RDBMSQueryHistoryDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryHistoryAccessCLI {
    private static final Logger logger = LoggerFactory.getLogger(QueryHistoryAccessCLI.class);
    private static final String PROJECT = "test_project";
    private static final String FAIL_LOG = "query history access test failed.";
    private final RDBMSQueryHistoryDAO queryHistoryDAO = RDBMSQueryHistoryDAO.getInstance();

    public static void main(String[] args) {
        QueryHistoryAccessCLI cli = null;
        try {
            cli = new QueryHistoryAccessCLI();
        }
        catch (Exception e) {
            logger.error("Test failed.", (Throwable)e);
            Unsafe.systemExit((int)1);
        }
        if (args.length != 1) {
            Unsafe.systemExit((int)1);
        }
        for (long repetition = Long.parseLong(args[0]); repetition > 0L; --repetition) {
            if (cli.testAccessQueryHistory()) continue;
            logger.error("Test failed.");
            Unsafe.systemExit((int)1);
        }
        logger.info("Test succeed.");
        Unsafe.systemExit((int)0);
    }

    public boolean testAccessQueryHistory() {
        try {
            QueryMetrics queryMetrics = new QueryMetrics("6a9a151f-f992-4d52-a8ec-8ff3fd3de6b1", "192.168.1.6:7070");
            queryMetrics.setSql("select LSTG_FORMAT_NAME from KYLIN_SALES\nLIMIT 500");
            queryMetrics.setSqlPattern("SELECT \"LSTG_FORMAT_NAME\"\nFROM \"KYLIN_SALES\"\nLIMIT 1");
            queryMetrics.setQueryDuration(5578L);
            queryMetrics.setTotalScanBytes(863L);
            queryMetrics.setTotalScanCount(4096L);
            queryMetrics.setResultRowCount(500L);
            queryMetrics.setSubmitter("ADMIN");
            queryMetrics.setErrorType("");
            queryMetrics.setCacheHit(true);
            queryMetrics.setIndexHit(true);
            queryMetrics.setQueryTime(1584888338274L);
            queryMetrics.setProjectName(PROJECT);
            QueryHistoryInfo queryHistoryInfo = new QueryHistoryInfo(true, Integer.valueOf(5), true);
            QueryMetrics.RealizationMetrics realizationMetrics = new QueryMetrics.RealizationMetrics("20000000001L", "Table Index", "771157c2-e6e2-4072-80c4-8ec25e1a83ea", (List)Lists.newArrayList());
            realizationMetrics.setQueryId("6a9a151f-f992-4d52-a8ec-8ff3fd3de6b1");
            realizationMetrics.setDuration(4591L);
            realizationMetrics.setQueryTime(1586405449387L);
            realizationMetrics.setProjectName(PROJECT);
            ArrayList realizationMetricsList = Lists.newArrayList();
            realizationMetricsList.add(realizationMetrics);
            realizationMetricsList.add(realizationMetrics);
            queryHistoryInfo.setRealizationMetrics((List)realizationMetricsList);
            queryMetrics.setQueryHistoryInfo(queryHistoryInfo);
            this.queryHistoryDAO.insert(queryMetrics);
            this.queryHistoryDAO.deleteQueryHistoryByProject(PROJECT);
            this.queryHistoryDAO.deleteAllQueryHistoryRealizationForProject(PROJECT);
        }
        catch (Exception e) {
            logger.error(FAIL_LOG, (Throwable)e);
            return false;
        }
        return true;
    }
}

