/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.nio.charset.Charset;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AuditLog;
import org.apache.kylin.common.persistence.ImageDesc;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.event.Event;
import org.apache.kylin.common.persistence.event.ResourceCreateOrUpdateEvent;
import org.apache.kylin.common.persistence.event.ResourceDeleteEvent;
import org.apache.kylin.common.persistence.metadata.AuditLogStore;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.MetadataChecker;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.helper.MetadataToolHelper;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegDetails;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.tool.MetadataTool;
import org.apache.kylin.tool.general.RollbackStatusEnum;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RollbackTool
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RollbackTool.class);
    private MetadataToolHelper helper = new MetadataToolHelper();
    private static final String HDFS_METADATA_URL_FORMATTER = "kylin_metadata@hdfs,path=%s";
    private static final Option OPTION_PROJECT = OptionBuilder.getInstance().hasArg().withArgName("PROJECT_NAME").withDescription("Specify project level for time travel (optional)").isRequired(false).create("project");
    private static final Option OPTION_SKIP_CHECK_DATA = OptionBuilder.getInstance().hasArg().withArgName("SKIP_CHECK_DATA").withDescription("Skip check storage data available (optional)").isRequired(false).create("skipCheckData");
    private static final Option OPTION_TIMESTAMP = OptionBuilder.getInstance().hasArg().withArgName("TIME").withDescription("Specify the travel time(must required)").isRequired(true).create("time");
    @VisibleForTesting
    public final KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
    private final Options options = new Options();
    @VisibleForTesting
    public RollbackStatusEnum rollbackStatus;
    private ResourceStore currentResourceStore;

    RollbackTool() {
        this.initOptions();
    }

    public static void main(String[] args) {
        RollbackTool tool = new RollbackTool();
        try {
            tool.execute(args);
        }
        catch (Exception e) {
            log.error("rollback error", (Throwable)e);
            Unsafe.systemExit((int)1);
        }
        if (RollbackStatusEnum.RESTORE_MIRROR_SUCCESS == tool.rollbackStatus) {
            Unsafe.systemExit((int)0);
        } else {
            Unsafe.systemExit((int)1);
        }
    }

    private void initOptions() {
        this.options.addOption(OPTION_PROJECT);
        this.options.addOption(OPTION_TIMESTAMP);
        this.options.addOption(OPTION_SKIP_CHECK_DATA);
    }

    protected Options getOptions() {
        return this.options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String currentBackupFolder;
        log.info("start roll back");
        log.info("start to init ResourceStore");
        this.currentResourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.kylinConfig);
        this.rollbackStatus = RollbackStatusEnum.START;
        if (!this.checkParam(optionsHelper).booleanValue()) {
            log.error("check param failed");
            return;
        }
        this.rollbackStatus = RollbackStatusEnum.CHECK_PARAM_SUCCESS;
        log.info("check param success");
        try {
            currentBackupFolder = this.backupCurrentMetadata(this.kylinConfig);
        }
        catch (Exception e) {
            log.error("backup current metadata failed : {}", (Throwable)e);
            return;
        }
        this.rollbackStatus = RollbackStatusEnum.BACKUP_CURRENT_METADATA_SUCCESS;
        log.info("backup current metadata success");
        if (!this.checkClusterStatus().booleanValue()) {
            log.error("check cluster status failed");
            return;
        }
        this.rollbackStatus = RollbackStatusEnum.CHECK_CLUSTER_STATUS_SUCESS;
        log.info("check cluster status success");
        ResourceStore restoreResourceStore = this.forwardToTimeStampFromSnapshot(optionsHelper);
        if (restoreResourceStore == null) {
            log.error("forward to timestamp from snapshot failed");
            return;
        }
        this.rollbackStatus = RollbackStatusEnum.FORWARD_TO_USER_TARGET_TIME_FROM_SNAPSHOT_SUCESS;
        log.info("forward to user target time success");
        this.outputDiff(optionsHelper, this.currentResourceStore, restoreResourceStore);
        this.rollbackStatus = RollbackStatusEnum.OUTPUT_DIFF_SUCCESS;
        log.info("output diff success");
        this.waitUserConfirm();
        this.rollbackStatus = RollbackStatusEnum.WAIT_USER_CONFIRM_SUCCESS;
        log.info("wait user confirm success");
        boolean skipCheckData = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_SKIP_CHECK_DATA));
        if (!skipCheckData && !this.checkStorageDataAvailable(optionsHelper, restoreResourceStore).booleanValue()) {
            log.error("target snapshot storage data is unavailable");
            return;
        }
        this.rollbackStatus = RollbackStatusEnum.CHECK_STORAGE_DATA_AVAILABLE_SUCCESS;
        log.info("check storage data available success");
        if (!this.restoreMirror(optionsHelper.getOptionValue(OPTION_PROJECT), this.currentResourceStore, restoreResourceStore).booleanValue()) {
            log.error("restore target metadata failed");
            if (this.restoreCurrentMirror(this.kylinConfig, currentBackupFolder).booleanValue()) {
                log.error("restore current metadata failed, please restore the metadata database manually the current database backup folder is: backup_current");
            }
            return;
        }
        this.rollbackStatus = RollbackStatusEnum.RESTORE_MIRROR_SUCCESS;
        log.info("restore mirror success");
        log.info("roll back success");
    }

    private Boolean checkParam(OptionsHelper optionsHelper) {
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        String userTargetTime = optionsHelper.getOptionValue(OPTION_TIMESTAMP);
        if (userTargetTime == null) {
            log.error("specify project level time travel (must required)");
            return false;
        }
        try {
            formatter.parseDateTime(userTargetTime);
        }
        catch (Exception e) {
            log.error("parse user specified time failed {}", (Throwable)e);
            return false;
        }
        long userTargetTimeMillis = formatter.parseDateTime(userTargetTime).getMillis();
        long protectionTime = System.currentTimeMillis() - this.kylinConfig.getStorageResourceSurvivalTimeThreshold();
        if (userTargetTimeMillis < protectionTime) {
            log.error("user specified time  is less than protection time");
            return false;
        }
        return true;
    }

    @VisibleForTesting
    public Boolean waitUserConfirm() {
        String line;
        Scanner scanner = new Scanner(System.in, Charset.defaultCharset().name());
        do {
            log.info("please enter:understand the impact and confirm the implementation");
        } while (!(line = scanner.nextLine()).equals("understand the impact and confirm the implementation"));
        return true;
    }

    private Boolean exists(FileSystem fs, Path path) {
        try {
            boolean exist = fs.exists(path);
            if (!exist) {
                log.error("check file path: {} failed", (Object)path);
            }
            return exist;
        }
        catch (Exception e) {
            log.error("check file path: {} failed : {}", (Object)path, (Object)e);
            return false;
        }
    }

    @VisibleForTesting
    public Boolean checkClusterStatus() {
        return this.isPortAvailable(Integer.parseInt(this.kylinConfig.getServerPort()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPortAvailable(int port) {
        try (ServerSocket server = new ServerSocket(port);){
            log.info("The port : {} is available", (Object)port);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            log.error("dectect port available failed: ", (Throwable)e);
            return false;
        }
    }

    private void outputDiff(String tag, Set<String> origin, Set<String> target) {
        Sets.SetView willbeAdded;
        Sets.SetView willBeDeleted = Sets.difference(origin, target);
        if (!willBeDeleted.isEmpty()) {
            log.info("{} {} will be deleted", (Object)tag, (Object)willBeDeleted.toString());
        }
        if (!(willbeAdded = Sets.difference(target, origin)).isEmpty()) {
            log.info("{} {} will be added", (Object)tag, (Object)willbeAdded);
        }
    }

    private void outputDiff(OptionsHelper optionsHelper, ResourceStore currentResourceStore, ResourceStore restoreResourceStore) throws IOException {
        HashSet updateProjects;
        String targetProject = optionsHelper.getOptionValue(OPTION_PROJECT);
        KylinConfig currentConfig = KylinConfig.createKylinConfig((KylinConfig)KylinConfig.getInstanceFromEnv());
        ResourceStore.setRS((KylinConfig)currentConfig, (ResourceStore)currentResourceStore);
        KylinConfig restoreConfig = KylinConfig.createKylinConfig((KylinConfig)KylinConfig.getInstanceFromEnv());
        ResourceStore.setRS((KylinConfig)restoreConfig, (ResourceStore)restoreResourceStore);
        if (StringUtils.isBlank((CharSequence)targetProject)) {
            NKylinUserManager currentAclManager = NKylinUserManager.getInstance((KylinConfig)currentConfig);
            NKylinUserManager restoreAclManager = NKylinUserManager.getInstance((KylinConfig)restoreConfig);
            Set<String> currentUsers = currentAclManager.list().stream().map(ManagedUser::getUsername).collect(Collectors.toSet());
            Set<String> restoreUsers = restoreAclManager.list().stream().map(ManagedUser::getUsername).collect(Collectors.toSet());
            this.outputDiff("user:", currentUsers, restoreUsers);
            NProjectManager currentProjectMgr = NProjectManager.getInstance((KylinConfig)currentConfig);
            NProjectManager restoreProjectMgr = NProjectManager.getInstance((KylinConfig)restoreConfig);
            Set<String> currentProjects = currentProjectMgr.listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toSet());
            Set<String> restoreProjects = restoreProjectMgr.listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toSet());
            this.outputDiff("project: ", currentProjects, restoreProjects);
            updateProjects = Sets.intersection(currentProjects, restoreProjects);
        } else {
            updateProjects = Sets.newHashSet((Object[])new String[]{targetProject});
        }
        for (String project : updateProjects) {
            NExecutableManager currentExecutableManager = NExecutableManager.getInstance((KylinConfig)currentConfig, (String)project);
            NExecutableManager restoreExecutableManager = NExecutableManager.getInstance((KylinConfig)restoreConfig, (String)project);
            restoreExecutableManager.getAllExecutables().stream().forEach(e -> {
                if (currentExecutableManager.getJob(e.getId()) != null) {
                    ExecutableState currentStatus = currentExecutableManager.getOutput(e.getId()).getState();
                    ExecutableState restoreStatus = restoreExecutableManager.getOutput(e.getId()).getState();
                    if (currentStatus.isFinalState() && restoreStatus.isProgressing()) {
                        log.info("job : {} will be re-executed and will  affect segments: {}", e, (Object)Sets.newHashSet((Iterable)e.getTargetSegments()).toString());
                    }
                }
            });
            NDataflowManager currentDfMgr = NDataflowManager.getInstance((KylinConfig)currentConfig, (String)project);
            NDataflowManager restoreDfMgr = NDataflowManager.getInstance((KylinConfig)restoreConfig, (String)project);
            NDataModelManager currentModelMgr = NDataModelManager.getInstance((KylinConfig)currentConfig, (String)project);
            NDataModelManager restoreModelMgr = NDataModelManager.getInstance((KylinConfig)restoreConfig, (String)project);
            List currentDataflows = currentDfMgr.listAllDataflows();
            List restoreDataflows = restoreDfMgr.listAllDataflows();
            Set<String> currentModels = currentDataflows.stream().map(NDataflow::getModel).map(model -> model.getAlias()).collect(Collectors.toSet());
            Set<String> restoreModels = restoreDataflows.stream().map(NDataflow::getModel).map(model -> model.getAlias()).collect(Collectors.toSet());
            this.outputDiff("model: ", currentModels, restoreModels);
            Sets.SetView updateModels = Sets.intersection(currentModels, restoreModels);
            for (String model2 : updateModels) {
                currentModelMgr.getDataModelDescByAlias(model2).toString();
                Set<String> currentNamedColumns = currentModelMgr.getDataModelDescByAlias(model2).getAllNamedColumns().stream().map(m -> String.valueOf(m.getId()) + m.getName()).collect(Collectors.toSet());
                Set<String> restoreNamedColumns = restoreModelMgr.getDataModelDescByAlias(model2).getAllNamedColumns().stream().map(m -> String.valueOf(m.getId()) + m.getName()).collect(Collectors.toSet());
                this.outputDiff("named columns: ", currentNamedColumns, restoreNamedColumns);
                Set<String> currentSegments = currentDfMgr.getDataflowByModelAlias(model2).getSegments().stream().map(NDataSegment::toString).collect(Collectors.toSet());
                Set<String> restoreSegments = restoreDfMgr.getDataflowByModelAlias(model2).getSegments().stream().map(NDataSegment::toString).collect(Collectors.toSet());
                this.outputDiff("segments: ", currentSegments, restoreSegments);
            }
        }
    }

    private Boolean checkStorageDataAvailable(OptionsHelper optionsHelper, ResourceStore restoreResourceStore) {
        String project = optionsHelper.getOptionValue(OPTION_PROJECT);
        KylinConfig configCopy = KylinConfig.createKylinConfig((KylinConfig)KylinConfig.getInstanceFromEnv());
        ResourceStore.setRS((KylinConfig)configCopy, (ResourceStore)restoreResourceStore);
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        NProjectManager prMgr = NProjectManager.getInstance((KylinConfig)configCopy);
        List projects = project == null ? prMgr.listAllProjects() : Lists.newArrayList((Object[])new ProjectInstance[]{prMgr.getProject(project)});
        boolean status = true;
        for (ProjectInstance p : projects) {
            if (!this.checkProjectStorageDataAvailable(configCopy, fs, p.getName()).booleanValue()) {
                log.info("project: {} check storage data available failed", (Object)p.getName());
                status = false;
            } else {
                log.info("project: {} check storage data available success", (Object)p.getName());
            }
            if (status) continue;
            log.error("check check storage data available failed");
            return false;
        }
        return true;
    }

    private Boolean checkProjectStorageDataAvailable(KylinConfig config, FileSystem fs, String project) {
        String hdfsWorkingDir = KapConfig.getInstanceFromEnv().getMetadataWorkingDirectory();
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)project);
        HashSet activeIndexDataPath = Sets.newHashSet();
        dfMgr.listAllDataflows().forEach(dataflow -> dataflow.getSegments().stream().flatMap(segment -> segment.getLayoutsMap().values().stream()).map(this::getDataLayoutDir).forEach(activeIndexDataPath::add));
        if (!activeIndexDataPath.stream().allMatch(e -> this.exists(fs, new Path(hdfsWorkingDir, e)))) {
            log.error("check all index file exist failed");
            return false;
        }
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)project);
        if (!tableManager.listAllTables().stream().map(table -> table.getLastSnapshotPath()).filter(p -> p != null).allMatch(e -> this.exists(fs, new Path(hdfsWorkingDir, e)))) {
            log.error("check all table snapshot path failed");
            return false;
        }
        return true;
    }

    private String getDataLayoutDir(NDataLayout dataLayout) {
        NDataSegDetails segDetails = dataLayout.getSegDetails();
        return this.getDataflowDir(segDetails.getProject(), segDetails.getDataSegment().getDataflow().getId()) + "/" + segDetails.getUuid() + "/" + dataLayout.getLayoutId();
    }

    private String getDataflowBaseDir(String project) {
        return project + "/parquet" + "/";
    }

    private String getDataflowDir(String project, String dataflowId) {
        return this.getDataflowBaseDir(project) + dataflowId;
    }

    @VisibleForTesting
    public Boolean restoreMirror(String project, ResourceStore currentResourceStore, ResourceStore restoreResourceStore) {
        try {
            MetadataChecker metadataChecker = new MetadataChecker(restoreResourceStore.getMetadataStore());
            MetadataChecker.VerifyResult verifyResult = metadataChecker.verify();
            if (!verifyResult.isQualified()) {
                log.error("{} \n the metadata dir is not qualified", (Object)verifyResult.getResultMessage());
            }
            this.helper.restore(currentResourceStore, restoreResourceStore, project, true);
        }
        catch (Exception e) {
            log.error("restore mirror resource store failed", (Throwable)e);
        }
        return true;
    }

    private ResourceStore forwardToTimeStampFromSnapshot(OptionsHelper optionsHelper) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        String project = optionsHelper.getOptionValue(OPTION_PROJECT);
        String path = HadoopUtil.getBackupFolder((KylinConfig)this.kylinConfig);
        if (!this.exists(fs, new Path(path)).booleanValue()) {
            log.error("check default backup folder failed");
            return null;
        }
        DateTimeFormatter userTimeformatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
        long userTargetTime = userTimeformatter.parseDateTime(optionsHelper.getOptionValue(OPTION_TIMESTAMP)).getMillis();
        if (userTargetTime > System.currentTimeMillis()) {
            log.error("User-specified time cannot be greater than the current time");
            return null;
        }
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd-HH-mm-ss");
        Set candidateFolder = Arrays.stream(fs.listStatus(new Path(path))).filter(fileStatus -> Pattern.matches("\\d{4}-\\d{2}-\\d{2}-\\d{2}-\\d{2}-\\d{2}_backup", fileStatus.getPath().getName())).filter(fileStatus -> {
            String filePrefix = fileStatus.getPath().getName().substring(0, "yyyy-MM-dd-HH-mm-ss".length());
            return formatter.parseDateTime(filePrefix).getMillis() < Long.valueOf(userTargetTime);
        }).collect(Collectors.toSet());
        if (candidateFolder.isEmpty()) {
            log.error("check default backup folder failed");
            return null;
        }
        Optional<FileStatus> last = candidateFolder.stream().max(Comparator.comparingLong(FileStatus::getModificationTime));
        String folder = last.get().getPath().getName();
        String restorePath = StringUtils.appendIfMissing((String)path, (CharSequence)"/", (CharSequence[])new CharSequence[0]) + folder;
        String restoreMetadataUrl = this.getMetadataUrl(restorePath, false);
        KylinConfig restoreConfig = KylinConfig.createKylinConfig((KylinConfig)this.kylinConfig);
        restoreConfig.setMetadataUrl(restoreMetadataUrl);
        log.info("The restore metadataUrl is {} and restore path is {} ", (Object)restoreMetadataUrl, (Object)restorePath);
        ResourceStore restoreResourceStore = ResourceStore.getKylinMetaStore((KylinConfig)restoreConfig);
        ImageDesc imageDesc = (ImageDesc)JsonUtil.readValue((byte[])restoreResourceStore.getResource("/_image").getByteSource().read(), ImageDesc.class);
        Long offset = imageDesc.getOffset();
        AuditLogStore auditlog = this.currentResourceStore.getMetadataStore().getAuditLogStore();
        AuditLogStore currentAuditlog = this.currentResourceStore.getAuditLogStore();
        Long startId = offset;
        long maxId = currentAuditlog.getMaxId();
        long minId = currentAuditlog.getMinId();
        if (startId + 1L < minId) {
            log.error("backup offset is less than  auditlog smallest id");
            return null;
        }
        if (startId > maxId) {
            log.error("backup offset is greater than auditlog largest  id");
            return null;
        }
        long step = 1000L;
        HashSet unitIds = Sets.newHashSet();
        while (startId < maxId) {
            List logs = currentAuditlog.fetch(startId.longValue(), Math.min(1000L, maxId - startId));
            for (AuditLog log : logs) {
                if (log.getTimestamp() >= Long.valueOf(userTargetTime) && !unitIds.contains(log.getUnitId())) continue;
                unitIds.add(log.getUnitId());
                Event event = Event.fromLog((AuditLog)log);
                if (event instanceof ResourceCreateOrUpdateEvent) {
                    restoreResourceStore.deleteResource(log.getResPath());
                    restoreResourceStore.putResourceWithoutCheck(log.getResPath(), log.getByteSource(), log.getTimestamp().longValue(), log.getMvcc().longValue());
                    continue;
                }
                if (!(event instanceof ResourceDeleteEvent)) continue;
                restoreResourceStore.deleteResource(log.getResPath());
            }
            startId = startId + 1000L;
        }
        try {
            if (!StringUtils.isBlank((CharSequence)project) && restoreResourceStore.listResourcesRecursively("/" + project) == null) {
                log.error("restore project: {} is have not exist in user specified time", (Object)project);
                return null;
            }
        }
        catch (Exception e) {
            log.error("list project: {} error: {}", (Object)project, (Object)e);
            return null;
        }
        return restoreResourceStore;
    }

    private String backupCurrentMetadata(KylinConfig kylinConfig) throws Exception {
        String currentBackupFolder = LocalDateTime.now(Clock.systemDefaultZone()).format(MetadataToolHelper.DATE_TIME_FORMATTER) + "_backup";
        this.helper.backup(kylinConfig, kylinConfig.getHdfsWorkingDirectory() + "_current_backup", currentBackupFolder);
        return currentBackupFolder;
    }

    private Boolean restoreCurrentMirror(KylinConfig kylinConfig, String currentBackupFolder) throws Exception {
        String restoreFolder = kylinConfig.getHdfsWorkingDirectory() + "_current_backup" + File.separator + currentBackupFolder;
        try {
            MetadataTool.restore(kylinConfig, restoreFolder);
        }
        catch (Exception e) {
            log.error("restore current mirror back failed: {} Please use MetadataTool to restore the current backup manually. The backup directory is in {}", (Object)e, (Object)restoreFolder);
        }
        return true;
    }

    String getMetadataUrl(String rootPath, boolean compressed) {
        if (rootPath.startsWith("hdfs://")) {
            String url = String.format(Locale.ROOT, HDFS_METADATA_URL_FORMATTER, Path.getPathWithoutSchemeAndAuthority((Path)new Path(rootPath)).toString() + "/");
            return compressed ? url + ",zip=1" : url;
        }
        if (rootPath.startsWith("file://")) {
            rootPath = rootPath.replace("file://", "");
            return StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        }
        return StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

