/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool;

import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.MetadataTool;
import org.apache.kylin.tool.util.ToolMainWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SampleProjectTool
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SampleProjectTool.class);
    private static final Option OPTION_PROJECT = OptionBuilder.getInstance().hasArg().withArgName("PROJECT_NAME").isRequired(true).create("project");
    private static final Option OPTION_MODEL = OptionBuilder.getInstance().hasArg().withArgName("MODEL_NAME").isRequired(true).create("model");
    private static final Option OPTION_DIR = OptionBuilder.getInstance().hasArg().withArgName("DIRECTORY_PATH").isRequired(true).create("dir");

    private boolean checkProjectExist(String project) {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        ProjectInstance prjInstance = projectManager.getProject(project);
        return prjInstance != null;
    }

    private void assertModelNotExist(String project, String model) {
        NDataModel dataModel = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).getDataModelDescByAlias(model);
        if (dataModel != null) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.MODEL_NAME_DUPLICATE, new Object[]{model});
        }
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_PROJECT);
        options.addOption(OPTION_MODEL);
        options.addOption(OPTION_DIR);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String project = optionsHelper.getOptionValue(OPTION_PROJECT);
        String model = optionsHelper.getOptionValue(OPTION_MODEL);
        if (this.checkProjectExist(project)) {
            this.assertModelNotExist(project, model);
        }
        String dir = optionsHelper.getOptionValue(OPTION_DIR);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)config);
        resourceStore.getAuditLogStore().setInstance(AddressUtil.getMockPortAddress());
        MetadataTool tool = new MetadataTool(config);
        tool.execute(new String[]{"-restore", "-dir", dir, "-project", project});
    }

    public static void main(String[] args) {
        ToolMainWrapper.wrap(args, () -> {
            SampleProjectTool tool = new SampleProjectTool();
            tool.execute(args);
        });
        Unsafe.systemExit((int)0);
    }
}

