/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.garbage;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataflowCleanerCLI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataflowCleanerCLI.class);

    public static void main(String[] args) {
        DataflowCleanerCLI.execute();
        System.out.println("Cleanup dataflow finished.");
        Unsafe.systemExit((int)0);
    }

    public static void execute() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)config);
        for (ProjectInstance project : projectManager.listAllProjects()) {
            log.info("Start dataflow cleanup for project<{}>", (Object)project.getName());
            try {
                DataflowCleanerCLI.cleanupRedundantIndex(project);
            }
            catch (Exception e) {
                log.warn("Clean dataflow for project<{}> failed", (Object)project.getName(), (Object)e);
            }
            log.info("Dataflow cleanup for project<{}> finished", (Object)project.getName());
        }
    }

    private static void cleanupRedundantIndex(ProjectInstance project) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            List models = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project.getName()).listUnderliningDataModels();
            for (NDataModel model : models) {
                DataflowCleanerCLI.removeLayouts(model);
            }
            return 0;
        }, (String)project.getName());
    }

    private static void removeLayouts(NDataModel model) {
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject());
        NDataflow dataflow = dataflowManager.getDataflow(model.getUuid());
        List<Long> layoutIds = DataflowCleanerCLI.getLayouts(dataflow);
        HashSet toBeRemoved = Sets.newHashSet();
        for (NDataSegment segment : dataflow.getSegments()) {
            toBeRemoved.addAll(segment.getSegDetails().getLayouts().stream().map(NDataLayout::getLayoutId).filter(id -> !layoutIds.contains(id)).collect(Collectors.toSet()));
        }
        dataflowManager.removeLayouts(dataflow, (Collection)Lists.newArrayList((Iterable)toBeRemoved));
    }

    private static List<Long> getLayouts(NDataflow dataflow) {
        IndexPlan cube = dataflow.getIndexPlan();
        List layouts = cube.getAllLayouts();
        return layouts.stream().map(LayoutEntity::getId).collect(Collectors.toList());
    }
}

