/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.obf;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.tool.constant.SensitiveConfigKeysConstant;
import org.apache.kylin.tool.obf.MappingRecorder;
import org.apache.kylin.tool.obf.ObfLevel;
import org.apache.kylin.tool.obf.PropertiesFileObfuscator;
import org.apache.kylin.tool.obf.ResultRecorder;

public class KylinConfObfuscator
extends PropertiesFileObfuscator {
    private final String[] sensitiveKeywords = new String[]{"password", "user", "zookeeper.zk-auth", "source.jdbc.pass"};

    public KylinConfObfuscator(ObfLevel level, MappingRecorder recorder, ResultRecorder resultRecorder) {
        super(level, recorder, resultRecorder);
    }

    @Override
    void obfuscateProperties(Properties input) {
        HashMap item = Maps.newHashMap();
        for (Map.Entry<Object, Object> entry : input.entrySet()) {
            ACTION action = this.checkConfEntry(entry.getKey().toString(), entry.getValue().toString());
            switch (action) {
                case NONE: {
                    break;
                }
                case META_JDBC: {
                    item.put(entry.getKey(), action.masked);
                    break;
                }
                case SENSITIVE_KEY: {
                    item.put(entry.getKey(), action.masked);
                    break;
                }
            }
        }
        input.putAll((Map<?, ?>)item);
    }

    private ACTION checkConfEntry(String name, String value) {
        if (name.equals("kylin.metadata.url") && value.contains("@jdbc")) {
            ACTION act = ACTION.META_JDBC;
            try {
                act.masked = this.simpleToString(StorageURL.valueOf((String)value));
            }
            catch (Exception e) {
                act.masked = "<hidden>";
                logger.error("Failed to parse metadata url", (Throwable)e);
            }
            return act;
        }
        for (String conf : SensitiveConfigKeysConstant.DEFAULT_SENSITIVE_CONF_BLACKLIST) {
            if (!StringUtils.equals((String)conf, (String)name)) continue;
            return ACTION.NONE;
        }
        for (String keyWord : this.sensitiveKeywords) {
            if (!name.contains(keyWord)) continue;
            ACTION act = ACTION.SENSITIVE_KEY;
            act.masked = "<hidden>";
            return act;
        }
        return ACTION.NONE;
    }

    private String simpleToString(StorageURL storageURL) {
        StringBuilder sb = new StringBuilder();
        sb.append(storageURL.getIdentifier());
        if (storageURL.getScheme() != null) {
            sb.append("@").append(storageURL.getScheme());
        }
        for (Map.Entry kv : storageURL.getAllParameters().entrySet()) {
            String key = (String)kv.getKey();
            String val = (String)kv.getValue();
            if (key.equalsIgnoreCase("username") || key.equalsIgnoreCase("password")) {
                val = "<hidden>";
            }
            sb.append(",").append(key).append("=");
            if (val.isEmpty()) continue;
            sb.append(val);
        }
        return sb.toString();
    }

    static enum ACTION {
        NONE,
        META_JDBC,
        SENSITIVE_KEY;

        String masked = "<hidden>";
    }
}

