/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.security;

import io.kyligence.kap.guava20.shaded.common.io.ByteSource;
import java.util.Collection;
import java.util.Locale;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.persistence.metadata.PersistException;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.util.PasswordEncodeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminUserInitCLI {
    protected static final Logger logger = LoggerFactory.getLogger(AdminUserInitCLI.class);
    public static final String ADMIN_USER_NAME = "ADMIN";
    public static final String ADMIN_USER_RES_PATH = "/_global/user/ADMIN";
    public static final Pattern PASSWORD_PATTERN = Pattern.compile("^(?=.*\\d)(?=.*[a-zA-Z])(?=.*[~!@#$%^&*(){}|:\"<>?\\[\\];',./`]).{8,}$");
    public static final String PASSWORD_VALID_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890~!@#$%^&*(){}|:\"<>?[];',./`";
    public static final int DEFAULT_PASSWORD_LENGTH = 8;

    public static void main(String[] args) {
        try {
            boolean randomPasswordEnabled = KylinConfig.getInstanceFromEnv().getRandomAdminPasswordEnabled();
            AdminUserInitCLI.initAdminUser(randomPasswordEnabled);
        }
        catch (Exception e) {
            logger.error("Create Admin user failed.", (Throwable)e);
            Unsafe.systemExit((int)1);
        }
        Unsafe.systemExit((int)0);
    }

    public static void initAdminUser(boolean randomPasswordEnabled) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if ("ldap".equalsIgnoreCase(config.getSecurityProfile()) && !config.isRemoveLdapCustomSecurityLimitEnabled()) {
            return;
        }
        NKylinUserManager userManager = NKylinUserManager.getInstance((KylinConfig)config);
        if (!randomPasswordEnabled) {
            return;
        }
        if (CollectionUtils.isNotEmpty((Collection)userManager.list())) {
            logger.info("The user has been initialized and does not need to be initialized again");
            return;
        }
        String password = AdminUserInitCLI.generateRandomPassword();
        ManagedUser managedUser = new ManagedUser(ADMIN_USER_NAME, PasswordEncodeFactory.newUserPasswordEncoder().encode((CharSequence)password), Boolean.valueOf(true), new String[]{"ROLE_ADMIN", "ALL_USERS"});
        managedUser.setUuid(RandomUtil.randomUUIDStr());
        MetadataStore metaStore = ResourceStore.getKylinMetaStore((KylinConfig)config).getMetadataStore();
        try {
            logger.info("Start init default user.");
            RawResource rawResource = new RawResource(ADMIN_USER_RES_PATH, ByteSource.wrap((byte[])JsonUtil.writeValueAsBytes((Object)managedUser)), System.currentTimeMillis(), 0L);
            metaStore.putResource(rawResource, null, -1L);
            String blackColorUsernameForPrint = "\u001b[0mADMIN\u001b[31m";
            String blackColorPasswordForPrint = "\u001b[0m" + password + "\u001b[31m";
            String info = String.format(Locale.ROOT, "Create default user finished. The username of initialized user is [%s], which password is [%s].\nPlease keep the password properly. And if you forget the password, you can reset it according to user manual.", blackColorUsernameForPrint, blackColorPasswordForPrint);
            System.out.println("\u001b[31m" + info + "\u001b[0m");
        }
        catch (PersistException e) {
            logger.warn("{} user has been created on another node.", (Object)ADMIN_USER_NAME);
        }
    }

    public static String generateRandomPassword() {
        String password;
        while (!PASSWORD_PATTERN.matcher(password = RandomStringUtils.random((int)8, (char[])PASSWORD_VALID_CHARS.toCharArray())).matches()) {
        }
        return password;
    }
}

