/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.snapshot;

import com.fasterxml.jackson.core.type.TypeReference;
import io.kyligence.kap.guava20.shaded.common.collect.Lists;
import io.kyligence.kap.guava20.shaded.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SnapshotSourceTableStatsTool {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SnapshotSourceTableStatsTool.class);

    private SnapshotSourceTableStatsTool() {
        throw new IllegalStateException("Utility class");
    }

    public static Boolean extractSourceTableStats(KylinConfig config, File exportDir, String project, AbstractExecutable job) {
        try {
            log.info("extractSourceTableStats start ...");
            File sourceTableStatsDir = new File(exportDir, "snapshot_auto_refresh");
            FileUtils.forceMkdir((File)sourceTableStatsDir);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            if (Sets.newHashSet((Object[])new JobTypeEnum[]{JobTypeEnum.SNAPSHOT_BUILD, JobTypeEnum.SNAPSHOT_REFRESH}).contains(job.getJobType())) {
                log.info("extract snapshot job[{}] snapshot hive table", (Object)job.getDisplayName());
                String tableIdentity = job.getParam("table");
                if (StringUtils.isBlank((CharSequence)tableIdentity)) {
                    log.info("Snapshot job param P_TABLE_NAME[{}] has error", (Object)tableIdentity);
                    return false;
                }
                TableDesc tableDesc = NTableMetadataManager.getInstance((KylinConfig)config, (String)project).getTableDesc(tableIdentity);
                List<String> sourceTables = SnapshotSourceTableStatsTool.getSourceTables(config, project, fs, tableDesc);
                SnapshotSourceTableStatsTool.extractSnapshotSourceTableStats(project, config, sourceTableStatsDir, fs, sourceTables);
                return true;
            }
            log.info("extract build job[{}] snapshot hive table", (Object)job.getDisplayName());
            String targetModelId = job.getTargetModelId();
            List<String> sourceTables = SnapshotSourceTableStatsTool.getSourceTablesByModelId(project, targetModelId, config, fs);
            SnapshotSourceTableStatsTool.extractSnapshotSourceTableStats(project, config, sourceTableStatsDir, fs, sourceTables);
            return true;
        }
        catch (Exception e) {
            log.error("Failed to SourceTableStats. ", (Throwable)e);
            return false;
        }
    }

    public static List<String> getSourceTables(KylinConfig config, String project, FileSystem fs, TableDesc tableDesc) {
        ArrayList sourceTables;
        block16: {
            sourceTables = Lists.newArrayList();
            if (tableDesc.isView()) {
                try {
                    Path viewMapping = new Path(config.getSnapshotAutoRefreshDir(project) + "view_mapping");
                    if (!fs.exists(viewMapping)) break block16;
                    try (FSDataInputStream inputStream = fs.open(viewMapping);){
                        Map result = (Map)JsonUtil.readValue((InputStream)inputStream, (TypeReference)new TypeReference<Map<String, List<String>>>(){});
                        List sources = result.getOrDefault(tableDesc.getIdentity(), Lists.newArrayList());
                        sourceTables.addAll(sources);
                    }
                }
                catch (IOException e) {
                    log.error("read viewMapping has error", (Throwable)e);
                }
            } else {
                sourceTables.add(tableDesc.getIdentity().toLowerCase(Locale.ROOT));
            }
        }
        return sourceTables;
    }

    public static List<String> getSourceTablesByModelId(String project, String modelId, KylinConfig config, FileSystem fs) {
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)config, (String)project);
        NDataModel model = modelManager.getDataModelDesc(modelId);
        if (null != model) {
            Set lookupTables = model.getLookupTables();
            List<String> lookTableSourceTables = lookupTables.stream().map(TableRef::getTableDesc).map(tableDesc -> SnapshotSourceTableStatsTool.getSourceTables(config, project, fs, tableDesc)).flatMap(Collection::stream).collect(Collectors.toList());
            log.info("Model{} lookup tables source tables size: {}", (Object)modelId, (Object)lookTableSourceTables.size());
            return lookTableSourceTables;
        }
        return Lists.newArrayList();
    }

    public static void extractSnapshotSourceTableStats(String project, KylinConfig config, File sourceTableStatsDir, FileSystem fs, List<String> tables) {
        for (String table : tables) {
            String fullTablePathString = config.getSnapshotAutoRefreshDir(project) + "source_table_stats" + "/" + table;
            try {
                Path path;
                File sourceTableStatsSnapshotDir = new File(sourceTableStatsDir, "source_table_stats");
                if (!sourceTableStatsSnapshotDir.exists()) {
                    FileUtils.forceMkdir((File)sourceTableStatsSnapshotDir);
                }
                if (!fs.exists(path = new Path(fullTablePathString)) || !fs.isFile(path)) continue;
                log.info("extract SourceTableStats [{}]", (Object)fullTablePathString);
                fs.copyToLocalFile(false, path, new Path(sourceTableStatsSnapshotDir.getAbsolutePath()), true);
            }
            catch (IOException e) {
                log.error("extract SourceTableStats [{}] has error", (Object)fullTablePathString);
            }
        }
    }

    public static Boolean extractSnapshotAutoUpdate(File exportDir) {
        try {
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            KylinConfig config = KylinConfig.readSystemKylinConfig();
            NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)config);
            List allProject = projectManager.listAllProjects();
            File snapshotAutoUpdate = new File(exportDir, "snapshot_auto_refresh");
            if (!snapshotAutoUpdate.exists()) {
                FileUtils.forceMkdir((File)snapshotAutoUpdate);
            }
            for (ProjectInstance project : allProject) {
                String fullTablePathString = config.getSnapshotAutoRefreshDir(project.getName());
                Path path = new Path(fullTablePathString);
                if (!fs.exists(path)) continue;
                File dst = new File(snapshotAutoUpdate, project.getName());
                if (!dst.exists()) {
                    FileUtils.forceMkdir((File)dst);
                }
                log.info("extract SourceTableStats [{}] to [{}]", (Object)path.toString(), (Object)dst.getAbsolutePath());
                fs.copyToLocalFile(false, path, new Path(dst.getAbsolutePath()), true);
            }
            return true;
        }
        catch (Exception e) {
            log.error("extract SourceTableStats has error", (Throwable)e);
            return false;
        }
    }
}

