/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import java.sql.Connection;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.metadata.JdbcEpochStore;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.util.MetadataUtil;
import org.apache.kylin.tool.util.ScreenPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableEpochCLI
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CreateTableEpochCLI.class);
    private static final Option OPTION_EXEC = OptionBuilder.getInstance().hasArg(false).withArgName("exec").withDescription("exec the upgrade.").isRequired(false).withLongOpt("exec").create("e");

    public static void main(String[] args) {
        CreateTableEpochCLI createTableEpochCLI = new CreateTableEpochCLI();
        try {
            createTableEpochCLI.execute(args);
        }
        catch (Exception e) {
            log.error("Failed to exec CreateTableEpochCLI", (Throwable)e);
            ScreenPrintUtil.systemExitWhenMainThread(1);
        }
        log.info("Upgrade table epoch finished!");
        ScreenPrintUtil.systemExitWhenMainThread(0);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_EXEC);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        KylinConfig systemKylinConfig = KylinConfig.getInstanceFromEnv();
        StorageURL url = systemKylinConfig.getMetadataUrl();
        String tableName = url.getIdentifier() + "_epoch";
        DataSource dataSource = MetadataUtil.getDataSource(systemKylinConfig);
        boolean tableExist = false;
        if (JdbcUtil.isTableExists((Connection)dataSource.getConnection(), (String)tableName)) {
            ScreenPrintUtil.printlnGreen("found epoch table already exists.");
            tableExist = true;
        } else {
            ScreenPrintUtil.printlnGreen("found epoch table doesn't exists.");
        }
        if (optionsHelper.hasOption(OPTION_EXEC)) {
            if (!tableExist) {
                ScreenPrintUtil.printlnGreen("start to create epoch table.");
                Properties properties = JdbcUtil.getProperties((BasicDataSource)((BasicDataSource)dataSource));
                String createTableStmt = JdbcEpochStore.getEpochSql((String)properties.getProperty("create.epoch.store.table"), (String)tableName);
                try {
                    MetadataUtil.createTableIfNotExist((BasicDataSource)dataSource, tableName, createTableStmt);
                }
                catch (Exception e) {
                    ScreenPrintUtil.printlnRed("Failed to create epoch table.");
                    throw e;
                }
            }
            ScreenPrintUtil.printlnGreen("epoch table upgrade succeeded.");
        }
    }
}

