/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.metadata.favorite.FavoriteRuleManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.tool.util.MetadataUtil;
import org.apache.kylin.tool.util.ScreenPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteFavoriteQueryCLI
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeleteFavoriteQueryCLI.class);
    private static final Option OPTION_METADATA_DIR = OptionBuilder.getInstance().hasArg().withArgName("metadata_dir").withDescription("metadata dir.").isRequired(true).withLongOpt("metadata_dir").create("d");
    private static final Option OPTION_EXEC = OptionBuilder.getInstance().hasArg(false).withArgName("exec").withDescription("exec the upgrade.").isRequired(false).withLongOpt("exec").create("e");

    public static void main(String[] args) {
        DeleteFavoriteQueryCLI updateFQCLI = new DeleteFavoriteQueryCLI();
        try {
            updateFQCLI.execute(args);
        }
        catch (Exception e) {
            log.error("Failed to exec DeleteFavoriteQueryCLI", (Throwable)e);
            ScreenPrintUtil.systemExitWhenMainThread(1);
        }
        log.info("Upgrade favorite query finished.");
        ScreenPrintUtil.systemExitWhenMainThread(0);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_METADATA_DIR);
        options.addOption(OPTION_EXEC);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String metadataUrl = MetadataUtil.getMetadataUrl(optionsHelper.getOptionValue(OPTION_METADATA_DIR));
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)metadataUrl));
        KylinConfig systemKylinConfig = KylinConfig.getInstanceFromEnv();
        systemKylinConfig.setMetadataUrl(metadataUrl);
        log.info("Start to truncate favorite query.");
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        HashMap globalFavoriteRuleList = Maps.newHashMap();
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)kylinConfig);
        projectManager.listAllProjects().forEach(projectInstance -> {
            FavoriteRuleManager favoriteRuleManager = FavoriteRuleManager.getInstance((KylinConfig)kylinConfig, (String)projectInstance.getName());
            List favoriteRuleList = favoriteRuleManager.getAll();
            globalFavoriteRuleList.put(projectInstance.getName(), favoriteRuleList);
        });
        long frCount = globalFavoriteRuleList.values().stream().mapToLong(List::size).sum();
        ScreenPrintUtil.printlnGreen(String.format(Locale.ROOT, "found %d recommendation metadata need to be updated.", frCount));
        if (optionsHelper.hasOption(OPTION_EXEC)) {
            globalFavoriteRuleList.forEach((project, frList) -> UnitOfWork.doInTransactionWithRetry(() -> {
                frList.forEach(fr -> FavoriteRuleManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).delete(fr));
                return null;
            }, (String)project));
            ScreenPrintUtil.printlnGreen("recommendation metadata upgrade succeeded.");
        }
        log.info("Succeed to truncate favorite query.");
    }
}

