/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.google.common.base.Throwables;
import io.kyligence.kap.guava20.shaded.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.metadata.MetadataStore;

class RenameEntity {
    private static final ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.getInstanceFromEnv());
    private String originName;
    private String destName;
    private RawResource rs;

    public RenameEntity(String originName, String destName) {
        this.originName = originName;
        this.destName = destName;
    }

    public RenameEntity(String originName, String destName, RawResource rs) {
        this.originName = originName;
        this.destName = destName;
        this.rs = rs;
    }

    public RenameEntity(String originName, String destName, RootPersistentEntity entity, Class clazz) {
        this.originName = originName;
        this.destName = destName;
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(buf);
        try {
            new JsonSerializer(clazz).serialize(entity, dout);
            dout.close();
            buf.close();
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        ByteSource byteSource = ByteSource.wrap((byte[])buf.toByteArray());
        this.rs = new RawResource(destName, byteSource, System.currentTimeMillis(), entity.getMvcc());
    }

    public RawResource getRs() {
        RawResource resource;
        if (this.rs == null && StringUtils.isNotEmpty((String)this.originName) && (resource = resourceStore.getResource(this.originName)) != null) {
            this.rs = new RawResource(this.destName, resource.getByteSource(), System.currentTimeMillis(), resource.getMvcc());
        }
        return this.rs;
    }

    public String getOriginName() {
        return this.originName;
    }

    public String getDestName() {
        return this.destName;
    }

    public void updateMetadata() throws Exception {
        MetadataStore metadataStore = resourceStore.getMetadataStore();
        RawResource rawResource = this.getRs();
        if (rawResource != null) {
            metadataStore.move(this.getOriginName(), this.getDestName());
            metadataStore.deleteResource(this.getOriginName(), null, -1L);
            metadataStore.putResource(rawResource, null, -1L);
        }
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s -> %s", this.originName, this.destName);
    }
}

