/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.kyligence.kap.guava20.shaded.common.io.ByteSource;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.job.dao.ExecutableOutputPO;
import org.apache.kylin.job.dao.ExecutablePO;
import org.apache.kylin.job.dao.JobStatistics;
import org.apache.kylin.job.dao.JobStatisticsManager;
import org.apache.kylin.job.dao.NExecutableDao;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataLoadingRange;
import org.apache.kylin.metadata.cube.model.NDataLoadingRangeManager;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.favorite.QueryHistoryTimeOffset;
import org.apache.kylin.metadata.favorite.QueryHistoryTimeOffsetManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.upgrade.RenameEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameProjectResourceTool
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RenameProjectResourceTool.class);
    private static final Option OPTION_DIR = OptionBuilder.getInstance().hasArg().withArgName("dir").withDescription("Specify the directory to operator").isRequired(true).create("dir");
    private static final Option OPTION_PROJECT = OptionBuilder.getInstance().hasArg().withArgName("project_name").withDescription("Specify project (optional)").isRequired(false).withLongOpt("project").create("p");
    private static final Option OPTION_COLLECT_ONLY = OptionBuilder.getInstance().hasArg().withArgName("true/false").withDescription("collect only, show rename resource.(default true)").isRequired(false).withLongOpt("collect-only").create("collect");
    private static final Option OPTION_HELP = OptionBuilder.getInstance().hasArg(false).withDescription("print help message.").isRequired(false).withLongOpt("help").create("h");
    private Set<String> projects = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private boolean collectOnly = true;
    private Set<String> existsProjectNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, String> renameProjectMap = new HashMap<String, String>();
    private KylinConfig fileSystemConfig = KylinConfig.getInstanceFromEnv();
    private KylinConfig config = KylinConfig.newKylinConfig();
    private ResourceStore resourceStore;

    public static void main(String[] args) {
        RenameProjectResourceTool tool = new RenameProjectResourceTool();
        tool.execute(args);
        System.out.println("Rename project resource finished.");
        Unsafe.systemExit((int)0);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DIR);
        options.addOption(OPTION_PROJECT);
        options.addOption(OPTION_COLLECT_ONLY);
        options.addOption(OPTION_HELP);
        return options;
    }

    private boolean printUsage(OptionsHelper optionsHelper) {
        boolean help = optionsHelper.hasOption(OPTION_HELP);
        if (help) {
            optionsHelper.printUsage(((Object)((Object)this)).getClass().getName(), this.getOptions());
        }
        return help;
    }

    private void initOptionValues(OptionsHelper optionsHelper) {
        while (true) {
            System.out.println("This script will help you modify the duplicate project names. The system will add a number to the project name created later, for example, project_a-> project_a1\nPlease confirm if you need to execute the script\uff1f(y/n)");
            Scanner scanner = new Scanner(System.in, Charset.defaultCharset().name());
            String prompt = scanner.nextLine();
            if (StringUtils.equals((CharSequence)"y", (CharSequence)prompt)) break;
            if (!StringUtils.equals((CharSequence)"n", (CharSequence)prompt)) continue;
            Unsafe.systemExit((int)0);
        }
        if (optionsHelper.hasOption(OPTION_PROJECT)) {
            this.projects.addAll(Arrays.asList(optionsHelper.getOptionValue(OPTION_PROJECT).split(",")));
        }
        if (optionsHelper.hasOption(OPTION_COLLECT_ONLY)) {
            this.collectOnly = Boolean.parseBoolean(optionsHelper.getOptionValue(OPTION_COLLECT_ONLY));
        }
        String metadataUrl = this.getMetadataUrl(optionsHelper.getOptionValue(OPTION_DIR));
        this.fileSystemConfig.setMetadataUrl(metadataUrl);
        this.resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.fileSystemConfig);
        List allProjectInstanceList = NProjectManager.getInstance((KylinConfig)this.fileSystemConfig).listAllProjects();
        this.existsProjectNames.addAll(allProjectInstanceList.stream().map(ProjectInstance::getName).collect(Collectors.toList()));
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        if (this.printUsage(optionsHelper)) {
            return;
        }
        this.initOptionValues(optionsHelper);
        if (optionsHelper.hasOption(OPTION_PROJECT)) {
            String destProjectName;
            String originProjectName = optionsHelper.getOptionValue(OPTION_PROJECT);
            int index = originProjectName.indexOf(58);
            if (index > 0) {
                destProjectName = originProjectName.substring(index + 1);
                originProjectName = originProjectName.substring(0, index);
            } else {
                destProjectName = this.generateAvailableProjectName(originProjectName);
            }
            this.renameProjectMap.put(originProjectName, destProjectName);
            NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)this.fileSystemConfig);
            ProjectInstance projectInstance = projectManager.getProject(originProjectName);
            if (projectInstance == null) {
                System.out.printf(Locale.ROOT, "project %s does not exists%n", originProjectName);
                Unsafe.systemExit((int)1);
            }
        } else {
            this.collectDuplicateProject();
        }
        ArrayList<RenameEntity> renameEntities = new ArrayList<RenameEntity>();
        for (Map.Entry<String, String> entry : this.renameProjectMap.entrySet()) {
            renameEntities.addAll(this.renameProject(entry.getKey(), entry.getValue()));
        }
        for (RenameEntity renameEntity : renameEntities) {
            System.out.println(renameEntity);
        }
        if (!this.collectOnly) {
            for (RenameEntity renameEntity : renameEntities) {
                renameEntity.updateMetadata();
            }
            for (Map.Entry<String, String> entry : this.renameProjectMap.entrySet()) {
                this.updateHDFSMetadata(entry.getKey(), entry.getValue());
            }
        }
    }

    private void collectDuplicateProject() {
        List allProjectInstanceList = NProjectManager.getInstance((KylinConfig)this.fileSystemConfig).listAllProjects();
        ConcurrentSkipListMap duplicateProjectNameProjectMap = allProjectInstanceList.stream().filter(projectInstance -> this.projects.isEmpty() || this.projects.contains(projectInstance.getName())).collect(Collectors.groupingByConcurrent(ProjectInstance::getName, () -> new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER), Collectors.toList()));
        for (Map.Entry entry : duplicateProjectNameProjectMap.entrySet()) {
            List projectInstances = ((List)entry.getValue()).stream().sorted(Comparator.comparingLong(RootPersistentEntity::getCreateTime)).collect(Collectors.toList());
            if (projectInstances.size() == 1) continue;
            for (int i = 1; i < projectInstances.size(); ++i) {
                ProjectInstance projectInstance2 = (ProjectInstance)projectInstances.get(i);
                this.renameProjectMap.put(projectInstance2.getName(), this.generateAvailableProjectName(projectInstance2.getName()));
            }
        }
    }

    private List<RenameEntity> renameProject(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        results.addAll(this.updateDataflow(originProjectName, destProjectName));
        results.addAll(this.updateExecute(originProjectName, destProjectName));
        results.addAll(this.updateIndexPlan(originProjectName, destProjectName));
        results.addAll(this.updateJobStat(originProjectName, destProjectName));
        results.addAll(this.updateModelDesc(originProjectName, destProjectName));
        results.addAll(this.updateFavoriteRule(originProjectName, destProjectName));
        results.addAll(this.updateDataLoadingRange(originProjectName, destProjectName));
        results.addAll(this.updateQueryHistoryTimeOffset(originProjectName, destProjectName));
        results.addAll(this.updateTable(originProjectName, destProjectName));
        results.addAll(this.updateUserGroupAcl(originProjectName, destProjectName));
        results.addAll(this.updateSavedQueries(originProjectName, destProjectName));
        results.add(this.updateProject(originProjectName, destProjectName));
        return results;
    }

    private List<RenameEntity> updateDataflow(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)this.fileSystemConfig, (String)originProjectName);
        List dataflows = dataflowManager.listAllDataflows(true);
        for (NDataflow dataflow : dataflows) {
            dataflow = dataflowManager.copy(dataflow);
            String srcResourcePath = dataflow.getResourcePath();
            dataflow.setProject(destProjectName);
            String destResourcePath = dataflow.getResourcePath();
            results.add(new RenameEntity(srcResourcePath, destResourcePath, (RootPersistentEntity)dataflow, NDataflow.class));
            NavigableSet daflowDetails = this.resourceStore.listResources(String.format(Locale.ROOT, "/%s%s/%s", originProjectName, "/dataflow_details", dataflow.getUuid()));
            if (daflowDetails == null) continue;
            for (String daflowDetail : daflowDetails) {
                results.add(new RenameEntity(daflowDetail, daflowDetail.replace(String.format(Locale.ROOT, "/%s/", originProjectName), String.format(Locale.ROOT, "/%s/", destProjectName))));
            }
        }
        return results;
    }

    private List<RenameEntity> updateIndexPlan(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)this.fileSystemConfig, (String)originProjectName);
        List indexPlans = indexPlanManager.listAllIndexPlans(true);
        for (IndexPlan indexPlan : indexPlans) {
            String srcResourcePath = indexPlan.getResourcePath();
            indexPlan.setProject(destProjectName);
            String destResourcePath = IndexPlan.concatResourcePath((String)indexPlan.resourceName(), (String)destProjectName);
            results.add(new RenameEntity(srcResourcePath, destResourcePath));
        }
        return results;
    }

    private List<RenameEntity> updateJobStat(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        JobStatisticsManager jobStatisticsManager = JobStatisticsManager.getInstance((KylinConfig)this.fileSystemConfig, (String)originProjectName);
        List jobStatistics = jobStatisticsManager.getAll();
        for (JobStatistics jobStatistic : jobStatistics) {
            String srcResourcePath = "/" + originProjectName + "/job_stats" + "/" + jobStatistic.resourceName() + ".json";
            String destResourcePath = "/" + destProjectName + "/job_stats" + "/" + jobStatistic.resourceName() + ".json";
            results.add(new RenameEntity(srcResourcePath, destResourcePath));
        }
        return results;
    }

    private List<RenameEntity> updateModelDesc(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NDataModelManager dataModelManager = NDataModelManager.getInstance((KylinConfig)this.fileSystemConfig, (String)originProjectName);
        List dataModels = dataModelManager.listAllModels();
        for (NDataModel dataModel : dataModels) {
            String srcResourcePath = NDataModel.concatResourcePath((String)dataModel.resourceName(), (String)originProjectName);
            String destResourcePath = NDataModel.concatResourcePath((String)dataModel.resourceName(), (String)destProjectName);
            results.add(new RenameEntity(srcResourcePath, destResourcePath));
        }
        return results;
    }

    private List<RenameEntity> updateFavoriteRule(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NavigableSet favoriteRulePaths = this.resourceStore.listResources("/" + originProjectName + "/rule");
        if (favoriteRulePaths != null) {
            for (String favoriteRulePath : favoriteRulePaths) {
                String destFavoriteRulePath = favoriteRulePath.replace("/" + originProjectName + "/", "/" + destProjectName + "/");
                results.add(new RenameEntity(favoriteRulePath, destFavoriteRulePath));
            }
        }
        return results;
    }

    private List<RenameEntity> updateDataLoadingRange(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NDataLoadingRangeManager dataLoadingRange = NDataLoadingRangeManager.getInstance((KylinConfig)this.fileSystemConfig, (String)originProjectName);
        List dataLoadingRanges = dataLoadingRange.getDataLoadingRanges();
        for (NDataLoadingRange loadingRange : dataLoadingRanges) {
            String srcResourcePath = loadingRange.getResourcePath();
            String destResourcePath = srcResourcePath.replace("/" + originProjectName + "/", "/" + destProjectName + "/");
            results.add(new RenameEntity(srcResourcePath, destResourcePath));
        }
        return results;
    }

    private List<RenameEntity> updateQueryHistoryTimeOffset(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        QueryHistoryTimeOffsetManager queryHistoryTimeOffsetManager = QueryHistoryTimeOffsetManager.getInstance((KylinConfig)this.fileSystemConfig, (String)originProjectName);
        QueryHistoryTimeOffset queryHistoryTimeOffset = queryHistoryTimeOffsetManager.get();
        String srcQueryHistoryTimeOffsetPath = "/" + originProjectName + "/query_history_time_offset" + "/" + queryHistoryTimeOffset.getUuid() + ".json";
        String destQueryHistoryTimeOffsetPath = "/" + destProjectName + "/query_history_time_offset" + "/" + queryHistoryTimeOffset.getUuid() + ".json";
        results.add(new RenameEntity(srcQueryHistoryTimeOffsetPath, destQueryHistoryTimeOffsetPath));
        return results;
    }

    private List<RenameEntity> updateTable(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)this.fileSystemConfig, (String)originProjectName);
        List tables = tableMetadataManager.listAllTables();
        for (TableDesc table : tables) {
            TableExtDesc tableExtDesc;
            String srcTableResourcePath = table.getResourcePath();
            table.init(destProjectName);
            String destTableResourcePath = table.getResourcePath();
            String lastSnapshotPath = table.getLastSnapshotPath();
            if (lastSnapshotPath != null) {
                table.setLastSnapshotPath(lastSnapshotPath.replace(originProjectName + "/", destProjectName + "/"));
                results.add(new RenameEntity(srcTableResourcePath, destTableResourcePath, (RootPersistentEntity)table, TableDesc.class));
            } else {
                results.add(new RenameEntity(srcTableResourcePath, destTableResourcePath));
            }
            if ((tableExtDesc = tableMetadataManager.getTableExtIfExists(table)) == null) continue;
            String srcTableExtResourcePath = tableExtDesc.getResourcePath();
            tableExtDesc.init(destProjectName);
            String destTableExtResourcePath = tableExtDesc.getResourcePath();
            results.add(new RenameEntity(srcTableExtResourcePath, destTableExtResourcePath));
        }
        return results;
    }

    private List<RenameEntity> updateUserGroupAcl(String originProjectName, String destProjectName) {
        NavigableSet groupAclPaths;
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NavigableSet userAclPaths = this.resourceStore.listResources(String.format(Locale.ROOT, "/%s/acl/user", originProjectName));
        if (userAclPaths != null) {
            for (String userAclPath : userAclPaths) {
                String destUserAclPath = userAclPath.replace("/" + originProjectName + "/", "/" + destProjectName + "/");
                results.add(new RenameEntity(userAclPath, destUserAclPath));
            }
        }
        if ((groupAclPaths = this.resourceStore.listResources(String.format(Locale.ROOT, "/%s/acl/group", originProjectName))) != null) {
            for (String groupAclPath : groupAclPaths) {
                String destGroupAclPath = groupAclPath.replace("/" + originProjectName + "/", "/" + destProjectName + "/");
                results.add(new RenameEntity(groupAclPath, destGroupAclPath));
            }
        }
        return results;
    }

    private List<RenameEntity> updateSavedQueries(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NavigableSet savedQueries = this.resourceStore.listResources("/" + originProjectName + "/query/");
        if (savedQueries == null) {
            return results;
        }
        for (String savedQuery : savedQueries) {
            RawResource rs = this.resourceStore.getResource(savedQuery);
            if (rs == null) continue;
            String destResourcePath = savedQuery.replace("/" + originProjectName + "/", "/" + destProjectName + "/");
            try (InputStream is = rs.getByteSource().openStream();){
                JsonNode savedQueryNode = (JsonNode)JsonUtil.readValue((InputStream)is, JsonNode.class);
                if (savedQueryNode.has("queries")) {
                    ArrayNode queries = (ArrayNode)savedQueryNode.get("queries");
                    for (JsonNode query : queries) {
                        String projectFiledName;
                        if (!query.has(projectFiledName = "project")) continue;
                        ((ObjectNode)query).put(projectFiledName, destProjectName);
                    }
                }
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                DataOutputStream dout = new DataOutputStream(buf);
                JsonUtil.writeValue((OutputStream)dout, (Object)savedQueryNode);
                dout.close();
                buf.close();
                ByteSource byteSource = ByteSource.wrap((byte[])buf.toByteArray());
                rs = new RawResource(destResourcePath, byteSource, System.currentTimeMillis(), rs.getMvcc());
            }
            catch (IOException e) {
                log.warn("read resource {} failed", (Object)savedQuery);
            }
            results.add(new RenameEntity(savedQuery, destResourcePath, rs));
        }
        return results;
    }

    private List<RenameEntity> updateExecute(String originProjectName, String destProjectName) {
        ArrayList<RenameEntity> results = new ArrayList<RenameEntity>();
        NExecutableDao executableDao = NExecutableDao.getInstance((KylinConfig)this.fileSystemConfig, (String)originProjectName);
        List jobs = executableDao.getJobs();
        for (ExecutablePO job : jobs) {
            Map info;
            String dependentFiles;
            String srcResourcePath = job.getResourcePath();
            job.setProject(destProjectName);
            String destResourcePath = job.getResourcePath();
            Map params = job.getParams();
            if (params.get("project") != null) {
                params.put("project", destProjectName);
            }
            List tasks = job.getTasks();
            for (ExecutablePO task : tasks) {
                String outputMetaUrl;
                String distMetaUrl;
                Map taskParams = task.getParams();
                if (taskParams.get("project") != null) {
                    taskParams.put("project", destProjectName);
                }
                if ((distMetaUrl = (String)taskParams.get("distMetaUrl")) != null) {
                    distMetaUrl = distMetaUrl.replace(String.format(Locale.ROOT, "/%s/", originProjectName), String.format(Locale.ROOT, "/%s/", destProjectName));
                    taskParams.put("distMetaUrl", distMetaUrl);
                }
                if ((outputMetaUrl = (String)taskParams.get("outputMetaUrl")) == null) continue;
                outputMetaUrl = outputMetaUrl.replace(String.format(Locale.ROOT, "/%s/", originProjectName), String.format(Locale.ROOT, "/%s/", destProjectName));
                taskParams.put("outputMetaUrl", outputMetaUrl);
            }
            ExecutableOutputPO jobOutput = job.getOutput();
            if (jobOutput != null && (dependentFiles = (String)(info = jobOutput.getInfo()).get("dependentFiles")) != null) {
                dependentFiles = dependentFiles.replace(String.format(Locale.ROOT, "/%s/", originProjectName), String.format(Locale.ROOT, "/%s/", destProjectName));
                info.put("dependentFiles", dependentFiles);
            }
            results.add(new RenameEntity(srcResourcePath, destResourcePath, (RootPersistentEntity)job, ExecutablePO.class));
        }
        return results;
    }

    public RenameEntity updateProject(String originProjectName, String destProjectName) {
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)this.fileSystemConfig);
        ProjectInstance projectInstance = projectManager.getProject(originProjectName);
        String srcResourcePath = projectInstance.getResourcePath();
        projectInstance.setName(destProjectName);
        String destResourcePath = projectInstance.getResourcePath();
        return new RenameEntity(srcResourcePath, destResourcePath, (RootPersistentEntity)projectInstance, ProjectInstance.class);
    }

    private void updateHDFSMetadata(String originPath, String destPath) throws Exception {
        Path src;
        String hdfsWorkingDirectory = this.config.getHdfsWorkingDirectory();
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        if (!fs.exists(src = new Path(hdfsWorkingDirectory, originPath))) {
            System.out.printf(Locale.ROOT, "src file %s not exists%n", src);
            return;
        }
        Path dst = new Path(hdfsWorkingDirectory, destPath);
        if (fs.exists(dst)) {
            System.out.printf(Locale.ROOT, "dst file %s already exists%n", dst);
            return;
        }
        System.out.printf(Locale.ROOT, "move file from  %s to %s%n", src, dst);
        boolean success = HadoopUtil.getWorkingFileSystem().rename(src, dst);
        if (!success) {
            System.out.printf(Locale.ROOT, "move file from  %s to %s failed%n", src, dst);
            Unsafe.systemExit((int)1);
        }
    }

    private String generateAvailableProjectName(String originProjectName) {
        if (this.renameProjectMap.get(originProjectName) != null) {
            return this.renameProjectMap.get(originProjectName);
        }
        String destName = this.generateAvailableResourceName(originProjectName, this.existsProjectNames);
        this.existsProjectNames.add(destName);
        this.renameProjectMap.put(originProjectName, destName);
        return destName;
    }

    private String generateAvailableResourceName(String originName, Set<String> existsResourceNames) {
        int suffix = 1;
        String destName;
        while (existsResourceNames.contains(destName = String.format(Locale.ROOT, "%s%s", originName, suffix))) {
            ++suffix;
        }
        return destName;
    }

    private String getMetadataUrl(String rootPath) {
        if (rootPath.startsWith("file://")) {
            rootPath = rootPath.replace("file://", "");
        }
        return StringUtils.appendIfMissing((String)rootPath, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
    }
}

