/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.Unsafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class UpdateAuditLogTableColumnLengthCLI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateAuditLogTableColumnLengthCLI.class);
    private static final String SHOW_TABLE = "SHOW TABLES LIKE '%s'";
    private static final String UPDATE_COL_TO_TABLE_SQL = "alter table %s modify column %s %s";
    private static final String TABLE_SUFFIX = "_audit_log";
    private static final String AUDIT_LOG_TABLE_OPERATOR = "operator";
    private static final int COLUMN_LENGTH = 200;

    public static void main(String[] args) throws Exception {
        block17: {
            log.info("Start to modify column length log...");
            try {
                KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
                StorageURL url = kylinConfig.getMetadataUrl();
                Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
                DataSource dataSource = JdbcDataSource.getDataSource((Properties)props);
                JdbcTemplate jdbcTemplate = new JdbcTemplate(dataSource);
                jdbcTemplate.setQueryTimeout(-1);
                String tableName = url.getIdentifier() + TABLE_SUFFIX;
                if (UpdateAuditLogTableColumnLengthCLI.tableIsExist(jdbcTemplate, tableName)) {
                    int length = 200;
                    String sql = String.format(Locale.ROOT, "SELECT %s FROM %s LIMIT 1", AUDIT_LOG_TABLE_OPERATOR, tableName);
                    try (PreparedStatement preparedStatement = dataSource.getConnection().prepareStatement(sql);){
                        ResultSetMetaData metaData = preparedStatement.getMetaData();
                        length = metaData.getPrecision(1);
                    }
                    if (length < 200) {
                        UpdateAuditLogTableColumnLengthCLI.modifyColumnLength(jdbcTemplate, tableName, AUDIT_LOG_TABLE_OPERATOR, String.format(Locale.ROOT, "varchar(%s)", 200));
                    }
                    break block17;
                }
                log.info("table {} not exist.", (Object)tableName);
            }
            catch (Exception e) {
                log.error("modify column length error", (Throwable)e);
            }
        }
        Unsafe.systemExit((int)0);
    }

    public static boolean tableIsExist(JdbcTemplate jdbcTemplate, String tableName) {
        try {
            String object = (String)jdbcTemplate.queryForObject(String.format(Locale.ROOT, SHOW_TABLE, tableName), (resultSet, i) -> resultSet.getString(1));
            return Objects.equals(tableName, object);
        }
        catch (EmptyResultDataAccessException emptyResultDataAccessException) {
            log.error("not found table", (Throwable)emptyResultDataAccessException);
            return false;
        }
    }

    public static void modifyColumnLength(JdbcTemplate jdbcTemplate, String tableName, String column, String type) {
        String sql = String.format(Locale.ROOT, UPDATE_COL_TO_TABLE_SQL, tableName, column, type);
        try {
            jdbcTemplate.execute(sql);
            log.info("update column length finished!");
        }
        catch (Exception e) {
            log.error("Failed to execute upgradeSql: {}", (Object)sql, (Object)e);
        }
    }
}

