/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.metadata.model.DatabaseDesc;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.tool.util.MetadataUtil;
import org.apache.kylin.tool.util.ScreenPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateProjectCLI
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateProjectCLI.class);
    private static final Option OPTION_DIR = OptionBuilder.getInstance().hasArg().withArgName("dir").withDescription("Specify the directory to operator").isRequired(true).create("dir");
    private static final Option OPTION_HELP = OptionBuilder.getInstance().hasArg(false).withDescription("print help message.").isRequired(false).withLongOpt("help").create("h");
    private static final Map<String, String> REPLACE_OVERRIDE_PROPERTIES_MAP = new HashMap<String, String>();
    private KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();

    public static void main(String[] args) throws Exception {
        UpdateProjectCLI tool = new UpdateProjectCLI();
        tool.execute(args);
        ScreenPrintUtil.println("Update project finished.");
        Unsafe.systemExit((int)0);
    }

    void updateAllProjects(KylinConfig kylinConfig) {
        log.info("Start to update project...");
        NProjectManager projectManager = NProjectManager.getInstance((KylinConfig)kylinConfig);
        for (ProjectInstance project : projectManager.listAllProjects()) {
            this.updateProject(project);
        }
        log.info("Update project finished!");
    }

    private void updateProject(ProjectInstance project) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            NProjectManager npr = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            REPLACE_OVERRIDE_PROPERTIES_MAP.forEach((arg_0, arg_1) -> ((ProjectInstance)project).replaceKeyOverrideKylinProps(arg_0, arg_1));
            if (StringUtils.isEmpty((String)project.getDefaultDatabase())) {
                Map schemaMap = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project.getName()).listTablesGroupBySchema();
                String defaultDatabase = DatabaseDesc.getDefaultDatabaseByMaxTables((Map)schemaMap);
                project.setDefaultDatabase(defaultDatabase.toUpperCase(Locale.ROOT));
            }
            npr.updateProject(project);
            return 0;
        }, (String)project.getName(), (int)1);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_DIR);
        options.addOption(OPTION_HELP);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        if (this.printUsage(optionsHelper)) {
            return;
        }
        log.info("Start to update project...");
        String metadataUrl = MetadataUtil.getMetadataUrl(optionsHelper.getOptionValue(OPTION_DIR));
        this.kylinConfig.setMetadataUrl(metadataUrl);
        UpdateProjectCLI defaultDatabaseCLI = new UpdateProjectCLI();
        defaultDatabaseCLI.updateAllProjects(this.kylinConfig);
        log.info("Update project finished!");
    }

    private boolean printUsage(OptionsHelper optionsHelper) {
        boolean help = optionsHelper.hasOption(OPTION_HELP);
        if (help) {
            optionsHelper.printUsage(((Object)((Object)this)).getClass().getName(), this.getOptions());
        }
        return help;
    }

    static {
        REPLACE_OVERRIDE_PROPERTIES_MAP.put("kap.metadata.semi-automatic-mode", "kylin.metadata.semi-automatic-mode");
        REPLACE_OVERRIDE_PROPERTIES_MAP.put("kap.query.metadata.expose-computed-column", "kylin.query.metadata.expose-computed-column");
    }
}

