/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Locale;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.tool.util.MetadataUtil;
import org.apache.kylin.tool.util.ScreenPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.security.util.InMemoryResource;

public class UpdateSessionTableCLI
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateSessionTableCLI.class);
    private static final Option OPTION_TRUNCATE = OptionBuilder.getInstance().hasArg(false).withArgName("truncate").withDescription("Truncate the session table.").isRequired(false).withLongOpt("truncate").create("t");
    private static final Option OPTION_EXEC = OptionBuilder.getInstance().hasArg(false).withArgName("exec").withDescription("exec the upgrade.").isRequired(false).withLongOpt("exec").create("e");
    private static final int SESSION_ID_LENGTH = 180;
    private static final String UPDATE_MYSQL_SESSION_TABLE_SQL = String.format(Locale.ROOT, "ALTER TABLE SPRING_SESSION MODIFY COLUMN SESSION_ID VARCHAR(%d) NOT NULL;", 180);
    private static final String UPDATE_MYSQL_SESSION_ATTRIBUTES_TABLE_SQL = String.format(Locale.ROOT, "ALTER TABLE SPRING_SESSION_ATTRIBUTES MODIFY COLUMN SESSION_ID VARCHAR(%d) NOT NULL;", 180);
    private static final String UPDATE_PG_SESSION_TABLE_SQL = String.format(Locale.ROOT, "ALTER TABLE SPRING_SESSION ALTER COLUMN SESSION_ID TYPE VARCHAR(%d) , ALTER COLUMN SESSION_ID SET NOT NULL;", 180);
    private static final String UPDATE_PG_SESSION_ATTRIBUTES_TABLE_SQL = String.format(Locale.ROOT, "ALTER TABLE SPRING_SESSION_ATTRIBUTES ALTER COLUMN SESSION_ID TYPE VARCHAR(%d) , ALTER COLUMN SESSION_ID SET NOT NULL;", 180);
    private static final String ERROR_MSG_FORMAT = "Failed to alter session table schema : %s , please alter session table schema manually according to user manual. Otherwise you may not be able to log in Detailed Message is at logs/shell.stderr";
    private DataSource dataSource;

    public static void main(String[] args) {
        UpdateSessionTableCLI updateSessionTableCLI = new UpdateSessionTableCLI();
        try {
            updateSessionTableCLI.execute(args);
        }
        catch (Exception e) {
            log.error("Failed to exec UpdateSessionTableCLI", (Throwable)e);
            ScreenPrintUtil.systemExitWhenMainThread(1);
        }
        log.info("Upgrade session table finished.");
        ScreenPrintUtil.systemExitWhenMainThread(0);
    }

    /*
     * Exception decompiling
     */
    @VisibleForTesting
    public int affectedRowsWhenTruncate(String sessionTableName) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @VisibleForTesting
    public void truncateSessionTable(String sessionTableName) throws SQLException {
        if (!JdbcUtil.isTableExists((Connection)this.dataSource.getConnection(), (String)sessionTableName)) {
            log.info("Table {} is not exist, skip truncate.", (Object)sessionTableName);
            return;
        }
        try (PreparedStatement preparedStatement = this.dataSource.getConnection().prepareStatement("DELETE FROM " + sessionTableName + " WHERE SESSION_ID IS NOT NULL");){
            int rows = preparedStatement.executeUpdate();
            log.info("Delete {} rows from {} .", (Object)rows, (Object)sessionTableName);
        }
        catch (Exception e) {
            log.error("Failed to truncate table: {}", (Object)sessionTableName, (Object)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    public boolean isSessionTableNeedUpgrade(String sessionTableName) throws SQLException {
        if (!JdbcUtil.isTableExists((Connection)this.dataSource.getConnection(), (String)sessionTableName)) {
            log.info("Table {} is not exist, no need to upgrade.", (Object)sessionTableName);
            return false;
        }
        try (PreparedStatement preparedStatement = this.dataSource.getConnection().prepareStatement("SELECT SESSION_ID FROM " + sessionTableName + " LIMIT 1");){
            int columnLength = preparedStatement.getMetaData().getPrecision(1);
            if (columnLength < 180) {
                log.info("Table: {}, Alter SESSION_ID column length: {} to length: {}", new Object[]{sessionTableName, columnLength, 180});
                boolean bl = true;
                return bl;
            }
            log.info("Table: {} is matched, skip upgrade.", (Object)sessionTableName);
            return false;
        }
        catch (Exception e) {
            log.error("Failed to check SESSION_ID from table: {}", (Object)sessionTableName, (Object)e);
            ScreenPrintUtil.systemExitWhenMainThread(1);
        }
        return false;
    }

    private void tryUpdateSessionTable(String replaceName, String sql, String sessionTableName) throws SQLException {
        if (!this.isSessionTableNeedUpgrade(sessionTableName)) {
            return;
        }
        try {
            ResourceDatabasePopulator populator = new ResourceDatabasePopulator();
            String sessionScript = sql.replaceAll("SPRING_SESSION", replaceName);
            populator.addScript((Resource)new InMemoryResource(sessionScript));
            populator.setContinueOnError(false);
            DatabasePopulatorUtils.execute((DatabasePopulator)populator, (DataSource)this.dataSource);
            log.info("session table {} upgrade succeeded.", (Object)sessionTableName);
        }
        catch (Exception e) {
            log.error("try update session table failed", (Throwable)e);
            throw e;
        }
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_TRUNCATE);
        options.addOption(OPTION_EXEC);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        KylinConfig systemKylinConfig = KylinConfig.getInstanceFromEnv();
        if (!StringUtils.equalsIgnoreCase((String)systemKylinConfig.getSpringStoreType(), (String)"JDBC")) {
            ScreenPrintUtil.printlnGreen("skip upgrade session and session_ATTRIBUTES table.");
            return;
        }
        String tableName = systemKylinConfig.getMetadataUrlPrefix() + "_session";
        String tableAttributesName = tableName + "_ATTRIBUTES";
        this.dataSource = MetadataUtil.getDataSource(systemKylinConfig);
        ScreenPrintUtil.printlnGreen(String.format(Locale.ROOT, "found %d rows need to be modified.", this.affectedRowsWhenTruncate(tableAttributesName) + this.affectedRowsWhenTruncate(tableName)));
        if (optionsHelper.hasOption(OPTION_EXEC)) {
            if (optionsHelper.hasOption(OPTION_TRUNCATE)) {
                this.truncateSessionTable(tableAttributesName);
                this.truncateSessionTable(tableName);
            }
            ScreenPrintUtil.printlnGreen("start to check the permission to update tables.");
            if (this.dataSource instanceof BasicDataSource && ((BasicDataSource)this.dataSource).getDriverClassName().equals("com.mysql.jdbc.Driver")) {
                this.tryUpdateSessionTable(tableName, UPDATE_MYSQL_SESSION_ATTRIBUTES_TABLE_SQL, tableAttributesName);
                this.tryUpdateSessionTable(tableName, UPDATE_MYSQL_SESSION_TABLE_SQL, tableName);
            } else {
                this.tryUpdateSessionTable(tableName, UPDATE_PG_SESSION_ATTRIBUTES_TABLE_SQL, tableAttributesName);
                this.tryUpdateSessionTable(tableName, UPDATE_PG_SESSION_TABLE_SQL, tableName);
            }
            ScreenPrintUtil.printlnGreen("session and session_ATTRIBUTES table upgrade succeeded.");
        }
    }
}

