/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.upgrade;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.ExecutableApplication;
import org.apache.kylin.common.util.OptionBuilder;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.helper.UpdateUserAclToolHelper;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.upgrade.GlobalAclVersion;
import org.apache.kylin.metadata.upgrade.GlobalAclVersionManager;
import org.apache.kylin.metadata.user.ManagedUser;
import org.apache.kylin.metadata.user.NKylinUserManager;
import org.apache.kylin.rest.security.AclManager;
import org.apache.kylin.rest.security.AclPermission;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.security.KylinPermissionGrantingStrategy;
import org.apache.kylin.rest.security.MutableAclRecord;
import org.apache.kylin.rest.security.UserAcl;
import org.apache.kylin.rest.security.UserAclManager;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.tool.MaintainModeTool;
import org.apache.kylin.tool.util.ScreenPrintUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.ConsoleAuditLogger;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class UpdateUserAclTool
extends ExecutableApplication {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpdateUserAclTool.class);
    public static final String UPGRADE = "upgrade";
    public static final String ROLLBACK = "rollback";
    private static final Option OPTION_SCRIPT = OptionBuilder.getInstance().hasArg(true).withDescription("the identify of script").isRequired(true).withLongOpt("script").create("s");
    private static final Option OPTION_OLD_KYLIN_VERSION = OptionBuilder.getInstance().hasArg(true).withDescription("old kylin version").isRequired(false).withLongOpt("old_kylin_version").create("v");
    private static final Option OPTION_KYLIN_HOME = OptionBuilder.getInstance().hasArg(true).withDescription("kylin home").isRequired(true).withLongOpt("kylin_home").create("h");
    private static final Option OPTION_ROLLBACK = OptionBuilder.getInstance().hasArg(false).withDescription("rollback the user acl").isRequired(false).withLongOpt("rollback").create("r");
    private static final Option OPTION_FORCE_UPGRADE = OptionBuilder.getInstance().hasArg(false).withDescription("force upgrade").isRequired(false).withLongOpt("force").create("f");
    private static final Pattern VERSION_PATTERN = Pattern.compile("\\d+\\.\\d+.*");

    public static void main(String[] args) {
        try {
            UpdateUserAclTool tool = new UpdateUserAclTool();
            if (tool.matchUpgradeCondition(args)) {
                log.info("Start update user acl metadata.");
                tool.execute(args);
                log.info("Update user acl metadata successfully.");
            } else {
                log.info("Skip update the acl metadata.");
            }
        }
        catch (Throwable e) {
            log.error("Update user acl metadata failed.", e);
            ScreenPrintUtil.systemExitWhenMainThread(1);
        }
        ScreenPrintUtil.systemExitWhenMainThread(0);
    }

    public boolean matchUpgradeCondition(String[] args) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        if (config.isQueryNodeOnly()) {
            log.info("Only job/all node can update user acl.");
            return false;
        }
        OptionsHelper optionsHelper = this.convertToOptionsHelper(args);
        String scriptIdentify = optionsHelper.getOptionValue(OPTION_SCRIPT);
        log.info("scriptIdentify={}", (Object)scriptIdentify);
        if ("migrate".equalsIgnoreCase(scriptIdentify)) {
            String oldKylinVersion = optionsHelper.getOptionValue(OPTION_OLD_KYLIN_VERSION);
            String newKylinHome = optionsHelper.getOptionValue(OPTION_KYLIN_HOME);
            log.info("oldKylinVersion={}", (Object)oldKylinVersion);
            log.info("newKylinHome={}", (Object)newKylinHome);
            if (!VERSION_PATTERN.matcher(oldKylinVersion.trim()).matches()) {
                throw new IllegalArgumentException("oldKylinVersion=" + oldKylinVersion);
            }
            return this.isDataPermissionSeparateVersion(newKylinHome) && this.compareVersion(oldKylinVersion, "4.2") >= 0 && this.compareVersion(oldKylinVersion, "4.5.19") < 0;
        }
        if (UPGRADE.equalsIgnoreCase(scriptIdentify)) {
            try {
                String oldKylinHome = optionsHelper.getOptionValue(OPTION_KYLIN_HOME);
                log.info("kylinHome={}", (Object)oldKylinHome);
                File versionFile = new File(oldKylinHome + "/VERSION");
                String version = this.parseVersion(FileUtils.readFileToString((File)versionFile, (Charset)StandardCharsets.UTF_8));
                log.info("version={}", (Object)version);
                return versionFile.exists() && this.compareVersion(version, "4.2") >= 0 && !this.isDataPermissionSeparateVersion(oldKylinHome);
            }
            catch (Exception e) {
                log.error("matchUpgradeCondition error", (Throwable)e);
                return false;
            }
        }
        throw new IllegalArgumentException("unknown script identify=" + scriptIdentify);
    }

    private boolean isDataPermissionSeparateVersion(String kylinHome) {
        try {
            String command = String.format(Locale.ROOT, "grep %s %s/server/jars/*.jar", UserAcl.class.getName(), kylinHome);
            log.info("command = {}", (Object)command);
            CliCommandExecutor exec = new CliCommandExecutor();
            CliCommandExecutor.CliCmdExecResult result = exec.execute(command, null);
            return result.getCode() == 0;
        }
        catch (ShellException e) {
            log.warn("execute command failed.", (Throwable)e);
            return false;
        }
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(OPTION_SCRIPT);
        options.addOption(OPTION_OLD_KYLIN_VERSION);
        options.addOption(OPTION_KYLIN_HOME);
        options.addOption(OPTION_ROLLBACK);
        options.addOption(OPTION_FORCE_UPGRADE);
        return options;
    }

    protected void execute(OptionsHelper optionsHelper) throws Exception {
        if (UpdateUserAclToolHelper.getInstance().isUpgraded() && !optionsHelper.hasOption(OPTION_ROLLBACK) && !optionsHelper.hasOption(OPTION_FORCE_UPGRADE)) {
            log.info("The acl related metadata have been upgraded.");
            return;
        }
        MaintainModeTool maintainModeTool = new MaintainModeTool("update user acl");
        try {
            maintainModeTool.init();
            maintainModeTool.markEpochs();
            if (optionsHelper.hasOption(OPTION_ROLLBACK)) {
                this.updateAdminUserAcl(ROLLBACK, this.getAdminUsers());
                this.updateProjectAcl(ROLLBACK);
                this.removeAclVersion();
            } else {
                this.updateAdminUserAcl(UPGRADE, this.getAdminUsers());
                this.updateProjectAcl(UPGRADE);
                this.addAclVersion();
            }
        }
        finally {
            maintainModeTool.releaseEpochs();
        }
    }

    public boolean isAdminUserUpgraded() {
        UserAclManager userAclManager = UserAclManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        return userAclManager.listAclUsernames().size() > 0;
    }

    private Set<String> getAdminUsers() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String profile = config.getSecurityProfile().toLowerCase(Locale.ROOT);
        HashSet<String> adminUsers = new HashSet<String>();
        switch (profile) {
            case "testing": {
                adminUsers.addAll(UpdateUserAclTool.getKylinAdminUsers());
                break;
            }
            case "ldap": {
                adminUsers.addAll(this.getLdapAdminUsers());
                break;
            }
            case "custom": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported kylin.security.profile=" + profile);
            }
        }
        return adminUsers;
    }

    public void updateAdminUserAcl(String operation, Set<String> adminUsers) {
        if (adminUsers.isEmpty()) {
            return;
        }
        log.info("start to {} query permission for system admin user.", (Object)operation);
        UserAcl defaultUserAcl = new UserAcl("");
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            UserAclManager userAclManager = UserAclManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            adminUsers.forEach(user -> {
                UserAcl userAcl = Optional.ofNullable(userAclManager.get(user)).orElse(defaultUserAcl);
                if (UPGRADE.equalsIgnoreCase(operation) && !userAcl.hasPermission(AclPermission.DATA_QUERY)) {
                    log.info("add query permission for sys admin user {}", user);
                    userAclManager.add(user);
                } else if (ROLLBACK.equalsIgnoreCase(operation) && userAcl.hasPermission(AclPermission.DATA_QUERY)) {
                    log.info("remove query permission for sys admin user {}", user);
                    userAclManager.delete(user);
                }
            });
            return null;
        }, (String)"_global", (int)1);
        log.info("{} query permission for system admin user successfully.", (Object)StringUtils.capitalize((String)operation));
    }

    private static List<String> getKylinAdminUsers() {
        NKylinUserManager userManager = NKylinUserManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
        return userManager.list().stream().filter(user -> user.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_ADMIN"))).map(ManagedUser::getUsername).collect(Collectors.toList());
    }

    public Set<String> getLdapAdminUsers() {
        return UpdateUserAclToolHelper.getInstance().getLdapAdminUsers();
    }

    public void updateProjectAcl(String operation) {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            AclManager aclManager = this.createAclManager();
            List aclRecordList = aclManager.listAll();
            aclRecordList.forEach(aclRecord -> {
                log.info("start to {} query permission for _global/acl/{}.", (Object)operation, (Object)aclRecord.getUuid());
                List entries = aclRecord.getEntries();
                HashMap sidPermissionMap = new HashMap();
                entries.forEach(ace -> {
                    boolean hasQueryPermission = AclPermissionUtil.hasQueryPermission((Permission)ace.getPermission());
                    if (UPGRADE.equalsIgnoreCase(operation) && !hasQueryPermission) {
                        sidPermissionMap.putIfAbsent(ace.getSid(), AclPermissionUtil.addExtPermission((Permission)ace.getPermission(), (Permission)AclPermission.DATA_QUERY));
                    } else if (ROLLBACK.equalsIgnoreCase(operation) && hasQueryPermission) {
                        sidPermissionMap.putIfAbsent(ace.getSid(), AclPermissionUtil.convertToBasePermission((Permission)ace.getPermission()));
                    }
                });
                MutableAclRecord mutableAclRecord = aclManager.readAcl(aclRecord.getObjectIdentity());
                aclManager.batchUpsertAce(mutableAclRecord, sidPermissionMap);
                log.info("{} query permission for _global/acl/{} successfully.", (Object)StringUtils.capitalize((String)operation), (Object)aclRecord.getUuid());
            });
            return null;
        }, (String)"_global", (int)1);
    }

    public void addAclVersion() {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            GlobalAclVersionManager versionManager = GlobalAclVersionManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            GlobalAclVersion version = new GlobalAclVersion();
            version.setAclVersion("data-permission-separate");
            versionManager.save(version);
            return null;
        }, (String)"_global", (int)1);
    }

    public void removeAclVersion() {
        EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
            GlobalAclVersionManager versionManager = GlobalAclVersionManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv());
            versionManager.delete();
            return null;
        }, (String)"_global", (int)1);
    }

    private AclManager createAclManager() {
        AclPermissionFactory permissionFactory = new AclPermissionFactory();
        KylinPermissionGrantingStrategy permissionGrantingStrategy = new KylinPermissionGrantingStrategy((AuditLogger)new ConsoleAuditLogger());
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        return new AclManager(config, (PermissionFactory)permissionFactory, (PermissionGrantingStrategy)permissionGrantingStrategy);
    }

    public String parseVersion(String versionText) {
        int versionStartIdx = versionText.indexOf("Enterprise");
        int versionEndIdx = versionText.lastIndexOf("-") == -1 ? versionText.length() : versionText.lastIndexOf("-");
        return versionText.substring(versionStartIdx + 11, versionEndIdx).trim();
    }

    public int compareVersion(String version1, String version2) {
        int i;
        if (StringUtils.isEmpty((CharSequence)version1)) {
            return -1;
        }
        if (StringUtils.isEmpty((CharSequence)version2)) {
            return 1;
        }
        String[] version1Array = version1.split("[._]");
        String[] version2Array = version2.split("[._]");
        int minLen = Math.min(version1Array.length, version2Array.length);
        long diff = 0L;
        for (int index = 0; index < minLen && (diff = Long.parseLong(version1Array[index]) - Long.parseLong(version2Array[index])) == 0L; ++index) {
        }
        if (diff != 0L) {
            return diff > 0L ? 1 : -1;
        }
        for (i = index; i < version1Array.length; ++i) {
            if (Long.parseLong(version1Array[i]) <= 0L) continue;
            return 1;
        }
        for (i = index; i < version2Array.length; ++i) {
            if (Long.parseLong(version2Array[i]) <= 0L) continue;
            return -1;
        }
        return 0;
    }
}

