/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.hive.service.rpc.thrift.TColumn;
import org.apache.hive.service.rpc.thrift.TRowSet;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.api.v1.dto.CloseBatchResponse;
import org.apache.kyuubi.client.api.v1.dto.GetBatchesResponse;
import org.apache.kyuubi.client.api.v1.dto.OperationLog;
import org.apache.kyuubi.client.exception.KyuubiRestException;
import org.apache.kyuubi.client.util.BatchUtils;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ApplicationInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.KyuubiApplicationManager$;
import org.apache.kyuubi.operation.BatchJobSubmission;
import org.apache.kyuubi.operation.BatchJobSubmission$;
import org.apache.kyuubi.operation.FetchOrientation$;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.OperationStatus;
import org.apache.kyuubi.server.KyuubiBatchService;
import org.apache.kyuubi.server.KyuubiRestFrontendService;
import org.apache.kyuubi.server.KyuubiServer$;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.v1.BatchesResource$;
import org.apache.kyuubi.server.api.v1.InternalRestClient;
import org.apache.kyuubi.server.metadata.MetadataManager$;
import org.apache.kyuubi.server.metadata.api.Metadata;
import org.apache.kyuubi.server.metadata.api.Metadata$;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.api.MetadataFilter$;
import org.apache.kyuubi.session.KyuubiBatchSession;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionHandle$;
import org.apache.kyuubi.session.SessionType$;
import org.apache.kyuubi.util.JdbcUtils$;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@Tag(name="Batch")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\rme!B\u0010!\u0001\u0001b\u0003\"B\u001e\u0001\t\u0003i\u0004b\u0002!\u0001\u0005\u0004%I!\u0011\u0005\u00075\u0002\u0001\u000b\u0011\u0002\"\t\u0011m\u0003\u0001R1A\u0005\nqC\u0001\u0002\u0019\u0001\t\u0006\u0004%I\u0001\u0018\u0005\tC\u0002A)\u0019!C\u0005E\")a\r\u0001C\u0005O\")Q\u000e\u0001C\u0005]\")\u0011\u000f\u0001C\u0005e\")\u0011\u0010\u0001C\u0005u\"1\u0011\u0010\u0001C\u0005\u0003'Aq!a\u000f\u0001\t\u0013\ti\u0004C\u0004\u0002J\u0001!\t!a\u0013\t\u000f\u00055\u0007\u0001\"\u0001\u0002P\"9!\u0011\u0005\u0001\u0005\n\t\r\u0002\"\u0003B\u0016\u0001E\u0005I\u0011\u0002B\u0017\u0011\u001d\u0011\u0019\u0005\u0001C\u0005\u0005\u000bBqAa\u0013\u0001\t\u0003\u0011i\u0005C\u0004\u0003z\u0001!\tAa\u001f\t\u000f\t=\b\u0001\"\u0001\u0003r\"911\u0005\u0001\u0005\u0002\r\u0015raBB4A!\u00051\u0011\u000e\u0004\u0007?\u0001B\taa\u001b\t\rm:B\u0011AB7\u0011%\u0019yg\u0006b\u0001\n\u0003\u0019\t\b\u0003\u0005\u0004\n^\u0001\u000b\u0011BB:\u0011%\u0019Yi\u0006b\u0001\n\u0003\u0019\t\b\u0003\u0005\u0004\u000e^\u0001\u000b\u0011BB:\u0011\u001d\u0019yi\u0006C\u0001\u0007#Cqa!&\u0018\t\u0003\u00199JA\bCCR\u001c\u0007.Z:SKN|WO]2f\u0015\t\t#%\u0001\u0002wc)\u00111\u0005J\u0001\u0004CBL'BA\u0013'\u0003\u0019\u0019XM\u001d<fe*\u0011q\u0005K\u0001\u0007Wf,XOY5\u000b\u0005%R\u0013AB1qC\u000eDWMC\u0001,\u0003\ry'oZ\n\u0005\u00015\u001at\u0007\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VM\u001a\t\u0003iUj\u0011AI\u0005\u0003m\t\u0012\u0011#\u00119j%\u0016\fX/Z:u\u0007>tG/\u001a=u!\tA\u0014(D\u0001'\u0013\tQdEA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?\u0007\u0001!\u0012A\u0010\t\u0003\u007f\u0001i\u0011\u0001I\u0001\u0014S:$XM\u001d8bYJ+7\u000f^\"mS\u0016tGo]\u000b\u0002\u0005B!1I\u0013'X\u001b\u0005!%BA#G\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003\u000f\"\u000bA!\u001e;jY*\t\u0011*\u0001\u0003kCZ\f\u0017BA&E\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0003\u001bRs!A\u0014*\u0011\u0005={S\"\u0001)\u000b\u0005Ec\u0014A\u0002\u001fs_>$h(\u0003\u0002T_\u00051\u0001K]3eK\u001aL!!\u0016,\u0003\rM#(/\u001b8h\u0015\t\u0019v\u0006\u0005\u0002@1&\u0011\u0011\f\t\u0002\u0013\u0013:$XM\u001d8bYJ+7\u000f^\"mS\u0016tG/\u0001\u000bj]R,'O\\1m%\u0016\u001cHo\u00117jK:$8\u000fI\u0001\u0016S:$XM\u001d8bYN{7m[3u)&lWm\\;u+\u0005i\u0006C\u0001\u0018_\u0013\tyvFA\u0002J]R\fa#\u001b8uKJt\u0017\r\\\"p]:,7\r\u001e+j[\u0016|W\u000f^\u0001\u0018S:$XM\u001d8bYN+7-\u001e:jif,e.\u00192mK\u0012,\u0012a\u0019\t\u0003]\u0011L!!Z\u0018\u0003\u000f\t{w\u000e\\3b]\u0006q!-\u0019;dQZ\u0013TI\\1cY\u0016$GCA2i\u0011\u0015Iw\u00011\u0001k\u0003\u001d\u0011X-]\"p]\u001a\u0004B!T6M\u0019&\u0011AN\u0016\u0002\u0004\u001b\u0006\u0004\u0018!F4fi&sG/\u001a:oC2\u0014Vm\u001d;DY&,g\u000e\u001e\u000b\u0003/>DQ\u0001\u001d\u0005A\u00021\u000bab[=vk\nL\u0017J\\:uC:\u001cW-\u0001\btKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0016\u0003M\u0004\"\u0001^<\u000e\u0003UT!A\u001e\u0014\u0002\u000fM,7o]5p]&\u0011\u00010\u001e\u0002\u0015\u0017f,XOY5TKN\u001c\u0018n\u001c8NC:\fw-\u001a:\u0002\u0015\t,\u0018\u000e\u001c3CCR\u001c\u0007\u000eF\u0002|\u0003\u0017\u00012\u0001`A\u0004\u001b\u0005i(B\u0001@\u0000\u0003\r!Go\u001c\u0006\u0004C\u0005\u0005!bA\u0012\u0002\u0004)\u0019\u0011Q\u0001\u0014\u0002\r\rd\u0017.\u001a8u\u0013\r\tI! \u0002\u0006\u0005\u0006$8\r\u001b\u0005\u0007m*\u0001\r!!\u0004\u0011\u0007Q\fy!C\u0002\u0002\u0012U\u0014!cS=vk\nL')\u0019;dQN+7o]5p]R)10!\u0006\u0002&!9\u0011qC\u0006A\u0002\u0005e\u0011\u0001C7fi\u0006$\u0017\r^1\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1aIA\u0010\u0015\r\t9\u0002J\u0005\u0005\u0003G\tiB\u0001\u0005NKR\fG-\u0019;b\u0011\u001d\t9c\u0003a\u0001\u0003S\taBY1uG\"\f\u0005\u000f]*uCR,8\u000fE\u0003/\u0003W\ty#C\u0002\u0002.=\u0012aa\u00149uS>t\u0007\u0003BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ub%\u0001\u0004f]\u001eLg.Z\u0005\u0005\u0003s\t\u0019DA\bBaBd\u0017nY1uS>t\u0017J\u001c4p\u0003M1wN]7biN+7o]5p]\"\u000bg\u000e\u001a7f)\u0011\ty$!\u0012\u0011\u0007Q\f\t%C\u0002\u0002DU\u0014QbU3tg&|g\u000eS1oI2,\u0007BBA$\u0019\u0001\u0007A*\u0001\ttKN\u001c\u0018n\u001c8IC:$G.Z*ue\u0006\u0001r\u000e]3o\u0005\u0006$8\r[*fgNLwN\u001c\u000b\u0004w\u00065\u0003bBA(\u001b\u0001\u0007\u0011\u0011K\u0001\be\u0016\fX/Z:u!\ra\u00181K\u0005\u0004\u0003+j(\u0001\u0004\"bi\u000eD'+Z9vKN$\bfB\u0007\u0002Z\u00055\u0014q\u000e\t\u0005\u00037\nI'\u0004\u0002\u0002^)!\u0011qLA1\u0003\t\u00118O\u0003\u0003\u0002d\u0005\u0015\u0014AA<t\u0015\t\t9'A\u0003kCZ\f\u00070\u0003\u0003\u0002l\u0005u#\u0001C\"p]N,X.Z:\u0002\u000bY\fG.^3-\u0005\u0005E\u0014EAA:\u0003A\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c80UN|g\u000eK\u0002\u000e\u0003o\u0002B!a\u0017\u0002z%!\u00111PA/\u0005\u0011\u0001vj\u0015+)\u001f5\ty(a(\u0002\"\u0006\u0015\u0016qUAd\u0003\u0013\u0004B!!!\u0002\u001c6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)A\u0005sKN\u0004xN\\:fg*!\u0011\u0011RAF\u0003-\tgN\\8uCRLwN\\:\u000b\t\u00055\u0015qR\u0001\u0004_\u0006\u001c(\u0002BAI\u0003'\u000b!A^\u001a\u000b\t\u0005U\u0015qS\u0001\bg^\fwmZ3s\u0015\t\tI*\u0001\u0002j_&!\u0011QTAB\u0005-\t\u0005/\u001b*fgB|gn]3\u0002\u0019I,7\u000f]8og\u0016\u001cu\u000eZ3\"\u0005\u0005\r\u0016a\u0001\u001a1a\u000591m\u001c8uK:$HFAAUW)\tY+a.\u0002r\u0005e\u00161\u0018\t\u0005\u0003[\u000b\u0019,\u0004\u0002\u00020*!\u0011\u0011WAD\u0003\u0015iW\rZ5b\u0013\u0011\t),a,\u0003\u000f\r{g\u000e^3oi\u0006IQ.\u001a3jCRK\b/Z\u0001\u0007g\u000eDW-\\1,\r\u0005u\u00161YAc!\u0011\ti+a0\n\t\u0005\u0005\u0017q\u0016\u0002\u0007'\u000eDW-\\1\u0002\u001d%l\u0007\u000f\\3nK:$\u0018\r^5p]\u000e\n10A\u0006eKN\u001c'/\u001b9uS>t\u0017EAAf\u0003}\u0019'/Z1uK\u0002\ng\u000e\u001a\u0011pa\u0016t\u0007%\u0019\u0011cCR\u001c\u0007\u000eI:fgNLwN\\\u0001\u001b_B,gNQ1uG\"\u001cVm]:j_:<\u0016\u000e\u001e5Va2|\u0017\r\u001a\u000b\bw\u0006E\u0017q\u001eB\u0002\u0011\u001d\t\u0019N\u0004a\u0001\u0003#\nABY1uG\"\u0014V-];fgRD\u0003\"!5\u0002X\u00065\u0014Q\u001e\t\u0005\u00033\fI/\u0004\u0002\u0002\\*!\u0011Q\\Ap\u0003%iW\u000f\u001c;ja\u0006\u0014HO\u0003\u0003\u00022\u0006\u0005(\u0002BAr\u0003K\faA[3sg\u0016L(bAAtU\u0005Iq\r\\1tg\u001aL7\u000f[\u0005\u0005\u0003W\fYNA\u0007G_JlG)\u0019;b!\u0006\u0014\u0018-\\\u0011\u0003\u0003'Dq!!=\u000f\u0001\u0004\t\u00190A\fsKN|WO]2f\r&dW-\u00138qkR\u001cFO]3b[B!\u0011Q_A}\u001b\t\t9PC\u0002\u0002\u001a\"KA!a?\u0002x\nY\u0011J\u001c9viN#(/Z1nQ!\ty/a6\u0002n\u0005}\u0018E\u0001B\u0001\u00031\u0011Xm]8ve\u000e,g)\u001b7f\u0011\u001d\u0011)A\u0004a\u0001\u0005\u000f\tAC]3t_V\u00148-\u001a$jY\u0016lU\r^1eCR\f\u0007\u0003BAm\u0005\u0013IAAa\u0003\u0002\\\nQbi\u001c:n\t\u0006$\u0018mQ8oi\u0016tG\u000fR5ta>\u001c\u0018\u000e^5p]\"B!1AAl\u0003[\ny\u0010K\u0004\u000f\u00033\niG!\u0005-\u0005\tM\u0011E\u0001B\u000b\u0003MiW\u000f\u001c;ja\u0006\u0014Ho\f4pe6lC-\u0019;bQ\rq\u0011q\u000f\u0015\u0010\u001d\u0005}\u0014qTAQ\u0003K\u0013Y\"a2\u0003\u001e1\u0012\u0011\u0011V\u0011\u0003\u0005?\tAh\u0019:fCR,\u0007%\u00198eA=\u0004XM\u001c\u0011bA\t\fGo\u00195!g\u0016\u001c8/[8oA]LG\u000f\u001b\u0011va2|\u0017\rZ5oO\u0002\u0012Xm]8ve\u000e,\u0007EZ5mK\u0006Ar\u000e]3o\u0005\u0006$8\r[*fgNLwN\\%oi\u0016\u0014h.\u00197\u0015\u000bm\u0014)Ca\n\t\u000f\u0005=s\u00021\u0001\u0002R!A!\u0011F\b\u0011\u0002\u0003\u00071-\u0001\u000bjgJ+7o\\;sG\u00164%o\\7Va2|\u0017\rZ\u0001#_B,gNQ1uG\"\u001cVm]:j_:Le\u000e^3s]\u0006dG\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t=\"fA2\u00032-\u0012!1\u0007\t\u0005\u0005k\u0011y$\u0004\u0002\u00038)!!\u0011\bB\u001e\u0003%)hn\u00195fG.,GMC\u0002\u0003>=\n!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tEa\u000e\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bnCJ\\G)\u001e9mS\u000e\fG/\u001a3\u0015\u0007m\u00149\u0005\u0003\u0004\u0003JE\u0001\ra_\u0001\u0006E\u0006$8\r[\u0001\nE\u0006$8\r[%oM>$2a\u001fB(\u0011\u0019\u0011\tF\u0005a\u0001\u0019\u00069!-\u0019;dQ&#\u0007\u0006\u0003B(\u0005+\niGa\u0017\u0011\t\u0005m#qK\u0005\u0005\u00053\niFA\u0005QCRD\u0007+\u0019:b[\u0006\u0012!\u0011\u000b\u0015\b%\t}\u0013Q\u000eB3!\u0011\tYF!\u0019\n\t\t\r\u0014Q\f\u0002\u0005!\u0006$\b.\t\u0002\u0003h\u0005I1PY1uG\"LE- \u0015\u0004%\t-\u0004\u0003BA.\u0005[JAAa\u001c\u0002^\t\u0019q)\u0012+)\u001fI\ty(a(\u0002\"\u0006\u0015&1OAd\u0005kb#!!+\"\u0005\t]\u0014aH4fi\u0002\"\b.\u001a\u0011cCR\u001c\u0007\u000eI5oM>\u0004c/[1!E\u0006$8\r\u001b\u0011jI\u0006\u0001r-\u001a;CCR\u001c\u0007.\u00138g_2K7\u000f\u001e\u000b\u0013\u0005{\u0012\u0019I!%\u0003\u001a\n\u0005&\u0011\u0016B\\\u0005\u007f\u00139\rE\u0002}\u0005\u007fJ1A!!~\u0005I9U\r\u001e\"bi\u000eDWm\u001d*fgB|gn]3\t\r\t\u00155\u00031\u0001M\u0003%\u0011\u0017\r^2i)f\u0004X\r\u000b\u0005\u0003\u0004\n%\u0015Q\u000eBH!\u0011\tYFa#\n\t\t5\u0015Q\f\u0002\u000b#V,'/\u001f)be\u0006l\u0017E\u0001BC\u0011\u0019\u0011\u0019j\u0005a\u0001\u0019\u0006Q!-\u0019;dQN#\u0018\r^3)\u0011\tE%\u0011RA7\u0005/\u000b#Aa%\t\r\tm5\u00031\u0001M\u0003%\u0011\u0017\r^2i+N,'\u000f\u000b\u0005\u0003\u001a\n%\u0015Q\u000eBPC\t\u0011Y\n\u0003\u0004\u0003$N\u0001\r\u0001T\u0001\nE\u0006$8\r\u001b(b[\u0016D\u0003B!)\u0003\n\u00065$qU\u0011\u0003\u0005GCqAa+\u0014\u0001\u0004\u0011i+\u0001\u0006de\u0016\fG/\u001a+j[\u0016\u00042A\fBX\u0013\r\u0011\tl\f\u0002\u0005\u0019>tw\r\u000b\u0005\u0003*\n%\u0015Q\u000eB[C\t\u0011Y\u000bC\u0004\u0003:N\u0001\rA!,\u0002\u000f\u0015tG\rV5nK\"B!q\u0017BE\u0003[\u0012i,\t\u0002\u0003:\"1!\u0011Y\nA\u0002u\u000bAA\u001a:p[\"B!q\u0018BE\u0003[\u0012)-\t\u0002\u0003B\"1!\u0011Z\nA\u0002u\u000bAa]5{K\"B!q\u0019Bg\u0003[\u0012\u0019\u000e\u0005\u0003\u0002\\\t=\u0017\u0002\u0002Bi\u0003;\u0012A\u0002R3gCVdGOV1mk\u0016\f#A!6\u0002\u0007E\u0002\u0004\u0007\u000b\u0005\u0003H\n%\u0015Q\u000eBmC\t\u0011I\rK\u0004\u0014\u00033\niG!8-\u0005\u0005E\u0004fA\n\u0003l!z1#a \u0002 \u0006\u0005\u0016Q\u0015Br\u0003\u000f\u0014Y\u000f\f\u0002\u0003f.R\u00111VA\\\u0003c\nILa:,\r\u0005u\u00161\u0019BuG\t\u0011i(\t\u0002\u0003n\u0006Y\"/\u001a;ve:\u001c\b\u0005\u001e5fA\t\fGo\u00195!g\u0016\u001c8/[8og:\n\u0001cZ3u\u0005\u0006$8\r\u001b'pG\u0006dGj\\4\u0015\u0011\tM(\u0011 B\u007f\u0007\u000f\u00012\u0001 B{\u0013\r\u001190 \u0002\r\u001fB,'/\u0019;j_:dun\u001a\u0005\u0007\u0005#\"\u0002\u0019\u0001')\u0011\te(QKA7\u00057BaA!1\u0015\u0001\u0004i\u0006\u0006\u0003B\u007f\u0005\u001b\fig!\u0001\"\u0005\r\r\u0011AA\u00172Q!\u0011iP!#\u0002n\t\u0015\u0007B\u0002Be)\u0001\u0007Q\f\u000b\u0005\u0004\b\t5\u0017Q\u000eBjQ!\u00199A!#\u0002n\te\u0007f\u0002\u000b\u0003`\u000554qB\u0011\u0003\u0007#\t!c\u001f2bi\u000eD\u0017\nZ?0Y>\u001c\u0017\r\u001c'pO\"\u001aACa\u001b)\u001fQ\ty(a(\u0002\"\u0006\u00156qCAd\u0007?a#a!\u0007,\u0015\u0005-\u0016qWA9\u0003s\u001bYb\u000b\u0004\u0002>\u0006\r7QD\u0012\u0003\u0005g\f#a!\t\u0002O\u001d,G\u000f\t;iK\u0002bwnY1mA1|w\r\t7j]\u0016\u001c\bE\u001a:p[\u0002\"\b.[:!E\u0006$8\r[\u0001\u0012G2|7/\u001a\"bi\u000eD7+Z:tS>tG\u0003BB\u0014\u0007[\u00012\u0001`B\u0015\u0013\r\u0019Y# \u0002\u0013\u00072|7/\u001a\"bi\u000eD'+Z:q_:\u001cX\r\u0003\u0004\u0003RU\u0001\r\u0001\u0014\u0015\t\u0007[\u0011)&!\u001c\u0003\\!:QCa\u0018\u0002n\t\u0015\u0004fA\u000b\u00046A!\u00111LB\u001c\u0013\u0011\u0019I$!\u0018\u0003\r\u0011+E*\u0012+FQ=)\u0012qPAP\u0003C\u000b)k!\u0010\u0002H\u000e\u0015CFAB W)\tY+a.\u0002r\u0005e6\u0011I\u0016\u0007\u0003{\u000b\u0019ma\u0011$\u0005\r\u001d\u0012EAB$\u0003\u0001\u001aGn\\:fA\u0005tG\rI2b]\u000e,G\u000eI1!E\u0006$8\r\u001b\u0011tKN\u001c\u0018n\u001c8)\u000f\u0001\u0019Y%!\u001c\u0004RA!\u00111LB'\u0013\u0011\u0019y%!\u0018\u0003\u0011A\u0013x\u000eZ;dKNd#!!\u001d)\u000f\u0001\u0019)f!\u0019\u0004dA!1qKB/\u001b\t\u0019IF\u0003\u0003\u0004\\\u0005\u001d\u0015\u0001\u0002;bONLAaa\u0018\u0004Z\t\u0019A+Y4\u0002\t9\fW.Z\u0011\u0003\u0007K\nQAQ1uG\"\fqBQ1uG\",7OU3t_V\u00148-\u001a\t\u0003\u007f]\u0019\"aF\u0017\u0015\u0005\r%\u0014!F*V!B{%\u000bV#E?\n\u000bEk\u0011%`)f\u0003ViU\u000b\u0003\u0007g\u0002ba!\u001e\u0004|\r}TBAB<\u0015\r\u0019IhL\u0001\u000bG>dG.Z2uS>t\u0017\u0002BB?\u0007o\u00121aU3r!\u0011\u0019\tia\"\u000e\u0005\r\r%bABC\u0011\u0006!A.\u00198h\u0013\r)61Q\u0001\u0017'V\u0003\u0006k\u0014*U\u000b\u0012{&)\u0011+D\u0011~#\u0016\fU#TA\u0005\u0011b+\u0011'J\t~\u0013\u0015\tV\"I?N#\u0016\tV#T\u0003M1\u0016\tT%E?\n\u000bEk\u0011%`'R\u000bE+R*!\u0003I\u0019X\u000f\u001d9peR,GMQ1uG\"$\u0016\u0010]3\u0015\u0007\r\u001c\u0019\n\u0003\u0004\u0003\u0006v\u0001\r\u0001T\u0001\u0010m\u0006d\u0017\u000e\u001a\"bi\u000eD7\u000b^1uKR\u00191m!'\t\r\tMe\u00041\u0001M\u0001")
public class BatchesResource
implements ApiRequestContext,
Logging {
    private int internalSocketTimeout;
    private int internalConnectTimeout;
    private boolean internalSecurityEnabled;
    private final ConcurrentHashMap<String, InternalRestClient> internalRestClients;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;
    private Option<KyuubiBatchService> batchService;
    private volatile byte bitmap$0;

    public static boolean validBatchState(String string) {
        return BatchesResource$.MODULE$.validBatchState(string);
    }

    public static boolean supportedBatchType(String string) {
        return BatchesResource$.MODULE$.supportedBatchType(string);
    }

    public static Seq<String> VALID_BATCH_STATES() {
        return BatchesResource$.MODULE$.VALID_BATCH_STATES();
    }

    public static Seq<String> SUPPORTED_BATCH_TYPES() {
        return BatchesResource$.MODULE$.SUPPORTED_BATCH_TYPES();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    @Override
    public final KyuubiRestFrontendService fe() {
        return ApiRequestContext.fe$(this);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private Option<KyuubiBatchService> batchService$lzycompute() {
        BatchesResource batchesResource = this;
        synchronized (batchesResource) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.batchService = ApiRequestContext.batchService$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.batchService;
    }

    @Override
    public Option<KyuubiBatchService> batchService() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.batchService$lzycompute();
        }
        return this.batchService;
    }

    private ConcurrentHashMap<String, InternalRestClient> internalRestClients() {
        return this.internalRestClients;
    }

    private int internalSocketTimeout$lzycompute() {
        BatchesResource batchesResource = this;
        synchronized (batchesResource) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.internalSocketTimeout = (int)BoxesRunTime.unboxToLong((Object)this.fe().getConf().get(KyuubiConf$.MODULE$.BATCH_INTERNAL_REST_CLIENT_SOCKET_TIMEOUT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.internalSocketTimeout;
    }

    private int internalSocketTimeout() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.internalSocketTimeout$lzycompute();
        }
        return this.internalSocketTimeout;
    }

    private int internalConnectTimeout$lzycompute() {
        BatchesResource batchesResource = this;
        synchronized (batchesResource) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.internalConnectTimeout = (int)BoxesRunTime.unboxToLong((Object)this.fe().getConf().get(KyuubiConf$.MODULE$.BATCH_INTERNAL_REST_CLIENT_CONNECT_TIMEOUT()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.internalConnectTimeout;
    }

    private int internalConnectTimeout() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.internalConnectTimeout$lzycompute();
        }
        return this.internalConnectTimeout;
    }

    private boolean internalSecurityEnabled$lzycompute() {
        BatchesResource batchesResource = this;
        synchronized (batchesResource) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.internalSecurityEnabled = BoxesRunTime.unboxToBoolean((Object)this.fe().getConf().get(KyuubiConf$.MODULE$.ENGINE_SECURITY_ENABLED()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.internalSecurityEnabled;
    }

    private boolean internalSecurityEnabled() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.internalSecurityEnabled$lzycompute();
        }
        return this.internalSecurityEnabled;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean batchV2Enabled(scala.collection.immutable.Map<String, String> reqConf) {
        if (!BoxesRunTime.unboxToBoolean((Object)KyuubiServer$.MODULE$.kyuubiServer().getConf().get(KyuubiConf$.MODULE$.BATCH_SUBMITTER_ENABLED()))) return false;
        Object object = reqConf.getOrElse((Object)KyuubiConf$.MODULE$.BATCH_IMPL_VERSION().key(), (Function0 & Serializable & scala.Serializable)() -> (String)this.fe().getConf().get(KyuubiConf$.MODULE$.BATCH_IMPL_VERSION()));
        String string = "2";
        if (object != null) {
            if (!object.equals(string)) return false;
            return true;
        }
        if (string == null) return true;
        return false;
    }

    private InternalRestClient getInternalRestClient(String kyuubiInstance2) {
        return this.internalRestClients().computeIfAbsent(kyuubiInstance2, kyuubiInstance -> new InternalRestClient((String)kyuubiInstance, this.internalSocketTimeout(), this.internalConnectTimeout(), this.internalSecurityEnabled()));
    }

    private KyuubiSessionManager sessionManager() {
        return (KyuubiSessionManager)this.fe().be().sessionManager();
    }

    private Batch buildBatch(KyuubiBatchSession session) {
        BatchJobSubmission batchOp = session.batchJobSubmissionOp();
        OperationStatus batchOpStatus = batchOp.getStatus();
        Tuple5 tuple5 = (Tuple5)batchOp.getApplicationInfo().map((Function1 & Serializable & scala.Serializable)appInfo -> {
            String name = (String)Option$.MODULE$.apply((Object)batchOp.batchName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> appInfo.name());
            return new Tuple5((Object)name, (Object)appInfo.id(), appInfo.url().orNull(Predef$.MODULE$.$conforms()), (Object)appInfo.state().toString(), appInfo.error().orNull(Predef$.MODULE$.$conforms()));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            Option<Metadata> option = this.sessionManager().getBatchMetadata(batchOp.batchId());
            if (option instanceof Some) {
                Some some = (Some)option;
                Metadata batch = (Metadata)some.value();
                String diagnostic = (String)batch.engineError().orNull(Predef$.MODULE$.$conforms());
                return new Tuple5((Object)batchOp.batchName(), (Object)batch.engineId(), (Object)batch.engineUrl(), (Object)batch.engineState(), (Object)diagnostic);
            }
            if (None$.MODULE$.equals(option)) {
                return new Tuple5((Object)batchOp.batchName(), null, null, null, null);
            }
            throw new MatchError(option);
        });
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        String name = (String)tuple5._1();
        String appId = (String)tuple5._2();
        String appUrl = (String)tuple5._3();
        String appState = (String)tuple5._4();
        String appDiagnostic = (String)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)name, (Object)appId, (Object)appUrl, (Object)appState, (Object)appDiagnostic);
        String name2 = (String)tuple52._1();
        String appId2 = (String)tuple52._2();
        String appUrl2 = (String)tuple52._3();
        String appState2 = (String)tuple52._4();
        String appDiagnostic2 = (String)tuple52._5();
        return new Batch(batchOp.batchId(), session.user(), batchOp.batchType(), name2, batchOp.appStartTime(), appId2, appUrl2, appState2, appDiagnostic2, session.connectionUrl(), batchOpStatus.state().toString(), session.createTime(), batchOpStatus.completed(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
    }

    private Batch buildBatch(Metadata metadata, Option<ApplicationInfo> batchAppStatus) {
        return (Batch)batchAppStatus.map((Function1 & Serializable & scala.Serializable)appStatus -> {
            String currentBatchState = BatchJobSubmission$.MODULE$.applicationFailed(batchAppStatus) ? OperationState$.MODULE$.ERROR().toString() : (BatchJobSubmission$.MODULE$.applicationTerminated(batchAppStatus) ? OperationState$.MODULE$.FINISHED().toString() : (batchAppStatus.isDefined() ? OperationState$.MODULE$.RUNNING().toString() : metadata.state()));
            String name = (String)Option$.MODULE$.apply((Object)metadata.requestName()).getOrElse((Function0 & Serializable & scala.Serializable)() -> appStatus.name());
            String appId = appStatus.id();
            String appUrl = (String)appStatus.url().orNull(Predef$.MODULE$.$conforms());
            String appState = appStatus.state().toString();
            String appDiagnostic = (String)appStatus.error().orNull(Predef$.MODULE$.$conforms());
            return new Batch(metadata.identifier(), metadata.username(), metadata.engineType(), name, metadata.engineOpenTime(), appId, appUrl, appState, appDiagnostic, metadata.kyuubiInstance(), currentBatchState, metadata.createTime(), metadata.endTime(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().empty()).asJava());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> MetadataManager$.MODULE$.buildBatch(metadata));
    }

    private SessionHandle formatSessionHandle(String sessionHandleStr) {
        SessionHandle sessionHandle;
        try {
            sessionHandle = SessionHandle$.MODULE$.fromUUID(sessionHandleStr);
        }
        catch (IllegalArgumentException e) {
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(sessionHandleStr).toString(), (Throwable)e);
        }
        return sessionHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Batch.class))}, description="create and open a batch session")
    @POST
    @Consumes(value={"application/json"})
    public Batch openBatchSession(BatchRequest request) {
        return this.openBatchSessionInternal(request, this.openBatchSessionInternal$default$2());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Batch.class))}, description="create and open a batch session with uploading resource file")
    @POST
    @Consumes(value={"multipart/form-data"})
    public Batch openBatchSessionWithUpload(@FormDataParam(value="batchRequest") BatchRequest batchRequest, @FormDataParam(value="resourceFile") InputStream resourceFileInputStream, @FormDataParam(value="resourceFile") FormDataContentDisposition resourceFileMetadata) {
        Predef$.MODULE$.require(BoxesRunTime.unboxToBoolean((Object)this.fe().getConf().get(KyuubiConf$.MODULE$.BATCH_RESOURCE_UPLOAD_ENABLED())), (Function0 & Serializable & scala.Serializable)() -> "Batch resource upload function is disabled.");
        Predef$.MODULE$.require(batchRequest != null, (Function0 & Serializable & scala.Serializable)() -> "batchRequest is required and please check the content type of batchRequest is application/json");
        File tempFile = Utils$.MODULE$.writeToTempFile(resourceFileInputStream, KyuubiApplicationManager$.MODULE$.uploadWorkDir(), resourceFileMetadata.getFileName());
        batchRequest.setResource(tempFile.getPath());
        return this.openBatchSessionInternal(batchRequest, true);
    }

    private Batch openBatchSessionInternal(BatchRequest request, boolean isResourceFromUpload) {
        Predef$.MODULE$.require(BatchesResource$.MODULE$.supportedBatchType(request.getBatchType()), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append(request.getBatchType()).append(" is not in the supported list: ").append(BatchesResource$.MODULE$.SUPPORTED_BATCH_TYPES()).append("}").toString());
        Predef$.MODULE$.require(request.getResource() != null, (Function0 & Serializable & scala.Serializable)() -> "resource is a required parameter");
        if (request.getBatchType().equalsIgnoreCase("SPARK")) {
            Predef$.MODULE$.require(request.getClassName() != null, (Function0 & Serializable & scala.Serializable)() -> "classname is a required parameter for SPARK");
        }
        request.setBatchType(request.getBatchType().toUpperCase(Locale.ROOT));
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()));
        String ipAddress = this.fe().getIpAddress();
        Option userProvidedBatchId = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).get((Object)BatchUtils.KYUUBI_BATCH_ID_KEY);
        userProvidedBatchId.foreach((Function1 & Serializable & scala.Serializable)batchId -> {
            UUID uUID;
            try {
                uUID = UUID.fromString(batchId);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    throw new IllegalArgumentException(new StringBuilder(17).append(BatchUtils.KYUUBI_BATCH_ID_KEY).append("=").append((String)batchId).append(" must be an UUID").toString(), e);
                }
                throw throwable;
            }
            return uUID;
        });
        Option option = userProvidedBatchId.flatMap((Function1 & Serializable & scala.Serializable)batchId -> this.sessionManager().getBatchFromMetadataStore((String)batchId));
        if (option instanceof Some) {
            Some some = (Some)option;
            Batch batch = (Batch)some.value();
            return this.markDuplicated(batch);
        }
        if (None$.MODULE$.equals(option)) {
            String batchId2 = (String)userProvidedBatchId.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString());
            request.setConf((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchUtils.KYUUBI_BATCH_ID_KEY), (Object)batchId2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.batch.resource.uploaded"), (Object)Boolean.toString(isResourceFromUpload)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.client.ipAddress"), (Object)ipAddress), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.server.ipAddress"), (Object)this.fe().host()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.connection.url"), (Object)this.fe().connectionUrl()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"kyuubi.session.real.user"), (Object)this.fe().getRealUser())})))).asJava());
            if (this.batchV2Enabled((scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()))) {
                this.logger().info(new StringBuilder(36).append("Submit batch job ").append(batchId2).append(" using Batch API v2").toString());
                boolean bl = false;
                Failure failure = null;
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.sessionManager().initializeBatchState(userName, ipAddress, (scala.collection.immutable.Map<String, String>)((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(request.getConf()).asScala()).toMap(Predef$.MODULE$.$conforms()), request));
                if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    String batchId3 = (String)success.value();
                    Option<Batch> option2 = this.sessionManager().getBatchFromMetadataStore(batchId3);
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        Batch batch = (Batch)some.value();
                        return batch;
                    }
                    if (None$.MODULE$.equals(option2)) {
                        throw new IllegalStateException(new StringBuilder(39).append("can not find batch ").append(batchId3).append(" from metadata store").toString());
                    }
                    throw new MatchError(option2);
                }
                if (try_ instanceof Failure) {
                    bl = true;
                    failure = (Failure)try_;
                    Throwable cause = failure.exception();
                    if (JdbcUtils$.MODULE$.isDuplicatedKeyDBErr(cause)) {
                        Option<Batch> option3 = this.sessionManager().getBatchFromMetadataStore(batchId2);
                        if (option3 instanceof Some) {
                            Some some = (Some)option3;
                            Batch batch = (Batch)some.value();
                            return this.markDuplicated(batch);
                        }
                        if (None$.MODULE$.equals(option3)) {
                            throw new IllegalStateException(new StringBuilder(50).append("can not find duplicated batch ").append(batchId2).append(" from metadata store").toString());
                        }
                        throw new MatchError(option3);
                    }
                }
                if (bl) {
                    Throwable cause = failure.exception();
                    throw new IllegalStateException(cause);
                }
                throw new MatchError((Object)try_);
            }
            boolean bl = false;
            Failure failure = null;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.sessionManager().openBatchSession(userName, "anonymous", ipAddress, request));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                SessionHandle sessionHandle = (SessionHandle)success.value();
                Option<KyuubiBatchSession> option4 = this.sessionManager().getBatchSession(sessionHandle);
                if (option4 instanceof Some) {
                    Some some = (Some)option4;
                    KyuubiBatchSession batchSession = (KyuubiBatchSession)((Object)some.value());
                    return this.buildBatch(batchSession);
                }
                if (None$.MODULE$.equals(option4)) {
                    throw new IllegalStateException(new StringBuilder(39).append("can not find batch ").append(batchId2).append(" from metadata store").toString());
                }
                throw new MatchError(option4);
            }
            if (try_ instanceof Failure) {
                bl = true;
                failure = (Failure)try_;
                Throwable cause = failure.exception();
                if (JdbcUtils$.MODULE$.isDuplicatedKeyDBErr(cause)) {
                    Option<Batch> option5 = this.sessionManager().getBatchFromMetadataStore(batchId2);
                    if (option5 instanceof Some) {
                        Some some = (Some)option5;
                        Batch batch = (Batch)some.value();
                        return this.markDuplicated(batch);
                    }
                    if (None$.MODULE$.equals(option5)) {
                        throw new IllegalStateException(new StringBuilder(50).append("can not find duplicated batch ").append(batchId2).append(" from metadata store").toString());
                    }
                    throw new MatchError(option5);
                }
            }
            if (bl) {
                Throwable cause = failure.exception();
                throw new IllegalStateException(cause);
            }
            throw new MatchError((Object)try_);
        }
        throw new MatchError((Object)option);
    }

    private boolean openBatchSessionInternal$default$2() {
        return false;
    }

    private Batch markDuplicated(Batch batch) {
        this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("duplicated submission: ").append(batch.getId()).append(", ignore and return the existing batch.").toString());
        batch.setBatchInfo((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchUtils.KYUUBI_BATCH_DUPLICATED_KEY), (Object)"true")}))).asJava());
        return batch;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=Batch.class))}, description="get the batch info via batch id")
    @GET
    @Path(value="{batchId}")
    public Batch batchInfo(@PathParam(value="batchId") String batchId) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        SessionHandle sessionHandle = this.formatSessionHandle(batchId);
        return (Batch)this.sessionManager().getBatchSession(sessionHandle).map((Function1 & Serializable & scala.Serializable)batchSession -> this.buildBatch((KyuubiBatchSession)((Object)batchSession))).getOrElse((Function0 & Serializable & scala.Serializable)() -> (Batch)this.sessionManager().getBatchMetadata(batchId).map((Function1 & Serializable & scala.Serializable)metadata -> {
            Batch batch;
            block5: {
                block4: {
                    if (this.batchV2Enabled(metadata.requestConf()) || OperationState$.MODULE$.isTerminal(OperationState$.MODULE$.withName(metadata.state()))) break block4;
                    String string = metadata.kyuubiInstance();
                    String string2 = this.fe().connectionUrl();
                    if (string != null ? !string.equals(string2) : string2 != null) break block5;
                }
                return MetadataManager$.MODULE$.buildBatch((Metadata)metadata);
            }
            InternalRestClient internalRestClient = this.getInternalRestClient(metadata.kyuubiInstance());
            try {
                batch = internalRestClient.getBatch(userName, batchId);
            }
            catch (KyuubiRestException e) {
                this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Error redirecting get batch[").append(batchId).append("] to ").append(metadata.kyuubiInstance()).toString(), e);
                Option<ApplicationInfo> batchAppStatus = this.sessionManager().applicationManager().getApplicationInfo(metadata.appMgrInfo(), batchId, (Option<String>)new Some((Object)userName), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)metadata.engineOpenTime())).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> x$2 > 0L).orElse((Function0 & Serializable & scala.Serializable)() -> new Some((Object)BoxesRunTime.boxToLong((long)System.currentTimeMillis()))));
                batch = this.buildBatch((Metadata)metadata, batchAppStatus);
            }
            return batch;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
        }));
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=GetBatchesResponse.class))}, description="returns the batch sessions.")
    @GET
    @Consumes(value={"application/json"})
    public GetBatchesResponse getBatchInfoList(@QueryParam(value="batchType") String batchType, @QueryParam(value="batchState") String batchState, @QueryParam(value="batchUser") String batchUser, @QueryParam(value="batchName") String batchName, @QueryParam(value="createTime") long createTime, @QueryParam(value="endTime") long endTime, @QueryParam(value="from") int from, @QueryParam(value="size") @DefaultValue(value="100") int size) {
        Predef$.MODULE$.require(createTime >= 0L && endTime >= 0L && (endTime == 0L || createTime <= endTime), (Function0 & Serializable & scala.Serializable)() -> "Invalid time range");
        if (batchState != null) {
            Predef$.MODULE$.require(BatchesResource$.MODULE$.validBatchState(batchState), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(51).append("The valid batch state can be one of the following: ").append(BatchesResource$.MODULE$.VALID_BATCH_STATES().mkString(",")).toString());
        }
        Enumeration.Value x$1 = SessionType$.MODULE$.BATCH();
        String x$2 = batchType;
        String x$3 = batchUser;
        String x$4 = batchState;
        String x$5 = batchName;
        long x$6 = createTime;
        long x$7 = endTime;
        String x$8 = MetadataFilter$.MODULE$.apply$default$6();
        boolean x$9 = MetadataFilter$.MODULE$.apply$default$9();
        MetadataFilter filter = new MetadataFilter(x$1, x$2, x$3, x$4, x$5, x$8, x$6, x$7, x$9);
        Seq<Batch> batches = this.sessionManager().getBatchesFromMetadataStore(filter, from, size);
        return new GetBatchesResponse(from, batches.size(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(batches).asJava());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=OperationLog.class))}, description="get the local log lines from this batch")
    @GET
    @Path(value="{batchId}/localLog")
    public OperationLog getBatchLocalLog(@PathParam(value="batchId") String batchId, @QueryParam(value="from") @DefaultValue(value="-1") int from, @QueryParam(value="size") @DefaultValue(value="100") int size) {
        String userName = this.fe().getSessionUser((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty());
        SessionHandle sessionHandle = this.formatSessionHandle(batchId);
        return (OperationLog)this.sessionManager().getBatchSession(sessionHandle).map((Function1 & Serializable & scala.Serializable)batchSession -> {
            OperationLog operationLog;
            try {
                java.util.List list;
                BatchJobSubmission submissionOp = batchSession.batchJobSubmissionOp();
                TRowSet rowSet = submissionOp.getOperationLogRowSet(FetchOrientation$.MODULE$.FETCH_NEXT(), from, size);
                java.util.List columns = rowSet.getColumns();
                if (columns == null || columns.size() == 0) {
                    list = Collections.emptyList();
                } else {
                    Predef$.MODULE$.assert(columns.size() == 1);
                    list = ((TColumn)columns.get(0)).getStringVal().getValues();
                }
                java.util.List logRowSet = list;
                operationLog = new OperationLog(logRowSet, logRowSet.size());
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    String errorMsg = new StringBuilder(41).append("Error getting operation log for batchId: ").append(batchId).toString();
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> errorMsg, e);
                    throw new NotFoundException(errorMsg);
                }
                throw throwable;
            }
            return operationLog;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (OperationLog)this.sessionManager().getBatchMetadata(batchId).map((Function1 & Serializable & scala.Serializable)metadata -> {
            block6: {
                block7: {
                    if (this.batchV2Enabled(metadata.requestConf())) {
                        String string = metadata.state();
                        String string2 = "INITIALIZED";
                        if (!(string != null ? !string.equals(string2) : string2 != null)) {
                            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Batch ").append(batchId).append(" is waiting for scheduling").toString());
                            java.util.List dummyLogs = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new StringBuilder(32).append("Batch ").append(batchId).append(" is waiting for scheduling").toString(), (List)Nil$.MODULE$)).asJava();
                            return new OperationLog(dummyLogs, dummyLogs.size());
                        }
                    }
                    String string = this.fe().connectionUrl();
                    String string3 = metadata.kyuubiInstance();
                    if (string == null ? string3 != null : !string.equals(string3)) {
                        InternalRestClient internalRestClient = this.getInternalRestClient(metadata.kyuubiInstance());
                        return internalRestClient.getBatchLocalLog(userName, batchId, from, size);
                    }
                    if (!this.batchV2Enabled(metadata.requestConf())) break block6;
                    String string4 = metadata.state();
                    String string5 = "PENDING";
                    if (!(string4 == null ? string5 != null : !string4.equals(string5))) break block7;
                    String string6 = metadata.state();
                    String string7 = "RUNNING";
                    if (string6 != null ? !string6.equals(string7) : string7 != null) break block6;
                }
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Batch ").append(batchId).append(" is waiting for submitting").toString());
                java.util.List dummyLogs = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new StringBuilder(32).append("Batch ").append(batchId).append(" is waiting for submitting").toString(), (List)Nil$.MODULE$)).asJava();
                return new OperationLog(dummyLogs, dummyLogs.size());
            }
            throw new NotFoundException(new StringBuilder(30).append("No local log found for batch: ").append(batchId).toString());
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
        }));
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=CloseBatchResponse.class))}, description="close and cancel a batch session")
    @DELETE
    @Path(value="{batchId}")
    public CloseBatchResponse closeBatchSession(@PathParam(value="batchId") String batchId) {
        SessionHandle sessionHandle = this.formatSessionHandle(batchId);
        return (CloseBatchResponse)this.sessionManager().getBatchSession(sessionHandle).map((Function1 & Serializable & scala.Serializable)batchSession -> {
            this.fe().getSessionUser(batchSession.user());
            this.sessionManager().closeSession(batchSession.handle());
            Tuple2<Object, String> tuple2 = batchSession.batchJobSubmissionOp().getKillMessage();
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            boolean killed = tuple2._1$mcZ$sp();
            String msg = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)killed), (Object)msg);
            boolean killed2 = tuple22._1$mcZ$sp();
            String msg2 = (String)tuple22._2();
            return new CloseBatchResponse(killed2, msg2);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> (CloseBatchResponse)this.sessionManager().getBatchMetadata(batchId).map((Function1 & Serializable & scala.Serializable)metadata -> {
            this.fe().getSessionUser(metadata.username());
            if (OperationState$.MODULE$.isTerminal(OperationState$.MODULE$.withName(metadata.state()))) {
                return new CloseBatchResponse(false, new StringBuilder(32).append("The batch[").append(metadata).append("] has been terminated.").toString());
            }
            if (this.batchV2Enabled(metadata.requestConf())) {
                String string = metadata.state();
                String string2 = "INITIALIZED";
                if (!(string != null ? !string.equals(string2) : string2 != null) && ((KyuubiBatchService)((Object)((Object)((Object)this.batchService().get())))).cancelUnscheduledBatch(batchId)) {
                    return new CloseBatchResponse(true, new StringBuilder(31).append("Unscheduled batch ").append(batchId).append(" is canceled.").toString());
                }
            }
            if (this.batchV2Enabled(metadata.requestConf()) && metadata.kyuubiInstance() == null) {
                return this.closeBatchSession(batchId);
            }
            String string = metadata.kyuubiInstance();
            String string3 = this.fe().connectionUrl();
            if (string == null ? string3 != null : !string.equals(string3)) {
                CloseBatchResponse closeBatchResponse;
                this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Redirecting delete batch[").append(batchId).append("] to ").append(metadata.kyuubiInstance()).toString());
                InternalRestClient internalRestClient = this.getInternalRestClient(metadata.kyuubiInstance());
                try {
                    closeBatchResponse = internalRestClient.deleteBatch(metadata.username(), batchId);
                }
                catch (KyuubiRestException e) {
                    this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error redirecting delete batch[").append(batchId).append("] to ").append(metadata.kyuubiInstance()).toString(), e);
                    Tuple2 tuple2 = this.forceKill$1(metadata.appMgrInfo(), batchId, metadata.username());
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    boolean killed = tuple2._1$mcZ$sp();
                    String msg = (String)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)killed), (Object)msg);
                    boolean killed2 = tuple22._1$mcZ$sp();
                    String msg2 = (String)tuple22._2();
                    closeBatchResponse = new CloseBatchResponse(killed2, killed2 ? msg2 : Utils$.MODULE$.stringifyException((Throwable)e));
                }
                return closeBatchResponse;
            }
            this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(69).append("Something wrong on deleting batch[").append(batchId).append("], try forcibly killing application").toString());
            Tuple2 tuple2 = this.forceKill$1(metadata.appMgrInfo(), batchId, metadata.username());
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean killed = tuple2._1$mcZ$sp();
            String msg = (String)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)killed), (Object)msg);
            boolean killed3 = tuple23._1$mcZ$sp();
            String msg3 = (String)tuple23._2();
            return new CloseBatchResponse(killed3, msg3);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            this.error((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
            throw new NotFoundException(new StringBuilder(17).append("Invalid batchId: ").append(batchId).toString());
        }));
    }

    private final Tuple2 forceKill$1(ApplicationManagerInfo appMgrInfo, String batchId, String user) {
        Tuple2<Object, String> tuple2 = this.sessionManager().applicationManager().killApplication(appMgrInfo, batchId, (Option<String>)new Some((Object)user));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean killed = tuple2._1$mcZ$sp();
        String message = (String)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)killed), (Object)message);
        boolean killed2 = tuple22._1$mcZ$sp();
        String message2 = (String)tuple22._2();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Mark batch[").append(batchId).append("] closed by ").append(this.fe().connectionUrl()).toString());
        String x$1 = batchId;
        boolean x$2 = true;
        Enumeration.Value x$3 = Metadata$.MODULE$.apply$default$2();
        String x$4 = Metadata$.MODULE$.apply$default$3();
        String x$5 = Metadata$.MODULE$.apply$default$4();
        String x$6 = Metadata$.MODULE$.apply$default$5();
        String x$7 = Metadata$.MODULE$.apply$default$6();
        String x$8 = Metadata$.MODULE$.apply$default$7();
        String x$9 = Metadata$.MODULE$.apply$default$8();
        String x$10 = Metadata$.MODULE$.apply$default$9();
        String x$11 = Metadata$.MODULE$.apply$default$10();
        scala.collection.immutable.Map<String, String> x$12 = Metadata$.MODULE$.apply$default$11();
        Seq<String> x$13 = Metadata$.MODULE$.apply$default$12();
        long x$14 = Metadata$.MODULE$.apply$default$13();
        String x$15 = Metadata$.MODULE$.apply$default$14();
        Option<String> x$16 = Metadata$.MODULE$.apply$default$15();
        long x$17 = Metadata$.MODULE$.apply$default$16();
        String x$18 = Metadata$.MODULE$.apply$default$17();
        String x$19 = Metadata$.MODULE$.apply$default$18();
        String x$20 = Metadata$.MODULE$.apply$default$19();
        String x$21 = Metadata$.MODULE$.apply$default$20();
        Option<String> x$22 = Metadata$.MODULE$.apply$default$21();
        long x$23 = Metadata$.MODULE$.apply$default$22();
        int x$24 = Metadata$.MODULE$.apply$default$23();
        this.sessionManager().updateMetadata(new Metadata(x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$2));
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)killed2), (Object)message2);
    }

    public BatchesResource() {
        ApiRequestContext.$init$(this);
        Logging.$init$((Logging)this);
        this.internalRestClients = new ConcurrentHashMap();
    }
}

