/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark;

import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.kyuubi.KerberizedTestHelper;
import org.apache.kyuubi.KyuubiException;
import org.apache.kyuubi.KyuubiFunSuite;
import org.apache.kyuubi.KyuubiFunSuite$LogAppender$;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.ThreadAudit;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ProcBuilder$;
import org.apache.kyuubi.engine.spark.FakeSparkProcessBuilder;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.AuthTypes$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.service.ServiceUtils$;
import org.apache.kyuubi.util.AssertionUtils$;
import org.apache.kyuubi.util.command.CommandLineUtils$;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.mockito.MockSettings;
import org.mockito.stubbing.Answer;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Outcome;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestSuite;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.enablers.Retrying$;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import org.scalatestplus.mockito.MockitoSugar;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001A2Aa\u0001\u0003\u0001\u001f!)A\u0005\u0001C\u0001K!)\u0001\u0006\u0001C\u0005S\tA2\u000b]1sWB\u0013xnY3tg\n+\u0018\u000e\u001c3feN+\u0018\u000e^3\u000b\u0005\u00151\u0011!B:qCJ\\'BA\u0004\t\u0003\u0019)gnZ5oK*\u0011\u0011BC\u0001\u0007Wf,XOY5\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001\u0003\u0007\u000f\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012\u0001\u00034v]N,\u0018\u000e^3\u000b\u0005Ua\u0011!C:dC2\fG/Z:u\u0013\t9\"CA\u0006B]f4UO\\*vSR,\u0007CA\r\u001b\u001b\u0005A\u0011BA\u000e\t\u0005QYUM\u001d2fe&TX\r\u001a+fgRDU\r\u001c9feB\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\b[>\u001c7.\u001b;p\u0015\t\tC\"A\u0007tG\u0006d\u0017\r^3tiBdWo]\u0005\u0003Gy\u0011A\"T8dW&$xnU;hCJ\fa\u0001P5oSRtD#\u0001\u0014\u0011\u0005\u001d\u0002Q\"\u0001\u0003\u0002\t\r|gNZ\u000b\u0002UA\u00111FL\u0007\u0002Y)\u0011Q\u0006C\u0001\u0007G>tg-[4\n\u0005=b#AC&zkV\u0014\u0017nQ8oM\u0002")
public class SparkProcessBuilderSuite
extends AnyFunSuite
implements KerberizedTestHelper,
MockitoSugar {
    private final String clientPrincipalUser;
    private final File baseDir;
    private final Properties kdcConf;
    private final String hostName;
    private MiniKdc org$apache$kyuubi$KerberizedTestHelper$$kdc;
    private String krb5ConfPath;
    private final File org$apache$kyuubi$KerberizedTestHelper$$keytabFile;
    private final String testKeytab;
    private String testPrincipal;
    private String testSpnegoPrincipal;
    private volatile KyuubiFunSuite$LogAppender$ LogAppender$module;
    private Set<String> org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public <T> T mock(ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, classTag);
    }

    public <T> T mock(Answer<?> defaultAnswer, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, defaultAnswer, classTag);
    }

    public <T> T mock(MockSettings mockSettings, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (MockSettings)mockSettings, classTag);
    }

    public <T> T mock(String name, ClassTag<T> classTag) {
        return (T)MockitoSugar.mock$((MockitoSugar)this, (String)name, classTag);
    }

    public /* synthetic */ void org$apache$kyuubi$KerberizedTestHelper$$super$beforeAll() {
        KyuubiFunSuite.beforeAll$((KyuubiFunSuite)this);
    }

    public /* synthetic */ void org$apache$kyuubi$KerberizedTestHelper$$super$afterAll() {
        KyuubiFunSuite.afterAll$((KyuubiFunSuite)this);
    }

    public void beforeAll() {
        KerberizedTestHelper.beforeAll$((KerberizedTestHelper)this);
    }

    public void afterAll() {
        KerberizedTestHelper.afterAll$((KerberizedTestHelper)this);
    }

    public void tryWithSecurityEnabled(Function0<BoxedUnit> block) {
        KerberizedTestHelper.tryWithSecurityEnabled$((KerberizedTestHelper)this, block);
    }

    public String generateToken(String server) {
        return KerberizedTestHelper.generateToken$((KerberizedTestHelper)this, (String)server);
    }

    public /* synthetic */ void org$apache$kyuubi$KyuubiFunSuite$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public /* synthetic */ void org$apache$kyuubi$KyuubiFunSuite$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    public final Outcome withFixture(TestSuite.NoArgTest test) {
        return KyuubiFunSuite.withFixture$((KyuubiFunSuite)this, (TestSuite.NoArgTest)test);
    }

    public final void withLogAppender(AbstractAppender appender, Seq<String> loggerNames, Option<Level> level, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withLogAppender$((KyuubiFunSuite)this, (AbstractAppender)appender, loggerNames, level, f);
    }

    public final Seq<String> withLogAppender$default$2() {
        return KyuubiFunSuite.withLogAppender$default$2$((KyuubiFunSuite)this);
    }

    public final Option<Level> withLogAppender$default$3() {
        return KyuubiFunSuite.withLogAppender$default$3$((KyuubiFunSuite)this);
    }

    public final void withSystemProperty(Map<String, String> properties, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withSystemProperty$((KyuubiFunSuite)this, properties, f);
    }

    public final void withSystemProperty(String key, String value, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withSystemProperty$((KyuubiFunSuite)this, (String)key, (String)value, f);
    }

    public final void setSystemProperty(String key, String value) {
        KyuubiFunSuite.setSystemProperty$((KyuubiFunSuite)this, (String)key, (String)value);
    }

    public void doThreadPreAudit() {
        ThreadAudit.doThreadPreAudit$((ThreadAudit)this);
    }

    public void doThreadPostAudit() {
        ThreadAudit.doThreadPostAudit$((ThreadAudit)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public String clientPrincipalUser() {
        return this.clientPrincipalUser;
    }

    public File baseDir() {
        return this.baseDir;
    }

    public Properties kdcConf() {
        return this.kdcConf;
    }

    public String hostName() {
        return this.hostName;
    }

    public MiniKdc org$apache$kyuubi$KerberizedTestHelper$$kdc() {
        return this.org$apache$kyuubi$KerberizedTestHelper$$kdc;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$$kdc_$eq(MiniKdc x$1) {
        this.org$apache$kyuubi$KerberizedTestHelper$$kdc = x$1;
    }

    public String krb5ConfPath() {
        return this.krb5ConfPath;
    }

    public void krb5ConfPath_$eq(String x$1) {
        this.krb5ConfPath = x$1;
    }

    public File org$apache$kyuubi$KerberizedTestHelper$$keytabFile() {
        return this.org$apache$kyuubi$KerberizedTestHelper$$keytabFile;
    }

    public String testKeytab() {
        return this.testKeytab;
    }

    public String testPrincipal() {
        return this.testPrincipal;
    }

    public void testPrincipal_$eq(String x$1) {
        this.testPrincipal = x$1;
    }

    public String testSpnegoPrincipal() {
        return this.testSpnegoPrincipal;
    }

    public void testSpnegoPrincipal_$eq(String x$1) {
        this.testSpnegoPrincipal = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$clientPrincipalUser_$eq(String x$1) {
        this.clientPrincipalUser = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$baseDir_$eq(File x$1) {
        this.baseDir = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$kdcConf_$eq(Properties x$1) {
        this.kdcConf = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$hostName_$eq(String x$1) {
        this.hostName = x$1;
    }

    public final void org$apache$kyuubi$KerberizedTestHelper$_setter_$org$apache$kyuubi$KerberizedTestHelper$$keytabFile_$eq(File x$1) {
        this.org$apache$kyuubi$KerberizedTestHelper$$keytabFile = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$testKeytab_$eq(String x$1) {
        this.testKeytab = x$1;
    }

    public KyuubiFunSuite$LogAppender$ LogAppender() {
        if (this.LogAppender$module == null) {
            this.LogAppender$lzycompute$1();
        }
        return this.LogAppender$module;
    }

    public Set<String> org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot() {
        return this.org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot;
    }

    public void org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot_$eq(Set<String> x$1) {
        this.org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot = x$1;
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private KyuubiConf conf() {
        return new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1()).set("kyuubi.on", "off");
    }

    private final void LogAppender$lzycompute$1() {
        SparkProcessBuilderSuite sparkProcessBuilderSuite = this;
        synchronized (sparkProcessBuilderSuite) {
            if (this.LogAppender$module == null) {
                this.LogAppender$module = new KyuubiFunSuite$LogAppender$((KyuubiFunSuite)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        SparkProcessBuilderSuite sparkProcessBuilderSuite = this;
        synchronized (sparkProcessBuilderSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    private static final void atomicTest$1() {
        ExecutorService pool = Executors.newFixedThreadPool(3);
        Path fakeWorkDir = Utils$.MODULE$.createTempDir("fake", Utils$.MODULE$.createTempDir$default$2());
        File dir = fakeWorkDir.toFile();
        try {
            String[] $org_scalatest_assert_macro_left = dir.list();
            int $org_scalatest_assert_macro_right = 0;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
            File longTimeFile = new File(dir, "kyuubi-spark-sql-engine.log.1");
            longTimeFile.createNewFile();
            longTimeFile.setLastModified(System.currentTimeMillis() - 3600000L);
            File shortTimeFile = new File(dir, "kyuubi-spark-sql-engine.log.0");
            shortTimeFile.createNewFile();
            KyuubiConf config = new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1()).set(KyuubiConf$.MODULE$.ENGINE_LOG_TIMEOUT(), (Object)BoxesRunTime.boxToLong((long)20000L));
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> pool.execute(() -> {
                FakeSparkProcessBuilder pb = new FakeSparkProcessBuilder(null, config, fakeWorkDir){
                    private final Path workingDir;

                    public Path workingDir() {
                        return this.workingDir;
                    }
                    {
                        this.workingDir = fakeWorkDir$1;
                    }
                };
                try {
                    Process p = pb.start();
                    p.waitFor();
                }
                finally {
                    pb.close(true);
                }
            }));
            pool.shutdown();
            while (!pool.isTerminated()) {
                Thread.sleep(100L);
            }
            File[] $org_scalatest_assert_macro_left2 = dir.listFiles();
            int $org_scalatest_assert_macro_right2 = 11;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2.length), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        }
        finally {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dir.listFiles())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.delete()));
            dir.delete();
        }
    }

    public static final /* synthetic */ void $anonfun$new$34(String sparkHome) {
        AssertionUtils$.MODULE$.assertMatches(sparkHome, SparkProcessBuilder$.MODULE$.SPARK_HOME_REGEX_SCALA_212(), Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 414));
        AssertionUtils$.MODULE$.assertNotMatches(sparkHome, SparkProcessBuilder$.MODULE$.SPARK_HOME_REGEX_SCALA_213(), Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 415));
    }

    public static final /* synthetic */ void $anonfun$new$35(String sparkHome) {
        AssertionUtils$.MODULE$.assertMatches(sparkHome, SparkProcessBuilder$.MODULE$.SPARK_HOME_REGEX_SCALA_213(), Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 422));
        AssertionUtils$.MODULE$.assertNotMatches(sparkHome, SparkProcessBuilder$.MODULE$.SPARK_HOME_REGEX_SCALA_212(), Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 423));
    }

    public SparkProcessBuilderSuite() {
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        Logging.$init$((Logging)this);
        ThreadAudit.$init$((ThreadAudit)this);
        KyuubiFunSuite.$init$((KyuubiFunSuite)this);
        KerberizedTestHelper.$init$((KerberizedTestHelper)this);
        MockitoSugar.$init$((MockitoSugar)this);
        this.test("spark process builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkProcessBuilder builder = new SparkProcessBuilder("kentyao", this.conf());
            String[] commands = new StringOps(Predef$.MODULE$.augmentString(builder.toString())).split(' ');
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(commands[2]);
            String $org_scalatest_assert_macro_right = "org.apache.kyuubi.engine.spark.SparkSQLEngine";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 46));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])commands);
            String $org_scalatest_assert_macro_right2 = "spark.kyuubi.on=off";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 47));
            builder.toString().contains("\\\n\t--class");
            builder.toString().contains("\\\n\t--conf spark.kyuubi.on=off");
            ProcessBuilder pb = new ProcessBuilder((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commands)).head(), "--help");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(BoxesRunTime.boxToInteger((int)pb.start().waitFor()));
            int $org_scalatest_assert_macro_right3 = 0;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right3), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 51));
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.simpleMacroBool(Files.exists(Paths.get((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])commands)).last(), new String[0]), new LinkOption[0]), "java.nio.file.Files.exists(java.nio.file.Paths.get(scala.Predef.refArrayOps[String](commands).last))", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
            Process process = builder.start();
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.simpleMacroBool(process.isAlive(), "process.isAlive()", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
            return process.destroyForcibly();
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 43));
        this.test("capture error from spark process builder", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkProcessBuilder processBuilder = new SparkProcessBuilder("kentyao", this.conf().set("spark.ui.port", "abc"));
            processBuilder.start();
            this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(90).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(500).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Throwable error = processBuilder.getError();
                String $org_scalatest_assert_macro_left = error.getMessage();
                String $org_scalatest_assert_macro_right = "java.lang.IllegalArgumentException: spark.ui.port should be int, but was abc";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
                Throwable $org_scalatest_assert_macro_left2 = error;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.isInstanceOfMacroBool((Object)$org_scalatest_assert_macro_left2, "isInstanceOf", "org.apache.kyuubi.KyuubiSQLException", $org_scalatest_assert_macro_left2 instanceof KyuubiSQLException, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 66));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
            SparkProcessBuilder processBuilder1 = new SparkProcessBuilder("kentyao", this.conf().set("spark.hive.metastore.uris", "thrift://dummy"));
            processBuilder1.start();
            return (Assertion)this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(90).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(500).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Throwable error1 = processBuilder1.getError();
                String $org_scalatest_assert_macro_left = error1.getMessage();
                String $org_scalatest_assert_macro_right = "org.apache.hadoop.hive.ql.metadata.HiveException:";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 75));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("engine log truncation", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkProcessBuilder pb = new SparkProcessBuilder("kentyao", this.conf().set("spark.hive.metastore.uris", "thrift://dummy"));
            pb.start();
            this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(90).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(500).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Throwable error1 = pb.getError();
                String $org_scalatest_assert_macro_left = error1.getMessage();
                String $org_scalatest_assert_macro_right = "Failed to detect the root cause";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
                String $org_scalatest_assert_macro_left2 = error1.getMessage();
                String $org_scalatest_assert_macro_right2 = "See more: ";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 87));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 84));
            SparkProcessBuilder pb2 = new SparkProcessBuilder("kentyao", this.conf().set("spark.hive.metastore.uris", "thrift://dummy").set(KyuubiConf$.MODULE$.ENGINE_ERROR_MAX_SIZE(), (Object)BoxesRunTime.boxToInteger((int)200)));
            pb2.start();
            this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(90).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(500).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Throwable error1 = pb2.getError();
                String $org_scalatest_assert_macro_left = error1.getMessage();
                String $org_scalatest_assert_macro_right = "Failed to detect the root cause";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 97));
                String $org_scalatest_assert_macro_left2 = error1.getMessage();
                String $org_scalatest_assert_macro_right2 = "See more: ";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 98));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 95));
            SparkProcessBuilder pb3 = new SparkProcessBuilder("kentyao", this.conf().set("spark.kerberos.principal", this.testPrincipal()));
            pb3.start();
            return (Assertion)this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(90).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(500).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Throwable error1 = pb3.getError();
                String $org_scalatest_assert_macro_left = error1.getMessage();
                String $org_scalatest_assert_macro_right = "Failed to detect the root cause";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 106));
                String $org_scalatest_assert_macro_left2 = error1.getMessage();
                String $org_scalatest_assert_macro_right2 = "See more: ";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 107));
                String $org_scalatest_assert_macro_left3 = error1.getMessage();
                String $org_scalatest_assert_macro_right3 = "Only one of --proxy-user or --principal can be provided";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 108));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 104));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("proxy user or keytab", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkProcessBuilder b1 = new SparkProcessBuilder("kentyao", this.conf());
            String $org_scalatest_assert_macro_left = b1.toString();
            String $org_scalatest_assert_macro_right = "--proxy-user kentyao";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            KyuubiConf conf1 = this.conf().set("spark.kerberos.principal", this.testPrincipal());
            SparkProcessBuilder b2 = new SparkProcessBuilder("kentyao", conf1);
            String $org_scalatest_assert_macro_left2 = b2.toString();
            String $org_scalatest_assert_macro_right2 = "--proxy-user kentyao";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 118));
            KyuubiConf conf2 = this.conf().set("spark.kerberos.keytab", this.testKeytab());
            SparkProcessBuilder b3 = new SparkProcessBuilder("kentyao", conf2);
            String $org_scalatest_assert_macro_left3 = b3.toString();
            String $org_scalatest_assert_macro_right3 = "--proxy-user kentyao";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 122));
            this.tryWithSecurityEnabled((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                KyuubiConf conf3 = this.conf().set("spark.kerberos.principal", this.testPrincipal()).set("spark.kerberos.keytab", "testKeytab");
                SparkProcessBuilder b4 = new SparkProcessBuilder(Utils$.MODULE$.currentUser(), conf3);
                String $org_scalatest_assert_macro_left = b4.toString();
                String $org_scalatest_assert_macro_right = new StringBuilder(13).append("--proxy-user ").append(Utils$.MODULE$.currentUser()).toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
                KyuubiConf conf4 = this.conf().set("spark.kerberos.principal", this.testPrincipal()).set("spark.kerberos.keytab", this.testKeytab());
                SparkProcessBuilder b5 = new SparkProcessBuilder("kentyao", conf4);
                String $org_scalatest_assert_macro_left2 = b5.toString();
                String $org_scalatest_assert_macro_right2 = "--proxy-user kentyao";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 133));
                SparkProcessBuilder b6 = new SparkProcessBuilder(ServiceUtils$.MODULE$.getShortName(this.testPrincipal()), conf4);
                String $org_scalatest_assert_macro_left3 = b6.toString();
                String $org_scalatest_assert_macro_right3 = "--proxy-user kentyao";
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            });
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 112));
        this.test("log capture should release after close", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            FakeSparkProcessBuilder process = new FakeSparkProcessBuilder(new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1()));
            try {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(process.logCaptureThreadReleased(), "process.logCaptureThreadReleased", Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 143));
                Process subProcess = process.start();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(process.logCaptureThreadReleased(), "process.logCaptureThreadReleased", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
                subProcess.waitFor(3L, TimeUnit.SECONDS);
            }
            finally {
                process.close(true);
            }
            return (Assertion)this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(3).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(100).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(process.logCaptureThreadReleased(), "process.logCaptureThreadReleased", Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("sub process log should be overwritten", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 10).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> SparkProcessBuilderSuite.atomicTest$1()), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
        this.test("overwrite log file should cleanup before write", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Path fakeWorkDir = Utils$.MODULE$.createTempDir("fake", Utils$.MODULE$.createTempDir$default$2());
            KyuubiConf conf = new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1());
            conf.set(KyuubiConf$.MODULE$.ENGINE_LOG_TIMEOUT(), (Object)BoxesRunTime.boxToLong((long)Duration.ofDays(1L).toMillis()));
            FakeSparkProcessBuilder builder1 = new FakeSparkProcessBuilder(null, conf, fakeWorkDir){
                private final Path workingDir;

                public Path workingDir() {
                    return this.workingDir;
                }
                {
                    this.workingDir = fakeWorkDir$2;
                }
            };
            File file1 = builder1.engineLog();
            Files.write(file1.toPath(), "a".getBytes(), StandardOpenOption.APPEND);
            File $org_scalatest_assert_macro_left = file1;
            int $org_scalatest_assert_macro_right = 1;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left, "length", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 210));
            Files.write(file1.toPath(), "a".getBytes(), StandardOpenOption.APPEND);
            File $org_scalatest_assert_macro_left2 = file1;
            int $org_scalatest_assert_macro_right2 = 2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left2, "length", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
            file1.setLastModified(System.currentTimeMillis() - Duration.ofDays(1L).toMillis() - 1000L);
            FakeSparkProcessBuilder builder2 = new FakeSparkProcessBuilder(null, conf, fakeWorkDir){
                private final Path workingDir;

                public Path workingDir() {
                    return this.workingDir;
                }
                {
                    this.workingDir = fakeWorkDir$2;
                }
            };
            File file2 = builder2.engineLog();
            String $org_scalatest_assert_macro_left3 = file1.getAbsolutePath();
            String $org_scalatest_assert_macro_right3 = file2.getAbsolutePath();
            String string = $org_scalatest_assert_macro_left3;
            String string2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 219));
            Files.write(file2.toPath(), "a".getBytes(), StandardOpenOption.APPEND);
            File $org_scalatest_assert_macro_left4 = file2;
            int $org_scalatest_assert_macro_right4 = 1;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.lengthSizeMacroBool((Object)$org_scalatest_assert_macro_left4, "length", (Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left4.length()), (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("main resource jar should not check when is not a local file", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Path workDir = Utils$.MODULE$.createTempDir("resource", Utils$.MODULE$.createTempDir$default$2());
            Path jarPath = Paths.get(((Object)workDir).toString(), "test.jar");
            String hdfsPath = new StringBuilder(7).append("hdfs://").append(jarPath).toString();
            KyuubiConf conf = new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1());
            conf.set(KyuubiConf$.MODULE$.ENGINE_SPARK_MAIN_RESOURCE(), (Object)hdfsPath);
            SparkProcessBuilder b1 = new SparkProcessBuilder("test", conf);
            String $org_scalatest_assert_macro_left = (String)b1.mainResource().get();
            String $org_scalatest_assert_macro_right = "hdfs://";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "startsWith", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.startsWith($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 232));
            String $org_scalatest_assert_macro_left2 = (String)b1.mainResource().get();
            String $org_scalatest_assert_macro_right2 = hdfsPath;
            String string = $org_scalatest_assert_macro_left2;
            String string2 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(string != null ? !string.equals(string2) : string2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 233));
            conf.set(KyuubiConf$.MODULE$.ENGINE_SPARK_MAIN_RESOURCE(), (Object)((Object)jarPath).toString());
            SparkProcessBuilder b2 = new SparkProcessBuilder("test", conf);
            String $org_scalatest_assert_macro_left3 = (String)b2.mainResource().getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            String $org_scalatest_assert_macro_right3 = ((Object)jarPath).toString();
            String string3 = $org_scalatest_assert_macro_left3;
            String string4 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "!=", (Object)$org_scalatest_assert_macro_right3, string3 == null ? string4 != null : !string3.equals(string4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("add spark prefix for conf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiConf conf = new KyuubiConf(false);
            conf.set("kyuubi.kent", "yao");
            conf.set("spark.vino", "yang");
            conf.set("kent", "yao");
            conf.set("hadoop.kent", "yao");
            SparkProcessBuilder builder = new SparkProcessBuilder("", conf);
            String[] commands = new StringOps(Predef$.MODULE$.augmentString(builder.toString())).split(' ');
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])commands);
            String $org_scalatest_assert_macro_right = "spark.kyuubi.kent=yao";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 249));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])commands);
            String $org_scalatest_assert_macro_right2 = "spark.vino=yang";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])commands);
            String $org_scalatest_assert_macro_right3 = "spark.kent=yao";
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "contains", (Object)$org_scalatest_assert_macro_right3, new ArrayOps.ofRef($org_scalatest_assert_macro_left3).contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 251));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])commands);
            String $org_scalatest_assert_macro_right4 = "spark.hadoop.hadoop.kent=yao";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "contains", (Object)$org_scalatest_assert_macro_right4, new ArrayOps.ofRef($org_scalatest_assert_macro_left4).contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 241));
        this.test("zookeeper kerberos authentication", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiConf conf = new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1());
            conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_AUTH_TYPE().key(), AuthTypes$.MODULE$.KERBEROS().toString());
            conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_KEYTAB().key(), this.testKeytab());
            conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_PRINCIPAL().key(), this.testPrincipal());
            SparkProcessBuilder b1 = new SparkProcessBuilder("test", conf);
            String $org_scalatest_assert_macro_left = b1.toString();
            String $org_scalatest_assert_macro_right = new StringBuilder(19).append("--conf spark.files=").append(this.testKeytab()).toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 262));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 255));
        this.test("SparkProcessBuilder commands immutable", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiConf conf = new KyuubiConf(false);
            String engineRefId = UUID.randomUUID().toString();
            SparkProcessBuilder pb = new SparkProcessBuilder("", conf, engineRefId, SparkProcessBuilder$.MODULE$.$lessinit$greater$default$4());
            String $org_scalatest_assert_macro_left = pb.toString();
            String $org_scalatest_assert_macro_right = engineRefId;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
            String engineRefId2 = UUID.randomUUID().toString();
            conf.set("spark.yarn.tags", engineRefId2);
            String $org_scalatest_assert_macro_left2 = pb.toString();
            String $org_scalatest_assert_macro_right2 = engineRefId2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 272));
            String $org_scalatest_assert_macro_left3 = pb.toString();
            String $org_scalatest_assert_macro_right3 = engineRefId;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 265));
        this.test("SparkProcessBuilder build spark engine with SPARK_USER_NAME", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String proxyName = "kyuubi";
            KyuubiConf conf1 = new KyuubiConf(false).set("spark.master", "k8s://test:12345");
            SparkProcessBuilder b1 = new SparkProcessBuilder(proxyName, conf1);
            String[] c1 = new StringOps(Predef$.MODULE$.augmentString(b1.toString())).split(' ');
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])c1);
            String $org_scalatest_assert_macro_right = new StringBuilder(43).append("spark.kubernetes.driverEnv.SPARK_USER_NAME=").append(proxyName).toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])c1);
            String $org_scalatest_assert_macro_right2 = new StringBuilder(34).append("spark.executorEnv.SPARK_USER_NAME=").append(proxyName).toString();
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 282));
            this.tryWithSecurityEnabled((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                KyuubiConf conf2 = this.conf().set("spark.master", "k8s://test:12345").set("spark.kerberos.principal", this.testPrincipal()).set("spark.kerberos.keytab", this.testKeytab());
                String name = ServiceUtils$.MODULE$.getShortName(this.testPrincipal());
                SparkProcessBuilder b2 = new SparkProcessBuilder(name, conf2);
                String[] c2 = new StringOps(Predef$.MODULE$.augmentString(b2.toString())).split(' ');
                Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])c2);
                String $org_scalatest_assert_macro_right = new StringBuilder(43).append("spark.kubernetes.driverEnv.SPARK_USER_NAME=").append(name).toString();
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
                Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])c2);
                String $org_scalatest_assert_macro_right2 = new StringBuilder(34).append("spark.executorEnv.SPARK_USER_NAME=").append(name).toString();
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 292));
                Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])c2);
                String $org_scalatest_assert_macro_right3 = new StringBuilder(13).append("--proxy-user ").append(name).toString();
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "contains", (Object)$org_scalatest_assert_macro_right3, new ArrayOps.ofRef($org_scalatest_assert_macro_left3).contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 293));
            });
            KyuubiConf conf3 = new KyuubiConf(false);
            SparkProcessBuilder b3 = new SparkProcessBuilder(proxyName, conf3);
            String[] c3 = new StringOps(Predef$.MODULE$.augmentString(b3.toString())).split(' ');
            Object[] $org_scalatest_assert_macro_left3 = Predef$.MODULE$.refArrayOps((Object[])c3);
            String $org_scalatest_assert_macro_right3 = new StringBuilder(43).append("spark.kubernetes.driverEnv.SPARK_USER_NAME=").append(proxyName).toString();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left3), "contains", (Object)$org_scalatest_assert_macro_right3, new ArrayOps.ofRef($org_scalatest_assert_macro_left3).contains((Object)$org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 300));
            Object[] $org_scalatest_assert_macro_left4 = Predef$.MODULE$.refArrayOps((Object[])c3);
            String $org_scalatest_assert_macro_right4 = new StringBuilder(34).append("spark.executorEnv.SPARK_USER_NAME=").append(proxyName).toString();
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left4), "contains", (Object)$org_scalatest_assert_macro_right4, new ArrayOps.ofRef($org_scalatest_assert_macro_left4).contains((Object)$org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 301));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 276));
        this.test("[KYUUBI #5009] Test pass spark engine log path to spark conf", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            SparkProcessBuilder b1 = new SparkProcessBuilder("kyuubi", this.conf());
            String $org_scalatest_assert_macro_left = b1.toString();
            String $org_scalatest_assert_macro_right = new StringBuilder(8).append(CommandLineUtils$.MODULE$.CONF()).append(" spark.").append(ProcBuilder$.MODULE$.KYUUBI_ENGINE_LOG_PATH_KEY()).append("=").append(b1.engineLog().getAbsolutePath()).toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 306));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 304));
        this.test("[KYUUBI #5165] Test SparkProcessBuilder#appendDriverPodPrefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String engineRefId = "kyuubi-test-engine";
            String appName = "test-app";
            SparkProcessBuilder processBuilder = new SparkProcessBuilder("kyuubi", this.conf().set("spark.master", "k8s://internal").set("spark.submit.deployMode", "cluster"), engineRefId, SparkProcessBuilder$.MODULE$.$lessinit$greater$default$4());
            Map conf1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.name"), (Object)"test-app")}));
            Option driverPodName1 = processBuilder.appendPodNameConf(conf1).get((Object)"spark.kubernetes.driver.pod.name");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(driverPodName1);
            Some $org_scalatest_assert_macro_right = new Some((Object)new StringBuilder(15).append("kyuubi-").append(appName).append("-").append(engineRefId).append("-driver").toString());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 320));
            Map conf2 = conf1.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.kubernetes.driver.pod.name"), (Object)"kyuubi-test-1-driver")})));
            Option driverPodName2 = processBuilder.appendPodNameConf(conf2).get((Object)"spark.kubernetes.driver.pod.name");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(driverPodName2);
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 324));
            String longAppName = "thisisalonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglongappname";
            Map conf3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.name"), (Object)longAppName)}));
            Option driverPodName3 = processBuilder.appendPodNameConf(conf3).get((Object)"spark.kubernetes.driver.pod.name");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(driverPodName3);
            Some $org_scalatest_assert_macro_right3 = new Some((Object)new StringBuilder(14).append("kyuubi-").append(engineRefId).append("-driver").toString());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 333));
            String chineseAppName = "\u4f60\u597d_test_\u4efb\u52a1";
            Map conf4 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.name"), (Object)chineseAppName)}));
            Option driverPodName4 = processBuilder.appendPodNameConf(conf4).get((Object)"spark.kubernetes.driver.pod.name");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(driverPodName4);
            Some $org_scalatest_assert_macro_right4 = new Some((Object)new StringBuilder(19).append("kyuubi-test-").append(engineRefId).append("-driver").toString());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 339));
            SparkProcessBuilder newProcessBuilder = new SparkProcessBuilder("kyuubi", this.conf().set("spark.master", "k8s://internal").set("spark.submit.deployMode", "cluster").set(KyuubiConf$.MODULE$.KUBERNETES_FORCIBLY_REWRITE_DRIVER_POD_NAME(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), engineRefId, SparkProcessBuilder$.MODULE$.$lessinit$greater$default$4());
            Map conf5 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.name"), (Object)"test-forcibly-rewrite-app")}));
            Option driverPodName5 = newProcessBuilder.appendPodNameConf(conf5).get((Object)"spark.kubernetes.driver.pod.name");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left5 = this.convertToEqualizer(driverPodName5);
            Some $org_scalatest_assert_macro_right5 = new Some((Object)new StringBuilder(14).append("kyuubi-").append(engineRefId).append("-driver").toString());
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "===", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.$eq$eq$eq((Object)$org_scalatest_assert_macro_right5, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 348));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 311));
        this.test("[KYUUBI #5165] Test SparkProcessBuilder#appendExecutorPodPrefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String engineRefId = "kyuubi-test-engine";
            String appName = "test-app";
            SparkProcessBuilder processBuilder = new SparkProcessBuilder("kyuubi", this.conf().set("spark.master", "k8s://internal").set("spark.submit.deployMode", "cluster"), engineRefId, SparkProcessBuilder$.MODULE$.$lessinit$greater$default$4());
            Map conf1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.name"), (Object)"test-app")}));
            Option execPodNamePrefix1 = processBuilder.appendPodNameConf(conf1).get((Object)"spark.kubernetes.executor.podNamePrefix");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left = this.convertToEqualizer(execPodNamePrefix1);
            Some $org_scalatest_assert_macro_right = new Some((Object)new StringBuilder(8).append("kyuubi-").append(appName).append("-").append(engineRefId).toString());
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "===", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.$eq$eq$eq((Object)$org_scalatest_assert_macro_right, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 361));
            Map conf2 = conf1.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.kubernetes.executor.podNamePrefix"), (Object)"kyuubi-test")})));
            Option execPodNamePrefix2 = processBuilder.appendPodNameConf(conf2).get((Object)"spark.kubernetes.executor.podNamePrefix");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(execPodNamePrefix2);
            None$ $org_scalatest_assert_macro_right2 = None$.MODULE$;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)$org_scalatest_assert_macro_right2, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 365));
            String longAppName = "thisisalonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglonglongappname";
            Map conf3 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.name"), (Object)longAppName)}));
            Option execPodNamePrefix3 = processBuilder.appendPodNameConf(conf3).get((Object)"spark.kubernetes.executor.podNamePrefix");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left3 = this.convertToEqualizer(execPodNamePrefix3);
            Some $org_scalatest_assert_macro_right3 = new Some((Object)new StringBuilder(7).append("kyuubi-").append(engineRefId).toString());
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "===", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.$eq$eq$eq((Object)$org_scalatest_assert_macro_right3, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
            SparkProcessBuilder newProcessBuilder = new SparkProcessBuilder("kyuubi", this.conf().set("spark.master", "k8s://internal").set("spark.submit.deployMode", "cluster").set(KyuubiConf$.MODULE$.KUBERNETES_FORCIBLY_REWRITE_EXEC_POD_NAME_PREFIX(), (Object)BoxesRunTime.boxToBoolean((boolean)true)), engineRefId, SparkProcessBuilder$.MODULE$.$lessinit$greater$default$4());
            Map conf5 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"spark.app.name"), (Object)"test-forcibly-rewrite-app")}));
            Option execPodNamePrefix4 = newProcessBuilder.appendPodNameConf(conf5).get((Object)"spark.kubernetes.executor.podNamePrefix");
            TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left4 = this.convertToEqualizer(execPodNamePrefix4);
            Some $org_scalatest_assert_macro_right4 = new Some((Object)new StringBuilder(7).append("kyuubi-").append(engineRefId).toString());
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "===", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.$eq$eq$eq((Object)$org_scalatest_assert_macro_right4, Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 351));
        this.test("extract spark core scala version", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SparkProcessBuilder builder = new SparkProcessBuilder("kentyao", new KyuubiConf(false));
            ((IterableLike)new .colon.colon((Object)"spark-core_2.13-3.4.1.jar", (List)new .colon.colon((Object)"spark-core_2.13-3.5.0-abc-20230921.jar", (List)new .colon.colon((Object)"spark-core_2.13-3.5.0-xyz-1.2.3.jar", (List)new .colon.colon((Object)"spark-core_2.13-3.5.0.1.jar", (List)new .colon.colon((Object)"spark-core_2.13.2-3.5.0.jar", (List)Nil$.MODULE$)))))).foreach((Function1 & Serializable & scala.Serializable)f -> this.assertResult("2.13", builder.extractSparkCoreScalaVersion((Iterable)new .colon.colon(f, (List)Nil$.MODULE$)), Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 396)));
            ((IterableLike)new .colon.colon((Object)"spark-dummy_2.13-3.5.0.jar", (List)new .colon.colon((Object)"spark-core_2.13-3.5.0.1.zip", (List)new .colon.colon((Object)"yummy-spark-core_2.13-3.5.0.jar", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)f -> this.assertThrows((Function0 & Serializable & scala.Serializable)() -> builder.extractSparkCoreScalaVersion((Iterable)new .colon.colon(f, (List)Nil$.MODULE$)), ClassTag$.MODULE$.apply(KyuubiException.class), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 403)));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 388));
        this.test("match scala version of spark home", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String string = package$.MODULE$.SCALA_COMPILE_VERSION();
            if ("2.12".equals(string)) {
                ((IterableLike)new .colon.colon((Object)"spark-3.2.4-bin-hadoop3.2", (List)new .colon.colon((Object)"spark-3.2.4-bin-hadoop2.7", (List)new .colon.colon((Object)"spark-3.4.1-bin-hadoop3", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)sparkHome -> {
                    SparkProcessBuilderSuite.$anonfun$new$34(sparkHome);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            if ("2.13".equals(string)) {
                ((IterableLike)new .colon.colon((Object)"spark-3.2.4-bin-hadoop3.2-scala2.13", (List)new .colon.colon((Object)"spark-3.4.1-bin-hadoop3-scala2.13", (List)new .colon.colon((Object)"spark-3.5.0-bin-hadoop3-scala2.13", (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)sparkHome -> {
                    SparkProcessBuilderSuite.$anonfun$new$35(sparkHome);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)string);
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 407));
        this.test("default spark.yarn.maxAppAttempts conf in yarn mode", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiConf conf1 = new KyuubiConf(false);
            conf1.set("spark.master", "k8s://test:12345");
            SparkProcessBuilder builder1 = new SparkProcessBuilder("", conf1);
            String[] commands1 = new StringOps(Predef$.MODULE$.augmentString(builder1.toString())).split(' ');
            Object[] $org_scalatest_assert_macro_left = Predef$.MODULE$.refArrayOps((Object[])commands1);
            String $org_scalatest_assert_macro_right = "spark.yarn.maxAppAttempts";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left), "contains", (Object)$org_scalatest_assert_macro_right, new ArrayOps.ofRef($org_scalatest_assert_macro_left).contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 433));
            KyuubiConf conf2 = new KyuubiConf(false);
            conf2.set("spark.master", "yarn");
            SparkProcessBuilder builder2 = new SparkProcessBuilder("", conf2);
            String[] commands2 = new StringOps(Predef$.MODULE$.augmentString(builder2.toString())).split(' ');
            Object[] $org_scalatest_assert_macro_left2 = Predef$.MODULE$.refArrayOps((Object[])commands2);
            String $org_scalatest_assert_macro_right2 = "spark.yarn.maxAppAttempts=1";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)new ArrayOps.ofRef($org_scalatest_assert_macro_left2), "contains", (Object)$org_scalatest_assert_macro_right2, new ArrayOps.ofRef($org_scalatest_assert_macro_left2).contains((Object)$org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 439));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 428));
        this.test("spark conf should be converted with `spark.` prefix", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiConf kyuubiConf = new KyuubiConf(false);
            kyuubiConf.set("kyuubi.key", "value");
            SparkProcessBuilder builder = new SparkProcessBuilder("kyuubi", kyuubiConf, UUID.randomUUID().toString(), (Option)None$.MODULE$);
            Seq $org_scalatest_assert_macro_left = builder.commands().toSeq();
            String $org_scalatest_assert_macro_right = "spark.kyuubi.key=value";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains((Object)$org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 450));
        }, new Position("SparkProcessBuilderSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 442));
    }
}

