/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.InetAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.server.MiniDFSService$;
import org.apache.kyuubi.service.AbstractService;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005ua\u0001B\u000b\u0017\u0001}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tq\u0001\u0011\t\u0011)A\u0005s!)\u0011\t\u0001C\u0001\u0005\"9q\t\u0001b\u0001\n\u0013A\u0005BB)\u0001A\u0003%\u0011\nC\u0005S\u0001\u0001\u0007\t\u0019!C\u0005'\"I!\f\u0001a\u0001\u0002\u0004%Ia\u0017\u0005\nE\u0002\u0001\r\u0011!Q!\nQCQ!\u0011\u0001\u0005\u0002\rDQ!\u001a\u0001\u0005B\u0019DQA\u001c\u0001\u0005B=DQ\u0001\u001d\u0001\u0005B=DQ!\u001d\u0001\u0005\n=DQA\u001d\u0001\u0005\u0002MDQ\u0001\u001e\u0001\u0005\u0002UDQ!\u001f\u0001\u0005\u0002i<qa\u001f\f\u0002\u0002#\u0005APB\u0004\u0016-\u0005\u0005\t\u0012A?\t\r\u0005\u0013B\u0011AA\u0002\u0011%\t)AEI\u0001\n\u0003\t9A\u0001\bNS:LGIR*TKJ4\u0018nY3\u000b\u0005]A\u0012AB:feZ,'O\u0003\u0002\u001a5\u000511._;vE&T!a\u0007\u000f\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0012aA8sO\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\u00111\u0005G\u0001\bg\u0016\u0014h/[2f\u0013\t)#EA\bBEN$(/Y2u'\u0016\u0014h/[2f!\t9\u0003&D\u0001\u0019\u0013\tI\u0003DA\u0004M_\u001e<\u0017N\\4\u0002\t9\fW.\u001a\t\u0003YUr!!L\u001a\u0011\u00059\nT\"A\u0018\u000b\u0005Ar\u0012A\u0002\u001fs_>$hHC\u00013\u0003\u0015\u00198-\u00197b\u0013\t!\u0014'\u0001\u0004Qe\u0016$WMZ\u0005\u0003m]\u0012aa\u0015;sS:<'B\u0001\u001b2\u0003!AGMZ:D_:4\u0007C\u0001\u001e@\u001b\u0005Y$B\u0001\u001f>\u0003\u0011\u0019wN\u001c4\u000b\u0005yR\u0012A\u00025bI>|\u0007/\u0003\u0002Aw\ti1i\u001c8gS\u001e,(/\u0019;j_:\fa\u0001P5oSRtDcA\"F\rB\u0011A\tA\u0007\u0002-!)!f\u0001a\u0001W!)\u0001h\u0001a\u0001s\u0005i\u0001.\u00193p_B\u001cuN\u001c4ESJ,\u0012!\u0013\t\u0003\u0015>k\u0011a\u0013\u0006\u0003\u00196\u000b!![8\u000b\u00039\u000bAA[1wC&\u0011\u0001k\u0013\u0002\u0005\r&dW-\u0001\biC\u0012|w\u000e]\"p]\u001a$\u0015N\u001d\u0011\u0002\u0017!$gm]\"mkN$XM]\u000b\u0002)B\u0011Q\u000bW\u0007\u0002-*\u0011q+P\u0001\u0005Q\u001247/\u0003\u0002Z-\nqQ*\u001b8j\t\u001a\u001b6\t\\;ti\u0016\u0014\u0018a\u00045eMN\u001cE.^:uKJ|F%Z9\u0015\u0005q\u0003\u0007CA/_\u001b\u0005\t\u0014BA02\u0005\u0011)f.\u001b;\t\u000f\u0005<\u0011\u0011!a\u0001)\u0006\u0019\u0001\u0010J\u0019\u0002\u0019!$gm]\"mkN$XM\u001d\u0011\u0015\u0005\r#\u0007b\u0002\u001d\n!\u0003\u0005\r!O\u0001\u000bS:LG/[1mSj,GC\u0001/h\u0011\u0015a$\u00021\u0001i!\tIG.D\u0001k\u0015\tY\u0007$\u0001\u0004d_:4\u0017nZ\u0005\u0003[*\u0014!bS=vk\nL7i\u001c8g\u0003\u0015\u0019H/\u0019:u)\u0005a\u0016\u0001B:u_B\fab]1wK\"\u000bGm\\8q\u0007>tg-A\u0007hKRD\u0015\rZ8pa\u000e{gNZ\u000b\u0002s\u0005Qq-\u001a;E\rN\u0003vN\u001d;\u0016\u0003Y\u0004\"!X<\n\u0005a\f$aA%oi\u0006\u0001r-\u001a;IC\u0012|w\u000e]\"p]\u001a$\u0015N]\u000b\u0002W\u0005qQ*\u001b8j\t\u001a\u001b6+\u001a:wS\u000e,\u0007C\u0001#\u0013'\t\u0011b\u0010\u0005\u0002^\u007f&\u0019\u0011\u0011A\u0019\u0003\r\u0005s\u0017PU3g)\u0005a\u0018a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\n)\u001a\u0011(a\u0003,\u0005\u00055\u0001\u0003BA\b\u00033i!!!\u0005\u000b\t\u0005M\u0011QC\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u00062\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00037\t\tBA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class MiniDFSService
extends AbstractService {
    private final Configuration hdfsConf;
    private final File hadoopConfDir;
    private MiniDFSCluster hdfsCluster;

    public static Configuration $lessinit$greater$default$1() {
        return MiniDFSService$.MODULE$.$lessinit$greater$default$1();
    }

    private File hadoopConfDir() {
        return this.hadoopConfDir;
    }

    private MiniDFSCluster hdfsCluster() {
        return this.hdfsCluster;
    }

    private void hdfsCluster_$eq(MiniDFSCluster x$1) {
        this.hdfsCluster = x$1;
    }

    public void initialize(KyuubiConf conf) {
        this.hdfsConf.setIfUnset("dfs.namenode.rpc-bind-host", "localhost");
        String currentUser = UserGroupInformation.getCurrentUser().getShortUserName();
        this.hdfsConf.set(new StringBuilder(24).append("hadoop.proxyuser.").append(currentUser).append(".groups").toString(), "*");
        this.hdfsConf.set(new StringBuilder(23).append("hadoop.proxyuser.").append(currentUser).append(".hosts").toString(), "*");
        super.initialize(conf);
    }

    public void start() {
        this.hdfsCluster_$eq(new MiniDFSCluster.Builder(this.hdfsConf).checkDataNodeAddrConfig(true).checkDataNodeHostConfig(true).build());
        this.info((Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(37).append("NameNode address in configuration is ").append($this.hdfsConf.get("dfs.namenode.rpc-address")).toString());
        super.start();
        this.saveHadoopConf();
    }

    public void stop() {
        if (this.hdfsCluster() != null) {
            this.hdfsCluster().shutdown(true);
        }
        super.stop();
    }

    private void saveHadoopConf() {
        Configuration configToWrite = new Configuration(false);
        String hostName = InetAddress.getLocalHost().getHostName();
        ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(this.hdfsConf.iterator()).asScala()).foreach((Function1 & java.io.Serializable & Serializable)kv -> {
            String key = (String)kv.getKey();
            String value = ((String)kv.getValue()).replaceAll(hostName, "localhost");
            configToWrite.set(key, value);
            return this.getConf().set(key, value);
        });
        FileWriter writer = new FileWriter(new File(this.hadoopConfDir(), "hdfs-site.xml"));
        configToWrite.writeXml((Writer)writer);
        writer.close();
    }

    public Configuration getHadoopConf() {
        return this.hdfsConf;
    }

    public int getDFSPort() {
        return this.hdfsCluster().getNameNodePort();
    }

    public String getHadoopConfDir() {
        return this.hadoopConfDir().getAbsolutePath();
    }

    public MiniDFSService(String name, Configuration hdfsConf) {
        this.hdfsConf = hdfsConf;
        super(name);
        this.hadoopConfDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2()).toFile();
    }

    public MiniDFSService(Configuration hdfsConf) {
        this(MiniDFSService.class.getSimpleName(), hdfsConf);
    }
}

