/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.rest.client;

import com.unboundid.ldap.listener.InMemoryDirectoryServer;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.UUID;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.shaded.com.nimbusds.jose.util.StandardCharset;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.BatchTestHelper;
import org.apache.kyuubi.KerberizedTestHelper;
import org.apache.kyuubi.KyuubiFunSuite;
import org.apache.kyuubi.KyuubiFunSuite$LogAppender$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.RestClientTestHelper;
import org.apache.kyuubi.RestFrontendTestHelper;
import org.apache.kyuubi.ThreadAudit;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.WithKyuubiServer;
import org.apache.kyuubi.client.api.v1.dto.Batch;
import org.apache.kyuubi.client.api.v1.dto.BatchRequest;
import org.apache.kyuubi.client.util.BatchUtils;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ctl.CtlConf$;
import org.apache.kyuubi.ctl.TestPrematureExit;
import org.apache.kyuubi.ctl.util.CommandLineUtils;
import org.apache.kyuubi.engine.ApplicationManagerInfo;
import org.apache.kyuubi.engine.ApplicationManagerInfo$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.server.KyuubiServer;
import org.apache.kyuubi.server.metadata.api.MetadataFilter;
import org.apache.kyuubi.server.metadata.api.MetadataFilter$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.service.FrontendService;
import org.apache.kyuubi.service.authentication.WithLdapServer;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.zookeeper.EmbeddedZookeeper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.glassfish.jersey.test.JerseyTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.TripleEqualsSupport;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Outcome;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestSuite;
import org.scalatest.compatible.Assertion;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.enablers.Retrying$;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import org.scalatest.time.SpanSugar$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001i3A!\u0004\b\u00017!)\u0011\u0007\u0001C\u0001e!9Q\u0007\u0001b\u0001\n\u00031\u0004B\u0002#\u0001A\u0003%q\u0007C\u0004F\u0001\t\u0007I\u0011\u0001\u001c\t\r\u0019\u0003\u0001\u0015!\u00038\u0011\u001d9\u0005A1A\u0005\u0002YBa\u0001\u0013\u0001!\u0002\u00139\u0004bB%\u0001\u0005\u0004%\tF\u0013\u0005\u0007\u001d\u0002\u0001\u000b\u0011B&\t\u000b=\u0003A\u0011\t)\t\u000bU\u0003A\u0011\t)\t\u000bY\u0003A\u0011B,\u0003\u001b\t\u000bGo\u00195DY&\u001cV/\u001b;f\u0015\ty\u0001#\u0001\u0004dY&,g\u000e\u001e\u0006\u0003#I\tAA]3ti*\u00111\u0003F\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005U1\u0012AB6zkV\u0014\u0017N\u0003\u0002\u00181\u00051\u0011\r]1dQ\u0016T\u0011!G\u0001\u0004_J<7\u0001A\n\u0006\u0001q!\u0003F\f\t\u0003;\tj\u0011A\b\u0006\u0003?\u0001\n\u0001BZ;ogVLG/\u001a\u0006\u0003Ca\t\u0011b]2bY\u0006$Xm\u001d;\n\u0005\rr\"aC!os\u001a+hnU;ji\u0016\u0004\"!\n\u0014\u000e\u0003QI!a\n\u000b\u0003)I+7\u000f^\"mS\u0016tG\u000fV3ti\"+G\u000e]3s!\tIC&D\u0001+\u0015\tYC#A\u0002di2L!!\f\u0016\u0003#Q+7\u000f\u001e)sK6\fG/\u001e:f\u000bbLG\u000f\u0005\u0002&_%\u0011\u0001\u0007\u0006\u0002\u0010\u0005\u0006$8\r\u001b+fgRDU\r\u001c9fe\u00061A(\u001b8jiz\"\u0012a\r\t\u0003i\u0001i\u0011AD\u0001\tE\u0006\u001cX\rU1uQV\tq\u0007\u0005\u00029\u0003:\u0011\u0011h\u0010\t\u0003uuj\u0011a\u000f\u0006\u0003yi\ta\u0001\u0010:p_Rt$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k\u0014A\u0002)sK\u0012,g-\u0003\u0002C\u0007\n11\u000b\u001e:j]\u001eT!\u0001Q\u001f\u0002\u0013\t\f7/\u001a)bi\"\u0004\u0013!\u00032bi\u000eDg)\u001b7f\u0003)\u0011\u0017\r^2i\r&dW\rI\u0001\u0012Y>tw\rV5nK\n\u000bGo\u00195GS2,\u0017A\u00057p]\u001e$\u0016.\\3CCR\u001c\u0007NR5mK\u0002\nAb\u001c;iKJ\u001cuN\u001c4jON,\u0012a\u0013\t\u0005q1;t'\u0003\u0002N\u0007\n\u0019Q*\u00199\u0002\u001b=$\b.\u001a:D_:4\u0017nZ:!\u0003%\u0011WMZ8sK\u0006cG\u000eF\u0001R!\t\u00116+D\u0001>\u0013\t!VH\u0001\u0003V]&$\u0018!C1gi\u0016\u0014X)Y2i\u0003e9W\r\u001e\"bi\u000eD\u0017\n\u001a$s_6\u0014\u0015\r^2i%\u0016\u0004xN\u001d;\u0015\u0005]B\u0006\"B-\r\u0001\u00049\u0014a\u00032bi\u000eD'+\u001a9peR\u0004")
public class BatchCliSuite
extends AnyFunSuite
implements RestClientTestHelper,
TestPrematureExit,
BatchTestHelper {
    private final String basePath;
    private final String batchFile;
    private final String longTimeBatchFile;
    private final Map<String, String> otherConfigs;
    private final String sparkBatchTestBatchType;
    private final String sparkBatchTestMainClass;
    private final String sparkBatchTestAppName;
    private final Option<String> sparkBatchTestResource;
    private final OutputStream org$apache$kyuubi$ctl$TestPrematureExit$$noOpOutputStream;
    private final String customUser;
    private final String customPasswd;
    private final UserGroupInformation org$apache$kyuubi$RestClientTestHelper$$currentUser;
    private KyuubiConf conf;
    private InMemoryDirectoryServer ldapServer;
    private final String[] ldapBaseDn;
    private final String ldapUser;
    private final String ldapUserPasswd;
    private final String clientPrincipalUser;
    private final File baseDir;
    private final Properties kdcConf;
    private final String hostName;
    private MiniKdc org$apache$kyuubi$KerberizedTestHelper$$kdc;
    private String krb5ConfPath;
    private final File org$apache$kyuubi$KerberizedTestHelper$$keytabFile;
    private final String testKeytab;
    private String testPrincipal;
    private String testSpnegoPrincipal;
    private final Seq<Enumeration.Value> frontendProtocols;
    private final JerseyTest restApiBaseSuite;
    private AbstractFrontendService fe;
    private URI baseUri;
    private WebTarget webTarget;
    private EmbeddedZookeeper org$apache$kyuubi$WithKyuubiServer$$zkServer;
    private KyuubiServer server;
    private volatile KyuubiFunSuite$LogAppender$ LogAppender$module;
    private Set<String> org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile byte bitmap$0;

    @Override
    public BatchRequest newBatchRequest(String batchType, String resource, String className, String name, Map<String, String> conf, Seq<String> args) {
        return BatchTestHelper.newBatchRequest$(this, batchType, resource, className, name, conf, args);
    }

    @Override
    public Map<String, String> newBatchRequest$default$5() {
        return BatchTestHelper.newBatchRequest$default$5$(this);
    }

    @Override
    public Seq<String> newBatchRequest$default$6() {
        return BatchTestHelper.newBatchRequest$default$6$(this);
    }

    @Override
    public BatchRequest newSparkBatchRequest(Map<String, String> conf, Seq<String> args) {
        return BatchTestHelper.newSparkBatchRequest$(this, conf, args);
    }

    @Override
    public Map<String, String> newSparkBatchRequest$default$1() {
        return BatchTestHelper.newSparkBatchRequest$default$1$(this);
    }

    @Override
    public Seq<String> newSparkBatchRequest$default$2() {
        return BatchTestHelper.newSparkBatchRequest$default$2$(this);
    }

    public String testPrematureExitForControlCli(String[] input, String searchString, CommandLineUtils mainObject) {
        return TestPrematureExit.testPrematureExitForControlCli$((TestPrematureExit)this, (String[])input, (String)searchString, (CommandLineUtils)mainObject);
    }

    public CommandLineUtils testPrematureExitForControlCli$default$3() {
        return TestPrematureExit.testPrematureExitForControlCli$default$3$((TestPrematureExit)this);
    }

    public void testPrematureExitForControlCliArgs(String[] args, String searchString) {
        TestPrematureExit.testPrematureExitForControlCliArgs$((TestPrematureExit)this, (String[])args, (String)searchString);
    }

    public String testPrematureExitForAdminControlCli(String[] input, String searchString) {
        return TestPrematureExit.testPrematureExitForAdminControlCli$((TestPrematureExit)this, (String[])input, (String)searchString);
    }

    public void testPrematureExitForAdminControlCliArgs(String[] args, String searchString) {
        TestPrematureExit.testPrematureExitForAdminControlCliArgs$((TestPrematureExit)this, (String[])args, (String)searchString);
    }

    @Override
    public /* synthetic */ void org$apache$kyuubi$RestClientTestHelper$$super$afterAll() {
        WithLdapServer.afterAll$((WithLdapServer)this);
    }

    @Override
    public void afterAll() {
        RestClientTestHelper.afterAll$(this);
    }

    public /* synthetic */ void org$apache$kyuubi$service$authentication$WithLdapServer$$super$beforeAll() {
        KerberizedTestHelper.beforeAll$((KerberizedTestHelper)this);
    }

    public /* synthetic */ void org$apache$kyuubi$service$authentication$WithLdapServer$$super$afterAll() {
        KerberizedTestHelper.afterAll$((KerberizedTestHelper)this);
    }

    public String ldapUrl() {
        return WithLdapServer.ldapUrl$((WithLdapServer)this);
    }

    public void applyLDIF(String resource) {
        WithLdapServer.applyLDIF$((WithLdapServer)this, (String)resource);
    }

    public /* synthetic */ void org$apache$kyuubi$KerberizedTestHelper$$super$beforeAll() {
        RestFrontendTestHelper.beforeAll$(this);
    }

    public /* synthetic */ void org$apache$kyuubi$KerberizedTestHelper$$super$afterAll() {
        RestFrontendTestHelper.afterAll$(this);
    }

    public void tryWithSecurityEnabled(Function0<BoxedUnit> block) {
        KerberizedTestHelper.tryWithSecurityEnabled$((KerberizedTestHelper)this, block);
    }

    public String generateToken(String server) {
        return KerberizedTestHelper.generateToken$((KerberizedTestHelper)this, (String)server);
    }

    @Override
    public /* synthetic */ void org$apache$kyuubi$RestFrontendTestHelper$$super$beforeAll() {
        WithKyuubiServer.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$kyuubi$RestFrontendTestHelper$$super$afterAll() {
        WithKyuubiServer.afterAll$(this);
    }

    @Override
    public Response v1Call(String func) {
        return RestFrontendTestHelper.v1Call$(this, func);
    }

    @Override
    public /* synthetic */ void org$apache$kyuubi$WithKyuubiServer$$super$beforeAll() {
        KyuubiFunSuite.beforeAll$((KyuubiFunSuite)this);
    }

    @Override
    public /* synthetic */ void org$apache$kyuubi$WithKyuubiServer$$super$afterAll() {
        KyuubiFunSuite.afterAll$((KyuubiFunSuite)this);
    }

    @Override
    public String getJdbcUrl() {
        return WithKyuubiServer.getJdbcUrl$(this);
    }

    public /* synthetic */ void org$apache$kyuubi$KyuubiFunSuite$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public /* synthetic */ void org$apache$kyuubi$KyuubiFunSuite$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    public final Outcome withFixture(TestSuite.NoArgTest test) {
        return KyuubiFunSuite.withFixture$((KyuubiFunSuite)this, (TestSuite.NoArgTest)test);
    }

    public final void withLogAppender(AbstractAppender appender, Seq<String> loggerNames, Option<Level> level, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withLogAppender$((KyuubiFunSuite)this, (AbstractAppender)appender, loggerNames, level, f);
    }

    public final Seq<String> withLogAppender$default$2() {
        return KyuubiFunSuite.withLogAppender$default$2$((KyuubiFunSuite)this);
    }

    public final Option<Level> withLogAppender$default$3() {
        return KyuubiFunSuite.withLogAppender$default$3$((KyuubiFunSuite)this);
    }

    public final void withSystemProperty(Map<String, String> properties, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withSystemProperty$((KyuubiFunSuite)this, properties, f);
    }

    public final void withSystemProperty(String key, String value, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withSystemProperty$((KyuubiFunSuite)this, (String)key, (String)value, f);
    }

    public final void setSystemProperty(String key, String value) {
        KyuubiFunSuite.setSystemProperty$((KyuubiFunSuite)this, (String)key, (String)value);
    }

    public void doThreadPreAudit() {
        ThreadAudit.doThreadPreAudit$((ThreadAudit)this);
    }

    public void doThreadPostAudit() {
        ThreadAudit.doThreadPostAudit$((ThreadAudit)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public String sparkBatchTestBatchType() {
        return this.sparkBatchTestBatchType;
    }

    @Override
    public String sparkBatchTestMainClass() {
        return this.sparkBatchTestMainClass;
    }

    @Override
    public String sparkBatchTestAppName() {
        return this.sparkBatchTestAppName;
    }

    @Override
    public Option<String> sparkBatchTestResource() {
        return this.sparkBatchTestResource;
    }

    @Override
    public void org$apache$kyuubi$BatchTestHelper$_setter_$sparkBatchTestBatchType_$eq(String x$1) {
        this.sparkBatchTestBatchType = x$1;
    }

    @Override
    public void org$apache$kyuubi$BatchTestHelper$_setter_$sparkBatchTestMainClass_$eq(String x$1) {
        this.sparkBatchTestMainClass = x$1;
    }

    @Override
    public void org$apache$kyuubi$BatchTestHelper$_setter_$sparkBatchTestAppName_$eq(String x$1) {
        this.sparkBatchTestAppName = x$1;
    }

    @Override
    public void org$apache$kyuubi$BatchTestHelper$_setter_$sparkBatchTestResource_$eq(Option<String> x$1) {
        this.sparkBatchTestResource = x$1;
    }

    public OutputStream org$apache$kyuubi$ctl$TestPrematureExit$$noOpOutputStream() {
        return this.org$apache$kyuubi$ctl$TestPrematureExit$$noOpOutputStream;
    }

    public final void org$apache$kyuubi$ctl$TestPrematureExit$_setter_$org$apache$kyuubi$ctl$TestPrematureExit$$noOpOutputStream_$eq(OutputStream x$1) {
        this.org$apache$kyuubi$ctl$TestPrematureExit$$noOpOutputStream = x$1;
    }

    @Override
    public String customUser() {
        return this.customUser;
    }

    @Override
    public String customPasswd() {
        return this.customPasswd;
    }

    @Override
    public UserGroupInformation org$apache$kyuubi$RestClientTestHelper$$currentUser() {
        return this.org$apache$kyuubi$RestClientTestHelper$$currentUser;
    }

    private KyuubiConf conf$lzycompute() {
        BatchCliSuite batchCliSuite = this;
        synchronized (batchCliSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.conf = RestClientTestHelper.conf$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.conf;
    }

    @Override
    public KyuubiConf conf() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.conf$lzycompute();
        }
        return this.conf;
    }

    @Override
    public void org$apache$kyuubi$RestClientTestHelper$_setter_$customUser_$eq(String x$1) {
        this.customUser = x$1;
    }

    @Override
    public void org$apache$kyuubi$RestClientTestHelper$_setter_$customPasswd_$eq(String x$1) {
        this.customPasswd = x$1;
    }

    @Override
    public final void org$apache$kyuubi$RestClientTestHelper$_setter_$org$apache$kyuubi$RestClientTestHelper$$currentUser_$eq(UserGroupInformation x$1) {
        this.org$apache$kyuubi$RestClientTestHelper$$currentUser = x$1;
    }

    @Override
    public void org$apache$kyuubi$RestClientTestHelper$_setter_$otherConfigs_$eq(Map<String, String> x$1) {
    }

    public InMemoryDirectoryServer ldapServer() {
        return this.ldapServer;
    }

    public void ldapServer_$eq(InMemoryDirectoryServer x$1) {
        this.ldapServer = x$1;
    }

    public String[] ldapBaseDn() {
        return this.ldapBaseDn;
    }

    public String ldapUser() {
        return this.ldapUser;
    }

    public String ldapUserPasswd() {
        return this.ldapUserPasswd;
    }

    public void org$apache$kyuubi$service$authentication$WithLdapServer$_setter_$ldapBaseDn_$eq(String[] x$1) {
        this.ldapBaseDn = x$1;
    }

    public void org$apache$kyuubi$service$authentication$WithLdapServer$_setter_$ldapUser_$eq(String x$1) {
        this.ldapUser = x$1;
    }

    public void org$apache$kyuubi$service$authentication$WithLdapServer$_setter_$ldapUserPasswd_$eq(String x$1) {
        this.ldapUserPasswd = x$1;
    }

    public String clientPrincipalUser() {
        return this.clientPrincipalUser;
    }

    public File baseDir() {
        return this.baseDir;
    }

    public Properties kdcConf() {
        return this.kdcConf;
    }

    public String hostName() {
        return this.hostName;
    }

    public MiniKdc org$apache$kyuubi$KerberizedTestHelper$$kdc() {
        return this.org$apache$kyuubi$KerberizedTestHelper$$kdc;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$$kdc_$eq(MiniKdc x$1) {
        this.org$apache$kyuubi$KerberizedTestHelper$$kdc = x$1;
    }

    public String krb5ConfPath() {
        return this.krb5ConfPath;
    }

    public void krb5ConfPath_$eq(String x$1) {
        this.krb5ConfPath = x$1;
    }

    public File org$apache$kyuubi$KerberizedTestHelper$$keytabFile() {
        return this.org$apache$kyuubi$KerberizedTestHelper$$keytabFile;
    }

    public String testKeytab() {
        return this.testKeytab;
    }

    public String testPrincipal() {
        return this.testPrincipal;
    }

    public void testPrincipal_$eq(String x$1) {
        this.testPrincipal = x$1;
    }

    public String testSpnegoPrincipal() {
        return this.testSpnegoPrincipal;
    }

    public void testSpnegoPrincipal_$eq(String x$1) {
        this.testSpnegoPrincipal = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$clientPrincipalUser_$eq(String x$1) {
        this.clientPrincipalUser = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$baseDir_$eq(File x$1) {
        this.baseDir = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$kdcConf_$eq(Properties x$1) {
        this.kdcConf = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$hostName_$eq(String x$1) {
        this.hostName = x$1;
    }

    public final void org$apache$kyuubi$KerberizedTestHelper$_setter_$org$apache$kyuubi$KerberizedTestHelper$$keytabFile_$eq(File x$1) {
        this.org$apache$kyuubi$KerberizedTestHelper$$keytabFile = x$1;
    }

    public void org$apache$kyuubi$KerberizedTestHelper$_setter_$testKeytab_$eq(String x$1) {
        this.testKeytab = x$1;
    }

    @Override
    public Seq<Enumeration.Value> frontendProtocols() {
        return this.frontendProtocols;
    }

    @Override
    public JerseyTest restApiBaseSuite() {
        return this.restApiBaseSuite;
    }

    private AbstractFrontendService fe$lzycompute() {
        BatchCliSuite batchCliSuite = this;
        synchronized (batchCliSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.fe = RestFrontendTestHelper.fe$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.fe;
    }

    @Override
    public AbstractFrontendService fe() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.fe$lzycompute();
        }
        return this.fe;
    }

    private URI baseUri$lzycompute() {
        BatchCliSuite batchCliSuite = this;
        synchronized (batchCliSuite) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.baseUri = RestFrontendTestHelper.baseUri$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.baseUri;
    }

    @Override
    public URI baseUri() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.baseUri$lzycompute();
        }
        return this.baseUri;
    }

    private WebTarget webTarget$lzycompute() {
        BatchCliSuite batchCliSuite = this;
        synchronized (batchCliSuite) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.webTarget = RestFrontendTestHelper.webTarget$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.webTarget;
    }

    @Override
    public WebTarget webTarget() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.webTarget$lzycompute();
        }
        return this.webTarget;
    }

    @Override
    public void org$apache$kyuubi$RestFrontendTestHelper$_setter_$frontendProtocols_$eq(Seq<Enumeration.Value> x$1) {
        this.frontendProtocols = x$1;
    }

    @Override
    public void org$apache$kyuubi$RestFrontendTestHelper$_setter_$restApiBaseSuite_$eq(JerseyTest x$1) {
        this.restApiBaseSuite = x$1;
    }

    @Override
    public EmbeddedZookeeper org$apache$kyuubi$WithKyuubiServer$$zkServer() {
        return this.org$apache$kyuubi$WithKyuubiServer$$zkServer;
    }

    @Override
    public void org$apache$kyuubi$WithKyuubiServer$$zkServer_$eq(EmbeddedZookeeper x$1) {
        this.org$apache$kyuubi$WithKyuubiServer$$zkServer = x$1;
    }

    @Override
    public KyuubiServer server() {
        return this.server;
    }

    @Override
    public void server_$eq(KyuubiServer x$1) {
        this.server = x$1;
    }

    @Override
    public void org$apache$kyuubi$WithKyuubiServer$_setter_$frontendProtocols_$eq(Seq<Enumeration.Value> x$1) {
    }

    public KyuubiFunSuite$LogAppender$ LogAppender() {
        if (this.LogAppender$module == null) {
            this.LogAppender$lzycompute$1();
        }
        return this.LogAppender$module;
    }

    public Set<String> org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot() {
        return this.org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot;
    }

    public void org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot_$eq(Set<String> x$1) {
        this.org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot = x$1;
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    public String basePath() {
        return this.basePath;
    }

    public String batchFile() {
        return this.batchFile;
    }

    public String longTimeBatchFile() {
        return this.longTimeBatchFile;
    }

    @Override
    public Map<String, String> otherConfigs() {
        return this.otherConfigs;
    }

    @Override
    public void beforeAll() {
        WithLdapServer.beforeAll$((WithLdapServer)this);
        System.setProperty("kyuubi.ctl.rest.base.url", this.baseUri().toString());
        System.setProperty("kyuubi.ctl.rest.spnego.host", "localhost");
        String batch_basic = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(754).append("apiVersion: v1\n                         |username: ").append(this.ldapUser()).append("\n                         |request:\n                         |  batchType: Spark\n                         |  name: ").append(this.sparkBatchTestAppName()).append("\n                         |  resource: ").append(this.sparkBatchTestResource().get()).append("\n                         |  className: ").append(this.sparkBatchTestMainClass()).append("\n                         |  args:\n                         |   - 1\n                         |   - x1\n                         |   - x2\n                         |   - true\n                         |  configs:\n                         |    spark.master: local\n                         |    wait.completion: true\n                         |    k1: v1\n                         |    1: test_integer_key\n                         |    key:\n                         |options:\n                         |  verbose: true").toString())).stripMargin();
        Files.write(Paths.get(this.batchFile(), new String[0]), batch_basic.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        String long_time_batch_basic = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(871).append("apiVersion: v1\n                                   |username: ").append(this.ldapUser()).append("\n                                   |request:\n                                   |  batchType: Spark\n                                   |  name: LongTimeBatch\n                                   |  resource: ").append(this.sparkBatchTestResource().get()).append("\n                                   |  className: org.apache.spark.examples.DriverSubmissionTest\n                                   |  args:\n                                   |   - 120\n                                   |  configs:\n                                   |    spark.master: local\n                                   |    wait.completion: true\n                                   |    k1: v1\n                                   |    1: test_integer_key\n                                   |    key:\n                                   |options:\n                                   |  verbose: true").toString())).stripMargin();
        Files.write(Paths.get(this.longTimeBatchFile(), new String[0]), long_time_batch_basic.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void afterEach() {
        KyuubiSessionManager sessionManager = (KyuubiSessionManager)this.fe().be().sessionManager();
        sessionManager.allSessions().foreach((Function1 & Serializable & scala.Serializable)session -> {
            sessionManager.closeSession(session.handle());
            return BoxedUnit.UNIT;
        });
        sessionManager.getBatchesFromMetadataStore(new MetadataFilter(MetadataFilter$.MODULE$.apply$default$1(), MetadataFilter$.MODULE$.apply$default$2(), MetadataFilter$.MODULE$.apply$default$3(), MetadataFilter$.MODULE$.apply$default$4(), MetadataFilter$.MODULE$.apply$default$5(), MetadataFilter$.MODULE$.apply$default$6(), MetadataFilter$.MODULE$.apply$default$7(), MetadataFilter$.MODULE$.apply$default$8(), MetadataFilter$.MODULE$.apply$default$9()), 0, Integer.MAX_VALUE).foreach((Function1 & Serializable & scala.Serializable)batch -> {
            BatchCliSuite.$anonfun$afterEach$2(sessionManager, batch);
            return BoxedUnit.UNIT;
        });
    }

    private String getBatchIdFromBatchReport(String batchReport) {
        Regex batchIdRegex = new StringOps(Predef$.MODULE$.augmentString("Batch Report \\((.*)\\)")).r();
        Option option = batchIdRegex.findFirstMatchIn((CharSequence)batchReport);
        if (option instanceof Some) {
            Some some = (Some)option;
            Regex.Match m = (Regex.Match)some.value();
            return m.group(1);
        }
        throw new IllegalArgumentException("Invalid batch report");
    }

    private final void LogAppender$lzycompute$1() {
        BatchCliSuite batchCliSuite = this;
        synchronized (batchCliSuite) {
            if (this.LogAppender$module == null) {
                this.LogAppender$module = new KyuubiFunSuite$LogAppender$((KyuubiFunSuite)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        BatchCliSuite batchCliSuite = this;
        synchronized (batchCliSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$afterEach$2(KyuubiSessionManager sessionManager$1, Batch batch) {
        sessionManager$1.applicationManager().killApplication(new ApplicationManagerInfo((Option)None$.MODULE$, ApplicationManagerInfo$.MODULE$.apply$default$2()), batch.getId(), sessionManager$1.applicationManager().killApplication$default$3());
        sessionManager$1.cleanupMetadata(batch.getId());
    }

    public BatchCliSuite() {
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        Logging.$init$((Logging)this);
        ThreadAudit.$init$((ThreadAudit)this);
        KyuubiFunSuite.$init$((KyuubiFunSuite)this);
        WithKyuubiServer.$init$(this);
        RestFrontendTestHelper.$init$(this);
        KerberizedTestHelper.$init$((KerberizedTestHelper)this);
        WithLdapServer.$init$((WithLdapServer)this);
        RestClientTestHelper.$init$(this);
        TestPrematureExit.$init$((TestPrematureExit)this);
        BatchTestHelper.$init$(this);
        this.basePath = Utils$.MODULE$.getCodeSourceLocation(this.getClass());
        this.batchFile = new StringBuilder(11).append(this.basePath()).append("/batch.yaml").toString();
        this.longTimeBatchFile = new StringBuilder(21).append(this.basePath()).append("/batch_long_time.yaml").toString();
        this.otherConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)KyuubiConf$.MODULE$.BATCH_APPLICATION_CHECK_INTERVAL().key()), (Object)"100")}));
        this.test("basic batch rest client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            long totalConnections = BoxesRunTime.unboxToLong((Object)MetricsSystem$.MODULE$.counterValue(MetricsConstants$.MODULE$.REST_CONN_TOTAL()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
            String[] createArgs = (String[])((Object[])new String[]{"create", "batch", "-f", this.longTimeBatchFile(), "--password", this.ldapUserPasswd()});
            ObjectRef result = ObjectRef.create((Object)this.testPrematureExitForControlCli(createArgs, "", this.testPrematureExitForControlCli$default$3()));
            String $org_scalatest_assert_macro_left = (String)result.elem;
            String $org_scalatest_assert_macro_right = "SPARK";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
            String $org_scalatest_assert_macro_left2 = (String)result.elem;
            String $org_scalatest_assert_macro_right2 = String.valueOf(this.fe().connectionUrl());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
            String batchId = this.getBatchIdFromBatchReport((String)result.elem);
            String[] getArgs = (String[])((Object[])new String[]{"get", "batch", batchId, "--username", this.ldapUser(), "--password", this.ldapUserPasswd()});
            IntRef invalidCount = IntRef.create((int)0);
            this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(5).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(100).milliseconds()), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ++invalidCount$1.elem;
                result$1.elem = this.testPrematureExitForControlCli(getArgs, "SPARK", this.testPrematureExitForControlCli$default$3());
                String $org_scalatest_assert_macro_left = (String)result$1.elem;
                String $org_scalatest_assert_macro_right = "RUNNING";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
                String $org_scalatest_assert_macro_left2 = (String)result$1.elem;
                String $org_scalatest_assert_macro_right2 = "SPARK";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
                String $org_scalatest_assert_macro_left3 = (String)result$1.elem;
                String $org_scalatest_assert_macro_right3 = String.valueOf(this.fe().connectionUrl());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 141));
                --invalidCount$1.elem;
            }, (Retrying)Retrying$.MODULE$.retryingNatureOfT(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
            String[] logArgs = (String[])((Object[])new String[]{"log", "batch", batchId, "--size", "100", "--username", this.ldapUser(), "--password", this.ldapUserPasswd()});
            this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(100).milliseconds()), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                ++invalidCount$1.elem;
                result$1.elem = this.testPrematureExitForControlCli(logArgs, "", this.testPrematureExitForControlCli$default$3());
                String[] rows = ((String)result$1.elem).split("\n");
                int $org_scalatest_assert_macro_left = rows.length;
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
                String $org_scalatest_assert_macro_left2 = (String)result$1.elem;
                String $org_scalatest_assert_macro_right2 = "Alive for";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 161));
                --invalidCount$1.elem;
            }, (Retrying)Retrying$.MODULE$.retryingNatureOfT(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
            String[] deleteArgs = (String[])((Object[])new String[]{"delete", "batch", batchId, "--username", this.ldapUser(), "--password", this.ldapUserPasswd()});
            result.elem = this.testPrematureExitForControlCli(deleteArgs, "\"success\":true", this.testPrematureExitForControlCli$default$3());
            return (Assertion)this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(3).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(200).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                long $org_scalatest_assert_macro_left = BoxesRunTime.unboxToLong((Object)MetricsSystem$.MODULE$.counterValue(MetricsConstants$.MODULE$.REST_CONN_TOTAL()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)) - totalConnections - (long)invalidCount$1.elem;
                int $org_scalatest_assert_macro_right = 5;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 176));
                TripleEqualsSupport.Equalizer $org_scalatest_assert_macro_left2 = this.convertToEqualizer(MetricsSystem$.MODULE$.counterValue(MetricsConstants$.MODULE$.REST_CONN_OPEN()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
                int $org_scalatest_assert_macro_right2 = 0;
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "===", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2.$eq$eq$eq((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), Equality$.MODULE$.default()), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 178));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 175));
        }, new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
        this.test("spnego batch rest client", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            UserGroupInformation.loginUserFromKeytab((String)this.testPrincipal(), (String)this.testKeytab());
            String[] createArgs = (String[])((Object[])new String[]{"create", "batch", "-f", this.longTimeBatchFile(), "--authSchema", "SPNEGO"});
            ObjectRef result = ObjectRef.create((Object)this.testPrematureExitForControlCli(createArgs, "", this.testPrematureExitForControlCli$default$3()));
            String $org_scalatest_assert_macro_left = (String)result.elem;
            String $org_scalatest_assert_macro_right = "SPARK";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            String $org_scalatest_assert_macro_left2 = (String)result.elem;
            String $org_scalatest_assert_macro_right2 = String.valueOf(this.fe().connectionUrl());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            String batchId = this.getBatchIdFromBatchReport((String)result.elem);
            String[] getArgs = (String[])((Object[])new String[]{"get", "batch", batchId, "--authSchema", "spnego"});
            this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(5).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(100).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                result$2.elem = this.testPrematureExitForControlCli(getArgs, "SPARK", this.testPrematureExitForControlCli$default$3());
                String $org_scalatest_assert_macro_left = (String)result$2.elem;
                String $org_scalatest_assert_macro_right = "RUNNING";
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 205));
                String $org_scalatest_assert_macro_left2 = (String)result$2.elem;
                String $org_scalatest_assert_macro_right2 = "SPARK";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
                String $org_scalatest_assert_macro_left3 = (String)result$2.elem;
                String $org_scalatest_assert_macro_right3 = String.valueOf(this.fe().connectionUrl());
                Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
            String[] logArgs = (String[])((Object[])new String[]{"log", "batch", batchId, "--size", "100", "--authSchema", "spnego"});
            this.eventually(this.timeout(SpanSugar$.MODULE$.convertIntToGrainOfTime(60).seconds()), this.interval(SpanSugar$.MODULE$.convertIntToGrainOfTime(100).milliseconds()), (Function0 & Serializable & scala.Serializable)() -> {
                result$2.elem = this.testPrematureExitForControlCli(logArgs, "", this.testPrematureExitForControlCli$default$3());
                String[] rows = ((String)result$2.elem).split("\n");
                int $org_scalatest_assert_macro_left = rows.length;
                int $org_scalatest_assert_macro_right = 2;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), ">=", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left >= $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 221));
                String $org_scalatest_assert_macro_left2 = (String)result$2.elem;
                String $org_scalatest_assert_macro_right2 = "Alive for";
                Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 223));
            }, Retrying$.MODULE$.retryingNatureOfT(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 218));
            String[] deleteArgs = (String[])((Object[])new String[]{"delete", "batch", batchId, "--authSchema", "spnego"});
            result.elem = this.testPrematureExitForControlCli(deleteArgs, "\"success\":true", this.testPrematureExitForControlCli$default$3());
        }, new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 182));
        this.test("log batch test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String result;
            String[] createArgs = (String[])((Object[])new String[]{"create", "batch", "-f", this.batchFile(), "--password", this.ldapUserPasswd()});
            String $org_scalatest_assert_macro_left = result = this.testPrematureExitForControlCli(createArgs, "", this.testPrematureExitForControlCli$default$3());
            String $org_scalatest_assert_macro_right = "SPARK";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 244));
            String $org_scalatest_assert_macro_left2 = result;
            String $org_scalatest_assert_macro_right2 = String.valueOf(this.fe().connectionUrl());
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 245));
            String batchId = this.getBatchIdFromBatchReport(result);
            String[] logArgs = (String[])((Object[])new String[]{"log", "batch", batchId, "--size", "100", "--username", this.ldapUser(), "--password", this.ldapUserPasswd(), "--forward"});
            String $org_scalatest_assert_macro_left3 = result = this.testPrematureExitForControlCli(logArgs, "", this.testPrematureExitForControlCli$default$3());
            String $org_scalatest_assert_macro_right3 = new StringBuilder(23).append("Submitted application: ").append(this.sparkBatchTestAppName()).toString();
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 260));
            String $org_scalatest_assert_macro_left4 = result;
            String $org_scalatest_assert_macro_right4 = "ShutdownHookManager: Shutdown hook called";
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 261));
        }, new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        this.test("submit batch test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String result;
            String[] submitArgs = (String[])((Object[])new String[]{"submit", "batch", "-f", this.batchFile(), "--password", this.ldapUserPasswd()});
            String $org_scalatest_assert_macro_left = result = this.testPrematureExitForControlCli(submitArgs, "", this.testPrematureExitForControlCli$default$3());
            String $org_scalatest_assert_macro_right = new StringBuilder(23).append("Submitted application: ").append(this.sparkBatchTestAppName()).toString();
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 273));
            String $org_scalatest_assert_macro_left2 = result;
            String $org_scalatest_assert_macro_right2 = "ShutdownHookManager: Shutdown hook called";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 274));
        }, new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 264));
        this.test("submit batch test with waitCompletion=false", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String result;
            String[] submitArgs = (String[])((Object[])new String[]{"submit", "batch", "-f", this.batchFile(), "--password", this.ldapUserPasswd(), "--waitCompletion", "false", "--conf", new StringBuilder(4).append(CtlConf$.MODULE$.CTL_BATCH_LOG_QUERY_INTERVAL().key()).append("=100").toString()});
            String $org_scalatest_assert_macro_left = result = this.testPrematureExitForControlCli(submitArgs, "", this.testPrematureExitForControlCli$default$3());
            String $org_scalatest_assert_macro_right = "/bin/spark-submit";
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 290));
            String $org_scalatest_assert_macro_left2 = result;
            String $org_scalatest_assert_macro_right2 = "ShutdownHookManager: Shutdown hook called";
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left2.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 291));
        }, new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        this.test("list batch test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            KyuubiSessionManager sessionManager = (KyuubiSessionManager)((FrontendService)this.server().frontendServices().head()).be().sessionManager();
            sessionManager.allSessions().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
                x$1.close();
                return BoxedUnit.UNIT;
            });
            sessionManager.openBatchSession("kyuubi", "kyuubi", InetAddress.getLocalHost().getCanonicalHostName(), this.newBatchRequest("spark", "", "", "", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchUtils.KYUUBI_BATCH_ID_KEY), (Object)UUID.randomUUID().toString())}))), this.newBatchRequest$default$6()));
            sessionManager.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V11, "", "", "", Predef$.MODULE$.Map().empty());
            sessionManager.openSession(TProtocolVersion.HIVE_CLI_SERVICE_PROTOCOL_V11, "", "", "", Predef$.MODULE$.Map().empty());
            sessionManager.openBatchSession("kyuubi", "kyuubi", InetAddress.getLocalHost().getCanonicalHostName(), this.newBatchRequest("spark", "", "", "", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchUtils.KYUUBI_BATCH_ID_KEY), (Object)UUID.randomUUID().toString())}))), this.newBatchRequest$default$6()));
            sessionManager.openBatchSession("kyuubi", "kyuubi", InetAddress.getLocalHost().getCanonicalHostName(), this.newBatchRequest("spark", "", "", "", (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BatchUtils.KYUUBI_BATCH_ID_KEY), (Object)UUID.randomUUID().toString())}))), this.newBatchRequest$default$6()));
            String[] listArgs = (String[])((Object[])new String[]{"list", "batch", "--username", this.ldapUser(), "--password", this.ldapUserPasswd(), "--batchType", "spark", "--batchUser", "kyuubi", "--createTime", "20220101000000"});
            this.testPrematureExitForControlCli(listArgs, "Batch List (from 0 total 3)", this.testPrematureExitForControlCli$default$3());
            String[] listArgs1 = (String[])((Object[])new String[]{"list", "batch", "--username", this.ldapUser(), "--password", this.ldapUserPasswd(), "--endTime", "20220101000000"});
            return this.testPrematureExitForControlCli(listArgs1, "Batch List (from 0 total 0)", this.testPrematureExitForControlCli$default$3());
        }, new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
        this.test("test batch yaml without request field", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            Path tempDir = Utils$.MODULE$.createTempDir(Utils$.MODULE$.createTempDir$default$1(), Utils$.MODULE$.createTempDir$default$2());
            Path yamlFile1 = Files.write(new File(tempDir.toFile(), "f1.yaml").toPath(), new StringOps(Predef$.MODULE$.augmentString("\n         |apiVersion: v1\n         |user: test_user\n         |")).stripMargin().getBytes(StandardCharset.UTF_8), new OpenOption[0]);
            String[] args = (String[])((Object[])new String[]{"create", "batch", "-f", yamlFile1.toFile().getAbsolutePath()});
            return this.testPrematureExitForControlCli(args, "No batch request field specified in yaml", this.testPrematureExitForControlCli$default$3());
        }, new Position("BatchCliSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 369));
    }
}

