/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.trino.api;

import com.google.common.base.Verify;
import io.airlift.units.Duration;
import io.trino.client.ClientSession;
import io.trino.client.QueryStatusInfo;
import io.trino.client.StatementClient;
import io.trino.client.StatementClientFactory;
import java.io.Serializable;
import java.net.URI;
import java.time.ZoneId;
import java.util.Collections;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import okhttp3.OkHttpClient;
import org.apache.kyuubi.KyuubiFunSuite;
import org.apache.kyuubi.KyuubiFunSuite$LogAppender$;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.RestFrontendTestHelper;
import org.apache.kyuubi.ThreadAudit;
import org.apache.kyuubi.TrinoRestFrontendTestHelper;
import org.apache.kyuubi.WithKyuubiServer;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.server.KyuubiServer;
import org.apache.kyuubi.server.trino.api.Query$;
import org.apache.kyuubi.service.AbstractFrontendService;
import org.apache.kyuubi.zookeeper.EmbeddedZookeeper;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.glassfish.jersey.test.JerseyTest;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Outcome;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestSuite;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0005\u000b\u0001]AQa\n\u0001\u0005\u0002!Bqa\u000b\u0001C\u0002\u0013%A\u0006\u0003\u00044\u0001\u0001\u0006I!\f\u0005\ti\u0001A)\u0019!C\u0005k!)1\n\u0001C\u0005\u0019\")q\u000b\u0001C\u00051\")!\u000e\u0001C\u0005W\")a\u000f\u0001C\u0005o\n\u0019BK]5o_\u000ec\u0017.\u001a8u\u0003BL7+^5uK*\u00111\u0002D\u0001\u0004CBL'BA\u0007\u000f\u0003\u0015!(/\u001b8p\u0015\ty\u0001#\u0001\u0004tKJ4XM\u001d\u0006\u0003#I\taa[=vk\nL'BA\n\u0015\u0003\u0019\t\u0007/Y2iK*\tQ#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00011\u0001\"\u0003CA\r\u001f\u001b\u0005Q\"BA\u000e\u001d\u0003!1WO\\:vSR,'BA\u000f\u0015\u0003%\u00198-\u00197bi\u0016\u001cH/\u0003\u0002 5\tY\u0011I\\=Gk:\u001cV/\u001b;f!\t\t#%D\u0001\u0011\u0013\t\u0019\u0003C\u0001\bLsV,(-\u001b$v]N+\u0018\u000e^3\u0011\u0005\u0005*\u0013B\u0001\u0014\u0011\u0005m!&/\u001b8p%\u0016\u001cHO\u0012:p]R,g\u000e\u001a+fgRDU\r\u001c9fe\u00061A(\u001b8jiz\"\u0012!\u000b\t\u0003U\u0001i\u0011AC\u0001\u000bQR$\bo\u00117jK:$X#A\u0017\u0011\u00059\nT\"A\u0018\u000b\u0003A\nqa\\6iiR\u00048'\u0003\u00023_\taqj\u001b%uiB\u001cE.[3oi\u0006Y\u0001\u000e\u001e;q\u00072LWM\u001c;!\u00035\u0019G.[3oiN+7o]5p]V\ta\u0007E\u00028\u0001\nk\u0011\u0001\u000f\u0006\u0003si\na!\u0019;p[&\u001c'BA\u001e=\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003{y\nA!\u001e;jY*\tq(\u0001\u0003kCZ\f\u0017BA!9\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA\"J\u001b\u0005!%BA#G\u0003\u0019\u0019G.[3oi*\u0011Qb\u0012\u0006\u0002\u0011\u0006\u0011\u0011n\\\u0005\u0003\u0015\u0012\u0013Qb\u00117jK:$8+Z:tS>t\u0017aE;qI\u0006$Xm\u00117jK:$8+Z:tS>tGCA'T!\tq\u0015+D\u0001P\u0015\u0005\u0001\u0016!B:dC2\f\u0017B\u0001*P\u0005\u0011)f.\u001b;\t\u000b5)\u0001\u0019\u0001+\u0011\u0005\r+\u0016B\u0001,E\u0005=\u0019F/\u0019;f[\u0016tGo\u00117jK:$\u0018aB3yK\u000e,H/\u001a\u000b\u00033&\u00042A\u00172f\u001d\tY\u0006M\u0004\u0002]?6\tQL\u0003\u0002_-\u00051AH]8pizJ\u0011\u0001U\u0005\u0003C>\u000bq\u0001]1dW\u0006<W-\u0003\u0002dI\n!A*[:u\u0015\t\tw\nE\u0002[E\u001a\u0004\"AT4\n\u0005!|%aA!os\")QB\u0002a\u0001)\u00069r-\u001a;Ue&twn\u0015;bi\u0016lWM\u001c;DY&,g\u000e\u001e\u000b\u0003)2DQ!\\\u0004A\u00029\f1a]9m!\ty7O\u0004\u0002qcB\u0011AlT\u0005\u0003e>\u000ba\u0001\u0015:fI\u00164\u0017B\u0001;v\u0005\u0019\u0019FO]5oO*\u0011!oT\u0001\u0018GJ,\u0017\r^3UKN$8\t\\5f]R\u001cVm]:j_:$\"A\u0011=\t\u000beD\u0001\u0019\u0001>\u0002\u0015\r|gN\\3diV\u0013H\u000e\u0005\u0002|}6\tAP\u0003\u0002~}\u0005\u0019a.\u001a;\n\u0005}d(aA+S\u0013\u0002")
public class TrinoClientApiSuite
extends AnyFunSuite
implements TrinoRestFrontendTestHelper {
    private AtomicReference<ClientSession> clientSession;
    private final OkHttpClient httpClient;
    private final Seq<Enumeration.Value> frontendProtocols;
    private final JerseyTest restApiBaseSuite;
    private KyuubiConf conf;
    private AbstractFrontendService fe;
    private URI baseUri;
    private WebTarget webTarget;
    private EmbeddedZookeeper org$apache$kyuubi$WithKyuubiServer$$zkServer;
    private KyuubiServer server;
    private volatile KyuubiFunSuite$LogAppender$ LogAppender$module;
    private scala.collection.immutable.Set<String> org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile byte bitmap$0;

    @Override
    public /* synthetic */ void org$apache$kyuubi$RestFrontendTestHelper$$super$beforeAll() {
        WithKyuubiServer.beforeAll$(this);
    }

    @Override
    public /* synthetic */ void org$apache$kyuubi$RestFrontendTestHelper$$super$afterAll() {
        WithKyuubiServer.afterAll$(this);
    }

    @Override
    public void beforeAll() {
        RestFrontendTestHelper.beforeAll$(this);
    }

    @Override
    public void afterAll() {
        RestFrontendTestHelper.afterAll$(this);
    }

    @Override
    public Response v1Call(String func) {
        return RestFrontendTestHelper.v1Call$(this, func);
    }

    @Override
    public /* synthetic */ void org$apache$kyuubi$WithKyuubiServer$$super$beforeAll() {
        KyuubiFunSuite.beforeAll$((KyuubiFunSuite)this);
    }

    @Override
    public /* synthetic */ void org$apache$kyuubi$WithKyuubiServer$$super$afterAll() {
        KyuubiFunSuite.afterAll$((KyuubiFunSuite)this);
    }

    @Override
    public String getJdbcUrl() {
        return WithKyuubiServer.getJdbcUrl$(this);
    }

    public /* synthetic */ void org$apache$kyuubi$KyuubiFunSuite$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public /* synthetic */ void org$apache$kyuubi$KyuubiFunSuite$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    public final Outcome withFixture(TestSuite.NoArgTest test) {
        return KyuubiFunSuite.withFixture$((KyuubiFunSuite)this, (TestSuite.NoArgTest)test);
    }

    public final void withLogAppender(AbstractAppender appender, Seq<String> loggerNames, Option<Level> level, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withLogAppender$((KyuubiFunSuite)this, (AbstractAppender)appender, loggerNames, level, f);
    }

    public final Seq<String> withLogAppender$default$2() {
        return KyuubiFunSuite.withLogAppender$default$2$((KyuubiFunSuite)this);
    }

    public final Option<Level> withLogAppender$default$3() {
        return KyuubiFunSuite.withLogAppender$default$3$((KyuubiFunSuite)this);
    }

    public final void withSystemProperty(scala.collection.immutable.Map<String, String> properties, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withSystemProperty$((KyuubiFunSuite)this, properties, f);
    }

    public final void withSystemProperty(String key, String value, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withSystemProperty$((KyuubiFunSuite)this, (String)key, (String)value, f);
    }

    public final void setSystemProperty(String key, String value) {
        KyuubiFunSuite.setSystemProperty$((KyuubiFunSuite)this, (String)key, (String)value);
    }

    public void doThreadPreAudit() {
        ThreadAudit.doThreadPreAudit$((ThreadAudit)this);
    }

    public void doThreadPostAudit() {
        ThreadAudit.doThreadPostAudit$((ThreadAudit)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    @Override
    public Seq<Enumeration.Value> frontendProtocols() {
        return this.frontendProtocols;
    }

    @Override
    public JerseyTest restApiBaseSuite() {
        return this.restApiBaseSuite;
    }

    @Override
    public void org$apache$kyuubi$TrinoRestFrontendTestHelper$_setter_$frontendProtocols_$eq(Seq<Enumeration.Value> x$1) {
        this.frontendProtocols = x$1;
    }

    @Override
    public void org$apache$kyuubi$TrinoRestFrontendTestHelper$_setter_$restApiBaseSuite_$eq(JerseyTest x$1) {
        this.restApiBaseSuite = x$1;
    }

    private KyuubiConf conf$lzycompute() {
        TrinoClientApiSuite trinoClientApiSuite = this;
        synchronized (trinoClientApiSuite) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.conf = RestFrontendTestHelper.conf$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.conf;
    }

    @Override
    public KyuubiConf conf() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.conf$lzycompute();
        }
        return this.conf;
    }

    private AbstractFrontendService fe$lzycompute() {
        TrinoClientApiSuite trinoClientApiSuite = this;
        synchronized (trinoClientApiSuite) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.fe = RestFrontendTestHelper.fe$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.fe;
    }

    @Override
    public AbstractFrontendService fe() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.fe$lzycompute();
        }
        return this.fe;
    }

    private URI baseUri$lzycompute() {
        TrinoClientApiSuite trinoClientApiSuite = this;
        synchronized (trinoClientApiSuite) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.baseUri = RestFrontendTestHelper.baseUri$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.baseUri;
    }

    @Override
    public URI baseUri() {
        if ((byte)(this.bitmap$0 & 8) == 0) {
            return this.baseUri$lzycompute();
        }
        return this.baseUri;
    }

    private WebTarget webTarget$lzycompute() {
        TrinoClientApiSuite trinoClientApiSuite = this;
        synchronized (trinoClientApiSuite) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.webTarget = RestFrontendTestHelper.webTarget$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.webTarget;
    }

    @Override
    public WebTarget webTarget() {
        if ((byte)(this.bitmap$0 & 0x10) == 0) {
            return this.webTarget$lzycompute();
        }
        return this.webTarget;
    }

    @Override
    public void org$apache$kyuubi$RestFrontendTestHelper$_setter_$frontendProtocols_$eq(Seq<Enumeration.Value> x$1) {
    }

    @Override
    public void org$apache$kyuubi$RestFrontendTestHelper$_setter_$restApiBaseSuite_$eq(JerseyTest x$1) {
    }

    @Override
    public EmbeddedZookeeper org$apache$kyuubi$WithKyuubiServer$$zkServer() {
        return this.org$apache$kyuubi$WithKyuubiServer$$zkServer;
    }

    @Override
    public void org$apache$kyuubi$WithKyuubiServer$$zkServer_$eq(EmbeddedZookeeper x$1) {
        this.org$apache$kyuubi$WithKyuubiServer$$zkServer = x$1;
    }

    @Override
    public KyuubiServer server() {
        return this.server;
    }

    @Override
    public void server_$eq(KyuubiServer x$1) {
        this.server = x$1;
    }

    @Override
    public void org$apache$kyuubi$WithKyuubiServer$_setter_$frontendProtocols_$eq(Seq<Enumeration.Value> x$1) {
    }

    public KyuubiFunSuite$LogAppender$ LogAppender() {
        if (this.LogAppender$module == null) {
            this.LogAppender$lzycompute$1();
        }
        return this.LogAppender$module;
    }

    public scala.collection.immutable.Set<String> org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot() {
        return this.org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot;
    }

    public void org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot_$eq(scala.collection.immutable.Set<String> x$1) {
        this.org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot = x$1;
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private OkHttpClient httpClient() {
        return this.httpClient;
    }

    private AtomicReference<ClientSession> clientSession$lzycompute() {
        TrinoClientApiSuite trinoClientApiSuite = this;
        synchronized (trinoClientApiSuite) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.clientSession = new AtomicReference<ClientSession>(this.createTestClientSession(this.baseUri()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.clientSession;
    }

    private AtomicReference<ClientSession> clientSession() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.clientSession$lzycompute();
        }
        return this.clientSession;
    }

    private void updateClientSession(StatementClient trino) {
        ClientSession session = this.clientSession().get();
        ClientSession.Builder builder = ClientSession.builder((ClientSession)session);
        if (trino.getSetCatalog().isPresent() || trino.getSetSchema().isPresent()) {
            builder = builder.withCatalog(trino.getSetCatalog().orElse(session.getCatalog())).withSchema(trino.getSetSchema().orElse(session.getSchema()));
        }
        if (trino.getSetPath().isPresent()) {
            builder = builder.withPath((String)trino.getSetPath().get());
        }
        if (!trino.getSetSessionProperties().isEmpty() || !trino.getResetSessionProperties().isEmpty()) {
            scala.collection.mutable.Map properties = ((scala.collection.mutable.MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(session.getProperties()).asScala()).clone();
            properties.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.mapAsScalaMapConverter(trino.getSetSessionProperties()).asScala());
            properties.$minus$minus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(trino.getResetSessionProperties()).asScala());
            builder = builder.withProperties((java.util.Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(properties).asJava());
        }
        this.clientSession().set(builder.build());
    }

    private List<List<Object>> execute(StatementClient trino) {
        return package$.MODULE$.Iterator().continually((Function0 & Serializable & scala.Serializable)() -> this.getData$1(trino)).takeWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2._1$mcZ$sp())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (List)x$3._2()).toList();
    }

    private StatementClient getTrinoStatementClient(String sql) {
        return StatementClientFactory.newStatementClient((OkHttpClient)this.httpClient(), (ClientSession)this.clientSession().get(), (String)sql);
    }

    private ClientSession createTestClientSession(URI connectUrl) {
        return new ClientSession(connectUrl, "kyuubi_test", Optional.of("test_user"), "kyuubi", Optional.of("test_token_tracing"), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$)).asJava(), "test_client_info", "test_catalog", "test_schema", null, ZoneId.systemDefault(), Locale.getDefault(), Collections.emptyMap(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_property_key0"), (Object)"test_property_value0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_property_key1"), (Object)"test_propert_value1")}))).asJava(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_statement_key0"), (Object)"select 1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"test_statement_key1"), (Object)"select 2")}))).asJava(), Collections.emptyMap(), Collections.emptyMap(), null, new Duration(2.0, TimeUnit.MINUTES), true);
    }

    private final void LogAppender$lzycompute$1() {
        TrinoClientApiSuite trinoClientApiSuite = this;
        synchronized (trinoClientApiSuite) {
            if (this.LogAppender$module == null) {
                this.LogAppender$module = new KyuubiFunSuite$LogAppender$((KyuubiFunSuite)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        TrinoClientApiSuite trinoClientApiSuite = this;
        synchronized (trinoClientApiSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    private final Tuple2 getData$1(StatementClient trino) {
        while (trino.isRunning()) {
            Iterable data = trino.currentData().getData();
            trino.advance();
            if (data == null) continue;
            return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(data).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(x$1).asScala()).toList(), List$.MODULE$.canBuildFrom()));
        }
        Verify.verify((boolean)trino.isFinished());
        QueryStatusInfo finalStatus = trino.finalStatusInfo();
        if (finalStatus.getError() != null) {
            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(15).append("Query ").append(finalStatus.getId()).append(" failed: ").append(finalStatus.getError().getMessage()).toString(), KyuubiSQLException$.MODULE$.apply$default$2(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
        }
        return new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)Nil$.MODULE$);
    }

    public TrinoClientApiSuite() {
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        Logging.$init$((Logging)this);
        ThreadAudit.$init$((ThreadAudit)this);
        KyuubiFunSuite.$init$((KyuubiFunSuite)this);
        WithKyuubiServer.$init$(this);
        RestFrontendTestHelper.$init$(this);
        TrinoRestFrontendTestHelper.$init$(this);
        this.httpClient = new OkHttpClient.Builder().readTimeout(5L, TimeUnit.MINUTES).build();
        this.test("submit query with trino client api", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            StatementClient trino = this.getTrinoStatementClient("select 1");
            List<List<Object>> result = this.execute(trino);
            Option sessionId = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(trino.getSetSessionProperties()).asScala()).get((Object)Query$.MODULE$.KYUUBI_SESSION_ID());
            List<List<Object>> $org_scalatest_assert_macro_left = result;
            .colon.colon $org_scalatest_assert_macro_right = new .colon.colon((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (List)Nil$.MODULE$);
            List<List<Object>> list = $org_scalatest_assert_macro_left;
            .colon.colon colon2 = $org_scalatest_assert_macro_right;
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(list != null ? !list.equals((Object)colon2) : colon2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TrinoClientApiSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
            this.updateClientSession(trino);
            StatementClient trino1 = this.getTrinoStatementClient("set k=v");
            List<List<Object>> result1 = this.execute(trino1);
            Option sessionId1 = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(trino1.getSetSessionProperties()).asScala()).get((Object)Query$.MODULE$.KYUUBI_SESSION_ID());
            List<List<Object>> $org_scalatest_assert_macro_left2 = result1;
            .colon.colon $org_scalatest_assert_macro_right2 = new .colon.colon((Object)new .colon.colon((Object)"k", (List)new .colon.colon((Object)"v", (List)Nil$.MODULE$)), (List)Nil$.MODULE$);
            List<List<Object>> list2 = $org_scalatest_assert_macro_left2;
            .colon.colon colon3 = $org_scalatest_assert_macro_right2;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left2, "==", (Object)$org_scalatest_assert_macro_right2, !(list2 != null ? !list2.equals((Object)colon3) : colon3 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TrinoClientApiSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 56));
            Option $org_scalatest_assert_macro_left3 = sessionId;
            Option $org_scalatest_assert_macro_right3 = sessionId1;
            Option option = $org_scalatest_assert_macro_left3;
            Option option2 = $org_scalatest_assert_macro_right3;
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "==", (Object)$org_scalatest_assert_macro_right3, !(option != null ? !option.equals(option2) : option2 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TrinoClientApiSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
            this.updateClientSession(trino);
            StatementClient trino2 = this.getTrinoStatementClient("set k");
            List<List<Object>> result2 = this.execute(trino2);
            Option sessionId2 = ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(trino2.getSetSessionProperties()).asScala()).get((Object)Query$.MODULE$.KYUUBI_SESSION_ID());
            List<List<Object>> $org_scalatest_assert_macro_left4 = result2;
            .colon.colon $org_scalatest_assert_macro_right4 = new .colon.colon((Object)new .colon.colon((Object)"k", (List)new .colon.colon((Object)"v", (List)Nil$.MODULE$)), (List)Nil$.MODULE$);
            List<List<Object>> list3 = $org_scalatest_assert_macro_left4;
            .colon.colon colon4 = $org_scalatest_assert_macro_right4;
            Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left4, "==", (Object)$org_scalatest_assert_macro_right4, !(list3 != null ? !list3.equals((Object)colon4) : colon4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TrinoClientApiSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
            Option $org_scalatest_assert_macro_left5 = sessionId;
            Option $org_scalatest_assert_macro_right5 = sessionId2;
            Option option3 = $org_scalatest_assert_macro_left5;
            Option option4 = $org_scalatest_assert_macro_right5;
            Bool $org_scalatest_assert_macro_expr5 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "==", (Object)$org_scalatest_assert_macro_right5, !(option3 != null ? !option3.equals(option4) : option4 != null), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr5, (Object)"", Prettifier$.MODULE$.default(), new Position("TrinoClientApiSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
            trino.close();
        }, new Position("TrinoClientApiSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
    }
}

