/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.session;

import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.LongAdder;
import org.apache.kyuubi.KyuubiFunSuite;
import org.apache.kyuubi.KyuubiFunSuite$LogAppender$;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.ThreadAudit;
import org.apache.kyuubi.session.SessionLimiter;
import org.apache.kyuubi.session.SessionLimiter$;
import org.apache.kyuubi.session.SessionLimiterImpl;
import org.apache.kyuubi.session.UserIpAddress;
import org.apache.kyuubi.util.ThreadUtils$;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Equality$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.Assertions$;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.BeforeAndAfterEach;
import org.scalatest.Outcome;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.TestSuite;
import org.scalatest.concurrent.AbstractPatienceConfiguration;
import org.scalatest.concurrent.AbstractPatienceConfiguration$PatienceConfig$;
import org.scalatest.concurrent.Eventually;
import org.scalatest.concurrent.PatienceConfiguration;
import org.scalatest.concurrent.ScaledTimeSpans;
import org.scalatest.enablers.Retrying;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.scalatest.time.Span;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0001u1AAA\u0002\u0001\u0019!)\u0011\u0004\u0001C\u00015\t\u00192+Z:tS>tG*[7ji\u0016\u00148+^5uK*\u0011A!B\u0001\bg\u0016\u001c8/[8o\u0015\t1q!\u0001\u0004lsV,(-\u001b\u0006\u0003\u0011%\ta!\u00199bG\",'\"\u0001\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001iQ\u0003\u0005\u0002\u000f'5\tqB\u0003\u0002\u0011#\u0005Aa-\u001e8tk&$XM\u0003\u0002\u0013\u0013\u0005I1oY1mCR,7\u000f^\u0005\u0003)=\u00111\"\u00118z\rVt7+^5uKB\u0011acF\u0007\u0002\u000b%\u0011\u0001$\u0002\u0002\u000f\u0017f,XOY5Gk:\u001cV/\u001b;f\u0003\u0019a\u0014N\\5u}Q\t1\u0004\u0005\u0002\u001d\u00015\t1\u0001")
public class SessionLimiterSuite
extends AnyFunSuite
implements KyuubiFunSuite {
    private volatile KyuubiFunSuite$LogAppender$ LogAppender$module;
    private Set<String> org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private final AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    private volatile AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig$module;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;

    public /* synthetic */ void org$apache$kyuubi$KyuubiFunSuite$$super$beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public /* synthetic */ void org$apache$kyuubi$KyuubiFunSuite$$super$afterAll() {
        BeforeAndAfterAll.afterAll$((BeforeAndAfterAll)this);
    }

    public void beforeAll() {
        KyuubiFunSuite.beforeAll$((KyuubiFunSuite)this);
    }

    public void afterAll() {
        KyuubiFunSuite.afterAll$((KyuubiFunSuite)this);
    }

    public final Outcome withFixture(TestSuite.NoArgTest test) {
        return KyuubiFunSuite.withFixture$((KyuubiFunSuite)this, (TestSuite.NoArgTest)test);
    }

    public final void withLogAppender(AbstractAppender appender, Seq<String> loggerNames, Option<Level> level, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withLogAppender$((KyuubiFunSuite)this, (AbstractAppender)appender, loggerNames, level, f);
    }

    public final Seq<String> withLogAppender$default$2() {
        return KyuubiFunSuite.withLogAppender$default$2$((KyuubiFunSuite)this);
    }

    public final Option<Level> withLogAppender$default$3() {
        return KyuubiFunSuite.withLogAppender$default$3$((KyuubiFunSuite)this);
    }

    public final void withSystemProperty(Map<String, String> properties, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withSystemProperty$((KyuubiFunSuite)this, properties, f);
    }

    public final void withSystemProperty(String key, String value, Function0<BoxedUnit> f) {
        KyuubiFunSuite.withSystemProperty$((KyuubiFunSuite)this, (String)key, (String)value, f);
    }

    public final void setSystemProperty(String key, String value) {
        KyuubiFunSuite.setSystemProperty$((KyuubiFunSuite)this, (String)key, (String)value);
    }

    public void doThreadPreAudit() {
        ThreadAudit.doThreadPreAudit$((ThreadAudit)this);
    }

    public void doThreadPostAudit() {
        ThreadAudit.doThreadPostAudit$((ThreadAudit)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, PatienceConfiguration.Interval interval, Function0<T> fun, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, (PatienceConfiguration.Interval)interval, fun, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Timeout timeout, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Timeout)timeout, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(PatienceConfiguration.Interval interval, Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, (PatienceConfiguration.Interval)interval, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public <T> T eventually(Function0<T> fun, AbstractPatienceConfiguration.PatienceConfig config, Retrying<T> retrying, Position pos) {
        return (T)Eventually.eventually$((Eventually)this, fun, (AbstractPatienceConfiguration.PatienceConfig)config, retrying, (Position)pos);
    }

    public AbstractPatienceConfiguration.PatienceConfig patienceConfig() {
        return PatienceConfiguration.patienceConfig$((PatienceConfiguration)this);
    }

    public PatienceConfiguration.Timeout timeout(Span value) {
        return PatienceConfiguration.timeout$((PatienceConfiguration)this, (Span)value);
    }

    public PatienceConfiguration.Interval interval(Span value) {
        return PatienceConfiguration.interval$((PatienceConfiguration)this, (Span)value);
    }

    public final Span scaled(Span span) {
        return ScaledTimeSpans.scaled$((ScaledTimeSpans)this, (Span)span);
    }

    public double spanScaleFactor() {
        return ScaledTimeSpans.spanScaleFactor$((ScaledTimeSpans)this);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterEach$$super$runTest(String testName, Args args) {
        return AnyFunSuiteLike.runTest$((AnyFunSuiteLike)this, (String)testName, (Args)args);
    }

    public void beforeEach() {
        BeforeAndAfterEach.beforeEach$((BeforeAndAfterEach)this);
    }

    public void afterEach() {
        BeforeAndAfterEach.afterEach$((BeforeAndAfterEach)this);
    }

    public Status runTest(String testName, Args args) {
        return BeforeAndAfterEach.runTest$((BeforeAndAfterEach)this, (String)testName, (Args)args);
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public KyuubiFunSuite$LogAppender$ LogAppender() {
        if (this.LogAppender$module == null) {
            this.LogAppender$lzycompute$1();
        }
        return this.LogAppender$module;
    }

    public Set<String> org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot() {
        return this.org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot;
    }

    public void org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot_$eq(Set<String> x$1) {
        this.org$apache$kyuubi$ThreadAudit$$threadNamesSnapshot = x$1;
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public AbstractPatienceConfiguration.PatienceConfig org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig() {
        return this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig;
    }

    public final void org$scalatest$concurrent$PatienceConfiguration$_setter_$org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig_$eq(AbstractPatienceConfiguration.PatienceConfig x$1) {
        this.org$scalatest$concurrent$PatienceConfiguration$$defaultPatienceConfig = x$1;
    }

    public AbstractPatienceConfiguration$PatienceConfig$ PatienceConfig() {
        if (this.PatienceConfig$module == null) {
            this.PatienceConfig$lzycompute$1();
        }
        return this.PatienceConfig$module;
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private final void LogAppender$lzycompute$1() {
        SessionLimiterSuite sessionLimiterSuite = this;
        synchronized (sessionLimiterSuite) {
            if (this.LogAppender$module == null) {
                this.LogAppender$module = new KyuubiFunSuite$LogAppender$((KyuubiFunSuite)this);
            }
        }
    }

    private final void PatienceConfig$lzycompute$1() {
        SessionLimiterSuite sessionLimiterSuite = this;
        synchronized (sessionLimiterSuite) {
            if (this.PatienceConfig$module == null) {
                this.PatienceConfig$module = new AbstractPatienceConfiguration$PatienceConfig$((AbstractPatienceConfiguration)this);
            }
        }
    }

    private final void checkLimit$1(UserIpAddress userIpAddress, int expectedIndex, String expectedErrorMsg, int userLimit$1, int ipAddressLimit$1, int userIpAddressLimit$1, ExecutorService threadPool$1) {
        SessionLimiter limiter = SessionLimiter$.MODULE$.apply(userLimit$1, ipAddressLimit$1, userIpAddressLimit$1, SessionLimiter$.MODULE$.apply$default$4(), SessionLimiter$.MODULE$.apply$default$5());
        LongAdder successAdder = new LongAdder();
        LongAdder expectedErrorAdder = new LongAdder();
        int count = 50;
        CountDownLatch latch = new CountDownLatch(count);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> threadPool$1.execute(() -> {
            block7: {
                try {
                    try {
                        limiter.increment(userIpAddress);
                        successAdder.increment();
                    }
                    catch (Throwable throwable) {
                        KyuubiSQLException kyuubiSQLException;
                        Throwable throwable2 = throwable;
                        if (throwable2 instanceof KyuubiSQLException && this.convertToEqualizer((kyuubiSQLException = (KyuubiSQLException)throwable2).getMessage()).$eq$eq$eq((Object)expectedErrorMsg, Equality$.MODULE$.default())) {
                            expectedErrorAdder.increment();
                            break block7;
                        }
                        if (throwable2 != null) {
                            break block7;
                        }
                        throw throwable;
                    }
                }
                finally {
                    latch.countDown();
                }
            }
        }));
        latch.await();
        int $org_scalatest_assert_macro_left = successAdder.intValue();
        int $org_scalatest_assert_macro_right = expectedIndex;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        int $org_scalatest_assert_macro_left2 = expectedErrorAdder.intValue();
        int $org_scalatest_assert_macro_right2 = count - expectedIndex;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == $org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
    }

    private static final void checkUserLimit$1(UserIpAddress userIpAddress, ThreadPoolExecutor threadPool$2, Random random$1, SessionLimiter limiter$5, CountDownLatch latch$2) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 200).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> threadPool$2.execute(() -> {
            try {
                try {
                    Thread.sleep(random$1.nextInt(200));
                    limiter$5.increment(userIpAddress);
                }
                catch (Throwable throwable) {}
            }
            finally {
                Thread.sleep(random$1.nextInt(500));
                limiter$5.decrement(userIpAddress);
                latch$2.countDown();
            }
        }));
    }

    public SessionLimiterSuite() {
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        BeforeAndAfterEach.$init$((BeforeAndAfterEach)this);
        ScaledTimeSpans.$init$((ScaledTimeSpans)this);
        AbstractPatienceConfiguration.$init$((AbstractPatienceConfiguration)this);
        PatienceConfiguration.$init$((PatienceConfiguration)this);
        Eventually.$init$((Eventually)this);
        Logging.$init$((Logging)this);
        ThreadAudit.$init$((ThreadAudit)this);
        KyuubiFunSuite.$init$((KyuubiFunSuite)this);
        this.test("test increment session limit", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String user = "user001";
            String ipAddress = "127.0.0.1";
            int userLimit = 30;
            int ipAddressLimit = 20;
            int userIpAddressLimit = 10;
            ExecutorService threadPool = Executors.newFixedThreadPool(10);
            this.checkLimit$1(new UserIpAddress(user, null), userLimit, new StringBuilder(50).append("Connection limit per user reached (user: ").append(user).append(" limit: ").append(userLimit).append(")").toString(), userLimit, ipAddressLimit, userIpAddressLimit, threadPool);
            this.checkLimit$1(new UserIpAddress(null, ipAddress), ipAddressLimit, new StringBuilder(60).append("Connection limit per ipaddress reached (ipaddress: ").append(ipAddress).append(" limit: ").append(ipAddressLimit).append(")").toString(), userLimit, ipAddressLimit, userIpAddressLimit, threadPool);
            this.checkLimit$1(new UserIpAddress(user, ipAddress), userIpAddressLimit, new StringBuilder(71).append("Connection limit per user:ipaddress reached").append(" (user:ipaddress: ").append(user).append(":").append(ipAddress).append(" limit: ").append(userIpAddressLimit).append(")").toString(), userLimit, ipAddressLimit, userIpAddressLimit, threadPool);
            threadPool.shutdown();
        }, new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 30));
        this.test("test increment and decrement session", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String user = "user001";
            String ipAddress = "127.0.0.1";
            int userLimit = 30;
            int ipAddressLimit = 20;
            int userIpAddressLimit = 10;
            SessionLimiter limiter = SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, SessionLimiter$.MODULE$.apply$default$4(), SessionLimiter$.MODULE$.apply$default$5());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                UserIpAddress userIpAddress = new UserIpAddress(user, ipAddress);
                limiter.increment(userIpAddress);
                limiter.decrement(userIpAddress);
            });
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((SessionLimiterImpl)limiter).counters()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)c -> {
                int $org_scalatest_assert_macro_left = c.get();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
            });
        }, new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 86));
        this.test("test session limiter with user unlimited list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String user = "user001";
            String ipAddress = "127.0.0.1";
            int userLimit = 30;
            int ipAddressLimit = 20;
            int userIpAddressLimit = 10;
            SessionLimiter limiter = SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{user})), SessionLimiter$.MODULE$.apply$default$5());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                UserIpAddress userIpAddress = new UserIpAddress(user, ipAddress);
                limiter.increment(userIpAddress);
            });
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((SessionLimiterImpl)limiter).counters()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)c -> {
                int $org_scalatest_assert_macro_left = c.get();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                UserIpAddress userIpAddress = new UserIpAddress(user, ipAddress);
                limiter.decrement(userIpAddress);
            });
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((SessionLimiterImpl)limiter).counters()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)c -> {
                int $org_scalatest_assert_macro_left = c.get();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 120));
            });
        }, new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("test session limiter with user deny list", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0 & Serializable & scala.Serializable)() -> {
            String ipAddress = "127.0.0.1";
            int userLimit = 100;
            int ipAddressLimit = 100;
            int userIpAddressLimit = 100;
            Set denyUsers = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user002", "user003"}));
            SessionLimiter limiter = SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, Predef$.MODULE$.Set().empty(), denyUsers);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                UserIpAddress userIpAddress = new UserIpAddress("user001", ipAddress);
                limiter.increment(userIpAddress);
            });
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((SessionLimiterImpl)limiter).counters()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)c -> {
                int $org_scalatest_assert_macro_left = c.get();
                int $org_scalatest_assert_macro_right = 50;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
            });
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
                UserIpAddress userIpAddress = new UserIpAddress("user001", ipAddress);
                limiter.decrement(userIpAddress);
            });
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((SessionLimiterImpl)limiter).counters()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)c -> {
                int $org_scalatest_assert_macro_left = c.get();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
            });
            KyuubiSQLException caught = (KyuubiSQLException)this.intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                UserIpAddress userIpAddress = new UserIpAddress("user002", ipAddress);
                limiter.increment(userIpAddress);
            }, ClassTag$.MODULE$.apply(KyuubiSQLException.class), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 146));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(caught.getMessage().equals("Connection denied because the user is in the deny user list. (user: user002)"), "caught.getMessage().equals(\"Connection denied because the user is in the deny user list. (user: user002)\")", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 151));
        }, new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 123));
        this.test("test refresh unlimited users and deny users", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Random random = new Random();
            CountDownLatch latch = new CountDownLatch(600);
            int userLimit = 100;
            int ipAddressLimit = 101;
            int userIpAddressLimit = 102;
            SessionLimiter limiter = SessionLimiter$.MODULE$.apply(userLimit, ipAddressLimit, userIpAddressLimit, Predef$.MODULE$.Set().empty(), Predef$.MODULE$.Set().empty());
            ThreadPoolExecutor threadPool = ThreadUtils$.MODULE$.newDaemonCachedThreadPool("test-refresh-config");
            SessionLimiterSuite.checkUserLimit$1(new UserIpAddress("user001", "127.0.0.1"), threadPool, random, limiter, latch);
            SessionLimiterSuite.checkUserLimit$1(new UserIpAddress("user002", "127.0.0.2"), threadPool, random, limiter, latch);
            SessionLimiterSuite.checkUserLimit$1(new UserIpAddress("user003", "127.0.0.3"), threadPool, random, limiter, latch);
            Thread.sleep(100L);
            SessionLimiter$.MODULE$.resetUnlimitedUsers(limiter, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user001"})));
            SessionLimiter$.MODULE$.resetDenyUsers(limiter, (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"user002"})));
            Thread.sleep(300L);
            SessionLimiter$.MODULE$.resetUnlimitedUsers(limiter, Predef$.MODULE$.Set().empty());
            SessionLimiter$.MODULE$.resetDenyUsers(limiter, Predef$.MODULE$.Set().empty());
            latch.await();
            threadPool.shutdown();
            ((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(((SessionLimiterImpl)limiter).counters()).asScala()).values().foreach((Function1 & Serializable & scala.Serializable)c -> {
                int $org_scalatest_assert_macro_left = c.get();
                int $org_scalatest_assert_macro_right = 0;
                Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == $org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
                return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            });
        }, new Position("SessionLimiterSuite.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 155));
    }
}

