/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.curator.framework.imps;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.apache.kyuubi.shaded.curator.RetryLoop;
import org.apache.kyuubi.shaded.curator.drivers.OperationTrace;
import org.apache.kyuubi.shaded.curator.framework.api.ACLable;
import org.apache.kyuubi.shaded.curator.framework.api.BackgroundCallback;
import org.apache.kyuubi.shaded.curator.framework.api.BackgroundPathable;
import org.apache.kyuubi.shaded.curator.framework.api.CuratorEventType;
import org.apache.kyuubi.shaded.curator.framework.api.ErrorListenerPathable;
import org.apache.kyuubi.shaded.curator.framework.api.Pathable;
import org.apache.kyuubi.shaded.curator.framework.api.SetACLBuilder;
import org.apache.kyuubi.shaded.curator.framework.api.UnhandledErrorListener;
import org.apache.kyuubi.shaded.curator.framework.imps.ACLing;
import org.apache.kyuubi.shaded.curator.framework.imps.BackgroundOperation;
import org.apache.kyuubi.shaded.curator.framework.imps.Backgrounding;
import org.apache.kyuubi.shaded.curator.framework.imps.CuratorEventImpl;
import org.apache.kyuubi.shaded.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.kyuubi.shaded.curator.framework.imps.OperationAndData;
import org.apache.kyuubi.shaded.zookeeper.AsyncCallback;
import org.apache.kyuubi.shaded.zookeeper.data.ACL;
import org.apache.kyuubi.shaded.zookeeper.data.Stat;

public class SetACLBuilderImpl
implements SetACLBuilder,
BackgroundPathable<Stat>,
BackgroundOperation<String>,
ErrorListenerPathable<Stat> {
    private final CuratorFrameworkImpl client;
    private ACLing acling;
    private Backgrounding backgrounding;
    private int version;

    SetACLBuilderImpl(CuratorFrameworkImpl client) {
        this.client = client;
        this.backgrounding = new Backgrounding();
        this.acling = new ACLing(client.getAclProvider());
        this.version = -1;
    }

    public SetACLBuilderImpl(CuratorFrameworkImpl client, Backgrounding backgrounding, List<ACL> aclList, int version) {
        this.client = client;
        this.acling = new ACLing(client.getAclProvider(), aclList);
        this.version = version;
        this.backgrounding = backgrounding;
    }

    @Override
    public BackgroundPathable<Stat> withACL(List<ACL> aclList) {
        this.acling = new ACLing(this.client.getAclProvider(), aclList, false);
        return this;
    }

    @Override
    public ACLable<BackgroundPathable<Stat>> withVersion(int version) {
        this.version = version;
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground() {
        this.backgrounding = new Backgrounding(true);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(Object context) {
        this.backgrounding = new Backgrounding(context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback) {
        this.backgrounding = new Backgrounding(callback);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context) {
        this.backgrounding = new Backgrounding(callback, context);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Object context, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, context, executor);
        return this;
    }

    @Override
    public ErrorListenerPathable<Stat> inBackground(BackgroundCallback callback, Executor executor) {
        this.backgrounding = new Backgrounding(this.client, callback, executor);
        return this;
    }

    @Override
    public Pathable<Stat> withUnhandledErrorListener(UnhandledErrorListener listener) {
        this.backgrounding = new Backgrounding(this.backgrounding, listener);
        return this;
    }

    @Override
    public Stat forPath(String path) throws Exception {
        String fixedPath = this.client.fixForNamespace(path);
        List<ACL> aclList = this.acling.getAclList(fixedPath);
        this.client.getSchemaSet().getSchema(path).validateGeneral(path, null, aclList);
        Stat resultStat = null;
        if (this.backgrounding.inBackground()) {
            this.client.processBackgroundOperation(new OperationAndData<String>(this, fixedPath, this.backgrounding.getCallback(), null, this.backgrounding.getContext(), null), null);
        } else {
            resultStat = this.pathInForeground(fixedPath, aclList);
        }
        return resultStat;
    }

    @Override
    public void performBackgroundOperation(final OperationAndData<String> operationAndData) throws Exception {
        try {
            final OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SetACLBuilderImpl-Background");
            String path = operationAndData.getData();
            this.client.getZooKeeper().setACL(path, this.acling.getAclList(path), this.version, new AsyncCallback.StatCallback(){

                @Override
                public void processResult(int rc, String path, Object ctx, Stat stat) {
                    trace.setReturnCode(rc).setPath(path).setStat(stat).commit();
                    CuratorEventImpl event = new CuratorEventImpl(SetACLBuilderImpl.this.client, CuratorEventType.SET_ACL, rc, path, null, ctx, stat, null, null, null, null, null);
                    SetACLBuilderImpl.this.client.processBackgroundOperation(operationAndData, event);
                }
            }, this.backgrounding.getContext());
        }
        catch (Throwable e) {
            this.backgrounding.checkError(e, null);
        }
    }

    private Stat pathInForeground(final String path, final List<ACL> aclList) throws Exception {
        OperationTrace trace = this.client.getZookeeperClient().startAdvancedTracer("SetACLBuilderImpl-Foreground");
        Stat resultStat = RetryLoop.callWithRetry(this.client.getZookeeperClient(), new Callable<Stat>(){

            @Override
            public Stat call() throws Exception {
                return SetACLBuilderImpl.this.client.getZooKeeper().setACL(path, aclList, SetACLBuilderImpl.this.version);
            }
        });
        trace.setPath(path).setStat(resultStat).commit();
        return resultStat;
    }
}

