/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.curator.framework.recipes.locks;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kyuubi.shaded.curator.framework.CuratorFramework;
import org.apache.kyuubi.shaded.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.kyuubi.shaded.curator.framework.recipes.locks.LockInternalsDriver;
import org.apache.kyuubi.shaded.curator.framework.recipes.locks.PredicateResults;
import org.apache.kyuubi.shaded.curator.framework.recipes.locks.StandardLockInternalsDriver;
import org.apache.kyuubi.shaded.curator.shaded.com.google.common.base.Predicate;
import org.apache.kyuubi.shaded.curator.shaded.com.google.common.collect.ImmutableList;
import org.apache.kyuubi.shaded.curator.shaded.com.google.common.collect.Iterables;

public class InterProcessReadWriteLock {
    private final ReadLock readMutex;
    private final WriteLock writeMutex;
    private static final String READ_LOCK_NAME = "__READ__";
    private static final String WRITE_LOCK_NAME = "__WRIT__";

    public InterProcessReadWriteLock(CuratorFramework client, String basePath) {
        this(client, basePath, null);
    }

    public InterProcessReadWriteLock(CuratorFramework client, String basePath, byte[] lockData) {
        this.writeMutex = new WriteLock(client, basePath, lockData);
        this.readMutex = new ReadLock(client, basePath, lockData, this.writeMutex);
    }

    protected InterProcessReadWriteLock(WriteLock writeLock, ReadLock readLock) {
        this.writeMutex = writeLock;
        this.readMutex = readLock;
    }

    public ReadLock readLock() {
        return this.readMutex;
    }

    public WriteLock writeLock() {
        return this.writeMutex;
    }

    public static class ReadLock
    extends InternalInterProcessMutex {
        public ReadLock(CuratorFramework client, String basePath, byte[] lockData, final WriteLock writeLock) {
            super(client, basePath, InterProcessReadWriteLock.READ_LOCK_NAME, lockData, Integer.MAX_VALUE, new SortingLockInternalsDriver(){

                @Override
                public PredicateResults getsTheLock(CuratorFramework client, List<String> children, String sequenceNodeName, int maxLeases) throws Exception {
                    if (writeLock.isOwnedByCurrentThread()) {
                        return new PredicateResults(null, true);
                    }
                    int index = 0;
                    int firstWriteIndex = Integer.MAX_VALUE;
                    int ourIndex = -1;
                    for (String node : children) {
                        if (node.contains(InterProcessReadWriteLock.WRITE_LOCK_NAME)) {
                            firstWriteIndex = Math.min(index, firstWriteIndex);
                        } else if (node.startsWith(sequenceNodeName)) {
                            ourIndex = index;
                            break;
                        }
                        ++index;
                    }
                    1.validateOurIndex(sequenceNodeName, ourIndex);
                    boolean getsTheLock = ourIndex < firstWriteIndex;
                    String pathToWatch = getsTheLock ? null : children.get(firstWriteIndex);
                    return new PredicateResults(pathToWatch, getsTheLock);
                }
            });
        }

        @Override
        protected String getLockPath() {
            return super.getLockPath();
        }
    }

    public static class WriteLock
    extends InternalInterProcessMutex {
        public WriteLock(CuratorFramework client, String basePath, byte[] lockData) {
            super(client, basePath, InterProcessReadWriteLock.WRITE_LOCK_NAME, lockData, 1, new SortingLockInternalsDriver(){

                @Override
                public PredicateResults getsTheLock(CuratorFramework client, List<String> children, String sequenceNodeName, int maxLeases) throws Exception {
                    return super.getsTheLock(client, children, sequenceNodeName, maxLeases);
                }
            });
        }

        @Override
        protected String getLockPath() {
            return super.getLockPath();
        }
    }

    private static class InternalInterProcessMutex
    extends InterProcessMutex {
        private final String lockName;
        private final byte[] lockData;

        InternalInterProcessMutex(CuratorFramework client, String path, String lockName, byte[] lockData, int maxLeases, LockInternalsDriver driver) {
            super(client, path, lockName, maxLeases, driver);
            this.lockName = lockName;
            this.lockData = lockData == null ? null : Arrays.copyOf(lockData, lockData.length);
        }

        @Override
        public final Collection<String> getParticipantNodes() throws Exception {
            return ImmutableList.copyOf(Iterables.filter(super.getParticipantNodes(), new Predicate<String>(){

                @Override
                public boolean apply(String node) {
                    return node.contains(lockName);
                }
            }));
        }

        @Override
        protected final byte[] getLockNodeBytes() {
            return this.lockData;
        }

        @Override
        protected String getLockPath() {
            return super.getLockPath();
        }
    }

    private static class SortingLockInternalsDriver
    extends StandardLockInternalsDriver {
        private SortingLockInternalsDriver() {
        }

        @Override
        public final String fixForSorting(String str, String lockName) {
            str = super.fixForSorting(str, InterProcessReadWriteLock.READ_LOCK_NAME);
            str = super.fixForSorting(str, InterProcessReadWriteLock.WRITE_LOCK_NAME);
            return str;
        }
    }
}

