/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.cli;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.kyuubi.shaded.zookeeper.AsyncCallback;
import org.apache.kyuubi.shaded.zookeeper.KeeperException;
import org.apache.kyuubi.shaded.zookeeper.ZKUtil;
import org.apache.kyuubi.shaded.zookeeper.cli.AclParser;
import org.apache.kyuubi.shaded.zookeeper.cli.CliCommand;
import org.apache.kyuubi.shaded.zookeeper.cli.CliException;
import org.apache.kyuubi.shaded.zookeeper.cli.CliParseException;
import org.apache.kyuubi.shaded.zookeeper.cli.CliWrapperException;
import org.apache.kyuubi.shaded.zookeeper.cli.MalformedPathException;
import org.apache.kyuubi.shaded.zookeeper.cli.StatPrinter;
import org.apache.kyuubi.shaded.zookeeper.data.ACL;
import org.apache.kyuubi.shaded.zookeeper.data.Stat;

public class SetAclCommand
extends CliCommand {
    private static Options options = new Options();
    private String[] args;
    private CommandLine cl;

    public SetAclCommand() {
        super("setAcl", "[-s] [-v version] [-R] path acl");
    }

    @Override
    public CliCommand parse(String[] cmdArgs) throws CliParseException {
        DefaultParser parser = new DefaultParser();
        try {
            this.cl = parser.parse(options, cmdArgs);
        }
        catch (ParseException ex) {
            throw new CliParseException(ex);
        }
        this.args = this.cl.getArgs();
        if (this.args.length < 3) {
            throw new CliParseException(this.getUsageStr());
        }
        return this;
    }

    @Override
    public boolean exec() throws CliException {
        String path = this.args[1];
        String aclStr = this.args[2];
        final List<ACL> acl = AclParser.parse(aclStr);
        final int version = this.cl.hasOption("v") ? Integer.parseInt(this.cl.getOptionValue("v")) : -1;
        try {
            if (this.cl.hasOption("R")) {
                ZKUtil.visitSubTreeDFS(this.zk, path, false, new AsyncCallback.StringCallback(){

                    @Override
                    public void processResult(int rc, String p, Object ctx, String name) {
                        try {
                            SetAclCommand.this.zk.setACL(p, acl, version);
                        }
                        catch (InterruptedException | KeeperException e) {
                            SetAclCommand.this.out.print(e.getMessage());
                        }
                    }
                });
            } else {
                Stat stat = this.zk.setACL(path, acl, version);
                if (this.cl.hasOption("s")) {
                    new StatPrinter(this.out).print(stat);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            throw new MalformedPathException(ex.getMessage());
        }
        catch (InterruptedException | KeeperException ex) {
            throw new CliWrapperException(ex);
        }
        return false;
    }

    static {
        options.addOption("s", false, "stats");
        options.addOption("v", true, "version");
        options.addOption("R", false, "recursive");
    }
}

