/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.common;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;

public class NetUtils {
    public static String formatInetAddr(InetSocketAddress addr) {
        InetAddress ia = addr.getAddress();
        if (ia == null) {
            return String.format("%s:%s", addr.getHostString(), addr.getPort());
        }
        if (ia instanceof Inet6Address) {
            return String.format("[%s]:%s", ia.getHostAddress(), addr.getPort());
        }
        return String.format("%s:%s", ia.getHostAddress(), addr.getPort());
    }

    public static String[] getIPV6HostAndPort(String hostPort) {
        if (hostPort.startsWith("[")) {
            int i = hostPort.lastIndexOf(93);
            if (i < 0) {
                throw new IllegalArgumentException(hostPort + " starts with '[' but has no matching ']'");
            }
            String host = hostPort.substring(1, i);
            if (host.isEmpty()) {
                throw new IllegalArgumentException(host + " is empty.");
            }
            if (hostPort.length() > i + 1) {
                return NetUtils.getHostPort(hostPort, i, host);
            }
            return new String[]{host};
        }
        return new String[0];
    }

    private static String[] getHostPort(String hostPort, int indexOfClosingBracket, String host) {
        if (hostPort.charAt(indexOfClosingBracket + 1) != ':') {
            throw new IllegalArgumentException(hostPort + " does not have : after ]");
        }
        if (indexOfClosingBracket + 2 == hostPort.length()) {
            throw new IllegalArgumentException(hostPort + " doesn't have a port after colon.");
        }
        String port = hostPort.substring(indexOfClosingBracket + 2);
        return new String[]{host, port};
    }
}

