/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.common;

import java.io.File;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Optional;
import org.apache.kyuubi.shaded.zookeeper.common.FileKeyStoreLoader;
import org.apache.kyuubi.shaded.zookeeper.util.PemReader;

class PEMFileLoader
extends FileKeyStoreLoader {
    private PEMFileLoader(String keyStorePath, String trustStorePath, String keyStorePassword, String trustStorePassword) {
        super(keyStorePath, trustStorePath, keyStorePassword, trustStorePassword);
    }

    @Override
    public KeyStore loadKeyStore() throws IOException, GeneralSecurityException {
        Optional<Object> passwordOption = this.keyStorePassword == null || this.keyStorePassword.length() == 0 ? Optional.empty() : Optional.of(this.keyStorePassword);
        File file = new File(this.keyStorePath);
        return PemReader.loadKeyStore(file, file, passwordOption);
    }

    @Override
    public KeyStore loadTrustStore() throws IOException, GeneralSecurityException {
        return PemReader.loadTrustStore(new File(this.trustStorePath));
    }

    static class Builder
    extends FileKeyStoreLoader.Builder<PEMFileLoader> {
        Builder() {
        }

        @Override
        PEMFileLoader build() {
            return new PEMFileLoader(this.keyStorePath, this.trustStorePath, this.keyStorePassword, this.trustStorePassword);
        }
    }
}

