/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.server;

import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.kyuubi.shaded.jute.InputArchive;
import org.apache.kyuubi.shaded.jute.OutputArchive;
import org.apache.kyuubi.shaded.jute.Record;
import org.apache.kyuubi.shaded.zookeeper.DigestWatcher;
import org.apache.kyuubi.shaded.zookeeper.KeeperException;
import org.apache.kyuubi.shaded.zookeeper.Quotas;
import org.apache.kyuubi.shaded.zookeeper.StatsTrack;
import org.apache.kyuubi.shaded.zookeeper.WatchedEvent;
import org.apache.kyuubi.shaded.zookeeper.Watcher;
import org.apache.kyuubi.shaded.zookeeper.ZooDefs;
import org.apache.kyuubi.shaded.zookeeper.audit.AuditEvent;
import org.apache.kyuubi.shaded.zookeeper.audit.ZKAuditProvider;
import org.apache.kyuubi.shaded.zookeeper.common.PathTrie;
import org.apache.kyuubi.shaded.zookeeper.data.ACL;
import org.apache.kyuubi.shaded.zookeeper.data.Stat;
import org.apache.kyuubi.shaded.zookeeper.data.StatPersisted;
import org.apache.kyuubi.shaded.zookeeper.server.ByteBufferInputStream;
import org.apache.kyuubi.shaded.zookeeper.server.DataNode;
import org.apache.kyuubi.shaded.zookeeper.server.DigestCalculator;
import org.apache.kyuubi.shaded.zookeeper.server.EphemeralType;
import org.apache.kyuubi.shaded.zookeeper.server.ExitCode;
import org.apache.kyuubi.shaded.zookeeper.server.NodeHashMap;
import org.apache.kyuubi.shaded.zookeeper.server.NodeHashMapImpl;
import org.apache.kyuubi.shaded.zookeeper.server.RateLogger;
import org.apache.kyuubi.shaded.zookeeper.server.ReferenceCountedACLCache;
import org.apache.kyuubi.shaded.zookeeper.server.ServerMetrics;
import org.apache.kyuubi.shaded.zookeeper.server.ZooKeeperServer;
import org.apache.kyuubi.shaded.zookeeper.server.ZooTrace;
import org.apache.kyuubi.shaded.zookeeper.server.watch.IWatchManager;
import org.apache.kyuubi.shaded.zookeeper.server.watch.WatchManagerFactory;
import org.apache.kyuubi.shaded.zookeeper.server.watch.WatcherMode;
import org.apache.kyuubi.shaded.zookeeper.server.watch.WatcherOrBitSet;
import org.apache.kyuubi.shaded.zookeeper.server.watch.WatchesPathReport;
import org.apache.kyuubi.shaded.zookeeper.server.watch.WatchesReport;
import org.apache.kyuubi.shaded.zookeeper.server.watch.WatchesSummary;
import org.apache.kyuubi.shaded.zookeeper.txn.CheckVersionTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.CloseSessionTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.CreateContainerTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.CreateTTLTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.CreateTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.DeleteTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.ErrorTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.MultiTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.SetACLTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.SetDataTxn;
import org.apache.kyuubi.shaded.zookeeper.txn.Txn;
import org.apache.kyuubi.shaded.zookeeper.txn.TxnDigest;
import org.apache.kyuubi.shaded.zookeeper.txn.TxnHeader;
import org.apache.kyuubi.shaded.zookeeper.util.ServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTree {
    private static final Logger LOG = LoggerFactory.getLogger(DataTree.class);
    private final RateLogger RATE_LOGGER = new RateLogger(LOG, 900000L);
    private final NodeHashMap nodes;
    private IWatchManager dataWatches;
    private IWatchManager childWatches;
    private final AtomicLong nodeDataSize = new AtomicLong(0L);
    private static final String rootZookeeper = "/";
    private static final String procZookeeper = "/zookeeper";
    private static final String procChildZookeeper = "/zookeeper".substring(1);
    private static final String quotaZookeeper = "/zookeeper/quota";
    private static final String quotaChildZookeeper = "/zookeeper/quota".substring("/zookeeper".length() + 1);
    private static final String configZookeeper = "/zookeeper/config";
    private static final String configChildZookeeper = "/zookeeper/config".substring("/zookeeper".length() + 1);
    private final PathTrie pTrie = new PathTrie();
    public static final int STAT_OVERHEAD_BYTES = 68;
    private final Map<Long, HashSet<String>> ephemerals = new ConcurrentHashMap<Long, HashSet<String>>();
    private final Set<String> containers = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<String> ttls = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ReferenceCountedACLCache aclCache = new ReferenceCountedACLCache();
    public static final int DIGEST_LOG_LIMIT = 1024;
    public static final int DIGEST_LOG_INTERVAL = 128;
    private ZxidDigest digestFromLoadedSnapshot;
    private volatile ZxidDigest lastProcessedZxidDigest;
    private boolean firstMismatchTxn = true;
    private final List<DigestWatcher> digestWatchers = new ArrayList<DigestWatcher>();
    private LinkedList<ZxidDigest> digestLog = new LinkedList();
    private final DigestCalculator digestCalculator;
    private DataNode root = new DataNode(new byte[0], -1L, new StatPersisted());
    private final DataNode procDataNode = new DataNode(new byte[0], -1L, new StatPersisted());
    private final DataNode quotaDataNode = new DataNode(new byte[0], -1L, new StatPersisted());
    public volatile long lastProcessedZxid = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getEphemerals(long sessionId) {
        HashSet<String> retv = this.ephemerals.get(sessionId);
        if (retv == null) {
            return new HashSet<String>();
        }
        HashSet cloned = null;
        HashSet<String> hashSet = retv;
        synchronized (hashSet) {
            cloned = (HashSet)retv.clone();
        }
        return cloned;
    }

    public Set<String> getContainers() {
        return new HashSet<String>(this.containers);
    }

    public Set<String> getTtls() {
        return new HashSet<String>(this.ttls);
    }

    public Collection<Long> getSessions() {
        return this.ephemerals.keySet();
    }

    public DataNode getNode(String path) {
        return this.nodes.get(path);
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public int getWatchCount() {
        return this.dataWatches.size() + this.childWatches.size();
    }

    public int getEphemeralsCount() {
        int result = 0;
        for (HashSet<String> set : this.ephemerals.values()) {
            result += set.size();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long approximateDataSize() {
        long result = 0L;
        for (Map.Entry<String, DataNode> entry : this.nodes.entrySet()) {
            DataNode value;
            DataNode dataNode = value = entry.getValue();
            synchronized (dataNode) {
                result += DataTree.getNodeSize(entry.getKey(), value.data);
            }
        }
        return result;
    }

    private static long getNodeSize(String path, byte[] data) {
        return (path == null ? 0 : path.length()) + (data == null ? 0 : data.length);
    }

    public long cachedApproximateDataSize() {
        return this.nodeDataSize.get();
    }

    public DataTree() {
        this(new DigestCalculator());
    }

    DataTree(DigestCalculator digestCalculator) {
        this.digestCalculator = digestCalculator;
        this.nodes = new NodeHashMapImpl(digestCalculator);
        this.nodes.put("", this.root);
        this.nodes.putWithoutDigest(rootZookeeper, this.root);
        this.root.addChild(procChildZookeeper);
        this.nodes.put(procZookeeper, this.procDataNode);
        this.procDataNode.addChild(quotaChildZookeeper);
        this.nodes.put(quotaZookeeper, this.quotaDataNode);
        this.addConfigNode();
        this.nodeDataSize.set(this.approximateDataSize());
        try {
            this.dataWatches = WatchManagerFactory.createWatchManager();
            this.childWatches = WatchManagerFactory.createWatchManager();
        }
        catch (Exception e) {
            LOG.error("Unexpected exception when creating WatchManager, exiting abnormally", (Throwable)e);
            ServiceUtils.requestSystemExit(ExitCode.UNEXPECTED_ERROR.getValue());
        }
    }

    public void addConfigNode() {
        block5: {
            DataNode zookeeperZnode = this.nodes.get(procZookeeper);
            if (zookeeperZnode != null) {
                zookeeperZnode.addChild(configChildZookeeper);
            } else assert (false) : "There's no /zookeeper znode - this should never happen.";
            this.nodes.put(configZookeeper, new DataNode(new byte[0], -1L, new StatPersisted()));
            try {
                this.setACL(configZookeeper, ZooDefs.Ids.READ_ACL_UNSAFE, -1);
            }
            catch (KeeperException.NoNodeException e) {
                if ($assertionsDisabled) break block5;
                throw new AssertionError((Object)"There's no /zookeeper/config znode - this should never happen.");
            }
        }
    }

    boolean isSpecialPath(String path) {
        return rootZookeeper.equals(path) || procZookeeper.equals(path) || quotaZookeeper.equals(path) || configZookeeper.equals(path);
    }

    public static void copyStatPersisted(StatPersisted from, StatPersisted to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
    }

    public static void copyStat(Stat from, Stat to) {
        to.setAversion(from.getAversion());
        to.setCtime(from.getCtime());
        to.setCversion(from.getCversion());
        to.setCzxid(from.getCzxid());
        to.setMtime(from.getMtime());
        to.setMzxid(from.getMzxid());
        to.setPzxid(from.getPzxid());
        to.setVersion(from.getVersion());
        to.setEphemeralOwner(from.getEphemeralOwner());
        to.setDataLength(from.getDataLength());
        to.setNumChildren(from.getNumChildren());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCountBytes(String lastPrefix, long bytesDiff, int countDiff) {
        String statNode = Quotas.statPath(lastPrefix);
        DataNode node = this.nodes.get(statNode);
        StatsTrack updatedStat = null;
        if (node == null) {
            LOG.error("Missing count node for stat {}", (Object)statNode);
            return;
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            updatedStat = new StatsTrack(new String(node.data));
            updatedStat.setCount(updatedStat.getCount() + countDiff);
            updatedStat.setBytes(updatedStat.getBytes() + bytesDiff);
            node.data = updatedStat.toString().getBytes();
        }
        String quotaNode = Quotas.quotaPath(lastPrefix);
        node = this.nodes.get(quotaNode);
        StatsTrack thisStats = null;
        if (node == null) {
            LOG.error("Missing count node for quota {}", (Object)quotaNode);
            return;
        }
        DataNode dataNode2 = node;
        synchronized (dataNode2) {
            thisStats = new StatsTrack(new String(node.data));
        }
        if (thisStats.getCount() > -1 && thisStats.getCount() < updatedStat.getCount()) {
            LOG.warn("Quota exceeded: {} count={} limit={}", new Object[]{lastPrefix, updatedStat.getCount(), thisStats.getCount()});
        }
        if (thisStats.getBytes() > -1L && thisStats.getBytes() < updatedStat.getBytes()) {
            LOG.warn("Quota exceeded: {} bytes={} limit={}", new Object[]{lastPrefix, updatedStat.getBytes(), thisStats.getBytes()});
        }
    }

    public void createNode(String path, byte[] data, List<ACL> acl, long ephemeralOwner, int parentCVersion, long zxid, long time) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        this.createNode(path, data, acl, ephemeralOwner, parentCVersion, zxid, time, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createNode(String path, byte[] data, List<ACL> acl, long ephemeralOwner, int parentCVersion, long zxid, long time, Stat outputStat) throws KeeperException.NoNodeException, KeeperException.NodeExistsException {
        long bytes;
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        String childName = path.substring(lastSlash + 1);
        StatPersisted stat = DataTree.createStat(zxid, time, ephemeralOwner);
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = parent;
        synchronized (dataNode) {
            Long longval = this.aclCache.convertAcls(acl);
            Set<String> children = parent.getChildren();
            if (children.contains(childName)) {
                throw new KeeperException.NodeExistsException();
            }
            this.nodes.preChange(parentName, parent);
            if (parentCVersion == -1) {
                parentCVersion = parent.stat.getCversion();
                ++parentCVersion;
            }
            if (parentCVersion > parent.stat.getCversion()) {
                parent.stat.setCversion(parentCVersion);
                parent.stat.setPzxid(zxid);
            }
            DataNode child = new DataNode(data, longval, stat);
            parent.addChild(childName);
            this.nodes.postChange(parentName, parent);
            this.nodeDataSize.addAndGet(DataTree.getNodeSize(path, child.data));
            this.nodes.put(path, child);
            EphemeralType ephemeralType = EphemeralType.get(ephemeralOwner);
            if (ephemeralType == EphemeralType.CONTAINER) {
                this.containers.add(path);
            } else if (ephemeralType == EphemeralType.TTL) {
                this.ttls.add(path);
            } else if (ephemeralOwner != 0L) {
                HashSet<String> list = this.ephemerals.get(ephemeralOwner);
                if (list == null) {
                    list = new HashSet();
                    this.ephemerals.put(ephemeralOwner, list);
                }
                HashSet<String> hashSet = list;
                synchronized (hashSet) {
                    list.add(path);
                }
            }
            if (outputStat != null) {
                child.copyStat(outputStat);
            }
        }
        if (parentName.startsWith(quotaZookeeper)) {
            if ("zookeeper_limits".equals(childName)) {
                this.pTrie.addPath(parentName.substring(quotaZookeeper.length()));
            }
            if ("zookeeper_stats".equals(childName)) {
                this.updateQuotaForPath(parentName.substring(quotaZookeeper.length()));
            }
        }
        String lastPrefix = this.getMaxPrefixWithQuota(path);
        long l = bytes = data == null ? 0L : (long)data.length;
        if (lastPrefix != null) {
            this.updateCountBytes(lastPrefix, bytes, 1);
        }
        this.updateWriteStat(path, bytes);
        this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeCreated);
        this.childWatches.triggerWatch(parentName.equals("") ? rootZookeeper : parentName, Watcher.Event.EventType.NodeChildrenChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteNode(String path, long zxid) throws KeeperException.NoNodeException {
        String lastPrefix;
        int lastSlash = path.lastIndexOf(47);
        String parentName = path.substring(0, lastSlash);
        String childName = path.substring(lastSlash + 1);
        DataNode parent = this.nodes.get(parentName);
        if (parent == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = parent;
        synchronized (dataNode) {
            this.nodes.preChange(parentName, parent);
            parent.removeChild(childName);
            if (zxid > parent.stat.getPzxid()) {
                parent.stat.setPzxid(zxid);
            }
            this.nodes.postChange(parentName, parent);
        }
        DataNode node = this.nodes.get(path);
        if (node == null) {
            throw new KeeperException.NoNodeException();
        }
        this.nodes.remove(path);
        DataNode dataNode2 = node;
        synchronized (dataNode2) {
            this.aclCache.removeUsage(node.acl);
            this.nodeDataSize.addAndGet(-DataTree.getNodeSize(path, node.data));
        }
        dataNode2 = parent;
        synchronized (dataNode2) {
            Set nodes;
            long eowner = node.stat.getEphemeralOwner();
            EphemeralType ephemeralType = EphemeralType.get(eowner);
            if (ephemeralType == EphemeralType.CONTAINER) {
                this.containers.remove(path);
            } else if (ephemeralType == EphemeralType.TTL) {
                this.ttls.remove(path);
            } else if (eowner != 0L && (nodes = (Set)this.ephemerals.get(eowner)) != null) {
                Set set = nodes;
                synchronized (set) {
                    nodes.remove(path);
                }
            }
        }
        if (parentName.startsWith(procZookeeper) && "zookeeper_limits".equals(childName)) {
            this.pTrie.deletePath(parentName.substring(quotaZookeeper.length()));
        }
        if ((lastPrefix = this.getMaxPrefixWithQuota(path)) != null) {
            int bytes = 0;
            DataNode dataNode3 = node;
            synchronized (dataNode3) {
                bytes = node.data == null ? 0 : -node.data.length;
            }
            this.updateCountBytes(lastPrefix, bytes, -1);
        }
        this.updateWriteStat(path, 0L);
        if (LOG.isTraceEnabled()) {
            ZooTrace.logTraceMessage(LOG, 64L, "dataWatches.triggerWatch " + path);
            ZooTrace.logTraceMessage(LOG, 64L, "childWatches.triggerWatch " + parentName);
        }
        WatcherOrBitSet processed = this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeDeleted);
        this.childWatches.triggerWatch(path, Watcher.Event.EventType.NodeDeleted, processed);
        this.childWatches.triggerWatch("".equals(parentName) ? rootZookeeper : parentName, Watcher.Event.EventType.NodeChildrenChanged);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setData(String path, byte[] data, int version, long zxid, long time) throws KeeperException.NoNodeException {
        long dataBytes;
        Stat s = new Stat();
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        byte[] lastdata = null;
        DataNode dataNode = n;
        synchronized (dataNode) {
            lastdata = n.data;
            this.nodes.preChange(path, n);
            n.data = data;
            n.stat.setMtime(time);
            n.stat.setMzxid(zxid);
            n.stat.setVersion(version);
            n.copyStat(s);
            this.nodes.postChange(path, n);
        }
        String lastPrefix = this.getMaxPrefixWithQuota(path);
        long l = dataBytes = data == null ? 0L : (long)data.length;
        if (lastPrefix != null) {
            this.updateCountBytes(lastPrefix, dataBytes - (long)(lastdata == null ? 0 : lastdata.length), 0);
        }
        this.nodeDataSize.addAndGet(DataTree.getNodeSize(path, data) - DataTree.getNodeSize(path, lastdata));
        this.updateWriteStat(path, dataBytes);
        this.dataWatches.triggerWatch(path, Watcher.Event.EventType.NodeDataChanged);
        return s;
    }

    public String getMaxPrefixWithQuota(String path) {
        String lastPrefix = this.pTrie.findMaxPrefix(path);
        if (rootZookeeper.equals(lastPrefix) || lastPrefix.isEmpty()) {
            return null;
        }
        return lastPrefix;
    }

    public void addWatch(String basePath, Watcher watcher, int mode) {
        WatcherMode watcherMode = WatcherMode.fromZooDef(mode);
        this.dataWatches.addWatch(basePath, watcher, watcherMode);
        this.childWatches.addWatch(basePath, watcher, watcherMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getData(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path);
        byte[] data = null;
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
            if (watcher != null) {
                this.dataWatches.addWatch(path, watcher);
            }
            data = n.data;
        }
        this.updateReadStat(path, data == null ? 0L : (long)data.length);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat statNode(String path, Watcher watcher) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNode n = this.nodes.get(path);
        if (watcher != null) {
            this.dataWatches.addWatch(path, watcher);
        }
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            n.copyStat(stat);
        }
        this.updateReadStat(path, 0L);
        return stat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildren(String path, Stat stat, Watcher watcher) throws KeeperException.NoNodeException {
        ArrayList<String> children;
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            if (stat != null) {
                n.copyStat(stat);
            }
            children = new ArrayList<String>(n.getChildren());
            if (watcher != null) {
                this.childWatches.addWatch(path, watcher);
            }
        }
        int bytes = 0;
        for (String child : children) {
            bytes += child.length();
        }
        this.updateReadStat(path, bytes);
        return children;
    }

    public int getAllChildrenNumber(String path) {
        if (rootZookeeper.equals(path)) {
            return this.nodes.size() - 2;
        }
        return (int)this.nodes.entrySet().parallelStream().filter(entry -> ((String)entry.getKey()).startsWith(path + rootZookeeper)).count();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stat setACL(String path, List<ACL> acl, int version) throws KeeperException.NoNodeException {
        Stat stat = new Stat();
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            this.aclCache.removeUsage(n.acl);
            this.nodes.preChange(path, n);
            n.stat.setAversion(version);
            n.acl = this.aclCache.convertAcls(acl);
            n.copyStat(stat);
            this.nodes.postChange(path, n);
            return stat;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(String path, Stat stat) throws KeeperException.NoNodeException {
        DataNode n = this.nodes.get(path);
        if (n == null) {
            throw new KeeperException.NoNodeException();
        }
        DataNode dataNode = n;
        synchronized (dataNode) {
            if (stat != null) {
                n.copyStat(stat);
            }
            return new ArrayList<ACL>(this.aclCache.convertLong(n.acl));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ACL> getACL(DataNode node) {
        DataNode dataNode = node;
        synchronized (dataNode) {
            return this.aclCache.convertLong(node.acl);
        }
    }

    public int aclCacheSize() {
        return this.aclCache.size();
    }

    public ProcessTxnResult processTxn(TxnHeader header, Record txn, TxnDigest digest) {
        ProcessTxnResult result = this.processTxn(header, txn);
        this.compareDigest(header, txn, digest);
        return result;
    }

    public ProcessTxnResult processTxn(TxnHeader header, Record txn) {
        return this.processTxn(header, txn, false);
    }

    public ProcessTxnResult processTxn(TxnHeader header, Record txn, boolean isSubTxn) {
        ProcessTxnResult rc = new ProcessTxnResult();
        try {
            rc.clientId = header.getClientId();
            rc.cxid = header.getCxid();
            rc.zxid = header.getZxid();
            rc.type = header.getType();
            rc.err = 0;
            rc.multiResult = null;
            switch (header.getType()) {
                case 1: {
                    CreateTxn createTxn = (CreateTxn)txn;
                    rc.path = createTxn.getPath();
                    this.createNode(createTxn.getPath(), createTxn.getData(), createTxn.getAcl(), createTxn.getEphemeral() ? header.getClientId() : 0L, createTxn.getParentCVersion(), header.getZxid(), header.getTime(), null);
                    break;
                }
                case 15: {
                    CreateTxn create2Txn = (CreateTxn)txn;
                    rc.path = create2Txn.getPath();
                    Stat stat = new Stat();
                    this.createNode(create2Txn.getPath(), create2Txn.getData(), create2Txn.getAcl(), create2Txn.getEphemeral() ? header.getClientId() : 0L, create2Txn.getParentCVersion(), header.getZxid(), header.getTime(), stat);
                    rc.stat = stat;
                    break;
                }
                case 21: {
                    CreateTTLTxn createTtlTxn = (CreateTTLTxn)txn;
                    rc.path = createTtlTxn.getPath();
                    Stat stat = new Stat();
                    this.createNode(createTtlTxn.getPath(), createTtlTxn.getData(), createTtlTxn.getAcl(), EphemeralType.TTL.toEphemeralOwner(createTtlTxn.getTtl()), createTtlTxn.getParentCVersion(), header.getZxid(), header.getTime(), stat);
                    rc.stat = stat;
                    break;
                }
                case 19: {
                    CreateContainerTxn createContainerTxn = (CreateContainerTxn)txn;
                    rc.path = createContainerTxn.getPath();
                    Stat stat = new Stat();
                    this.createNode(createContainerTxn.getPath(), createContainerTxn.getData(), createContainerTxn.getAcl(), Long.MIN_VALUE, createContainerTxn.getParentCVersion(), header.getZxid(), header.getTime(), stat);
                    rc.stat = stat;
                    break;
                }
                case 2: 
                case 20: {
                    DeleteTxn deleteTxn = (DeleteTxn)txn;
                    rc.path = deleteTxn.getPath();
                    this.deleteNode(deleteTxn.getPath(), header.getZxid());
                    break;
                }
                case 5: 
                case 16: {
                    SetDataTxn setDataTxn = (SetDataTxn)txn;
                    rc.path = setDataTxn.getPath();
                    rc.stat = this.setData(setDataTxn.getPath(), setDataTxn.getData(), setDataTxn.getVersion(), header.getZxid(), header.getTime());
                    break;
                }
                case 7: {
                    SetACLTxn setACLTxn = (SetACLTxn)txn;
                    rc.path = setACLTxn.getPath();
                    rc.stat = this.setACL(setACLTxn.getPath(), setACLTxn.getAcl(), setACLTxn.getVersion());
                    break;
                }
                case -11: {
                    long sessionId = header.getClientId();
                    if (txn != null) {
                        this.killSession(sessionId, header.getZxid(), (Set<String>)this.ephemerals.remove(sessionId), ((CloseSessionTxn)txn).getPaths2Delete());
                        break;
                    }
                    this.killSession(sessionId, header.getZxid());
                    break;
                }
                case -1: {
                    ErrorTxn errTxn = (ErrorTxn)txn;
                    rc.err = errTxn.getErr();
                    break;
                }
                case 13: {
                    CheckVersionTxn checkTxn = (CheckVersionTxn)txn;
                    rc.path = checkTxn.getPath();
                    break;
                }
                case 14: {
                    MultiTxn multiTxn = (MultiTxn)txn;
                    List<Txn> txns = multiTxn.getTxns();
                    rc.multiResult = new ArrayList<ProcessTxnResult>();
                    boolean failed = false;
                    for (Txn subtxn : txns) {
                        if (subtxn.getType() != -1) continue;
                        failed = true;
                        break;
                    }
                    boolean post_failed = false;
                    for (Txn subtxn : txns) {
                        ByteBuffer bb = ByteBuffer.wrap(subtxn.getData());
                        Record record = null;
                        switch (subtxn.getType()) {
                            case 1: {
                                record = new CreateTxn();
                                break;
                            }
                            case 21: {
                                record = new CreateTTLTxn();
                                break;
                            }
                            case 19: {
                                record = new CreateContainerTxn();
                                break;
                            }
                            case 2: 
                            case 20: {
                                record = new DeleteTxn();
                                break;
                            }
                            case 5: {
                                record = new SetDataTxn();
                                break;
                            }
                            case -1: {
                                record = new ErrorTxn();
                                post_failed = true;
                                break;
                            }
                            case 13: {
                                record = new CheckVersionTxn();
                                break;
                            }
                            default: {
                                throw new IOException("Invalid type of op: " + subtxn.getType());
                            }
                        }
                        assert (record != null);
                        ByteBufferInputStream.byteBuffer2Record(bb, record);
                        if (failed && subtxn.getType() != -1) {
                            int ec = post_failed ? KeeperException.Code.RUNTIMEINCONSISTENCY.intValue() : KeeperException.Code.OK.intValue();
                            subtxn.setType(-1);
                            record = new ErrorTxn(ec);
                        }
                        assert (!failed || subtxn.getType() == -1);
                        TxnHeader subHdr = new TxnHeader(header.getClientId(), header.getCxid(), header.getZxid(), header.getTime(), subtxn.getType());
                        ProcessTxnResult subRc = this.processTxn(subHdr, record, true);
                        rc.multiResult.add(subRc);
                        if (subRc.err == 0 || rc.err != 0) continue;
                        rc.err = subRc.err;
                    }
                    break;
                }
            }
        }
        catch (KeeperException e) {
            LOG.debug("Failed: {}:{}", new Object[]{header, txn, e});
            rc.err = e.code().intValue();
        }
        catch (IOException e) {
            LOG.debug("Failed: {}:{}", new Object[]{header, txn, e});
        }
        if (header.getType() == 1 && rc.err == KeeperException.Code.NODEEXISTS.intValue()) {
            LOG.debug("Adjusting parent cversion for Txn: {} path: {} err: {}", new Object[]{header.getType(), rc.path, rc.err});
            int lastSlash = rc.path.lastIndexOf(47);
            String parentName = rc.path.substring(0, lastSlash);
            CreateTxn cTxn = (CreateTxn)txn;
            try {
                this.setCversionPzxid(parentName, cTxn.getParentCVersion(), header.getZxid());
            }
            catch (KeeperException.NoNodeException e) {
                LOG.error("Failed to set parent cversion for: {}", (Object)parentName, (Object)e);
                rc.err = e.code().intValue();
            }
        } else if (rc.err != KeeperException.Code.OK.intValue()) {
            LOG.debug("Ignoring processTxn failure hdr: {} : error: {}", (Object)header.getType(), (Object)rc.err);
        }
        if (!isSubTxn) {
            if (rc.zxid > this.lastProcessedZxid) {
                this.lastProcessedZxid = rc.zxid;
            }
            if (this.digestFromLoadedSnapshot != null) {
                this.compareSnapshotDigests(rc.zxid);
            } else {
                this.logZxidDigest(rc.zxid, this.getTreeDigest());
            }
        }
        return rc;
    }

    void killSession(long session, long zxid) {
        this.killSession(session, zxid, (Set<String>)this.ephemerals.remove(session), null);
    }

    void killSession(long session, long zxid, Set<String> paths2DeleteLocal, List<String> paths2DeleteInTxn) {
        if (paths2DeleteInTxn != null) {
            this.deleteNodes(session, zxid, paths2DeleteInTxn);
        }
        if (paths2DeleteLocal == null) {
            return;
        }
        if (paths2DeleteInTxn != null) {
            for (String path : paths2DeleteInTxn) {
                paths2DeleteLocal.remove(path);
            }
            if (!paths2DeleteLocal.isEmpty()) {
                LOG.warn("Unexpected extra paths under session {} which are not in txn 0x{}", paths2DeleteLocal, (Object)Long.toHexString(zxid));
            }
        }
        this.deleteNodes(session, zxid, paths2DeleteLocal);
    }

    void deleteNodes(long session, long zxid, Iterable<String> paths2Delete) {
        for (String path : paths2Delete) {
            boolean deleted = false;
            String sessionHex = "0x" + Long.toHexString(session);
            try {
                this.deleteNode(path, zxid);
                deleted = true;
                LOG.debug("Deleting ephemeral node {} for session {}", (Object)path, (Object)sessionHex);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.warn("Ignoring NoNodeException for path {} while removing ephemeral for dead session {}", (Object)path, (Object)sessionHex);
            }
            if (!ZKAuditProvider.isAuditEnabled()) continue;
            if (deleted) {
                ZKAuditProvider.log(ZKAuditProvider.getZKUser(), "ephemeralZNodeDeletionOnSessionCloseOrExpire", path, null, null, sessionHex, null, AuditEvent.Result.SUCCESS);
                continue;
            }
            ZKAuditProvider.log(ZKAuditProvider.getZKUser(), "ephemeralZNodeDeletionOnSessionCloseOrExpire", path, null, null, sessionHex, null, AuditEvent.Result.FAILURE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCounts(String path, Counts counts) {
        String[] node = this.getNode(path);
        if (node == null) {
            return;
        }
        String[] children = null;
        int len = 0;
        String[] stringArray = node;
        synchronized (node) {
            Set<String> childs = node.getChildren();
            children = childs.toArray(new String[childs.size()]);
            len = node.data == null ? 0 : node.data.length;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            ++counts.count;
            counts.bytes += (long)len;
            for (String child : children) {
                this.getCounts(path + rootZookeeper + child, counts);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateQuotaForPath(String path) {
        Counts c = new Counts();
        this.getCounts(path, c);
        StatsTrack strack = new StatsTrack();
        strack.setBytes(c.bytes);
        strack.setCount(c.count);
        String statPath = quotaZookeeper + path + rootZookeeper + "zookeeper_stats";
        DataNode node = this.getNode(statPath);
        if (node == null) {
            LOG.warn("Missing quota stat node {}", (Object)statPath);
            return;
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            this.nodes.preChange(statPath, node);
            node.data = strack.toString().getBytes();
            this.nodes.postChange(statPath, node);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverseNode(String path) {
        String[] node = this.getNode(path);
        String[] children = null;
        String[] stringArray = node;
        synchronized (node) {
            Set<String> childs = node.getChildren();
            children = childs.toArray(new String[childs.size()]);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (children.length == 0) {
                String endString = "/zookeeper_limits";
                if (path.endsWith(endString)) {
                    String realPath = path.substring(quotaZookeeper.length(), path.indexOf(endString));
                    this.updateQuotaForPath(realPath);
                    this.pTrie.addPath(realPath);
                }
                return;
            }
            for (String child : children) {
                this.traverseNode(path + rootZookeeper + child);
            }
            return;
        }
    }

    private void setupQuota() {
        String quotaPath = quotaZookeeper;
        DataNode node = this.getNode(quotaPath);
        if (node == null) {
            return;
        }
        this.traverseNode(quotaPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serializeNode(OutputArchive oa, StringBuilder path) throws IOException {
        DataNode nodeCopy;
        String pathString = path.toString();
        DataNode node = this.getNode(pathString);
        if (node == null) {
            return;
        }
        String[] children = null;
        DataNode dataNode = node;
        synchronized (dataNode) {
            StatPersisted statCopy = new StatPersisted();
            DataTree.copyStatPersisted(node.stat, statCopy);
            nodeCopy = new DataNode(node.data, node.acl, statCopy);
            Set<String> childs = node.getChildren();
            children = childs.toArray(new String[childs.size()]);
        }
        this.serializeNodeData(oa, pathString, nodeCopy);
        path.append('/');
        int off = path.length();
        for (String child : children) {
            path.delete(off, Integer.MAX_VALUE);
            path.append(child);
            this.serializeNode(oa, path);
        }
    }

    public void serializeNodeData(OutputArchive oa, String path, DataNode node) throws IOException {
        oa.writeString(path, "path");
        oa.writeRecord(node, "node");
    }

    public void serializeAcls(OutputArchive oa) throws IOException {
        this.aclCache.serialize(oa);
    }

    public void serializeNodes(OutputArchive oa) throws IOException {
        this.serializeNode(oa, new StringBuilder());
        if (this.root != null) {
            oa.writeString(rootZookeeper, "path");
        }
    }

    public void serialize(OutputArchive oa, String tag) throws IOException {
        this.serializeAcls(oa);
        this.serializeNodes(oa);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deserialize(InputArchive ia, String tag) throws IOException {
        this.aclCache.deserialize(ia);
        this.nodes.clear();
        this.pTrie.clear();
        this.nodeDataSize.set(0L);
        String path = ia.readString("path");
        while (!rootZookeeper.equals(path)) {
            DataNode node = new DataNode();
            ia.readRecord(node, "node");
            this.nodes.put(path, node);
            DataNode dataNode = node;
            synchronized (dataNode) {
                this.aclCache.addUsage(node.acl);
            }
            int lastSlash = path.lastIndexOf(47);
            if (lastSlash == -1) {
                this.root = node;
            } else {
                String parentPath = path.substring(0, lastSlash);
                DataNode parent = this.nodes.get(parentPath);
                if (parent == null) {
                    throw new IOException("Invalid Datatree, unable to find parent " + parentPath + " of path " + path);
                }
                parent.addChild(path.substring(lastSlash + 1));
                long eowner = node.stat.getEphemeralOwner();
                EphemeralType ephemeralType = EphemeralType.get(eowner);
                if (ephemeralType == EphemeralType.CONTAINER) {
                    this.containers.add(path);
                } else if (ephemeralType == EphemeralType.TTL) {
                    this.ttls.add(path);
                } else if (eowner != 0L) {
                    HashSet<String> list = this.ephemerals.get(eowner);
                    if (list == null) {
                        list = new HashSet();
                        this.ephemerals.put(eowner, list);
                    }
                    list.add(path);
                }
            }
            path = ia.readString("path");
        }
        this.nodes.putWithoutDigest(rootZookeeper, this.root);
        this.nodeDataSize.set(this.approximateDataSize());
        this.setupQuota();
        this.aclCache.purgeUnused();
    }

    public synchronized void dumpWatchesSummary(PrintWriter pwriter) {
        pwriter.print(this.dataWatches.toString());
    }

    public synchronized void dumpWatches(PrintWriter pwriter, boolean byPath) {
        this.dataWatches.dumpWatches(pwriter, byPath);
    }

    public synchronized WatchesReport getWatches() {
        return this.dataWatches.getWatches();
    }

    public synchronized WatchesPathReport getWatchesByPath() {
        return this.dataWatches.getWatchesByPath();
    }

    public synchronized WatchesSummary getWatchesSummary() {
        return this.dataWatches.getWatchesSummary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpEphemerals(PrintWriter pwriter) {
        pwriter.println("Sessions with Ephemerals (" + this.ephemerals.keySet().size() + "):");
        for (Map.Entry<Long, HashSet<String>> entry : this.ephemerals.entrySet()) {
            pwriter.print("0x" + Long.toHexString(entry.getKey()));
            pwriter.println(":");
            Set tmp = entry.getValue();
            if (tmp == null) continue;
            Set set = tmp;
            synchronized (set) {
                for (String path : tmp) {
                    pwriter.println("\t" + path);
                }
            }
        }
    }

    public void shutdownWatcher() {
        this.dataWatches.shutdown();
        this.childWatches.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Long, Set<String>> getEphemerals() {
        HashMap<Long, Set<String>> ephemeralsCopy = new HashMap<Long, Set<String>>();
        for (Map.Entry<Long, HashSet<String>> e : this.ephemerals.entrySet()) {
            HashSet<String> hashSet = e.getValue();
            synchronized (hashSet) {
                ephemeralsCopy.put(e.getKey(), new HashSet(e.getValue()));
            }
        }
        return ephemeralsCopy;
    }

    public void removeCnxn(Watcher watcher) {
        this.dataWatches.removeWatcher(watcher);
        this.childWatches.removeWatcher(watcher);
    }

    public void setWatches(long relativeZxid, List<String> dataWatches, List<String> existWatches, List<String> childWatches, List<String> persistentWatches, List<String> persistentRecursiveWatches, Watcher watcher) {
        DataNode node;
        for (String path : dataWatches) {
            node = this.getNode(path);
            Object e = null;
            if (node == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            if (node.stat.getMzxid() > relativeZxid) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDataChanged, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            this.dataWatches.addWatch(path, watcher);
        }
        for (String path : existWatches) {
            node = this.getNode(path);
            if (node != null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeCreated, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            this.dataWatches.addWatch(path, watcher);
        }
        for (String path : childWatches) {
            node = this.getNode(path);
            if (node == null) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeDeleted, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            if (node.stat.getPzxid() > relativeZxid) {
                watcher.process(new WatchedEvent(Watcher.Event.EventType.NodeChildrenChanged, Watcher.Event.KeeperState.SyncConnected, path));
                continue;
            }
            this.childWatches.addWatch(path, watcher);
        }
        for (String path : persistentWatches) {
            this.childWatches.addWatch(path, watcher, WatcherMode.PERSISTENT);
            this.dataWatches.addWatch(path, watcher, WatcherMode.PERSISTENT);
        }
        for (String path : persistentRecursiveWatches) {
            this.childWatches.addWatch(path, watcher, WatcherMode.PERSISTENT_RECURSIVE);
            this.dataWatches.addWatch(path, watcher, WatcherMode.PERSISTENT_RECURSIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCversionPzxid(String path, int newCversion, long zxid) throws KeeperException.NoNodeException {
        DataNode node;
        if (path.endsWith(rootZookeeper)) {
            path = path.substring(0, path.length() - 1);
        }
        if ((node = this.nodes.get(path)) == null) {
            throw new KeeperException.NoNodeException(path);
        }
        DataNode dataNode = node;
        synchronized (dataNode) {
            if (newCversion == -1) {
                newCversion = node.stat.getCversion() + 1;
            }
            if (newCversion > node.stat.getCversion()) {
                this.nodes.preChange(path, node);
                node.stat.setCversion(newCversion);
                node.stat.setPzxid(zxid);
                this.nodes.postChange(path, node);
            }
        }
    }

    public boolean containsWatcher(String path, Watcher.WatcherType type, Watcher watcher) {
        boolean containsWatcher = false;
        switch (type) {
            case Children: {
                containsWatcher = this.childWatches.containsWatcher(path, watcher);
                break;
            }
            case Data: {
                containsWatcher = this.dataWatches.containsWatcher(path, watcher);
                break;
            }
            case Any: {
                if (this.childWatches.containsWatcher(path, watcher)) {
                    containsWatcher = true;
                }
                if (!this.dataWatches.containsWatcher(path, watcher)) break;
                containsWatcher = true;
            }
        }
        return containsWatcher;
    }

    public boolean removeWatch(String path, Watcher.WatcherType type, Watcher watcher) {
        boolean removed = false;
        switch (type) {
            case Children: {
                removed = this.childWatches.removeWatcher(path, watcher);
                break;
            }
            case Data: {
                removed = this.dataWatches.removeWatcher(path, watcher);
                break;
            }
            case Any: {
                if (this.childWatches.removeWatcher(path, watcher)) {
                    removed = true;
                }
                if (!this.dataWatches.removeWatcher(path, watcher)) break;
                removed = true;
            }
        }
        return removed;
    }

    public ReferenceCountedACLCache getReferenceCountedAclCache() {
        return this.aclCache;
    }

    private String getTopNamespace(String path) {
        String[] parts = path.split(rootZookeeper);
        return parts.length > 1 ? parts[1] : null;
    }

    private void updateReadStat(String path, long bytes) {
        String namespace = this.getTopNamespace(path);
        if (namespace == null) {
            return;
        }
        long totalBytes = (long)path.length() + bytes + 68L;
        ServerMetrics.getMetrics().READ_PER_NAMESPACE.add(namespace, totalBytes);
    }

    private void updateWriteStat(String path, long bytes) {
        String namespace = this.getTopNamespace(path);
        if (namespace == null) {
            return;
        }
        ServerMetrics.getMetrics().WRITE_PER_NAMESPACE.add(namespace, (long)path.length() + bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logZxidDigest(long zxid, long digest) {
        ZxidDigest zxidDigest;
        this.lastProcessedZxidDigest = zxidDigest = new ZxidDigest(zxid, this.digestCalculator.getDigestVersion(), digest);
        if (zxidDigest.zxid % 128L == 0L) {
            LinkedList<ZxidDigest> linkedList = this.digestLog;
            synchronized (linkedList) {
                this.digestLog.add(zxidDigest);
                if (this.digestLog.size() > 1024) {
                    this.digestLog.poll();
                }
            }
        }
    }

    public boolean serializeZxidDigest(OutputArchive oa) throws IOException {
        if (!ZooKeeperServer.isDigestEnabled()) {
            return false;
        }
        ZxidDigest zxidDigest = this.lastProcessedZxidDigest;
        if (zxidDigest == null) {
            zxidDigest = new ZxidDigest();
        }
        zxidDigest.serialize(oa);
        return true;
    }

    public boolean deserializeZxidDigest(InputArchive ia, long startZxidOfSnapshot) throws IOException {
        if (!ZooKeeperServer.isDigestEnabled()) {
            return false;
        }
        try {
            ZxidDigest zxidDigest = new ZxidDigest();
            zxidDigest.deserialize(ia);
            if (zxidDigest.zxid > 0L) {
                this.digestFromLoadedSnapshot = zxidDigest;
                LOG.info("The digest in the snapshot has digest version of {}, , with zxid as 0x{}, and digest value as {}", new Object[]{this.digestFromLoadedSnapshot.digestVersion, Long.toHexString(this.digestFromLoadedSnapshot.zxid), this.digestFromLoadedSnapshot.digest});
            } else {
                this.digestFromLoadedSnapshot = null;
                LOG.info("The digest value is empty in snapshot");
            }
            if (this.digestFromLoadedSnapshot != null && this.digestFromLoadedSnapshot.zxid < startZxidOfSnapshot) {
                LOG.info("The zxid of snapshot digest 0x{} is smaller than the known snapshot highest zxid, the snapshot started with zxid 0x{}. It will be invalid to use this snapshot digest associated with this zxid, will ignore comparing it.", (Object)Long.toHexString(this.digestFromLoadedSnapshot.zxid), (Object)Long.toHexString(startZxidOfSnapshot));
                this.digestFromLoadedSnapshot = null;
            }
            return true;
        }
        catch (EOFException e) {
            LOG.warn("Got EOF exception while reading the digest, likely due to the reading an older snapshot.");
            return false;
        }
    }

    public void compareSnapshotDigests(long zxid) {
        if (zxid == this.digestFromLoadedSnapshot.zxid) {
            if (this.digestCalculator.getDigestVersion() != this.digestFromLoadedSnapshot.digestVersion) {
                LOG.info("Digest version changed, local: {}, new: {}, skip comparing digest now.", (Object)this.digestFromLoadedSnapshot.digestVersion, (Object)this.digestCalculator.getDigestVersion());
                this.digestFromLoadedSnapshot = null;
                return;
            }
            if (this.getTreeDigest() != this.digestFromLoadedSnapshot.getDigest()) {
                this.reportDigestMismatch(zxid);
            }
            this.digestFromLoadedSnapshot = null;
        } else if (this.digestFromLoadedSnapshot.zxid != 0L && zxid > this.digestFromLoadedSnapshot.zxid) {
            this.RATE_LOGGER.rateLimitLog("The txn 0x{} of snapshot digest does not exist.", Long.toHexString(this.digestFromLoadedSnapshot.zxid));
        }
    }

    public boolean compareDigest(TxnHeader header, Record txn, TxnDigest digest) {
        long actualDigest;
        long zxid = header.getZxid();
        if (!ZooKeeperServer.isDigestEnabled() || digest == null) {
            return true;
        }
        if (this.digestFromLoadedSnapshot != null) {
            return true;
        }
        if (this.digestCalculator.getDigestVersion() != digest.getVersion()) {
            this.RATE_LOGGER.rateLimitLog("Digest version not the same on zxid.", String.valueOf(zxid));
            return true;
        }
        long logDigest = digest.getTreeDigest();
        if (logDigest != (actualDigest = this.getTreeDigest())) {
            this.reportDigestMismatch(zxid);
            LOG.debug("Digest in log: {}, actual tree: {}", (Object)logDigest, (Object)actualDigest);
            if (this.firstMismatchTxn) {
                LOG.error("First digest mismatch on txn: {}, {}, expected digest is {}, actual digest is {}, ", new Object[]{header, txn, digest, actualDigest});
                this.firstMismatchTxn = false;
            }
            return false;
        }
        this.RATE_LOGGER.flush();
        LOG.debug("Digests are matching for Zxid: {}, Digest in log and actual tree: {}", (Object)Long.toHexString(zxid), (Object)logDigest);
        return true;
    }

    public void reportDigestMismatch(long zxid) {
        ServerMetrics.getMetrics().DIGEST_MISMATCHES_COUNT.add(1L);
        this.RATE_LOGGER.rateLimitLog("Digests are not matching. Value is Zxid.", String.valueOf(zxid));
        for (DigestWatcher watcher : this.digestWatchers) {
            watcher.process(zxid);
        }
    }

    public long getTreeDigest() {
        return this.nodes.getDigest();
    }

    public ZxidDigest getLastProcessedZxidDigest() {
        return this.lastProcessedZxidDigest;
    }

    public ZxidDigest getDigestFromLoadedSnapshot() {
        return this.digestFromLoadedSnapshot;
    }

    public void addDigestWatcher(DigestWatcher digestWatcher) {
        this.digestWatchers.add(digestWatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ZxidDigest> getDigestLog() {
        LinkedList<ZxidDigest> linkedList = this.digestLog;
        synchronized (linkedList) {
            return new LinkedList<ZxidDigest>(this.digestLog);
        }
    }

    public static StatPersisted createStat(long zxid, long time, long ephemeralOwner) {
        StatPersisted stat = new StatPersisted();
        stat.setCtime(time);
        stat.setMtime(time);
        stat.setCzxid(zxid);
        stat.setMzxid(zxid);
        stat.setPzxid(zxid);
        stat.setVersion(0);
        stat.setAversion(0);
        stat.setEphemeralOwner(ephemeralOwner);
        return stat;
    }

    public class ZxidDigest {
        long zxid;
        long digest;
        int digestVersion;

        ZxidDigest() {
            this(0L, this$0.digestCalculator.getDigestVersion(), 0L);
        }

        ZxidDigest(long zxid, int digestVersion, long digest) {
            this.zxid = zxid;
            this.digestVersion = digestVersion;
            this.digest = digest;
        }

        public void serialize(OutputArchive oa) throws IOException {
            oa.writeLong(this.zxid, "zxid");
            oa.writeInt(this.digestVersion, "digestVersion");
            oa.writeLong(this.digest, "digest");
        }

        public void deserialize(InputArchive ia) throws IOException {
            this.zxid = ia.readLong("zxid");
            this.digestVersion = ia.readInt("digestVersion");
            if (this.digestVersion < 2) {
                String d = ia.readString("digest");
                if (d != null) {
                    this.digest = Long.parseLong(d, 16);
                }
            } else {
                this.digest = ia.readLong("digest");
            }
        }

        public long getZxid() {
            return this.zxid;
        }

        public int getDigestVersion() {
            return this.digestVersion;
        }

        public long getDigest() {
            return this.digest;
        }
    }

    private static class Counts {
        long bytes;
        int count;

        private Counts() {
        }
    }

    public static class ProcessTxnResult {
        public long clientId;
        public int cxid;
        public long zxid;
        public int err;
        public int type;
        public String path;
        public Stat stat;
        public List<ProcessTxnResult> multiResult;

        public boolean equals(Object o) {
            if (o instanceof ProcessTxnResult) {
                ProcessTxnResult other = (ProcessTxnResult)o;
                return other.clientId == this.clientId && other.cxid == this.cxid;
            }
            return false;
        }

        public int hashCode() {
            return (int)((this.clientId ^ (long)this.cxid) % Integer.MAX_VALUE);
        }
    }
}

