/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shaded.zookeeper.server.auth;

import org.apache.kyuubi.shaded.zookeeper.KeeperException;
import org.apache.kyuubi.shaded.zookeeper.server.ServerCnxn;
import org.apache.kyuubi.shaded.zookeeper.server.auth.AuthenticationProvider;
import org.apache.kyuubi.shaded.zookeeper.server.auth.KerberosName;

public class SASLAuthenticationProvider
implements AuthenticationProvider {
    @Override
    public String getScheme() {
        return "sasl";
    }

    @Override
    public KeeperException.Code handleAuthentication(ServerCnxn cnxn, byte[] authData) {
        return KeeperException.Code.AUTHFAILED;
    }

    @Override
    public boolean matches(String id, String aclExpr) {
        if (id.equals("super") || id.equals(aclExpr)) {
            return true;
        }
        String readAccessUser = System.getProperty("zookeeper.letAnySaslUserDoX");
        return readAccessUser != null && aclExpr.equals(readAccessUser);
    }

    @Override
    public boolean isAuthenticated() {
        return true;
    }

    @Override
    public boolean isValid(String id) {
        try {
            new KerberosName(id);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }
}

